/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.TypedValue;

class ViewUtils {
    ViewUtils() {
    }

    @NonNull
    static TypedValue getThemeAccentColor(@NonNull Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NonNull
    static TypedValue getThemeColorControlNormal(@NonNull Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843817 : context.getResources().getIdentifier("colorControlNormal", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NonNull
    static TypedValue getThemeTextColorSecondary(@NonNull Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16842808 : 17170439;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NonNull
    static TypedValue getThemeTextColorPrimary(@NonNull Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16842806 : 17170435;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NonNull
    static Drawable getTintedIcon(@NonNull Context context, @DrawableRes int iconResourceId, @ColorRes int colorResourceId) {
        int color2 = ContextCompat.getColor((Context)context, (int)colorResourceId);
        Drawable icon = ContextCompat.getDrawable((Context)context, (int)iconResourceId);
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)color2);
        return compatIcon;
    }

    @NonNull
    static Drawable getTintedIconWithAttribute(@NonNull Context context, @NonNull Resources.Theme theme, @AttrRes int attributeResource, @DrawableRes int iconResourceId) {
        TypedValue typedValue = new TypedValue();
        theme.resolveAttribute(attributeResource, typedValue, true);
        int color2 = typedValue.data;
        Drawable icon = ContextCompat.getDrawable((Context)context, (int)iconResourceId);
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)color2);
        return compatIcon;
    }

    static boolean isColorTransparent(@ColorInt int color2) {
        return Color.alpha((int)color2) < 16;
    }

    static boolean isColorDark(@ColorInt int color2) {
        double luminescence = 0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2);
        double luminescencePercentage = luminescence / 255.0;
        return luminescencePercentage <= 0.5;
    }

    static boolean isCvcMaximalLength(@NonNull String cardBrand, @Nullable String cvcText) {
        if (cvcText == null) {
            return false;
        }
        if ("American Express".equals(cardBrand)) {
            return cvcText.trim().length() == 4;
        }
        return cvcText.trim().length() == 3;
    }

    @NonNull
    static String[] separateCardNumberGroups(@NonNull String spacelessCardNumber, @NonNull String brand) {
        String[] numberGroups;
        if (spacelessCardNumber.length() > 16) {
            spacelessCardNumber = spacelessCardNumber.substring(0, 16);
        }
        if (brand.equals("American Express")) {
            numberGroups = new String[3];
            int length = spacelessCardNumber.length();
            int lastUsedIndex = 0;
            if (length > 4) {
                numberGroups[0] = spacelessCardNumber.substring(0, 4);
                lastUsedIndex = 4;
            }
            if (length > 10) {
                numberGroups[1] = spacelessCardNumber.substring(4, 10);
                lastUsedIndex = 10;
            }
            for (int i = 0; i < 3; ++i) {
                if (numberGroups[i] != null) continue;
                numberGroups[i] = spacelessCardNumber.substring(lastUsedIndex);
                break;
            }
        } else {
            numberGroups = new String[4];
            int i = 0;
            int previousStart = 0;
            while ((i + 1) * 4 < spacelessCardNumber.length()) {
                String group;
                numberGroups[i] = group = spacelessCardNumber.substring(previousStart, (i + 1) * 4);
                previousStart = (i + 1) * 4;
                ++i;
            }
            numberGroups[i] = spacelessCardNumber.substring(previousStart);
        }
        return numberGroups;
    }

    static int getPxFromDp(Context context, int dp) {
        return (int)((float)dp * context.getResources().getDisplayMetrics().density);
    }
}

