/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import com.stripe.android.CustomerEphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeError;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CustomerSession
implements EphemeralKeyManager.KeyManagerListener<CustomerEphemeralKey> {
    public static final String ACTION_API_EXCEPTION = "action_api_exception";
    public static final String EXTRA_EXCEPTION = "exception";
    public static final String EVENT_SHIPPING_INFO_SAVED = "shipping_info_saved";
    private static final String ACTION_ADD_SOURCE = "add_source";
    private static final String ACTION_DELETE_SOURCE = "delete_source";
    private static final String ACTION_SET_DEFAULT_SOURCE = "default_source";
    private static final String ACTION_SET_CUSTOMER_SHIPPING_INFO = "set_shipping_info";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_SOURCE_TYPE = "source_type";
    private static final String KEY_SHIPPING_INFO = "shipping_info";
    private static final String TOKEN_PAYMENT_SESSION = "PaymentSession";
    private static final Set<String> VALID_TOKENS = new HashSet<String>(Arrays.asList("AddSourceActivity", "PaymentMethodsActivity", "PaymentFlowActivity", "PaymentSession", "ShippingInfoScreen", "ShippingMethodScreen"));
    private static final int CUSTOMER_RETRIEVED = 7;
    private static final int CUSTOMER_ERROR = 11;
    private static final int SOURCE_RETRIEVED = 13;
    private static final int SOURCE_ERROR = 17;
    private static final int CUSTOMER_SHIPPING_INFO_SAVED = 19;
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final long KEY_REFRESH_BUFFER_IN_SECONDS = 30L;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    private static CustomerSession mInstance;
    @Nullable
    private Customer mCustomer;
    private long mCustomerCacheTime;
    @Nullable
    private Context mContext;
    @NonNull
    private final Map<String, CustomerRetrievalListener> mCustomerRetrievalListeners = new HashMap<String, CustomerRetrievalListener>();
    @NonNull
    private final Map<String, SourceRetrievalListener> mSourceRetrievalListeners = new HashMap<String, SourceRetrievalListener>();
    @NonNull
    private final EphemeralKeyManager mEphemeralKeyManager;
    @NonNull
    private final Handler mUiThreadHandler;
    @NonNull
    private final Set<String> mProductUsageTokens;
    @Nullable
    private final Calendar mProxyNowCalendar;
    @NonNull
    private final ThreadPoolExecutor mThreadPoolExecutor;
    @NonNull
    private final StripeApiHandler mApiHandler;

    public static void initCustomerSession(@NonNull EphemeralKeyProvider keyProvider) {
        CustomerSession.setInstance(new CustomerSession(keyProvider));
    }

    @NonNull
    public static CustomerSession getInstance() {
        if (mInstance == null) {
            throw new IllegalStateException("Attempted to get instance of CustomerSession without initialization.");
        }
        return mInstance;
    }

    @VisibleForTesting
    static void setInstance(@Nullable CustomerSession customerSession) {
        mInstance = customerSession;
    }

    public static void endCustomerSession() {
        CustomerSession.clearInstance();
    }

    @VisibleForTesting
    static void clearInstance() {
        if (mInstance != null) {
            CustomerSession.mInstance.mCustomerRetrievalListeners.clear();
            CustomerSession.mInstance.mSourceRetrievalListeners.clear();
        }
        CustomerSession.cancelCallbacks();
        CustomerSession.setInstance(null);
    }

    public static void cancelCallbacks() {
        if (mInstance == null) {
            return;
        }
        CustomerSession.mInstance.mThreadPoolExecutor.shutdownNow();
    }

    private CustomerSession(@NonNull EphemeralKeyProvider keyProvider) {
        this(keyProvider, null, CustomerSession.createThreadPoolExecutor(), new StripeApiHandler());
    }

    @VisibleForTesting
    CustomerSession(@NonNull EphemeralKeyProvider keyProvider, @Nullable Calendar proxyNowCalendar, @NonNull ThreadPoolExecutor threadPoolExecutor, @NonNull StripeApiHandler apiHandler) {
        this.mThreadPoolExecutor = threadPoolExecutor;
        this.mProxyNowCalendar = proxyNowCalendar;
        this.mProductUsageTokens = new HashSet<String>();
        this.mApiHandler = apiHandler;
        this.mUiThreadHandler = this.createMainThreadHandler();
        this.mEphemeralKeyManager = new EphemeralKeyManager<CustomerEphemeralKey>(keyProvider, this, 30L, proxyNowCalendar, CustomerEphemeralKey.class);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addProductUsageTokenIfValid(@Nullable String token) {
        if (VALID_TOKENS.contains(token)) {
            this.mProductUsageTokens.add(token);
        }
    }

    public void retrieveCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        Customer cachedCustomer = this.getCachedCustomer();
        if (cachedCustomer != null) {
            listener.onCustomerRetrieved(cachedCustomer);
        } else {
            this.mCustomer = null;
            String operationId = UUID.randomUUID().toString();
            this.mCustomerRetrievalListeners.put(operationId, listener);
            this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, null, null);
        }
    }

    public void updateCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        this.mCustomer = null;
        String operationId = UUID.randomUUID().toString();
        this.mCustomerRetrievalListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, null, null);
    }

    @Nullable
    public Customer getCachedCustomer() {
        if (this.canUseCachedCustomer()) {
            return this.mCustomer;
        }
        return null;
    }

    public void addCustomerSource(@NonNull Context context, @NonNull String sourceId, @NonNull String sourceType, @Nullable SourceRetrievalListener listener) {
        this.mContext = context.getApplicationContext();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        String operationId = UUID.randomUUID().toString();
        if (listener != null) {
            this.mSourceRetrievalListeners.put(operationId, listener);
        }
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_ADD_SOURCE, arguments);
    }

    public void deleteCustomerSource(@NonNull Context context, @NonNull String sourceId, @Nullable SourceRetrievalListener listener) {
        this.mContext = context.getApplicationContext();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        String operationId = UUID.randomUUID().toString();
        if (listener != null) {
            this.mSourceRetrievalListeners.put(operationId, listener);
        }
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_DELETE_SOURCE, arguments);
    }

    public void setCustomerShippingInformation(@NonNull Context context, @NonNull ShippingInformation shippingInformation) {
        this.mContext = context.getApplicationContext();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SHIPPING_INFO, shippingInformation);
        this.mEphemeralKeyManager.retrieveEphemeralKey(null, ACTION_SET_CUSTOMER_SHIPPING_INFO, arguments);
    }

    public void setCustomerDefaultSource(@NonNull Context context, @NonNull String sourceId, @NonNull String sourceType, @Nullable CustomerRetrievalListener listener) {
        this.mContext = context.getApplicationContext();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        String operationId = UUID.randomUUID().toString();
        if (listener != null) {
            this.mCustomerRetrievalListeners.put(operationId, listener);
        }
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_SET_DEFAULT_SOURCE, arguments);
    }

    void resetUsageTokens() {
        this.mProductUsageTokens.clear();
    }

    @Nullable
    @VisibleForTesting
    Customer getCustomer() {
        return this.mCustomer;
    }

    @VisibleForTesting
    long getCustomerCacheTime() {
        return this.mCustomerCacheTime;
    }

    @VisibleForTesting
    Set<String> getProductUsageTokens() {
        return this.mProductUsageTokens;
    }

    private void addCustomerSource(final @NonNull Context context, final @NonNull CustomerEphemeralKey key, final @NonNull String sourceId, final @NonNull String sourceType, final @Nullable String operationId) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SourceMessage sourceMessage = new SourceMessage(operationId, CustomerSession.this.addCustomerSourceWithKey(context, key, sourceId, sourceType));
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(13, (Object)sourceMessage));
                }
                catch (StripeException stripeEx) {
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(17, (Object)new ExceptionMessage(operationId, stripeEx)));
                    CustomerSession.this.sendErrorIntent(stripeEx);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private boolean canUseCachedCustomer() {
        long currentTime = this.getCalendarInstance().getTimeInMillis();
        return this.mCustomer != null && currentTime - this.mCustomerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    private void deleteCustomerSource(final @NonNull Context context, final @NonNull CustomerEphemeralKey key, final @NonNull String sourceId, final @Nullable String operationId) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SourceMessage sourceMessage = new SourceMessage(operationId, CustomerSession.this.deleteCustomerSourceWithKey(context, key, sourceId));
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(13, (Object)sourceMessage));
                }
                catch (StripeException stripeEx) {
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(17, (Object)new ExceptionMessage(operationId, stripeEx)));
                    CustomerSession.this.sendErrorIntent(stripeEx);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private void setCustomerSourceDefault(final @NonNull Context context, final @NonNull CustomerEphemeralKey key, final @NonNull String sourceId, final @NonNull String sourceType, final @Nullable String operationId) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    CustomerMessage customerMessage = new CustomerMessage(operationId, CustomerSession.this.setCustomerSourceDefaultWithKey(context, key, sourceId, sourceType));
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(7, (Object)customerMessage));
                }
                catch (StripeException stripeEx) {
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(11, (Object)new ExceptionMessage(operationId, stripeEx)));
                    CustomerSession.this.sendErrorIntent(stripeEx);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private void setCustomerShippingInformation(final @NonNull Context context, final @NonNull CustomerEphemeralKey key, final @NonNull ShippingInformation shippingInformation, final @Nullable String operationId) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    CustomerMessage customerMessage = new CustomerMessage(operationId, CustomerSession.this.setCustomerShippingInfoWithKey(context, key, shippingInformation));
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(19, (Object)customerMessage));
                }
                catch (StripeException stripeEx) {
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(11, (Object)new ExceptionMessage(operationId, stripeEx)));
                    CustomerSession.this.sendErrorIntent(stripeEx);
                }
            }
        };
        this.executeRunnable(runnable);
    }

    private void updateCustomer(final @NonNull CustomerEphemeralKey key, final @Nullable String operationId) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    CustomerMessage customerMessage = new CustomerMessage(operationId, CustomerSession.this.retrieveCustomerWithKey(key));
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(7, (Object)customerMessage));
                }
                catch (StripeException stripeEx) {
                    CustomerSession.this.mUiThreadHandler.sendMessage(CustomerSession.this.mUiThreadHandler.obtainMessage(11, (Object)new ExceptionMessage(operationId, stripeEx)));
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private void executeRunnable(@NonNull Runnable runnable) {
        this.mThreadPoolExecutor.execute(runnable);
    }

    @Override
    public void onKeyUpdate(@NonNull CustomerEphemeralKey ephemeralKey, @Nullable String operationId, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        if (actionString == null) {
            this.updateCustomer(ephemeralKey, operationId);
            return;
        }
        if (arguments == null || this.mContext == null) {
            return;
        }
        if (ACTION_ADD_SOURCE.equals(actionString) && arguments.containsKey(KEY_SOURCE) && arguments.containsKey(KEY_SOURCE_TYPE)) {
            this.addCustomerSource(this.mContext, ephemeralKey, (String)arguments.get(KEY_SOURCE), (String)arguments.get(KEY_SOURCE_TYPE), operationId);
            this.resetUsageTokens();
        } else if (ACTION_DELETE_SOURCE.equals(actionString) && arguments.containsKey(KEY_SOURCE)) {
            this.deleteCustomerSource(this.mContext, ephemeralKey, (String)arguments.get(KEY_SOURCE), operationId);
            this.resetUsageTokens();
        } else if (ACTION_SET_DEFAULT_SOURCE.equals(actionString) && arguments.containsKey(KEY_SOURCE) && arguments.containsKey(KEY_SOURCE_TYPE)) {
            this.setCustomerSourceDefault(this.mContext, ephemeralKey, (String)arguments.get(KEY_SOURCE), (String)arguments.get(KEY_SOURCE_TYPE), operationId);
            this.resetUsageTokens();
        } else if (ACTION_SET_CUSTOMER_SHIPPING_INFO.equals(actionString) && arguments.containsKey(KEY_SHIPPING_INFO)) {
            this.setCustomerShippingInformation(this.mContext, ephemeralKey, (ShippingInformation)arguments.get(KEY_SHIPPING_INFO), operationId);
            this.resetUsageTokens();
        }
    }

    @Override
    public void onKeyError(@Nullable String operationId, int httpCode, @Nullable String errorMessage) {
        SourceRetrievalListener sourceRetrievalListener;
        CustomerRetrievalListener customerRetrievalListener = this.getCustomerRetrievalListener(operationId);
        if (customerRetrievalListener != null) {
            customerRetrievalListener.onError(httpCode, errorMessage, null);
        }
        if ((sourceRetrievalListener = this.getSourceRetrievalListener(operationId)) != null) {
            sourceRetrievalListener.onError(httpCode, errorMessage, null);
        }
    }

    @NonNull
    private Handler createMainThreadHandler() {
        return new Handler(Looper.getMainLooper()){

            public void handleMessage(@NonNull Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 7: {
                        if (!(msg.obj instanceof CustomerMessage)) break;
                        CustomerMessage customerMessage = (CustomerMessage)msg.obj;
                        String operationId = customerMessage.operationId;
                        CustomerSession.this.mCustomer = customerMessage.customer;
                        CustomerSession.this.mCustomerCacheTime = CustomerSession.this.getCalendarInstance().getTimeInMillis();
                        CustomerRetrievalListener listener = CustomerSession.this.getCustomerRetrievalListener(operationId);
                        if (listener == null || CustomerSession.this.mCustomer == null) break;
                        listener.onCustomerRetrieved(CustomerSession.this.mCustomer);
                        break;
                    }
                    case 13: {
                        SourceMessage sourceMessage;
                        String operationId;
                        SourceRetrievalListener listener;
                        if (msg.obj instanceof SourceMessage && (listener = CustomerSession.this.getSourceRetrievalListener(operationId = (sourceMessage = (SourceMessage)msg.obj).operationId)) != null && sourceMessage.source != null) {
                            listener.onSourceRetrieved(sourceMessage.source);
                        }
                        CustomerSession.this.mContext = null;
                        break;
                    }
                    case 19: {
                        if (CustomerSession.this.mContext == null || !(msg.obj instanceof CustomerMessage)) break;
                        CustomerMessage customerMessage = (CustomerMessage)msg.obj;
                        CustomerSession.this.mCustomer = customerMessage.customer;
                        LocalBroadcastManager.getInstance((Context)CustomerSession.this.mContext).sendBroadcast(new Intent(CustomerSession.EVENT_SHIPPING_INFO_SAVED));
                        break;
                    }
                    case 11: {
                        if (!(msg.obj instanceof ExceptionMessage)) break;
                        ExceptionMessage exceptionMessage = (ExceptionMessage)msg.obj;
                        CustomerSession.this.handleRetrievalError(exceptionMessage.operationId, exceptionMessage.exception, 11);
                        break;
                    }
                    case 17: {
                        if (!(msg.obj instanceof ExceptionMessage)) break;
                        ExceptionMessage exceptionMessage = (ExceptionMessage)msg.obj;
                        CustomerSession.this.handleRetrievalError(exceptionMessage.operationId, exceptionMessage.exception, 17);
                        break;
                    }
                }
            }
        };
    }

    private void handleRetrievalError(@Nullable String operationId, @NonNull StripeException exception, int errorType) {
        RetrievalListener listener = errorType == 17 ? (RetrievalListener)this.mSourceRetrievalListeners.remove(operationId) : (errorType == 11 ? (RetrievalListener)this.mCustomerRetrievalListeners.remove(operationId) : null);
        if (listener != null) {
            int errorCode = exception.getStatusCode() == null ? 400 : exception.getStatusCode();
            listener.onError(errorCode, exception.getLocalizedMessage(), exception.getStripeError());
        }
        this.resetUsageTokens();
    }

    @NonNull
    private static ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(3, 3, 2L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue<Runnable>());
    }

    @NonNull
    private Calendar getCalendarInstance() {
        return this.mProxyNowCalendar == null ? Calendar.getInstance() : this.mProxyNowCalendar;
    }

    @Nullable
    private Source addCustomerSourceWithKey(@NonNull Context context, @NonNull CustomerEphemeralKey key, @NonNull String sourceId, @NonNull String sourceType) throws StripeException {
        return this.mApiHandler.addCustomerSource(context, key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), new ArrayList<String>(this.mProductUsageTokens), sourceId, sourceType, key.getSecret(), null);
    }

    @Nullable
    private Source deleteCustomerSourceWithKey(@NonNull Context context, @NonNull CustomerEphemeralKey key, @NonNull String sourceId) throws StripeException {
        return this.mApiHandler.deleteCustomerSource(context, key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), new ArrayList<String>(this.mProductUsageTokens), sourceId, key.getSecret(), null);
    }

    @Nullable
    private Customer setCustomerShippingInfoWithKey(@NonNull Context context, @NonNull CustomerEphemeralKey key, @NonNull ShippingInformation shippingInformation) throws StripeException {
        return this.mApiHandler.setCustomerShippingInfo(context, key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), new ArrayList<String>(this.mProductUsageTokens), shippingInformation, key.getSecret(), null);
    }

    @Nullable
    private Customer setCustomerSourceDefaultWithKey(@NonNull Context context, @NonNull CustomerEphemeralKey key, @NonNull String sourceId, @NonNull String sourceType) throws StripeException {
        return this.mApiHandler.setDefaultCustomerSource(context, key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), new ArrayList<String>(this.mProductUsageTokens), sourceId, sourceType, key.getSecret(), null);
    }

    @Nullable
    private Customer retrieveCustomerWithKey(@NonNull CustomerEphemeralKey key) throws StripeException {
        return this.mApiHandler.retrieveCustomer(key.getCustomerId(), key.getSecret());
    }

    private void sendErrorIntent(@NonNull StripeException exception) {
        if (this.mContext == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putSerializable(EXTRA_EXCEPTION, (Serializable)exception);
        Intent intent = new Intent(ACTION_API_EXCEPTION).putExtras(bundle);
        LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
    }

    @Nullable
    private CustomerRetrievalListener getCustomerRetrievalListener(@Nullable String operationId) {
        return this.mCustomerRetrievalListeners.remove(operationId);
    }

    @Nullable
    private SourceRetrievalListener getSourceRetrievalListener(@Nullable String operationId) {
        return this.mSourceRetrievalListeners.remove(operationId);
    }

    private static class ExceptionMessage {
        @Nullable
        private final String operationId;
        @NonNull
        private final StripeException exception;

        private ExceptionMessage(@Nullable String operationId, @NonNull StripeException exception) {
            this.operationId = operationId;
            this.exception = exception;
        }
    }

    private static class SourceMessage {
        @Nullable
        private final String operationId;
        @Nullable
        private final Source source;

        private SourceMessage(@Nullable String operationId, @Nullable Source source) {
            this.operationId = operationId;
            this.source = source;
        }
    }

    private static class CustomerMessage {
        @Nullable
        private final String operationId;
        @Nullable
        private final Customer customer;

        private CustomerMessage(@Nullable String operationId, @Nullable Customer customer) {
            this.operationId = operationId;
            this.customer = customer;
        }
    }

    public static abstract class ActivitySourceRetrievalListener<A extends Activity>
    implements SourceRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivitySourceRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    static interface RetrievalListener {
        public void onError(int var1, @Nullable String var2, @Nullable StripeError var3);
    }

    public static interface SourceRetrievalListener
    extends RetrievalListener {
        public void onSourceRetrieved(@NonNull Source var1);
    }

    public static interface CustomerRetrievalListener
    extends RetrievalListener {
        public void onCustomerRetrieved(@NonNull Customer var1);
    }
}

