/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.stripe.android.model.Address;
import com.stripe.android.model.ShippingInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PaymentSessionConfig
implements Parcelable {
    @NonNull
    private List<String> mHiddenShippingInfoFields;
    @NonNull
    private List<String> mOptionalShippingInfoFields;
    @NonNull
    private ShippingInformation mShippingInformation;
    private boolean mShippingInfoRequired;
    private boolean mShippingMethodRequired;
    public static final Parcelable.Creator<PaymentSessionConfig> CREATOR = new Parcelable.Creator<PaymentSessionConfig>(){

        public PaymentSessionConfig createFromParcel(Parcel in) {
            return new PaymentSessionConfig(in);
        }

        public PaymentSessionConfig[] newArray(int size) {
            return new PaymentSessionConfig[size];
        }
    };

    PaymentSessionConfig(Builder builder) {
        this.mHiddenShippingInfoFields = builder.mHiddenShippingInfoFields;
        this.mOptionalShippingInfoFields = builder.mOptionalShippingInfoFields;
        this.mShippingInformation = builder.mShippingInformation;
        this.mShippingInfoRequired = builder.mShippingInfoRequired;
        this.mShippingMethodRequired = builder.mShippingMethodsRequired;
    }

    private PaymentSessionConfig(Parcel in) {
        this.mHiddenShippingInfoFields = new ArrayList<String>();
        in.readList(this.mHiddenShippingInfoFields, String.class.getClassLoader());
        this.mOptionalShippingInfoFields = new ArrayList<String>();
        in.readList(this.mOptionalShippingInfoFields, String.class.getClassLoader());
        this.mShippingInformation = (ShippingInformation)in.readParcelable(Address.class.getClassLoader());
        this.mShippingInfoRequired = in.readInt() == 1;
        this.mShippingMethodRequired = in.readInt() == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentSessionConfig that = (PaymentSessionConfig)o;
        if (this.isShippingInfoRequired() != that.isShippingInfoRequired()) {
            return false;
        }
        if (this.isShippingMethodRequired() != that.isShippingMethodRequired()) {
            return false;
        }
        if (!this.getHiddenShippingInfoFields().equals(that.getHiddenShippingInfoFields())) {
            return false;
        }
        if (!this.getOptionalShippingInfoFields().equals(that.getOptionalShippingInfoFields())) {
            return false;
        }
        return this.getPrepopulatedShippingInfo().equals(that.getPrepopulatedShippingInfo());
    }

    public int hashCode() {
        int result = this.getHiddenShippingInfoFields().hashCode();
        result = 31 * result + this.getOptionalShippingInfoFields().hashCode();
        result = 31 * result + this.mShippingInformation.hashCode();
        result = 31 * result + (this.isShippingInfoRequired() ? 1 : 0);
        result = 31 * result + (this.isShippingMethodRequired() ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeList(this.mHiddenShippingInfoFields);
        parcel.writeList(this.mOptionalShippingInfoFields);
        parcel.writeParcelable((Parcelable)this.mShippingInformation, flags);
        parcel.writeInt(this.mShippingInfoRequired ? 1 : 0);
        parcel.writeInt(this.mShippingMethodRequired ? 1 : 0);
    }

    @NonNull
    public List<String> getHiddenShippingInfoFields() {
        return this.mHiddenShippingInfoFields;
    }

    @NonNull
    public List<String> getOptionalShippingInfoFields() {
        return this.mOptionalShippingInfoFields;
    }

    @NonNull
    public ShippingInformation getPrepopulatedShippingInfo() {
        return this.mShippingInformation;
    }

    public boolean isShippingInfoRequired() {
        return this.mShippingInfoRequired;
    }

    public boolean isShippingMethodRequired() {
        return this.mShippingMethodRequired;
    }

    public static class Builder {
        private boolean mShippingInfoRequired = true;
        private boolean mShippingMethodsRequired = true;
        @NonNull
        private List<String> mHiddenShippingInfoFields;
        @NonNull
        private List<String> mOptionalShippingInfoFields;
        @NonNull
        private ShippingInformation mShippingInformation;

        public Builder setHiddenShippingInfoFields(String ... hiddenShippingInfoFields) {
            this.mHiddenShippingInfoFields = Arrays.asList(hiddenShippingInfoFields);
            return this;
        }

        public Builder setOptionalShippingInfoFields(String ... optionalShippingInfoFields) {
            this.mOptionalShippingInfoFields = Arrays.asList(optionalShippingInfoFields);
            return this;
        }

        public Builder setPrepopulatedShippingInfo(ShippingInformation shippingInfo) {
            this.mShippingInformation = shippingInfo;
            return this;
        }

        public Builder setShippingInfoRequired(boolean shippingInfoRequired) {
            this.mShippingInfoRequired = shippingInfoRequired;
            return this;
        }

        public Builder setShippingMethodsRequired(boolean shippingMethodsRequired) {
            this.mShippingMethodsRequired = shippingMethodsRequired;
            return this;
        }

        public PaymentSessionConfig build() {
            return new PaymentSessionConfig(this);
        }
    }
}

