/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentUtils;
import com.stripe.android.view.ViewUtils;

class ShippingMethodView
extends RelativeLayout {
    private TextView mLabel;
    private TextView mDetail;
    private TextView mAmount;
    private ImageView mCheckmark;
    @ColorInt
    int mSelectedColorInt;
    @ColorInt
    int mUnselectedTextColorSecondaryInt;
    @ColorInt
    int mUnselectedTextColorPrimaryInt;

    ShippingMethodView(Context context) {
        super(context);
        this.initView();
    }

    ShippingMethodView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    ShippingMethodView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.mLabel.setTextColor(this.mSelectedColorInt);
            this.mDetail.setTextColor(this.mSelectedColorInt);
            this.mAmount.setTextColor(this.mSelectedColorInt);
            this.mCheckmark.setVisibility(0);
        } else {
            this.mLabel.setTextColor(this.mUnselectedTextColorPrimaryInt);
            this.mDetail.setTextColor(this.mUnselectedTextColorSecondaryInt);
            this.mAmount.setTextColor(this.mUnselectedTextColorPrimaryInt);
            this.mCheckmark.setVisibility(4);
        }
    }

    private void initView() {
        ShippingMethodView.inflate((Context)this.getContext(), (int)R.layout.shipping_method_view, (ViewGroup)this);
        this.mLabel = (TextView)this.findViewById(R.id.tv_label_smv);
        this.mDetail = (TextView)this.findViewById(R.id.tv_detail_smv);
        this.mAmount = (TextView)this.findViewById(R.id.tv_amount_smv);
        this.mCheckmark = (ImageView)this.findViewById(R.id.iv_selected_icon);
        this.mSelectedColorInt = ViewUtils.getThemeAccentColor((Context)this.getContext()).data;
        this.mUnselectedTextColorPrimaryInt = ViewUtils.getThemeTextColorPrimary((Context)this.getContext()).data;
        this.mUnselectedTextColorSecondaryInt = ViewUtils.getThemeTextColorSecondary((Context)this.getContext()).data;
        this.useDefaultColorsIfThemeColorsAreInvisible();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        if (Build.VERSION.SDK_INT >= 17) {
            params.addRule(16);
        }
        int height = this.getResources().getDimensionPixelSize(R.dimen.shipping_method_view_height);
        params.height = ViewUtils.getPxFromDp(this.getContext(), height);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void useDefaultColorsIfThemeColorsAreInvisible() {
        this.mSelectedColorInt = ViewUtils.isColorTransparent(this.mSelectedColorInt) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.accent_color_default) : this.mSelectedColorInt;
        this.mUnselectedTextColorPrimaryInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorPrimaryInt) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_text_unselected_primary_default) : this.mUnselectedTextColorPrimaryInt;
        this.mUnselectedTextColorSecondaryInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorSecondaryInt) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_text_unselected_secondary_default) : this.mUnselectedTextColorSecondaryInt;
    }

    void setShippingMethod(@NonNull ShippingMethod shippingMethod) {
        this.mLabel.setText((CharSequence)shippingMethod.getLabel());
        this.mDetail.setText((CharSequence)shippingMethod.getDetail());
        this.mAmount.setText((CharSequence)PaymentUtils.formatPriceStringUsingFree(shippingMethod.getAmount(), shippingMethod.getCurrency(), this.getContext().getString(R.string.price_free)));
    }
}

