/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentIntent
extends StripeJsonModel {
    static final String VALUE_PAYMENT_INTENT = "payment_intent";
    static final String FIELD_ID = "id";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_ALLOWED_SOURCE_TYPES = "allowed_source_types";
    static final String FIELD_AMOUNT = "amount";
    static final String FIELD_CREATED = "created";
    static final String FIELD_CANCELED = "canceled_at";
    static final String FIELD_CAPTURE_METHOD = "capture_method";
    static final String FIELD_CLIENT_SECRET = "client_secret";
    static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    static final String FIELD_CURRENCY = "currency";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_NEXT_SOURCE_ACTION = "next_source_action";
    static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    static final String FIELD_SOURCE = "source";
    static final String FIELD_STATUS = "status";
    private String mId;
    private String mObjectType;
    private List<String> mAllowedSourceTypes;
    private Long mAmount;
    private Long mCanceledAt;
    private String mCaptureMethod;
    private String mClientSecret;
    private String mConfirmationMethod;
    private Long mCreated;
    private String mCurrency;
    private String mDescription;
    private Boolean mLiveMode;
    private Map<String, Object> mNextSourceAction;
    private String mReceiptEmail;
    private String mSource;
    private String mStatus;

    public String getId() {
        return this.mId;
    }

    public List<String> getAllowedSourceTypes() {
        return this.mAllowedSourceTypes;
    }

    public Long getAmount() {
        return this.mAmount;
    }

    public Long getCanceledAt() {
        return this.mCanceledAt;
    }

    public String getCaptureMethod() {
        return this.mCaptureMethod;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public String getConfirmationMethod() {
        return this.mConfirmationMethod;
    }

    public Long getCreated() {
        return this.mCreated;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Boolean isLiveMode() {
        return this.mLiveMode;
    }

    public Map<String, Object> getNextSourceAction() {
        return this.mNextSourceAction;
    }

    @Nullable
    public Uri getAuthorizationUrl() {
        Map authorizeWithUrlMap;
        if ("requires_source_action".equals(this.mStatus) && this.mNextSourceAction.containsKey("authorize_with_url") && this.mNextSourceAction.get("authorize_with_url") instanceof Map && (authorizeWithUrlMap = (Map)this.mNextSourceAction.get("authorize_with_url")).containsKey("url") && authorizeWithUrlMap.get("url") instanceof String) {
            return Uri.parse((String)((String)authorizeWithUrlMap.get("url")));
        }
        return null;
    }

    @Nullable
    public String getReceiptEmail() {
        return this.mReceiptEmail;
    }

    @Nullable
    public String getSource() {
        return this.mSource;
    }

    @NonNull
    public String getStatus() {
        return this.mStatus;
    }

    PaymentIntent(String id2, String objectType, List<String> allowedSourceTypes, Long amount, Long canceledAt, String captureMethod, String clientSecret, String confirmationMethod, Long created, String currency, String description, Boolean liveMode, Map<String, Object> nextSourceAction, String receiptEmail, String source, String status) {
        this.mId = id2;
        this.mObjectType = objectType;
        this.mAllowedSourceTypes = allowedSourceTypes;
        this.mAmount = amount;
        this.mCanceledAt = canceledAt;
        this.mCaptureMethod = captureMethod;
        this.mClientSecret = clientSecret;
        this.mConfirmationMethod = confirmationMethod;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mDescription = description;
        this.mLiveMode = liveMode;
        this.mNextSourceAction = nextSourceAction;
        this.mReceiptEmail = receiptEmail;
        this.mSource = source;
        this.mStatus = status;
    }

    @NonNull
    public static String parseIdFromClientSecret(@NonNull String clientSecret) {
        return clientSecret.split("_secret")[0];
    }

    @Nullable
    public static PaymentIntent fromString(@Nullable String jsonString) {
        try {
            return PaymentIntent.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_PAYMENT_INTENT.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        String id2 = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        String objectType = StripeJsonUtils.optString(jsonObject, FIELD_OBJECT);
        JSONArray allowedSourceTypesJSONArray = jsonObject.optJSONArray(FIELD_ALLOWED_SOURCE_TYPES);
        ArrayList<String> allowedSourceTypes = new ArrayList<String>();
        for (int i = 0; i < allowedSourceTypesJSONArray.length(); ++i) {
            try {
                allowedSourceTypes.add(allowedSourceTypesJSONArray.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        Long canceledAt = StripeJsonUtils.optLong(jsonObject, FIELD_CANCELED);
        String captureMethod = StripeJsonUtils.optString(jsonObject, FIELD_CAPTURE_METHOD);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        String confirmationMethod = StripeJsonUtils.optString(jsonObject, FIELD_CONFIRMATION_METHOD);
        Long created = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY);
        String description = StripeJsonUtils.optString(jsonObject, FIELD_DESCRIPTION);
        Boolean livemode = StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE);
        String receiptEmail = StripeJsonUtils.optString(jsonObject, FIELD_RECEIPT_EMAIL);
        String status = StripeJsonUtils.optString(jsonObject, FIELD_STATUS);
        Map<String, Object> nextSourceAction = StripeJsonUtils.optMap(jsonObject, FIELD_NEXT_SOURCE_ACTION);
        String source = StripeJsonUtils.optString(jsonObject, FIELD_SOURCE);
        return new PaymentIntent(id2, objectType, allowedSourceTypes, amount, canceledAt, captureMethod, clientSecret, confirmationMethod, created, currency, description, livemode, nextSourceAction, receiptEmail, source, status);
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ID, this.mId);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_OBJECT, this.mObjectType);
        StripeJsonUtils.putArrayIfNotNull(jsonObject, FIELD_ALLOWED_SOURCE_TYPES, StripeJsonUtils.listToJsonArray(this.mAllowedSourceTypes));
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_AMOUNT, this.mAmount);
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_CANCELED, this.mCanceledAt);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CAPTURE_METHOD, this.mCaptureMethod);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CLIENT_SECRET, this.mClientSecret);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CONFIRMATION_METHOD, this.mConfirmationMethod);
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_CREATED, this.mCreated);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CURRENCY, this.mCurrency);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_DESCRIPTION, this.mDescription);
        StripeJsonUtils.putBooleanIfNotNull(jsonObject, FIELD_LIVEMODE, this.mLiveMode);
        StripeJsonUtils.putMapIfNotNull(jsonObject, FIELD_NEXT_SOURCE_ACTION, this.mNextSourceAction);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_RECEIPT_EMAIL, this.mReceiptEmail);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_SOURCE, this.mSource);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATUS, this.mStatus);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_ID, this.mId);
        map.put(FIELD_OBJECT, this.mObjectType);
        map.put(FIELD_ALLOWED_SOURCE_TYPES, this.mAllowedSourceTypes);
        map.put(FIELD_AMOUNT, this.mAmount);
        map.put(FIELD_CANCELED, this.mCanceledAt);
        map.put(FIELD_CLIENT_SECRET, this.mClientSecret);
        map.put(FIELD_CAPTURE_METHOD, this.mCaptureMethod);
        map.put(FIELD_CONFIRMATION_METHOD, this.mConfirmationMethod);
        map.put(FIELD_CREATED, this.mCreated);
        map.put(FIELD_CURRENCY, this.mCurrency);
        map.put(FIELD_DESCRIPTION, this.mDescription);
        map.put(FIELD_LIVEMODE, this.mLiveMode);
        map.put(FIELD_NEXT_SOURCE_ACTION, this.mNextSourceAction);
        map.put(FIELD_RECEIPT_EMAIL, this.mReceiptEmail);
        map.put(FIELD_STATUS, this.mStatus);
        map.put(FIELD_SOURCE, this.mSource);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }
}

