/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewStub;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.R;
import com.stripe.android.exception.StripeException;
import com.stripe.android.view.ViewUtils;

abstract class StripeActivity
extends AppCompatActivity {
    BroadcastReceiver mAlertBroadcastReceiver;
    @Nullable
    AlertMessageListener mAlertMessageListener;
    boolean mCommunicating;
    Toolbar mToolbar;
    ProgressBar mProgressBar;
    ViewStub mViewStub;

    StripeActivity() {
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_stripe);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress_bar_as);
        this.mToolbar = (Toolbar)this.findViewById(R.id.toolbar_as);
        this.mViewStub = (ViewStub)this.findViewById(R.id.widget_viewstub_as);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.setSupportActionBar(this.mToolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.setCommunicatingProgress(false);
        this.mAlertBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                StripeException exception = (StripeException)intent.getSerializableExtra("exception");
                StripeActivity.this.showError(exception.getLocalizedMessage());
            }
        };
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mAlertBroadcastReceiver);
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mAlertBroadcastReceiver, new IntentFilter("action_api_exception"));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.add_source_menu, menu2);
        menu2.findItem(R.id.action_save).setEnabled(!this.mCommunicating);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_save) {
            this.onActionSave();
            return true;
        }
        boolean handled = super.onOptionsItemSelected(item);
        if (!handled) {
            this.onBackPressed();
        }
        return handled;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        MenuItem saveItem = menu2.findItem(R.id.action_save);
        Drawable tintedIcon = ViewUtils.getTintedIconWithAttribute((Context)this, this.getTheme(), R.attr.titleTextColor, R.drawable.ic_checkmark);
        saveItem.setIcon(tintedIcon);
        return super.onPrepareOptionsMenu(menu2);
    }

    protected abstract void onActionSave();

    protected void setCommunicatingProgress(boolean communicating) {
        this.mCommunicating = communicating;
        if (communicating) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
        this.supportInvalidateOptionsMenu();
    }

    void setAlertMessageListener(@Nullable AlertMessageListener listener) {
        this.mAlertMessageListener = listener;
    }

    void showError(@NonNull String error) {
        if (this.mAlertMessageListener != null) {
            this.mAlertMessageListener.onAlertMessageDisplayed(error);
        }
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    static interface AlertMessageListener {
        public void onAlertMessageDisplayed(String var1);
    }
}

