/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeTextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RequestOptions {
    public static final String TYPE_QUERY = "source";
    public static final String TYPE_JSON = "json_data";
    @NonNull
    private final String mApiVersion;
    @Nullable
    private final String mGuid;
    @Nullable
    private final String mIdempotencyKey;
    @Nullable
    private final String mPublishableApiKey;
    @NonNull
    private final String mRequestType;
    @Nullable
    private final String mStripeAccount;

    private RequestOptions(@NonNull String apiVersion, @Nullable String guid, @Nullable String idempotencyKey, @Nullable String publishableApiKey, @NonNull String requestType, @Nullable String stripeAccount) {
        this.mApiVersion = apiVersion;
        this.mGuid = guid;
        this.mIdempotencyKey = idempotencyKey;
        this.mPublishableApiKey = publishableApiKey;
        this.mRequestType = requestType;
        this.mStripeAccount = stripeAccount;
    }

    @NonNull
    String getApiVersion() {
        return this.mApiVersion;
    }

    @Nullable
    String getGuid() {
        return this.mGuid;
    }

    @Nullable
    String getIdempotencyKey() {
        return this.mIdempotencyKey;
    }

    @Nullable
    String getPublishableApiKey() {
        return this.mPublishableApiKey;
    }

    @NonNull
    String getRequestType() {
        return this.mRequestType;
    }

    @Nullable
    String getStripeAccount() {
        return this.mStripeAccount;
    }

    public static RequestOptionsBuilder builder(@Nullable String publishableApiKey) {
        return RequestOptions.builder(publishableApiKey, TYPE_QUERY);
    }

    public static RequestOptionsBuilder builder(@Nullable String publishableApiKey, @Nullable String stripeAccount, @NonNull String requestType) {
        return new RequestOptionsBuilder(publishableApiKey, requestType).setStripeAccount(stripeAccount);
    }

    public static RequestOptionsBuilder builder(@Nullable String publishableApiKey, @NonNull String requestType) {
        return new RequestOptionsBuilder(publishableApiKey, requestType);
    }

    public static final class RequestOptionsBuilder {
        private String apiVersion;
        private String guid;
        private String idempotencyKey;
        private String publishableApiKey;
        private String requestType;
        private String stripeAccount;

        RequestOptionsBuilder(@Nullable String publishableApiKey, @NonNull String requestType) {
            this.publishableApiKey = publishableApiKey;
            this.requestType = requestType;
        }

        @NonNull
        RequestOptionsBuilder setPublishableApiKey(@NonNull String publishableApiKey) {
            this.publishableApiKey = publishableApiKey;
            return this;
        }

        @NonNull
        RequestOptionsBuilder setIdempotencyKey(@Nullable String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @NonNull
        RequestOptionsBuilder setGuid(@Nullable String guid) {
            this.guid = guid;
            return this;
        }

        @NonNull
        RequestOptionsBuilder setApiVersion(@Nullable String apiVersion) {
            this.apiVersion = StripeTextUtils.isBlank(apiVersion) ? null : apiVersion;
            return this;
        }

        @NonNull
        RequestOptionsBuilder setStripeAccount(@Nullable String stripeAccount) {
            this.stripeAccount = stripeAccount;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.apiVersion, this.guid, this.idempotencyKey, this.publishableApiKey, this.requestType, this.stripeAccount);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
    }
}

