/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AbstractEphemeralKey;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralKeyUpdateListener;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

class EphemeralKeyManager<TEphemeralKey extends AbstractEphemeralKey> {
    @NonNull
    private final Class<TEphemeralKey> mEphemeralKeyClass;
    @Nullable
    private TEphemeralKey mEphemeralKey;
    @NonNull
    private EphemeralKeyProvider mEphemeralKeyProvider;
    @Nullable
    private Calendar mOverrideCalendar;
    @NonNull
    private KeyManagerListener mListener;
    private final long mTimeBufferInSeconds;

    EphemeralKeyManager(@NonNull EphemeralKeyProvider ephemeralKeyProvider, @NonNull KeyManagerListener keyManagerListener, long timeBufferInSeconds, @Nullable Calendar overrideCalendar, @NonNull Class<TEphemeralKey> ephemeralKeyClass) {
        this.mEphemeralKeyClass = ephemeralKeyClass;
        this.mEphemeralKeyProvider = ephemeralKeyProvider;
        this.mListener = keyManagerListener;
        this.mTimeBufferInSeconds = timeBufferInSeconds;
        this.mOverrideCalendar = overrideCalendar;
        this.retrieveEphemeralKey(null, null);
    }

    void retrieveEphemeralKey(@Nullable String actionString, Map<String, Object> arguments) {
        if (EphemeralKeyManager.shouldRefreshKey(this.mEphemeralKey, this.mTimeBufferInSeconds, this.mOverrideCalendar)) {
            this.mEphemeralKeyProvider.createEphemeralKey("2017-06-05", new ClientKeyUpdateListener(this, actionString, arguments));
        } else {
            this.mListener.onKeyUpdate(this.mEphemeralKey, actionString, arguments);
        }
    }

    @Nullable
    @VisibleForTesting
    TEphemeralKey getEphemeralKey() {
        return this.mEphemeralKey;
    }

    private void updateKey(@NonNull String key, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        if (key == null) {
            this.mListener.onKeyError(500, "EphemeralKeyUpdateListener.onKeyUpdate was called with a null value");
            return;
        }
        try {
            this.mEphemeralKey = AbstractEphemeralKey.fromString(key, this.mEphemeralKeyClass);
            this.mListener.onKeyUpdate(this.mEphemeralKey, actionString, arguments);
        }
        catch (JSONException e) {
            this.mListener.onKeyError(500, "EphemeralKeyUpdateListener.onKeyUpdate was passed a value that could not be JSON parsed: [" + e.getLocalizedMessage() + "]. The raw body from Stripe's response should be passed");
        }
        catch (Exception e) {
            this.mListener.onKeyError(500, "EphemeralKeyUpdateListener.onKeyUpdate was passed a JSON String that was invalid: [" + e.getLocalizedMessage() + "]. The raw body from Stripe's response should be passed");
        }
    }

    private void updateKeyError(int errorCode, @Nullable String errorMessage) {
        this.mEphemeralKey = null;
        this.mListener.onKeyError(errorCode, errorMessage);
    }

    static boolean shouldRefreshKey(@Nullable AbstractEphemeralKey key, long bufferInSeconds, @Nullable Calendar proxyCalendar) {
        if (key == null) {
            return true;
        }
        Calendar now = proxyCalendar == null ? Calendar.getInstance() : proxyCalendar;
        long nowInSeconds = TimeUnit.MILLISECONDS.toSeconds(now.getTimeInMillis());
        long nowPlusBuffer = nowInSeconds + bufferInSeconds;
        return key.getExpires() < nowPlusBuffer;
    }

    private static class ClientKeyUpdateListener
    implements EphemeralKeyUpdateListener {
        @Nullable
        private String mActionString;
        @Nullable
        private Map<String, Object> mArguments;
        @NonNull
        private WeakReference<EphemeralKeyManager> mEphemeralKeyManagerWeakReference;

        ClientKeyUpdateListener(@NonNull EphemeralKeyManager keyManager, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
            this.mEphemeralKeyManagerWeakReference = new WeakReference<EphemeralKeyManager>(keyManager);
            this.mActionString = actionString;
            this.mArguments = arguments;
        }

        @Override
        public void onKeyUpdate(@NonNull String rawKey) {
            EphemeralKeyManager keyManager = (EphemeralKeyManager)this.mEphemeralKeyManagerWeakReference.get();
            if (keyManager != null) {
                keyManager.updateKey(rawKey, this.mActionString, this.mArguments);
            }
        }

        @Override
        public void onKeyUpdateFailure(int responseCode, @Nullable String message) {
            EphemeralKeyManager keyManager = (EphemeralKeyManager)this.mEphemeralKeyManagerWeakReference.get();
            if (keyManager != null) {
                keyManager.updateKeyError(responseCode, message);
            }
        }
    }

    static interface KeyManagerListener<TEphemeralKey extends AbstractEphemeralKey> {
        public void onKeyUpdate(@NonNull TEphemeralKey var1, @Nullable String var2, @Nullable Map<String, Object> var3);

        public void onKeyError(int var1, @Nullable String var2);
    }
}

