/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.HorizontalScrollView;

public class LockableHorizontalScrollView
extends HorizontalScrollView {
    private LockableScrollChangedListener mLockableScrollChangedListener;
    private boolean mScrollable;

    public LockableHorizontalScrollView(Context context) {
        super(context);
    }

    public LockableHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LockableHorizontalScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean isScrollable() {
        return this.mScrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.mScrollable = scrollable;
        this.setSmoothScrollingEnabled(scrollable);
    }

    public void scrollTo(int x, int y) {
        if (!this.mScrollable) {
            return;
        }
        super.scrollTo(x, y);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() != 0) {
            return super.onTouchEvent(event);
        }
        return this.mScrollable && super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mScrollable && super.onInterceptTouchEvent(event);
    }

    void setScrollChangedListener(LockableScrollChangedListener listener) {
        this.mLockableScrollChangedListener = listener;
    }

    void wrappedSmoothScrollBy(int dx, int dy) {
        if (!this.mScrollable) {
            return;
        }
        this.smoothScrollBy(dx, dy);
        if (this.mLockableScrollChangedListener != null) {
            this.mLockableScrollChangedListener.onSmoothScrollBy(dx, dy);
        }
    }

    static interface LockableScrollChangedListener {
        public void onSmoothScrollBy(int var1, int var2);
    }
}

