/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.stripe.android.ErrorParser;
import com.stripe.android.LoggingUtils;
import com.stripe.android.RequestOptions;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeResponse;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.TelemetryClientUtil;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class StripeApiHandler {
    static final String GET = "GET";
    static final String POST = "POST";
    static final String DELETE = "DELETE";
    private static final String LIVE_API_BASE = "https://api.stripe.com";
    private static final String LIVE_LOGGING_BASE = "https://q.stripe.com";
    private static final String LOGGING_ENDPOINT = "https://m.stripe.com/4";
    private static final String CHARSET = "UTF-8";
    private static final String CUSTOMERS = "customers";
    private static final String TOKENS = "tokens";
    private static final String SOURCES = "sources";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final SSLSocketFactory SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();
    static final String API_VERSION = "2017-06-05";

    StripeApiHandler() {
    }

    static void logApiCall(@NonNull Map<String, Object> loggingMap, @Nullable RequestOptions options, @Nullable LoggingResponseListener listener) {
        if (options == null) {
            return;
        }
        if (listener != null && !listener.shouldLogTest()) {
            return;
        }
        String apiKey = options.getPublishableApiKey();
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return;
        }
        StripeApiHandler.fireAndForgetApiCall(loggingMap, LIVE_LOGGING_BASE, GET, options, listener);
    }

    @Nullable
    static PaymentIntent confirmPaymentIntent(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = paymentIntentParams.toParamMap();
        StripeNetworkUtils.addUidParamsToPaymentIntent(uidProvider, context, paramMap);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            StripeApiHandler.setTelemetryData(context, loggingResponseListener);
            SourceParams sourceParams = paymentIntentParams.getSourceParams();
            String sourceType = sourceParams != null ? sourceParams.getType() : null;
            Map<String, Object> loggingParams = LoggingUtils.getPaymentIntentConfirmationParams(context, null, apiKey, sourceType);
            RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
            StripeApiHandler.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(paymentIntentParams.getClientSecret());
            StripeResponse response = StripeApiHandler.requestData(POST, StripeApiHandler.confirmPaymentIntentUrl(paymentIntentId), paramMap, options);
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), unexpected);
        }
    }

    @Nullable
    static PaymentIntent retrievePaymentIntent(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = paymentIntentParams.toParamMap();
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            StripeApiHandler.setTelemetryData(context, loggingResponseListener);
            Map<String, Object> loggingParams = LoggingUtils.getPaymentIntentRetrieveParams(context, null, apiKey);
            RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
            StripeApiHandler.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(paymentIntentParams.getClientSecret());
            StripeResponse response = StripeApiHandler.requestData(GET, StripeApiHandler.retrievePaymentIntentUrl(paymentIntentId), paramMap, options);
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), unexpected);
        }
    }

    @Nullable
    static Source createSource(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return StripeApiHandler.createSource(uidProvider, context, sourceParams, publishableKey, stripeAccount, loggingResponseListener, null);
    }

    @VisibleForTesting
    @Nullable
    static Source createSource(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener, @Nullable StripeResponseListener stripeResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = sourceParams.toParamMap();
        StripeNetworkUtils.addUidParams(uidProvider, context, paramMap);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            StripeApiHandler.setTelemetryData(context, loggingResponseListener);
            Map<String, Object> loggingParams = LoggingUtils.getSourceCreationParams(context, null, apiKey, sourceParams.getType());
            RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
            StripeApiHandler.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
            StripeResponse response = StripeApiHandler.requestData(POST, StripeApiHandler.getSourcesUrl(), paramMap, options);
            if (stripeResponseListener != null) {
                stripeResponseListener.onStripeResponse(response);
            }
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), unexpected);
        }
    }

    @Nullable
    static Source retrieveSource(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = SourceParams.createRetrieveSourceParams(clientSecret);
        RequestOptions options = RequestOptions.builder(publishableKey).build();
        try {
            StripeResponse response = StripeApiHandler.requestData(GET, StripeApiHandler.getRetrieveSourceApiUrl(sourceId), paramMap, options);
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), unexpected);
        }
    }

    @Nullable
    static Token createToken(@NonNull Context context, @NonNull Map<String, Object> tokenParams, @NonNull RequestOptions options, @NonNull String tokenType, @Nullable LoggingResponseListener listener) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            List loggingTokens = (List)tokenParams.get("product_usage");
            tokenParams.remove("product_usage");
            StripeApiHandler.setTelemetryData(context, listener);
            Map<String, Object> loggingParams = LoggingUtils.getTokenCreationParams(context, loggingTokens, apiKey, tokenType);
            StripeApiHandler.logApiCall(loggingParams, options, listener);
        }
        catch (ClassCastException classCastEx) {
            tokenParams.remove("product_usage");
        }
        return StripeApiHandler.requestToken(POST, StripeApiHandler.getApiUrl(), tokenParams, options);
    }

    @Nullable
    static Source addCustomerSource(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("source", sourceId);
        if (context != null) {
            Map<String, Object> loggingParamsMap = LoggingUtils.getAddSourceParams(context, productUsageTokens, publicKey, sourceType);
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).setApiVersion(API_VERSION).build();
            StripeApiHandler.logApiCall(loggingParamsMap, loggingOptions, listener);
        }
        StripeResponse response = StripeApiHandler.getStripeResponse(POST, StripeApiHandler.getAddCustomerSourceUrl(customerId), paramsMap, RequestOptions.builder(secret).setApiVersion(API_VERSION).build());
        StripeApiHandler.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    static Source deleteCustomerSource(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (context != null) {
            Map<String, Object> loggingParamsMap = LoggingUtils.getDeleteSourceParams(context, productUsageTokens, publicKey);
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).setApiVersion(API_VERSION).build();
            StripeApiHandler.logApiCall(loggingParamsMap, loggingOptions, listener);
        }
        StripeResponse response = StripeApiHandler.getStripeResponse(DELETE, StripeApiHandler.getDeleteCustomerSourceUrl(customerId, sourceId), paramsMap, RequestOptions.builder(secret).setApiVersion(API_VERSION).build());
        StripeApiHandler.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    static Customer setDefaultCustomerSource(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("default_source", sourceId);
        if (context != null) {
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).setApiVersion(API_VERSION).build();
            Map<String, Object> loggingParameters = LoggingUtils.getEventLoggingParams(context, productUsageTokens, sourceType, null, publicKey, "default_source");
            StripeApiHandler.logApiCall(loggingParameters, loggingOptions, listener);
        }
        StripeResponse response = StripeApiHandler.getStripeResponse(POST, StripeApiHandler.getRetrieveCustomerUrl(customerId), paramsMap, RequestOptions.builder(secret).setApiVersion(API_VERSION).build());
        StripeApiHandler.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    static Customer setCustomerShippingInfo(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull ShippingInformation shippingInformation, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("shipping", shippingInformation.toMap());
        if (context != null) {
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).setApiVersion(API_VERSION).build();
            Map<String, Object> loggingParameters = LoggingUtils.getEventLoggingParams(context, productUsageTokens, null, null, publicKey, "set_shipping_info");
            StripeApiHandler.logApiCall(loggingParameters, loggingOptions, listener);
        }
        StripeResponse response = StripeApiHandler.getStripeResponse(POST, StripeApiHandler.getRetrieveCustomerUrl(customerId), paramsMap, RequestOptions.builder(secret).setApiVersion(API_VERSION).build());
        StripeApiHandler.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    static Customer retrieveCustomer(@NonNull String customerId, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        StripeResponse response = StripeApiHandler.getStripeResponse(GET, StripeApiHandler.getRetrieveCustomerUrl(customerId), null, RequestOptions.builder(secret).setApiVersion(API_VERSION).build());
        StripeApiHandler.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException, InvalidRequestException {
        StringBuilder queryStringBuffer = new StringBuilder();
        List<Parameter> flatParams = StripeApiHandler.flattenParams(params);
        Iterator<Parameter> it = flatParams.iterator();
        while (it.hasNext()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            Parameter param = it.next();
            queryStringBuffer.append(StripeApiHandler.urlEncodePair(param.key, param.value));
        }
        return queryStringBuffer.toString();
    }

    static Map<String, String> getHeaders(RequestOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("Accept", "application/json");
        headers.put("User-Agent", String.format("Stripe/v1 AndroidBindings/%s", "8.0.0"));
        if (options != null) {
            headers.put("Authorization", String.format(Locale.ENGLISH, "Bearer %s", options.getPublishableApiKey()));
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        String systemPropertyName = "java.version";
        propertyMap.put("java.version", System.getProperty("java.version"));
        propertyMap.put("os.name", "android");
        propertyMap.put("os.version", String.valueOf(Build.VERSION.SDK_INT));
        propertyMap.put("bindings.version", "8.0.0");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Stripe");
        JSONObject headerMappingObject = new JSONObject(propertyMap);
        headers.put("X-Stripe-Client-User-Agent", headerMappingObject.toString());
        if (options != null && options.getApiVersion() != null) {
            headers.put("Stripe-Version", options.getApiVersion());
        }
        if (options != null && options.getStripeAccount() != null) {
            headers.put("Stripe-Account", options.getStripeAccount());
        }
        if (options != null && options.getIdempotencyKey() != null) {
            headers.put("Idempotency-Key", options.getIdempotencyKey());
        }
        return headers;
    }

    @VisibleForTesting
    static String getApiUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, TOKENS);
    }

    @VisibleForTesting
    static String getSourcesUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, SOURCES);
    }

    private static String createPaymentIntentUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/payment_intents", LIVE_API_BASE);
    }

    static String retrievePaymentIntentUrl(String paymentIntentId) {
        return String.format(Locale.ENGLISH, "%s/v1/payment_intents/%s", LIVE_API_BASE, paymentIntentId);
    }

    static String confirmPaymentIntentUrl(String paymentIntentId) {
        return String.format(Locale.ENGLISH, "%s/v1/payment_intents/%s/confirm", LIVE_API_BASE, paymentIntentId);
    }

    @VisibleForTesting
    static String getCustomersUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, CUSTOMERS);
    }

    @VisibleForTesting
    static String getAddCustomerSourceUrl(@NonNull String customerId) {
        return String.format(Locale.ENGLISH, "%s/%s", StripeApiHandler.getRetrieveCustomerUrl(customerId), SOURCES);
    }

    @VisibleForTesting
    static String getDeleteCustomerSourceUrl(@NonNull String customerId, @NonNull String sourceId) {
        return String.format(Locale.ENGLISH, "%s/%s", StripeApiHandler.getAddCustomerSourceUrl(customerId), sourceId);
    }

    @VisibleForTesting
    static String getRetrieveCustomerUrl(@NonNull String customerId) {
        return String.format(Locale.ENGLISH, "%s/%s", StripeApiHandler.getCustomersUrl(), customerId);
    }

    @VisibleForTesting
    static String getRetrieveSourceApiUrl(@NonNull String sourceId) {
        return String.format(Locale.ENGLISH, "%s/%s", StripeApiHandler.getSourcesUrl(), sourceId);
    }

    @VisibleForTesting
    static String getRetrieveTokenApiUrl(@NonNull String tokenId) {
        return String.format("%s/%s", StripeApiHandler.getApiUrl(), tokenId);
    }

    static void convertErrorsToExceptionsAndThrowIfNecessary(StripeResponse response) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        List<String> requestIdList;
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        String requestId = null;
        Map<String, List<String>> headers = response.getResponseHeaders();
        List<String> list = requestIdList = headers == null ? null : headers.get("Request-Id");
        if (requestIdList != null && requestIdList.size() > 0) {
            requestId = requestIdList.get(0);
        }
        if (rCode < 200 || rCode >= 300) {
            StripeApiHandler.handleAPIError(rBody, rCode, requestId);
        }
    }

    @Nullable
    private static JSONObject mapToJsonObject(@Nullable Map<String, ? extends Object> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            Object value = mapObject.get(key);
            if (value == null) continue;
            try {
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)StripeApiHandler.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)StripeApiHandler.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    private static JSONArray listToJsonArray(@Nullable List values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                jsonArray.put((Object)StripeApiHandler.mapToJsonObject(mapObject));
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)StripeApiHandler.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)object.toString());
        }
        return jsonArray;
    }

    private static void attachPseudoCookie(@NonNull HttpURLConnection connection, @NonNull RequestOptions options) {
        if (options.getGuid() != null && !TextUtils.isEmpty((CharSequence)options.getGuid())) {
            connection.setRequestProperty("Cookie", "m=" + options.getGuid());
        }
    }

    private static HttpURLConnection createDeleteConnection(@NonNull String url, @NonNull RequestOptions options) throws IOException {
        HttpURLConnection conn = StripeApiHandler.createStripeConnection(url, options);
        conn.setRequestMethod(DELETE);
        return conn;
    }

    private static HttpURLConnection createGetConnection(String url, String query, RequestOptions options) throws IOException {
        String getURL = StripeApiHandler.formatURL(url, query);
        HttpURLConnection conn = StripeApiHandler.createStripeConnection(getURL, options);
        conn.setRequestMethod(GET);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(@NonNull String url, @NonNull Map<String, Object> params, @NonNull RequestOptions options) throws IOException, InvalidRequestException {
        HttpURLConnection conn = StripeApiHandler.createStripeConnection(url, options);
        conn.setDoOutput(true);
        conn.setRequestMethod(POST);
        conn.setRequestProperty("Content-Type", StripeApiHandler.getContentType(options));
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(StripeApiHandler.getOutputBytes(params, options));
        }
        return conn;
    }

    private static HttpURLConnection createStripeConnection(String url, RequestOptions options) throws IOException {
        URL stripeURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)stripeURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        if (StripeApiHandler.urlNeedsHeaderData(url)) {
            for (Map.Entry<String, String> header : StripeApiHandler.getHeaders(options).entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (StripeApiHandler.urlNeedsPseudoCookie(url)) {
            StripeApiHandler.attachPseudoCookie(conn, options);
        }
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireAndForgetApiCall(@NonNull Map<String, Object> paramMap, @NonNull String url, @NonNull String method, @Nullable RequestOptions options, @Nullable LoggingResponseListener listener) {
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            StripeResponse response = StripeApiHandler.getStripeResponse(method, url, paramMap, options);
            if (listener != null) {
                listener.onLoggingResponse(response);
            }
        }
        catch (StripeException stripeException) {
            if (listener != null) {
                listener.onStripeException(stripeException);
            }
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    private static List<Parameter> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        return StripeApiHandler.flattenParamsMap(params, null);
    }

    private static List<Parameter> flattenParamsList(List<Object> params, String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        Iterator<Object> it = params.iterator();
        String newPrefix = String.format("%s[]", keyPrefix);
        if (params.isEmpty()) {
            flatParams.add(new Parameter(keyPrefix, ""));
        } else {
            while (it.hasNext()) {
                flatParams.addAll(StripeApiHandler.flattenParamsValue(it.next(), newPrefix));
            }
        }
        return flatParams;
    }

    private static List<Parameter> flattenParamsMap(Map<String, Object> params, String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params == null) {
            return flatParams;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newPrefix = key;
            if (keyPrefix != null) {
                newPrefix = String.format("%s[%s]", keyPrefix, key);
            }
            flatParams.addAll(StripeApiHandler.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    private static List<Parameter> flattenParamsValue(Object value, String keyPrefix) throws InvalidRequestException {
        List<Parameter> flatParams;
        if (value instanceof Map) {
            flatParams = StripeApiHandler.flattenParamsMap((Map)value, keyPrefix);
        } else if (value instanceof List) {
            flatParams = StripeApiHandler.flattenParamsList((List)value, keyPrefix);
        } else {
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null);
            }
            if (value == null) {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, ""));
            } else {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, value.toString()));
            }
        }
        return flatParams;
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static String getContentType(@NonNull RequestOptions options) {
        if ("json_data".equals(options.getRequestType())) {
            return String.format("application/json; charset=%s", CHARSET);
        }
        return String.format("application/x-www-form-urlencoded;charset=%s", CHARSET);
    }

    private static byte[] getOutputBytes(@NonNull Map<String, Object> params, @NonNull RequestOptions options) throws InvalidRequestException {
        try {
            if ("json_data".equals(options.getRequestType())) {
                JSONObject jsonData = StripeApiHandler.mapToJsonObject(params);
                if (jsonData == null) {
                    throw new InvalidRequestException("Unable to create JSON data from parameters. Please contact support@stripe.com for assistance.", null, null, 0, null);
                }
                return jsonData.toString().getBytes(CHARSET);
            }
            String query = StripeApiHandler.createQuery(params);
            return query.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, 0, e);
        }
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return rBody;
    }

    private static StripeResponse getStripeResponse(String method, String url, Map<String, Object> params, RequestOptions options) throws InvalidRequestException, APIConnectionException, APIException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case "GET": {
                    conn = StripeApiHandler.createGetConnection(url, StripeApiHandler.createQuery(params), options);
                    break;
                }
                case "POST": {
                    conn = StripeApiHandler.createPostConnection(url, params, options);
                    break;
                }
                case "DELETE": {
                    conn = StripeApiHandler.createDeleteConnection(url, options);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the Stripe bindings. Please contact support@stripe.com for assistance.", method));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? StripeApiHandler.getResponseBody(conn.getInputStream()) : StripeApiHandler.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            StripeResponse stripeResponse = new StripeResponse(rCode, rBody, headers);
            return stripeResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists, you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", StripeApiHandler.getApiUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void handleAPIError(String rBody, int rCode, String requestId) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        ErrorParser.StripeError stripeError = ErrorParser.parseError(rBody);
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, rCode, null);
            }
            case 404: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, rCode, null);
            }
            case 401: {
                throw new AuthenticationException(stripeError.message, requestId, rCode);
            }
            case 402: {
                throw new CardException(stripeError.message, requestId, stripeError.code, stripeError.param, stripeError.decline_code, stripeError.charge, rCode, null);
            }
            case 403: {
                throw new PermissionException(stripeError.message, requestId, rCode);
            }
            case 429: {
                throw new RateLimitException(stripeError.message, stripeError.param, requestId, rCode, null);
            }
        }
        throw new APIException(stripeError.message, requestId, rCode, null);
    }

    private static StripeResponse requestData(String method, String url, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        List<String> requestIdList;
        if (options == null) {
            return null;
        }
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        String apiKey = options.getPublishableApiKey();
        if (apiKey.trim().isEmpty()) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Stripe.apiKey = <API-KEY>'. You can generate API keys from the Stripe web interface. See https://stripe.com/api for details or email support@stripe.com if you have questions.", null, 0);
        }
        StripeResponse response = StripeApiHandler.getStripeResponse(method, url, params, options);
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        String requestId = null;
        Map<String, List<String>> headers = response.getResponseHeaders();
        List<String> list = requestIdList = headers == null ? null : headers.get("Request-Id");
        if (requestIdList != null && requestIdList.size() > 0) {
            requestId = requestIdList.get(0);
        }
        if (rCode < 200 || rCode >= 300) {
            StripeApiHandler.handleAPIError(rBody, rCode, requestId);
        }
        if (allowedToSetTTL.booleanValue()) {
            if (originalDNSCacheTTL == null) {
                Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
            } else {
                Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
            }
        }
        return response;
    }

    @Nullable
    private static Token requestToken(String method, String url, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse response = StripeApiHandler.requestData(method, url, params, options);
        return Token.fromString(response.getResponseBody());
    }

    private static void setTelemetryData(@NonNull Context context, @Nullable LoggingResponseListener listener) {
        Map<String, Object> telemetry = TelemetryClientUtil.createTelemetryMap(context);
        StripeNetworkUtils.removeNullAndEmptyParams(telemetry);
        if (listener != null && !listener.shouldLogTest()) {
            return;
        }
        RequestOptions options = RequestOptions.builder(null, "json_data").setGuid(TelemetryClientUtil.getHashedId(context)).build();
        StripeApiHandler.fireAndForgetApiCall(telemetry, LOGGING_ENDPOINT, POST, options, listener);
    }

    private static boolean urlNeedsHeaderData(@NonNull String url) {
        return url.startsWith(LIVE_API_BASE) || url.startsWith(LIVE_LOGGING_BASE);
    }

    private static boolean urlNeedsPseudoCookie(@NonNull String url) {
        return url.startsWith(LOGGING_ENDPOINT);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", StripeApiHandler.urlEncode(k), StripeApiHandler.urlEncode(v));
    }

    private static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private static final class Parameter {
        public final String key;
        public final String value;

        Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    static interface StripeResponseListener {
        public void onStripeResponse(StripeResponse var1);
    }

    static interface LoggingResponseListener {
        public boolean shouldLogTest();

        public void onLoggingResponse(StripeResponse var1);

        public void onStripeException(StripeException var1);
    }
}

