/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.SourceParams;
import java.util.HashMap;
import java.util.Map;

public class PaymentIntentParams {
    static final String API_PARAM_SOURCE_DATA = "source_data";
    static final String API_PARAM_SOURCE_ID = "source";
    static final String API_PARAM_RETURN_URL = "return_url";
    static final String API_PARAM_CLIENT_SECRET = "client_secret";
    private Map<String, Object> mExtraParams;
    private SourceParams mSourceParams;
    private String mSourceId;
    private String mClientSecret;
    private String mReturnUrl;

    private PaymentIntentParams() {
    }

    public static PaymentIntentParams createCustomParams() {
        return new PaymentIntentParams();
    }

    @NonNull
    public static PaymentIntentParams createConfirmPaymentIntentWithSourceData(@Nullable SourceParams sourceParams, @NonNull String clientSecret, @Nullable String returnUrl) {
        return new PaymentIntentParams().setSourceParams(sourceParams).setClientSecret(clientSecret).setReturnUrl(returnUrl);
    }

    @NonNull
    public static PaymentIntentParams createConfirmPaymentIntentWithSourceId(@Nullable String sourceId, @NonNull String clientSecret, @Nullable String returnUrl) {
        return new PaymentIntentParams().setSourceId(sourceId).setClientSecret(clientSecret).setReturnUrl(returnUrl);
    }

    @NonNull
    public static PaymentIntentParams createRetrievePaymentIntent(@NonNull String clientSecret) {
        return new PaymentIntentParams().setClientSecret(clientSecret);
    }

    @NonNull
    public PaymentIntentParams setSourceParams(@NonNull SourceParams sourceParams) {
        this.mSourceParams = sourceParams;
        return this;
    }

    @NonNull
    public PaymentIntentParams setSourceId(@NonNull String sourceId) {
        this.mSourceId = sourceId;
        return this;
    }

    public PaymentIntentParams setClientSecret(@NonNull String clientSecret) {
        this.mClientSecret = clientSecret;
        return this;
    }

    @NonNull
    public PaymentIntentParams setReturnUrl(@NonNull String returnUrl) {
        this.mReturnUrl = returnUrl;
        return this;
    }

    @NonNull
    public PaymentIntentParams setExtraParams(@NonNull Map<String, Object> extraParams) {
        this.mExtraParams = extraParams;
        return this;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        if (this.mSourceParams != null) {
            networkReadyMap.put(API_PARAM_SOURCE_DATA, this.mSourceParams.toParamMap());
        } else if (this.mSourceId != null) {
            networkReadyMap.put(API_PARAM_SOURCE_ID, this.mSourceId);
        }
        if (this.mReturnUrl != null) {
            networkReadyMap.put(API_PARAM_RETURN_URL, this.mReturnUrl);
        }
        networkReadyMap.put(API_PARAM_CLIENT_SECRET, this.mClientSecret);
        if (this.mExtraParams != null) {
            networkReadyMap.putAll(this.mExtraParams);
        }
        return networkReadyMap;
    }

    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public Map<String, Object> getExtraParams() {
        return this.mExtraParams;
    }

    @Nullable
    public SourceParams getSourceParams() {
        return this.mSourceParams;
    }

    @Nullable
    public String getSourceId() {
        return this.mSourceId;
    }

    @Nullable
    public String getReturnUrl() {
        return this.mReturnUrl;
    }
}

