/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.TextInputLayout;
import android.util.AttributeSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class IconTextInputLayout
extends TextInputLayout {
    private static final String BOUNDS_FIELD_NAME = "mCollapsedBounds";
    private static final String TEXT_FIELD_NAME = "mCollapsingTextHelper";
    private static final String RECALCULATE_METHOD_NAME = "recalculate";
    @VisibleForTesting
    Rect mBounds;
    @VisibleForTesting
    Object mCollapsingTextHelper;
    @VisibleForTesting
    Method mRecalculateMethod;

    public IconTextInputLayout(Context context) {
        this(context, null);
    }

    public IconTextInputLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconTextInputLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.adjustBounds();
    }

    @VisibleForTesting
    void init() {
        try {
            Field textHeaderField = TextInputLayout.class.getDeclaredField(TEXT_FIELD_NAME);
            textHeaderField.setAccessible(true);
            this.mCollapsingTextHelper = textHeaderField.get((Object)this);
            Field boundsField = this.mCollapsingTextHelper.getClass().getDeclaredField(BOUNDS_FIELD_NAME);
            boundsField.setAccessible(true);
            this.mBounds = (Rect)boundsField.get(this.mCollapsingTextHelper);
            this.mRecalculateMethod = this.mCollapsingTextHelper.getClass().getDeclaredMethod(RECALCULATE_METHOD_NAME, new Class[0]);
        }
        catch (Exception e) {
            this.mCollapsingTextHelper = null;
            this.mBounds = null;
            this.mRecalculateMethod = null;
            e.printStackTrace();
        }
    }

    private void adjustBounds() {
        if (this.mCollapsingTextHelper == null || this.getEditText() == null) {
            return;
        }
        try {
            this.mBounds.left = this.getEditText().getLeft() + this.getEditText().getPaddingLeft();
            this.mRecalculateMethod.invoke(this.mCollapsingTextHelper, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

