/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Token
implements StripePaymentSource {
    public static final String TYPE_CARD = "card";
    public static final String TYPE_BANK_ACCOUNT = "bank_account";
    public static final String TYPE_PII = "pii";
    private static final String FIELD_BANK_ACCOUNT = "bank_account";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_ID = "id";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USED = "used";
    private final String mId;
    private final String mType;
    private final Date mCreated;
    private final boolean mLivemode;
    private final boolean mUsed;
    private final BankAccount mBankAccount;
    private final Card mCard;

    public Token(String id2, boolean livemode, Date created, Boolean used, Card card) {
        this.mId = id2;
        this.mType = "card";
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = card;
        this.mUsed = used;
        this.mBankAccount = null;
    }

    public Token(String id2, boolean livemode, Date created, Boolean used, BankAccount bankAccount) {
        this.mId = id2;
        this.mType = "bank_account";
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = null;
        this.mUsed = used;
        this.mBankAccount = bankAccount;
    }

    public Token(String id2, boolean livemode, Date created, Boolean used) {
        this.mId = id2;
        this.mType = TYPE_PII;
        this.mCreated = created;
        this.mCard = null;
        this.mBankAccount = null;
        this.mUsed = used;
        this.mLivemode = livemode;
    }

    public Date getCreated() {
        return this.mCreated;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public boolean getLivemode() {
        return this.mLivemode;
    }

    public boolean getUsed() {
        return this.mUsed;
    }

    public String getType() {
        return this.mType;
    }

    public Card getCard() {
        return this.mCard;
    }

    public BankAccount getBankAccount() {
        return this.mBankAccount;
    }

    @Nullable
    public static Token fromString(@Nullable String jsonString) {
        try {
            JSONObject tokenObject = new JSONObject(jsonString);
            return Token.fromJson(tokenObject);
        }
        catch (JSONException exception) {
            return null;
        }
    }

    @Nullable
    public static Token fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String tokenId = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        Long createdTimeStamp = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        Boolean liveMode = StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE);
        String tokenType = Token.asTokenType(StripeJsonUtils.optString(jsonObject, FIELD_TYPE));
        Boolean used = StripeJsonUtils.optBoolean(jsonObject, FIELD_USED);
        if (tokenId == null || createdTimeStamp == null || liveMode == null) {
            return null;
        }
        Date date = new Date(createdTimeStamp * 1000L);
        Token token = null;
        if ("bank_account".equals(tokenType)) {
            JSONObject bankAccountObject = jsonObject.optJSONObject("bank_account");
            if (bankAccountObject == null) {
                return null;
            }
            BankAccount bankAccount = BankAccount.fromJson(bankAccountObject);
            token = new Token(tokenId, (boolean)liveMode, date, used, bankAccount);
        } else if ("card".equals(tokenType)) {
            JSONObject cardObject = jsonObject.optJSONObject("card");
            if (cardObject == null) {
                return null;
            }
            Card card = Card.fromJson(cardObject);
            token = new Token(tokenId, (boolean)liveMode, date, used, card);
        } else if (TYPE_PII.equals(tokenType)) {
            token = new Token(tokenId, liveMode, date, used);
        }
        return token;
    }

    @Nullable
    static String asTokenType(@Nullable String possibleTokenType) {
        if (possibleTokenType == null || TextUtils.isEmpty((CharSequence)possibleTokenType.trim())) {
            return null;
        }
        if ("card".equals(possibleTokenType)) {
            return "card";
        }
        if ("bank_account".equals(possibleTokenType)) {
            return "bank_account";
        }
        if (TYPE_PII.equals(possibleTokenType)) {
            return TYPE_PII;
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TokenType {
    }
}

