/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.SourceCallback;
import com.stripe.android.Stripe;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.StripeActivity;

public class AddSourceActivity
extends StripeActivity {
    public static final String EXTRA_NEW_SOURCE = "new_source";
    static final String ADD_SOURCE_ACTIVITY = "AddSourceActivity";
    static final String EXTRA_SHOW_ZIP = "show_zip";
    static final String EXTRA_PROXY_DELAY = "proxy_delay";
    static final String EXTRA_UPDATE_CUSTOMER = "update_customer";
    CardMultilineWidget mCardMultilineWidget;
    CustomerSessionProxy mCustomerSessionProxy;
    FrameLayout mErrorLayout;
    StripeProvider mStripeProvider;
    private boolean mStartedFromPaymentSession;
    private boolean mUpdatesCustomer;

    public static Intent newIntent(@NonNull Context context, boolean requirePostalField, boolean updatesCustomer) {
        Intent intent = new Intent(context, AddSourceActivity.class);
        intent.putExtra(EXTRA_SHOW_ZIP, requirePostalField);
        intent.putExtra(EXTRA_UPDATE_CUSTOMER, updatesCustomer);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mViewStub.setLayoutResource(R.layout.activity_add_source);
        this.mViewStub.inflate();
        this.mCardMultilineWidget = (CardMultilineWidget)this.findViewById(R.id.add_source_card_entry_widget);
        this.mErrorLayout = (FrameLayout)this.findViewById(R.id.add_source_error_container);
        boolean showZip = this.getIntent().getBooleanExtra(EXTRA_SHOW_ZIP, false);
        this.mUpdatesCustomer = this.getIntent().getBooleanExtra(EXTRA_UPDATE_CUSTOMER, false);
        this.mStartedFromPaymentSession = this.getIntent().getBooleanExtra("payment_session_active", true);
        this.mCardMultilineWidget.setShouldShowPostalCode(showZip);
        if (this.mUpdatesCustomer && !this.getIntent().getBooleanExtra(EXTRA_PROXY_DELAY, false)) {
            this.initCustomerSessionTokens();
        }
        this.setTitle(R.string.title_add_a_card);
    }

    @VisibleForTesting
    void initCustomerSessionTokens() {
        this.logToCustomerSessionIf(ADD_SOURCE_ACTIVITY, this.mUpdatesCustomer);
        this.logToCustomerSessionIf("PaymentSession", this.mStartedFromPaymentSession);
    }

    @Override
    protected void onActionSave() {
        Card card = this.mCardMultilineWidget.getCard();
        if (card == null) {
            return;
        }
        card.addLoggingToken(ADD_SOURCE_ACTIVITY);
        Stripe stripe = this.getStripe();
        stripe.setDefaultPublishableKey(PaymentConfiguration.getInstance().getPublishableKey());
        SourceParams sourceParams = SourceParams.createCardParams(card);
        this.setCommunicatingProgress(true);
        stripe.createSource(sourceParams, new SourceCallback(){

            @Override
            public void onError(Exception error) {
                AddSourceActivity.this.setCommunicatingProgress(false);
                AddSourceActivity.this.showError(error.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Source source) {
                if (AddSourceActivity.this.mUpdatesCustomer) {
                    AddSourceActivity.this.attachCardToCustomer(source);
                } else {
                    AddSourceActivity.this.finishWithSource(source);
                }
            }
        });
    }

    private void attachCardToCustomer(StripePaymentSource source) {
        CustomerSession.SourceRetrievalListener listener = new CustomerSession.SourceRetrievalListener(){

            @Override
            public void onSourceRetrieved(@NonNull Source source) {
                AddSourceActivity.this.finishWithSource(source);
            }

            @Override
            public void onError(int errorCode, @Nullable String errorMessage) {
                String displayedError = errorMessage == null ? "" : errorMessage;
                AddSourceActivity.this.setCommunicatingProgress(false);
                AddSourceActivity.this.showError(displayedError);
            }
        };
        if (this.mCustomerSessionProxy == null) {
            String sourceType = source instanceof Source ? ((Source)source).getType() : (source instanceof Card ? "card" : "unknown");
            CustomerSession.getInstance().addCustomerSource((Context)this, source.getId(), sourceType, listener);
        } else {
            this.mCustomerSessionProxy.addCustomerSource(source.getId(), listener);
        }
    }

    private void logToCustomerSessionIf(@NonNull String logToken, boolean condition) {
        if (this.mCustomerSessionProxy != null) {
            this.logToProxyIf(logToken, condition);
            return;
        }
        if (condition) {
            CustomerSession.getInstance().addProductUsageTokenIfValid(logToken);
        }
    }

    private void logToProxyIf(@NonNull String logToken, boolean condition) {
        if (this.mCustomerSessionProxy != null && condition) {
            this.mCustomerSessionProxy.addProductUsageTokenIfValid(logToken);
        }
    }

    private void finishWithSource(@NonNull Source source) {
        this.setCommunicatingProgress(false);
        Intent intent = new Intent();
        intent.putExtra(EXTRA_NEW_SOURCE, source.toString());
        this.setResult(-1, intent);
        this.finish();
    }

    private Stripe getStripe() {
        if (this.mStripeProvider == null) {
            return new Stripe((Context)this);
        }
        return this.mStripeProvider.getStripe((Context)this);
    }

    @Override
    protected void setCommunicatingProgress(boolean communicating) {
        super.setCommunicatingProgress(communicating);
        if (this.mCardMultilineWidget != null) {
            this.mCardMultilineWidget.setEnabled(!communicating);
        }
    }

    @VisibleForTesting
    void setCustomerSessionProxy(CustomerSessionProxy proxy) {
        this.mCustomerSessionProxy = proxy;
    }

    @VisibleForTesting
    void setStripeProvider(@NonNull StripeProvider stripeProvider) {
        this.mStripeProvider = stripeProvider;
    }

    static interface CustomerSessionProxy {
        public void addProductUsageTokenIfValid(String var1);

        public void addCustomerSource(String var1, CustomerSession.SourceRetrievalListener var2);
    }

    static interface StripeProvider {
        public Stripe getStripe(@NonNull Context var1);
    }
}

