/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ShippingMethod
extends StripeJsonModel
implements Parcelable {
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CURRENCY_CODE = "currency_code";
    private static final String FIELD_DETAIL = "detail";
    private static final String FIELD_IDENTIFIER = "identifier";
    private static final String FIELD_LABEL = "label";
    private long mAmount;
    @NonNull
    @Size(min=0L, max=3L)
    private String mCurrencyCode;
    @Nullable
    private String mDetail;
    @NonNull
    private String mIdentifier;
    @NonNull
    private String mLabel;
    public static final Parcelable.Creator<ShippingMethod> CREATOR = new Parcelable.Creator<ShippingMethod>(){

        public ShippingMethod createFromParcel(Parcel in) {
            return new ShippingMethod(in);
        }

        public ShippingMethod[] newArray(int size) {
            return new ShippingMethod[size];
        }
    };

    public ShippingMethod(@NonNull String label, @NonNull String identifier, @NonNull long amount, @NonNull @Size(min=0L, max=3L) String currencyCode) {
        this(label, identifier, null, amount, currencyCode);
    }

    public ShippingMethod(@NonNull String label, @NonNull String identifier, @Nullable String detail, @NonNull long amount, @NonNull @Size(min=0L, max=3L) String currencyCode) {
        this.mLabel = label;
        this.mIdentifier = identifier;
        this.mDetail = detail;
        this.mAmount = amount;
        this.mCurrencyCode = currencyCode;
    }

    @NonNull
    public Currency getCurrency() {
        return Currency.getInstance(this.mCurrencyCode);
    }

    public long getAmount() {
        return this.mAmount;
    }

    @NonNull
    public String getLabel() {
        return this.mLabel;
    }

    @Nullable
    public String getDetail() {
        return this.mDetail;
    }

    @NonNull
    public String getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putLongIfNotNull(jsonObject, FIELD_AMOUNT, this.mAmount);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CURRENCY_CODE, this.mCurrencyCode);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_DETAIL, this.mDetail);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_IDENTIFIER, this.mIdentifier);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_LABEL, this.mLabel);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_AMOUNT, this.mAmount);
        map.put(FIELD_CURRENCY_CODE, this.mCurrencyCode);
        map.put(FIELD_DETAIL, this.mDetail);
        map.put(FIELD_IDENTIFIER, this.mIdentifier);
        map.put(FIELD_LABEL, this.mLabel);
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.mAmount);
        parcel.writeString(this.mCurrencyCode);
        parcel.writeString(this.mDetail);
        parcel.writeString(this.mIdentifier);
        parcel.writeString(this.mLabel);
    }

    private ShippingMethod(Parcel in) {
        this.mAmount = in.readLong();
        this.mCurrencyCode = in.readString();
        this.mDetail = in.readString();
        this.mIdentifier = in.readString();
        this.mLabel = in.readString();
    }
}

