/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.TextInputEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import com.stripe.android.R;
import com.stripe.android.view.ViewUtils;

public class StripeEditText
extends TextInputEditText {
    @Nullable
    private AfterTextChangedListener mAfterTextChangedListener;
    @Nullable
    private DeleteEmptyListener mDeleteEmptyListener;
    @Nullable
    private ColorStateList mCachedColorStateList;
    private boolean mShouldShowError;
    @ColorRes
    private int mDefaultErrorColorResId;
    @ColorInt
    private int mErrorColor;
    private Handler mHandler;
    private String mErrorMessage;
    private ErrorMessageListener mErrorMessageListener;

    public StripeEditText(Context context) {
        super(context);
        this.initView();
    }

    public StripeEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public StripeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    @Nullable
    public ColorStateList getCachedColorStateList() {
        return this.mCachedColorStateList;
    }

    public boolean getShouldShowError() {
        return this.mShouldShowError;
    }

    @ColorInt
    public int getDefaultErrorColorInt() {
        this.determineDefaultErrorColor();
        int errorColor = Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(this.mDefaultErrorColorResId, null) : this.getResources().getColor(this.mDefaultErrorColorResId);
        return errorColor;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new SoftDeleteInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    void setAfterTextChangedListener(@Nullable AfterTextChangedListener afterTextChangedListener) {
        this.mAfterTextChangedListener = afterTextChangedListener;
    }

    void setDeleteEmptyListener(@Nullable DeleteEmptyListener deleteEmptyListener) {
        this.mDeleteEmptyListener = deleteEmptyListener;
    }

    void setErrorMessageListener(@Nullable ErrorMessageListener errorMessageListener) {
        this.mErrorMessageListener = errorMessageListener;
    }

    void setErrorMessage(@Nullable String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public void setErrorColor(@ColorInt int errorColor) {
        this.mErrorColor = errorColor;
    }

    public void setHintDelayed(final @StringRes int hintResource, long delayMilliseconds) {
        Runnable hintRunnable = new Runnable(){

            @Override
            public void run() {
                StripeEditText.this.setHint(hintResource);
            }
        };
        this.mHandler.postDelayed(hintRunnable, delayMilliseconds);
    }

    public void setShouldShowError(boolean shouldShowError) {
        if (this.mErrorMessage != null && this.mErrorMessageListener != null) {
            String errorMessage = shouldShowError ? this.mErrorMessage : null;
            this.mErrorMessageListener.displayErrorMessage(errorMessage);
        } else {
            this.mShouldShowError = shouldShowError;
            if (this.mShouldShowError) {
                this.setTextColor(this.mErrorColor);
            } else {
                this.setTextColor(this.mCachedColorStateList);
            }
            this.refreshDrawableState();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private void initView() {
        this.mHandler = new Handler();
        this.listenForTextChanges();
        this.listenForDeleteEmpty();
        this.determineDefaultErrorColor();
        this.mCachedColorStateList = this.getTextColors();
    }

    private void determineDefaultErrorColor() {
        this.mCachedColorStateList = this.getTextColors();
        int color2 = this.mCachedColorStateList.getDefaultColor();
        this.mDefaultErrorColorResId = ViewUtils.isColorDark(color2) ? R.color.error_text_light_theme : R.color.error_text_dark_theme;
    }

    private void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (StripeEditText.this.mAfterTextChangedListener != null) {
                    StripeEditText.this.mAfterTextChangedListener.onTextChanged(s.toString());
                }
            }
        });
    }

    private void listenForDeleteEmpty() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 67 && event.getAction() == 0 && StripeEditText.this.mDeleteEmptyListener != null && StripeEditText.this.length() == 0) {
                    StripeEditText.this.mDeleteEmptyListener.onDeleteEmpty();
                }
                return false;
            }
        });
    }

    private class SoftDeleteInputConnection
    extends InputConnectionWrapper {
        public SoftDeleteInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (this.getTextBeforeCursor(1, 0).length() == 0 && StripeEditText.this.mDeleteEmptyListener != null) {
                StripeEditText.this.mDeleteEmptyListener.onDeleteEmpty();
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }

    static interface ErrorMessageListener {
        public void displayErrorMessage(@Nullable String var1);
    }

    static interface AfterTextChangedListener {
        public void onTextChanged(String var1);
    }

    static interface DeleteEmptyListener {
        public void onDeleteEmpty();
    }
}

