/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoggingUtils {
    public static final String ANDROID_PAY_TOKEN = "AndroidPay";
    public static final String PII_TOKEN = "PII";
    public static final String CARD_WIDGET_TOKEN = "CardInputView";
    public static final Set<String> VALID_LOGGING_TOKENS = new HashSet<String>();
    public static final String EVENT_TOKEN_CREATION = "token_creation";
    public static final String EVENT_SOURCE_CREATION = "source_creation";
    public static final String FIELD_PRODUCT_USAGE = "product_usage";
    static final String FIELD_ANALYTICS_UA = "analytics_ua";
    static final String FIELD_BINDINGS_VERSION = "bindings_version";
    static final String FIELD_DEVICE_TYPE = "device_type";
    static final String FIELD_EVENT = "event";
    static final String FIELD_OS_NAME = "os_name";
    static final String FIELD_OS_RELEASE = "os_release";
    static final String FIELD_OS_VERSION = "os_version";
    static final String FIELD_PUBLISHABLE_KEY = "publishable_key";
    static final String FIELD_SOURCE_TYPE = "source_type";
    static final String FIELD_TOKEN_TYPE = "token_type";
    static final Set<String> VALID_PARAM_FIELDS;
    private static final String ANALYTICS_PREFIX = "analytics";
    private static final String ANALYTICS_NAME = "stripe_android";
    private static final String ANALYTICS_VERSION = "1.0";

    @NonNull
    public static Map<String, Object> getTokenCreationParams(@NonNull List<String> productUsageTokens, @NonNull String publishableApiKey, @Nullable String tokenType) {
        return LoggingUtils.getEventLoggingParams(productUsageTokens, null, tokenType, publishableApiKey, EVENT_TOKEN_CREATION);
    }

    @NonNull
    public static Map<String, Object> getSourceCreationParams(@NonNull String publishableApiKey, @NonNull String sourceType) {
        return LoggingUtils.getEventLoggingParams(null, sourceType, null, publishableApiKey, EVENT_SOURCE_CREATION);
    }

    @NonNull
    public static Map<String, Object> getEventLoggingParams(@Nullable List<String> productUsageTokens, @Nullable String sourceType, @Nullable String tokenType, @NonNull String publishableApiKey, @NonNull String eventName) {
        HashMap<String, Object> paramsObject = new HashMap<String, Object>();
        paramsObject.put(FIELD_ANALYTICS_UA, LoggingUtils.getAnalyticsUa());
        paramsObject.put(FIELD_EVENT, LoggingUtils.getEventParamName(eventName));
        paramsObject.put(FIELD_PUBLISHABLE_KEY, publishableApiKey);
        paramsObject.put(FIELD_OS_NAME, Build.VERSION.CODENAME);
        paramsObject.put(FIELD_OS_RELEASE, Build.VERSION.RELEASE);
        paramsObject.put(FIELD_OS_VERSION, Build.VERSION.SDK_INT);
        paramsObject.put(FIELD_DEVICE_TYPE, LoggingUtils.getDeviceLoggingString());
        paramsObject.put(FIELD_BINDINGS_VERSION, "4.1.4");
        if (productUsageTokens != null) {
            paramsObject.put(FIELD_PRODUCT_USAGE, productUsageTokens);
        }
        if (sourceType != null) {
            paramsObject.put(FIELD_SOURCE_TYPE, sourceType);
        }
        if (tokenType != null) {
            paramsObject.put(FIELD_TOKEN_TYPE, tokenType);
        } else if (sourceType == null) {
            paramsObject.put(FIELD_TOKEN_TYPE, "unknown");
        }
        return paramsObject;
    }

    @NonNull
    static String getDeviceLoggingString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Build.MANUFACTURER).append('_').append(Build.BRAND).append('_').append(Build.MODEL);
        return builder.toString();
    }

    @NonNull
    static String getAnalyticsUa() {
        return "analytics.stripe_android-1.0";
    }

    @NonNull
    static String getEventParamName(@NonNull String eventName) {
        return "stripe_android." + eventName;
    }

    static {
        VALID_LOGGING_TOKENS.add(ANDROID_PAY_TOKEN);
        VALID_LOGGING_TOKENS.add(CARD_WIDGET_TOKEN);
        VALID_PARAM_FIELDS = new HashSet<String>();
        VALID_PARAM_FIELDS.add(FIELD_ANALYTICS_UA);
        VALID_PARAM_FIELDS.add(FIELD_BINDINGS_VERSION);
        VALID_PARAM_FIELDS.add(FIELD_DEVICE_TYPE);
        VALID_PARAM_FIELDS.add(FIELD_EVENT);
        VALID_PARAM_FIELDS.add(FIELD_OS_VERSION);
        VALID_PARAM_FIELDS.add(FIELD_OS_NAME);
        VALID_PARAM_FIELDS.add(FIELD_OS_RELEASE);
        VALID_PARAM_FIELDS.add(FIELD_PRODUCT_USAGE);
        VALID_PARAM_FIELDS.add(FIELD_PUBLISHABLE_KEY);
        VALID_PARAM_FIELDS.add(FIELD_SOURCE_TYPE);
        VALID_PARAM_FIELDS.add(FIELD_TOKEN_TYPE);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoggingEventName {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoggingToken {
    }
}

