/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.SourceAddress;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.util.StripeJsonUtils;
import com.stripe.android.util.StripeNetworkUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ShippingInformation
extends StripeJsonModel {
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PHONE = "phone";
    @Nullable
    private SourceAddress mAddress;
    @Nullable
    private String mName;
    @Nullable
    private String mPhone;

    @Nullable
    public SourceAddress getAddress() {
        return this.mAddress;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getPhone() {
        return this.mPhone;
    }

    @Nullable
    public static ShippingInformation fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        ShippingInformation shippingInformation = new ShippingInformation();
        shippingInformation.mName = StripeJsonUtils.optString(jsonObject, FIELD_NAME);
        shippingInformation.mPhone = StripeJsonUtils.optString(jsonObject, FIELD_PHONE);
        shippingInformation.mAddress = SourceAddress.fromJson(jsonObject.optJSONObject(FIELD_ADDRESS));
        return shippingInformation;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_NAME, this.mName);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_PHONE, this.mPhone);
        ShippingInformation.putStripeJsonModelIfNotNull(jsonObject, FIELD_ADDRESS, this.mAddress);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_NAME, this.mName);
        map.put(FIELD_PHONE, this.mPhone);
        ShippingInformation.putStripeJsonModelMapIfNotNull(map, FIELD_ADDRESS, this.mAddress);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }
}

