/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.Card;
import com.stripe.android.util.StripeTextUtils;

public class CardUtils {
    public static final int LENGTH_COMMON_CARD = 16;
    public static final int LENGTH_AMERICAN_EXPRESS = 15;
    public static final int LENGTH_DINERS_CLUB = 14;
    public static final int CVC_LENGTH_COMMON = 3;
    public static final int CVC_LENGTH_AMEX = 4;

    public static boolean isValidCardNumber(@Nullable String cardNumber) {
        String normalizedNumber = StripeTextUtils.removeSpacesAndHyphens(cardNumber);
        return CardUtils.isValidLuhnNumber(normalizedNumber) && CardUtils.isValidCardLength(normalizedNumber);
    }

    public static boolean isValidLuhnNumber(@Nullable String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        boolean isOdd = true;
        int sum = 0;
        for (int index = cardNumber.length() - 1; index >= 0; --index) {
            char c = cardNumber.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Character.getNumericValue(c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    public static boolean isValidCardLength(@Nullable String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        return CardUtils.isValidCardLength(cardNumber, CardUtils.getPossibleCardType(cardNumber, false));
    }

    public static boolean isValidCardLength(@Nullable String cardNumber, @NonNull String cardBrand) {
        if (cardNumber == null || "Unknown".equals(cardBrand)) {
            return false;
        }
        int length = cardNumber.length();
        switch (cardBrand) {
            case "American Express": {
                return length == 15;
            }
            case "Diners Club": {
                return length == 14;
            }
        }
        return length == 16;
    }

    @NonNull
    public static String getPossibleCardType(@Nullable String cardNumber) {
        return CardUtils.getPossibleCardType(cardNumber, true);
    }

    @NonNull
    private static String getPossibleCardType(@Nullable String cardNumber, boolean shouldNormalize) {
        if (StripeTextUtils.isBlank(cardNumber)) {
            return "Unknown";
        }
        String spacelessCardNumber = cardNumber;
        if (shouldNormalize) {
            spacelessCardNumber = StripeTextUtils.removeSpacesAndHyphens(cardNumber);
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_AMERICAN_EXPRESS)) {
            return "American Express";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_DISCOVER)) {
            return "Discover";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_JCB)) {
            return "JCB";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_DINERS_CLUB)) {
            return "Diners Club";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_VISA)) {
            return "Visa";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_MASTERCARD)) {
            return "MasterCard";
        }
        return "Unknown";
    }

    @NonNull
    public static String[] separateCardNumberGroups(@NonNull String spacelessCardNumber, @NonNull String brand) {
        String[] numberGroups;
        if (brand.equals("American Express")) {
            numberGroups = new String[3];
            int length = spacelessCardNumber.length();
            int lastUsedIndex = 0;
            if (length > 4) {
                numberGroups[0] = spacelessCardNumber.substring(0, 4);
                lastUsedIndex = 4;
            }
            if (length > 10) {
                numberGroups[1] = spacelessCardNumber.substring(4, 10);
                lastUsedIndex = 10;
            }
            for (int i = 0; i < 3; ++i) {
                if (numberGroups[i] != null) continue;
                numberGroups[i] = spacelessCardNumber.substring(lastUsedIndex);
                break;
            }
        } else {
            numberGroups = new String[4];
            int i = 0;
            int previousStart = 0;
            while ((i + 1) * 4 < spacelessCardNumber.length()) {
                String group;
                numberGroups[i] = group = spacelessCardNumber.substring(previousStart, (i + 1) * 4);
                previousStart = (i + 1) * 4;
                ++i;
            }
            numberGroups[i] = spacelessCardNumber.substring(previousStart);
        }
        return numberGroups;
    }
}

