/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.time.Clock;
import java.util.Calendar;
import java.util.Locale;

public class DateUtils {
    static final int MAX_VALID_YEAR = 9980;

    public static boolean hasYearPassed(int year) {
        Calendar now;
        int normalized = DateUtils.normalizeYear(year);
        return normalized < (now = Clock.getCalendarInstance()).get(1);
    }

    public static boolean hasMonthPassed(int year, int month) {
        if (DateUtils.hasYearPassed(year)) {
            return true;
        }
        Calendar now = Clock.getCalendarInstance();
        return DateUtils.normalizeYear(year) == now.get(1) && month < now.get(2) + 1;
    }

    public static boolean isValidMonth(@Nullable String monthString) {
        if (monthString == null) {
            return false;
        }
        try {
            int monthInt = Integer.parseInt(monthString);
            return monthInt > 0 && monthInt <= 12;
        }
        catch (NumberFormatException numEx) {
            return false;
        }
    }

    @Size(value=2L)
    @NonNull
    public static String[] separateDateStringParts(@NonNull @Size(max=4L) String expiryInput) {
        String[] parts = new String[2];
        if (expiryInput.length() >= 2) {
            parts[0] = expiryInput.substring(0, 2);
            parts[1] = expiryInput.substring(2);
        } else {
            parts[0] = expiryInput;
            parts[1] = "";
        }
        return parts;
    }

    public static boolean isExpiryDataValid(int expiryMonth, int expiryYear) {
        return DateUtils.isExpiryDataValid(expiryMonth, expiryYear, Calendar.getInstance());
    }

    @VisibleForTesting
    static boolean isExpiryDataValid(int expiryMonth, int expiryYear, @NonNull Calendar calendar) {
        if (expiryMonth < 1 || expiryMonth > 12) {
            return false;
        }
        if (expiryYear < 0 || expiryYear > 9980) {
            return false;
        }
        int currentYear = calendar.get(1);
        if (expiryYear < currentYear) {
            return false;
        }
        if (expiryYear > currentYear) {
            return true;
        }
        int readableMonth = calendar.get(2) + 1;
        return expiryMonth >= readableMonth;
    }

    @IntRange(from=1000L, to=9999L)
    public static int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear) {
        return DateUtils.convertTwoDigitYearToFour(inputYear, Calendar.getInstance());
    }

    @VisibleForTesting
    @IntRange(from=1000L, to=9999L)
    static int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear, @NonNull Calendar calendar) {
        int year = calendar.get(1);
        int centuryBase = year / 100;
        if (year % 100 > 80 && inputYear < 20) {
            ++centuryBase;
        } else if (year % 100 < 20 && inputYear > 80) {
            --centuryBase;
        }
        return centuryBase * 100 + inputYear;
    }

    private static int normalizeYear(int year) {
        if (year < 100 && year >= 0) {
            Calendar now = Clock.getCalendarInstance();
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            year = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return year;
    }
}

