/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class StripeJsonModel {
    @NonNull
    public abstract Map<String, Object> toMap();

    @NonNull
    public abstract JSONObject toJson();

    public String toString() {
        return this.toJson().toString();
    }

    static void putStripeJsonModelMapIfNotNull(@NonNull Map<String, Object> upperLevelMap, @NonNull @Size(min=1L) String key, @Nullable StripeJsonModel jsonModel) {
        if (jsonModel == null) {
            return;
        }
        upperLevelMap.put(key, jsonModel.toMap());
    }

    static void putStripeJsonModelIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String key, @Nullable StripeJsonModel jsonModel) {
        if (jsonModel == null) {
            return;
        }
        try {
            jsonObject.put(key, (Object)jsonModel.toJson());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

