/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.model.StripeSourceTypeModel;
import com.stripe.android.util.StripeJsonUtils;
import com.stripe.android.util.StripeNetworkUtils;
import com.stripe.android.util.StripeTextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceCardData
extends StripeSourceTypeModel {
    public static final String REQUIRED = "required";
    public static final String OPTIONAL = "optional";
    public static final String NOT_SUPPORTED = "not_supported";
    public static final String UNKNOWN = "unknown";
    public static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
    public static final String FIELD_ADDRESS_ZIP_CHECK = "address_zip_check";
    public static final String FIELD_BRAND = "brand";
    public static final String FIELD_COUNTRY = "country";
    public static final String FIELD_CVC_CHECK = "cvc_check";
    public static final String FIELD_DYNAMIC_LAST4 = "dynamic_last4";
    public static final String FIELD_EXP_MONTH = "exp_month";
    public static final String FIELD_EXP_YEAR = "exp_year";
    public static final String FIELD_FUNDING = "funding";
    public static final String FIELD_LAST4 = "last4";
    public static final String FIELD_THREE_D_SECURE = "three_d_secure";
    public static final String FIELD_TOKENIZATION_METHOD = "tokenization_method";
    private String mAddressLine1Check;
    private String mAddressZipCheck;
    private String mBrand;
    private String mCountry;
    private String mCvcCheck;
    private String mDynamicLast4;
    private Integer mExpiryMonth;
    private Integer mExpiryYear;
    private String mFunding;
    private String mLast4;
    private String mThreeDSecureStatus;
    private String mTokenizationMethod;

    private SourceCardData() {
        this.addStandardFields(FIELD_ADDRESS_LINE1_CHECK, FIELD_ADDRESS_ZIP_CHECK, FIELD_BRAND, FIELD_COUNTRY, FIELD_CVC_CHECK, FIELD_DYNAMIC_LAST4, FIELD_EXP_MONTH, FIELD_EXP_YEAR, FIELD_FUNDING, FIELD_LAST4, FIELD_THREE_D_SECURE, FIELD_TOKENIZATION_METHOD);
    }

    @Nullable
    public String getAddressLine1Check() {
        return this.mAddressLine1Check;
    }

    @Nullable
    public String getAddressZipCheck() {
        return this.mAddressZipCheck;
    }

    @Nullable
    public String getBrand() {
        return this.mBrand;
    }

    @Nullable
    public String getCountry() {
        return this.mCountry;
    }

    @Nullable
    public String getCvcCheck() {
        return this.mCvcCheck;
    }

    @Nullable
    public String getDynamicLast4() {
        return this.mDynamicLast4;
    }

    @Nullable
    public Integer getExpiryMonth() {
        return this.mExpiryMonth;
    }

    @Nullable
    public Integer getExpiryYear() {
        return this.mExpiryYear;
    }

    @Nullable
    public String getFunding() {
        return this.mFunding;
    }

    @Nullable
    public String getLast4() {
        return this.mLast4;
    }

    @Nullable
    public String getThreeDSecureStatus() {
        return this.mThreeDSecureStatus;
    }

    @Nullable
    public String getTokenizationMethod() {
        return this.mTokenizationMethod;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ADDRESS_LINE1_CHECK, this.mAddressLine1Check);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ADDRESS_ZIP_CHECK, this.mAddressZipCheck);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_BRAND, this.mBrand);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_COUNTRY, this.mCountry);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_DYNAMIC_LAST4, this.mDynamicLast4);
        StripeJsonUtils.putIntegerIfNotNull(jsonObject, FIELD_EXP_MONTH, this.mExpiryMonth);
        StripeJsonUtils.putIntegerIfNotNull(jsonObject, FIELD_EXP_YEAR, this.mExpiryYear);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_FUNDING, this.mFunding);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_LAST4, this.mLast4);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_THREE_D_SECURE, this.mThreeDSecureStatus);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_TOKENIZATION_METHOD, this.mTokenizationMethod);
        SourceCardData.putAdditionalFieldsIntoJsonObject(jsonObject, this.mAdditionalFields);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put(FIELD_ADDRESS_LINE1_CHECK, this.mAddressLine1Check);
        objectMap.put(FIELD_ADDRESS_ZIP_CHECK, this.mAddressZipCheck);
        objectMap.put(FIELD_BRAND, this.mBrand);
        objectMap.put(FIELD_COUNTRY, this.mCountry);
        objectMap.put(FIELD_DYNAMIC_LAST4, this.mDynamicLast4);
        objectMap.put(FIELD_EXP_MONTH, this.mExpiryMonth);
        objectMap.put(FIELD_EXP_YEAR, this.mExpiryYear);
        objectMap.put(FIELD_FUNDING, this.mFunding);
        objectMap.put(FIELD_LAST4, this.mLast4);
        objectMap.put(FIELD_THREE_D_SECURE, this.mThreeDSecureStatus);
        objectMap.put(FIELD_TOKENIZATION_METHOD, this.mTokenizationMethod);
        SourceCardData.putAdditionalFieldsIntoMap(objectMap, this.mAdditionalFields);
        StripeNetworkUtils.removeNullParams(objectMap);
        return objectMap;
    }

    private SourceCardData setAddressLine1Check(String addressLine1Check) {
        this.mAddressLine1Check = addressLine1Check;
        return this;
    }

    private SourceCardData setAddressZipCheck(String addressZipCheck) {
        this.mAddressZipCheck = addressZipCheck;
        return this;
    }

    private SourceCardData setBrand(String brand) {
        this.mBrand = brand;
        return this;
    }

    private SourceCardData setCountry(String country) {
        this.mCountry = country;
        return this;
    }

    private SourceCardData setCvcCheck(String cvcCheck) {
        this.mCvcCheck = cvcCheck;
        return this;
    }

    private SourceCardData setDynamicLast4(String dynamicLast4) {
        this.mDynamicLast4 = dynamicLast4;
        return this;
    }

    private SourceCardData setExpiryMonth(Integer expiryMonth) {
        this.mExpiryMonth = expiryMonth;
        return this;
    }

    private SourceCardData setExpiryYear(Integer expiryYear) {
        this.mExpiryYear = expiryYear;
        return this;
    }

    private SourceCardData setFunding(String funding) {
        this.mFunding = funding;
        return this;
    }

    private SourceCardData setLast4(String last4) {
        this.mLast4 = last4;
        return this;
    }

    private SourceCardData setThreeDSecureStatus(String threeDSecureStatus) {
        this.mThreeDSecureStatus = threeDSecureStatus;
        return this;
    }

    private SourceCardData setTokenizationMethod(String tokenizationMethod) {
        this.mTokenizationMethod = tokenizationMethod;
        return this;
    }

    @Nullable
    static SourceCardData fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        SourceCardData cardData = new SourceCardData();
        cardData.setAddressLine1Check(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE1_CHECK)).setAddressZipCheck(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_ZIP_CHECK)).setBrand(StripeTextUtils.asCardBrand(StripeJsonUtils.optString(jsonObject, FIELD_BRAND))).setCountry(StripeJsonUtils.optString(jsonObject, FIELD_COUNTRY)).setCvcCheck(StripeJsonUtils.optString(jsonObject, FIELD_CVC_CHECK)).setDynamicLast4(StripeJsonUtils.optString(jsonObject, FIELD_DYNAMIC_LAST4)).setExpiryMonth(StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_MONTH)).setExpiryYear(StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_YEAR)).setFunding(StripeTextUtils.asFundingType(StripeJsonUtils.optString(jsonObject, FIELD_FUNDING))).setLast4(StripeJsonUtils.optString(jsonObject, FIELD_LAST4)).setThreeDSecureStatus(SourceCardData.asThreeDSecureStatus(StripeJsonUtils.optString(jsonObject, FIELD_THREE_D_SECURE))).setTokenizationMethod(StripeJsonUtils.optString(jsonObject, FIELD_TOKENIZATION_METHOD));
        Map<String, Object> nonStandardFields = SourceCardData.jsonObjectToMapWithoutKeys(jsonObject, cardData.mStandardFields);
        if (nonStandardFields != null) {
            cardData.setAdditionalFields(nonStandardFields);
        }
        return cardData;
    }

    @VisibleForTesting
    static SourceCardData fromString(String jsonString) {
        try {
            return SourceCardData.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException badJson) {
            return null;
        }
    }

    @Nullable
    static String asThreeDSecureStatus(@Nullable String threeDSecureStatus) {
        String nullChecked = StripeJsonUtils.nullIfNullOrEmpty(threeDSecureStatus);
        if (nullChecked == null) {
            return null;
        }
        if (REQUIRED.equalsIgnoreCase(threeDSecureStatus)) {
            return REQUIRED;
        }
        if (OPTIONAL.equalsIgnoreCase(threeDSecureStatus)) {
            return OPTIONAL;
        }
        if (NOT_SUPPORTED.equalsIgnoreCase(threeDSecureStatus)) {
            return NOT_SUPPORTED;
        }
        return UNKNOWN;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThreeDSecureStatus {
    }
}

