/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Application;
import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.paymentsheet.DefaultPrefsRepository;
import com.stripe.android.paymentsheet.PaymentOptionContract;
import com.stripe.android.paymentsheet.PaymentOptionResult;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PrefsRepository;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.model.FragmentConfig;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000212B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020%H\u0016J\u0006\u0010)\u001a\u00020%J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200R\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00063"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel;", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "args", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "prefsRepository", "Lcom/stripe/android/paymentsheet/PrefsRepository;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "application", "Landroid/app/Application;", "(Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;Lcom/stripe/android/paymentsheet/PrefsRepository;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lkotlin/coroutines/CoroutineContext;Landroid/app/Application;)V", "_paymentOptionResult", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/paymentsheet/PaymentOptionResult;", "get_paymentOptionResult$stripe_release$annotations", "()V", "get_paymentOptionResult$stripe_release", "()Landroidx/lifecycle/MutableLiveData;", "hasTransitionToUnsavedCard", "", "newCard", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$Card;", "getNewCard", "()Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$Card;", "setNewCard", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$Card;)V", "paymentOptionResult", "Landroidx/lifecycle/LiveData;", "getPaymentOptionResult$stripe_release", "()Landroidx/lifecycle/LiveData;", "shouldTransitionToUnsavedCard", "getShouldTransitionToUnsavedCard", "()Z", "onFatal", "", "throwable", "", "onUserCancel", "onUserSelection", "processExistingCard", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "processNewCard", "resolveTransitionTarget", "config", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "Factory", "TransitionTarget", "stripe_release"})
public final class PaymentOptionsViewModel
extends BaseSheetViewModel<TransitionTarget> {
    @NotNull
    private final EventReporter eventReporter;
    @NotNull
    private final MutableLiveData<PaymentOptionResult> _paymentOptionResult;
    @NotNull
    private final LiveData<PaymentOptionResult> paymentOptionResult;
    @Nullable
    private PaymentSelection.New.Card newCard;
    private boolean hasTransitionToUnsavedCard;

    public PaymentOptionsViewModel(@NotNull PaymentOptionContract.Args args2, @NotNull PrefsRepository prefsRepository2, @NotNull EventReporter eventReporter2, @NotNull CoroutineContext workContext, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)prefsRepository2, (String)"prefsRepository");
        Intrinsics.checkNotNullParameter((Object)eventReporter2, (String)"eventReporter");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PaymentSheet.Configuration configuration = args2.getConfig();
        super(application, configuration, prefsRepository2, workContext);
        this.eventReporter = eventReporter2;
        this._paymentOptionResult = new MutableLiveData();
        this.paymentOptionResult = (LiveData)this._paymentOptionResult;
        this.newCard = args2.getNewCard();
        this.get_isGooglePayReady().setValue((Object)args2.isGooglePayReady());
        this.get_paymentIntent().setValue((Object)args2.getPaymentIntent());
        this.get_paymentMethods().setValue(args2.getPaymentMethods());
        this.get_processing$stripe_release().postValue((Object)false);
    }

    @NotNull
    public final MutableLiveData<PaymentOptionResult> get_paymentOptionResult$stripe_release() {
        return this._paymentOptionResult;
    }

    @VisibleForTesting
    public static /* synthetic */ void get_paymentOptionResult$stripe_release$annotations() {
    }

    @NotNull
    public final LiveData<PaymentOptionResult> getPaymentOptionResult$stripe_release() {
        return this.paymentOptionResult;
    }

    @Override
    @Nullable
    public PaymentSelection.New.Card getNewCard() {
        return this.newCard;
    }

    @Override
    public void setNewCard(@Nullable PaymentSelection.New.Card card) {
        this.newCard = card;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldTransitionToUnsavedCard() {
        if (this.hasTransitionToUnsavedCard) return false;
        PaymentSelection.New.Card card = this.getNewCard();
        if (!(card instanceof PaymentSelection.New)) return false;
        PaymentSelection.New new_ = card;
        PaymentSelection.New new_2 = new_;
        if (new_2 == null) {
            return false;
        }
        PaymentSelection.New new_3 = new_2;
        boolean bl = false;
        boolean bl2 = false;
        PaymentSelection.New it = new_3;
        boolean bl3 = false;
        if (it.getShouldSavePaymentMethod()) return false;
        return true;
    }

    @Override
    public void onFatal(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.get_fatal().setValue((Object)throwable);
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Failed(throwable));
    }

    @Override
    public void onUserCancel() {
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Canceled((Throwable)this.get_fatal().getValue()));
    }

    public final void onUserSelection() {
        PaymentSelection paymentSelection = (PaymentSelection)this.getSelection$stripe_release().getValue();
        if (paymentSelection != null) {
            PaymentSelection paymentSelection2 = paymentSelection;
            boolean bl = false;
            boolean bl2 = false;
            PaymentSelection paymentSelection3 = paymentSelection2;
            boolean bl3 = false;
            this.eventReporter.onSelectPaymentOption(paymentSelection3);
            PaymentSelection paymentSelection4 = paymentSelection3;
            if (paymentSelection4 instanceof PaymentSelection.Saved ? true : Intrinsics.areEqual((Object)paymentSelection4, (Object)PaymentSelection.GooglePay.INSTANCE)) {
                this.processExistingCard(paymentSelection3);
            } else if (paymentSelection4 instanceof PaymentSelection.New) {
                this.processNewCard(paymentSelection3);
            }
        }
    }

    private final void processExistingCard(PaymentSelection paymentSelection) {
        this.getPrefsRepository().savePaymentSelection(paymentSelection);
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Succeeded(paymentSelection));
    }

    private final void processNewCard(PaymentSelection paymentSelection) {
        this.getPrefsRepository().savePaymentSelection(paymentSelection);
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Succeeded(paymentSelection));
    }

    public final void resolveTransitionTarget(@NotNull FragmentConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.getShouldTransitionToUnsavedCard()) {
            this.hasTransitionToUnsavedCard = true;
            this.transitionTo(new TransitionTarget.AddPaymentMethodFull(config));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "", "()V", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "AddPaymentMethodFull", "AddPaymentMethodSheet", "SelectSavedPaymentMethod", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$SelectSavedPaymentMethod;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodFull;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodSheet;", "stripe_release"})
    public static abstract class TransitionTarget {
        private TransitionTarget() {
        }

        @NotNull
        public abstract FragmentConfig getFragmentConfig();

        public /* synthetic */ TransitionTarget(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$SelectSavedPaymentMethod;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class SelectSavedPaymentMethod
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;

            public SelectSavedPaymentMethod(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final SelectSavedPaymentMethod copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new SelectSavedPaymentMethod(fragmentConfig);
            }

            public static /* synthetic */ SelectSavedPaymentMethod copy$default(SelectSavedPaymentMethod selectSavedPaymentMethod, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = selectSavedPaymentMethod.getFragmentConfig();
                }
                return selectSavedPaymentMethod.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "SelectSavedPaymentMethod(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SelectSavedPaymentMethod)) {
                    return false;
                }
                SelectSavedPaymentMethod selectSavedPaymentMethod = (SelectSavedPaymentMethod)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)selectSavedPaymentMethod.getFragmentConfig());
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodFull;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class AddPaymentMethodFull
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;

            public AddPaymentMethodFull(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final AddPaymentMethodFull copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new AddPaymentMethodFull(fragmentConfig);
            }

            public static /* synthetic */ AddPaymentMethodFull copy$default(AddPaymentMethodFull addPaymentMethodFull, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = addPaymentMethodFull.getFragmentConfig();
                }
                return addPaymentMethodFull.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "AddPaymentMethodFull(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddPaymentMethodFull)) {
                    return false;
                }
                AddPaymentMethodFull addPaymentMethodFull = (AddPaymentMethodFull)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)addPaymentMethodFull.getFragmentConfig());
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodSheet;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class AddPaymentMethodSheet
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;

            public AddPaymentMethodSheet(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final AddPaymentMethodSheet copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new AddPaymentMethodSheet(fragmentConfig);
            }

            public static /* synthetic */ AddPaymentMethodSheet copy$default(AddPaymentMethodSheet addPaymentMethodSheet, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = addPaymentMethodSheet.getFragmentConfig();
                }
                return addPaymentMethodSheet.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "AddPaymentMethodSheet(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddPaymentMethodSheet)) {
                    return false;
                }
                AddPaymentMethodSheet addPaymentMethodSheet = (AddPaymentMethodSheet)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)addPaymentMethodSheet.getFragmentConfig());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J'\u0010\b\u001a\u0002H\t\"\n\b\u0000\u0010\t*\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "applicationSupplier", "Lkotlin/Function0;", "Landroid/app/Application;", "starterArgsSupplier", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Function0<Application> applicationSupplier;
        @NotNull
        private final Function0<PaymentOptionContract.Args> starterArgsSupplier;

        public Factory(@NotNull Function0<? extends Application> applicationSupplier, @NotNull Function0<PaymentOptionContract.Args> starterArgsSupplier) {
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter(starterArgsSupplier, (String)"starterArgsSupplier");
            this.applicationSupplier = applicationSupplier;
            this.starterArgsSupplier = starterArgsSupplier;
        }

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            DefaultPrefsRepository defaultPrefsRepository;
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            PaymentOptionContract.Args starterArgs2 = (PaymentOptionContract.Args)this.starterArgsSupplier.invoke();
            Application application = (Application)this.applicationSupplier.invoke();
            PaymentSheet.Configuration configuration = starterArgs2.getConfig();
            if (configuration == null) {
                defaultPrefsRepository = null;
            } else {
                PaymentSheet.CustomerConfiguration customerConfiguration = configuration.getCustomer();
                if (customerConfiguration == null) {
                    defaultPrefsRepository = null;
                } else {
                    PaymentSheet.CustomerConfiguration customerConfiguration2 = customerConfiguration;
                    boolean bl = false;
                    boolean bl2 = false;
                    PaymentSheet.CustomerConfiguration $dstr$id = customerConfiguration2;
                    boolean bl3 = false;
                    String id2 = $dstr$id.component1();
                    defaultPrefsRepository = new DefaultPrefsRepository((Context)application, id2, (Function1<? super Continuation<? super Boolean>, ? extends Object>)((Function1)new Function1<Continuation<? super Boolean>, Object>(starterArgs2, null){
                        int label;
                        final /* synthetic */ PaymentOptionContract.Args $starterArgs;
                        {
                            this.$starterArgs = $starterArgs;
                            super(1, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    return Boxing.boxBoolean((boolean)this.$starterArgs.isGooglePayReady());
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@Nullable Continuation<? super Boolean> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (CoroutineContext)Dispatchers.INSTANCE.getIO());
                }
            }
            DefaultPrefsRepository defaultPrefsRepository2 = defaultPrefsRepository;
            PrefsRepository prefsRepository2 = defaultPrefsRepository2 == null ? (PrefsRepository)new PrefsRepository.Noop() : (PrefsRepository)defaultPrefsRepository2;
            return (T)((ViewModel)new PaymentOptionsViewModel(starterArgs2, prefsRepository2, new DefaultEventReporter(EventReporter.Mode.Custom, starterArgs2.getSessionId(), (Context)application, null, 8, null), (CoroutineContext)Dispatchers.INSTANCE.getIO(), application));
        }
    }
}

