/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.payments.BrowserCapabilities;
import com.stripe.android.payments.BrowserCapabilitiesSupplier;
import com.stripe.android.payments.PaymentFlowResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "browserCapabilities", "Lcom/stripe/android/payments/BrowserCapabilities;", "intentChooserTitle", "", "(Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lcom/stripe/android/payments/BrowserCapabilities;Ljava/lang/String;)V", "createLaunchIntent", "Landroid/content/Intent;", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "getResultIntent", "logCapabilities", "", "shouldUseCustomTabs", "", "Factory", "stripe_release"})
public final class StripeBrowserLauncherViewModel
extends ViewModel {
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final BrowserCapabilities browserCapabilities;
    @NotNull
    private final String intentChooserTitle;

    public StripeBrowserLauncherViewModel(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull BrowserCapabilities browserCapabilities, @NotNull String intentChooserTitle) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)browserCapabilities), (String)"browserCapabilities");
        Intrinsics.checkNotNullParameter((Object)intentChooserTitle, (String)"intentChooserTitle");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
        this.browserCapabilities = browserCapabilities;
        this.intentChooserTitle = intentChooserTitle;
    }

    @NotNull
    public final Intent createLaunchIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        boolean shouldUseCustomTabs = this.browserCapabilities == BrowserCapabilities.CustomTabs;
        this.logCapabilities(shouldUseCustomTabs);
        Uri url = Uri.parse((String)args2.getUrl());
        if (shouldUseCustomTabs) {
            boolean bl;
            Integer n;
            CustomTabColorSchemeParams customTabColorSchemeParams;
            Integer n2 = args2.getStatusBarColor();
            if (n2 == null) {
                customTabColorSchemeParams = null;
            } else {
                n = n2;
                boolean bl2 = false;
                bl = false;
                int statusBarColor = ((Number)n).intValue();
                boolean bl3 = false;
                customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(statusBarColor).build();
            }
            CustomTabColorSchemeParams customTabColorSchemeParams2 = customTabColorSchemeParams;
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder().setShareState(2);
            bl = false;
            boolean bl4 = false;
            CustomTabsIntent.Builder it = builder;
            boolean bl5 = false;
            if (customTabColorSchemeParams2 != null) {
                it.setDefaultColorSchemeParams(customTabColorSchemeParams2);
            }
            n = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"Builder()\n                .setShareState(CustomTabsIntent.SHARE_STATE_OFF)\n                .also {\n                    if (customTabColorSchemeParams != null) {\n                        it.setDefaultColorSchemeParams(customTabColorSchemeParams)\n                    }\n                }\n                .build()");
            Integer customTabsIntent = n;
            ((CustomTabsIntent)customTabsIntent).intent.setData(url);
            Intent intent2 = Intent.createChooser((Intent)((CustomTabsIntent)customTabsIntent).intent, (CharSequence)this.intentChooserTitle);
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n            val customTabColorSchemeParams = args.statusBarColor?.let { statusBarColor ->\n                CustomTabColorSchemeParams.Builder()\n                    .setToolbarColor(statusBarColor)\n                    .build()\n            }\n\n            // use Custom Tabs\n            val customTabsIntent = CustomTabsIntent.Builder()\n                .setShareState(CustomTabsIntent.SHARE_STATE_OFF)\n                .also {\n                    if (customTabColorSchemeParams != null) {\n                        it.setDefaultColorSchemeParams(customTabColorSchemeParams)\n                    }\n                }\n                .build()\n            customTabsIntent.intent.data = url\n\n            Intent.createChooser(\n                customTabsIntent.intent,\n                intentChooserTitle\n            )\n        }");
            intent = intent2;
        } else {
            Intent intent3 = Intent.createChooser((Intent)new Intent("android.intent.action.VIEW", url), (CharSequence)this.intentChooserTitle);
            Intrinsics.checkNotNullExpressionValue((Object)intent3, (String)"{\n            // use default device browser\n            Intent.createChooser(\n                Intent(Intent.ACTION_VIEW, url),\n                intentChooserTitle\n            )\n        }");
            intent = intent3;
        }
        return intent;
    }

    @NotNull
    public final Intent getResultIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        Intent intent = new Intent();
        String string2 = args2.getClientSecret();
        String string3 = url.getLastPathSegment();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        string3 = args2.getStripeAccountId();
        bl = args2.getShouldCancelSource();
        Intent intent2 = intent.putExtras(new PaymentFlowResult.Unvalidated(string2, 0, null, bl, string5, null, string3, 38, null).toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent().putExtras(\n            PaymentFlowResult.Unvalidated(\n                clientSecret = args.clientSecret,\n                sourceId = url.lastPathSegment.orEmpty(),\n                stripeAccountId = args.stripeAccountId,\n                canCancelSource = args.shouldCancelSource\n            ).toBundle()\n        )");
        return intent2;
    }

    public final void logCapabilities(boolean shouldUseCustomTabs) {
        AnalyticsEvent analyticsEvent;
        boolean bl = shouldUseCustomTabs;
        if (bl) {
            analyticsEvent = AnalyticsEvent.AuthWithCustomTabs;
        } else if (!bl) {
            analyticsEvent = AnalyticsEvent.AuthWithDefaultBrowser;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, analyticsEvent, null, null, null, null, 30, null));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Application application;

        public Factory(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
        }

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            PaymentConfiguration config = PaymentConfiguration.Companion.getInstance((Context)this.application);
            BrowserCapabilitiesSupplier browserCapabilitiesSupplier = new BrowserCapabilitiesSupplier((Context)this.application);
            AnalyticsRequestExecutor analyticsRequestExecutor = new AnalyticsRequestExecutor.Default(null, null, 3, null);
            AnalyticsRequestFactory analyticsRequestFactory = new AnalyticsRequestFactory((Context)this.application, config.getPublishableKey());
            BrowserCapabilities browserCapabilities = browserCapabilitiesSupplier.get();
            String string2 = this.application.getString(R.string.stripe_verify_your_payment);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"application.getString(R.string.stripe_verify_your_payment)");
            return (T)((Object)new StripeBrowserLauncherViewModel(analyticsRequestExecutor, analyticsRequestFactory, browserCapabilities, string2));
        }
    }
}

