/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.RequestHeadersFactory;
import com.stripe.android.networking.StripeClientUserAgentHeaderFactory;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000e2\u00020\u0001:\u0004\f\r\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004R\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory;", "", "()V", "extraHeaders", "", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "create", "Analytics", "Api", "Companion", "Fingerprint", "Lcom/stripe/android/networking/RequestHeadersFactory$Api;", "Lcom/stripe/android/networking/RequestHeadersFactory$Fingerprint;", "Lcom/stripe/android/networking/RequestHeadersFactory$Analytics;", "stripe_release"})
public abstract class RequestHeadersFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HEADER_USER_AGENT = "User-Agent";
    @NotNull
    private static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    private static final String CHARSET = Charsets.UTF_8.name();

    private RequestHeadersFactory() {
    }

    @NotNull
    public final Map<String, String> create() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)HEADER_USER_AGENT, (Object)this.getUserAgent()), TuplesKt.to((Object)HEADER_ACCEPT_CHARSET, (Object)CHARSET)};
        return MapsKt.plus(this.getExtraHeaders(), (Map)MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    protected abstract String getUserAgent();

    @NotNull
    protected abstract Map<String, String> getExtraHeaders();

    public /* synthetic */ RequestHeadersFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Api;", "Lcom/stripe/android/networking/RequestHeadersFactory;", "options", "Lcom/stripe/android/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "locale", "Ljava/util/Locale;", "systemPropertySupplier", "Lkotlin/Function1;", "", "apiVersion", "sdkVersion", "(Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/AppInfo;Ljava/util/Locale;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "languageTag", "getLanguageTag", "()Ljava/lang/String;", "stripeClientUserAgentHeaderFactory", "Lcom/stripe/android/networking/StripeClientUserAgentHeaderFactory;", "userAgent", "getUserAgent", "Companion", "stripe_release"})
    public static final class Api
    extends RequestHeadersFactory {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final ApiRequest.Options options;
        @Nullable
        private final AppInfo appInfo;
        @NotNull
        private final Locale locale;
        @NotNull
        private final String apiVersion;
        @NotNull
        private final String sdkVersion;
        @NotNull
        private final StripeClientUserAgentHeaderFactory stripeClientUserAgentHeaderFactory;
        @Deprecated
        @NotNull
        private static final Function1<String, String> DEFAULT_SYSTEM_PROPERTY_SUPPLIER = Companion.DEFAULT_SYSTEM_PROPERTY_SUPPLIER.1.INSTANCE;

        public Api(@NotNull ApiRequest.Options options, @Nullable AppInfo appInfo, @NotNull Locale locale, @NotNull Function1<? super String, String> systemPropertySupplier, @NotNull String apiVersion, @NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter(systemPropertySupplier, (String)"systemPropertySupplier");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            super(null);
            this.options = options;
            this.appInfo = appInfo;
            this.locale = locale;
            this.apiVersion = apiVersion;
            this.sdkVersion = sdkVersion;
            this.stripeClientUserAgentHeaderFactory = new StripeClientUserAgentHeaderFactory(systemPropertySupplier);
        }

        public /* synthetic */ Api(ApiRequest.Options options, AppInfo appInfo, Locale locale, Function1 function1, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                appInfo = null;
            }
            if ((n & 4) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                locale = locale2;
            }
            if ((n & 8) != 0) {
                function1 = DEFAULT_SYSTEM_PROPERTY_SUPPLIER;
            }
            if ((n & 0x10) != 0) {
                string2 = ApiVersion.Companion.get$stripe_release().getCode();
            }
            if ((n & 0x20) != 0) {
                string3 = "AndroidBindings/16.8.2";
            }
            this(options, appInfo, locale, function1, string2, string3);
        }

        private final String getLanguageTag() {
            String string2 = this.locale.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.toString()");
            string2 = StringsKt.replace$default((String)string2, (String)"_", (String)"-", (boolean)false, (int)4, null);
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            return !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            AppInfo appInfo;
            Object[] objectArray = new String[]{Companion.getUserAgent$stripe_release(this.sdkVersion), (appInfo = this.appInfo) == null ? null : appInfo.toUserAgent$stripe_release()};
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            Map map;
            Map map2;
            Map map3;
            Object it;
            Map map4;
            boolean bl;
            boolean bl2;
            Map map5;
            Object object = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Stripe-Version", (Object)this.apiVersion), TuplesKt.to((Object)"Authorization", (Object)Intrinsics.stringPlus((String)"Bearer ", (Object)this.options.getApiKey()))};
            Map map6 = MapsKt.plus((Map)MapsKt.mapOf((Pair[])object), this.stripeClientUserAgentHeaderFactory.create(this.appInfo));
            object = this.options.getStripeAccount$stripe_release();
            if (object == null) {
                map5 = null;
            } else {
                Object object2 = object;
                bl2 = false;
                bl = false;
                Object object3 = object2;
                map4 = map6;
                boolean bl3 = false;
                map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Account", (Object)it));
                map6 = map4;
                map5 = map3;
            }
            object = map5;
            boolean bl4 = false;
            Object object4 = object;
            if (object == null) {
                object4 = MapsKt.emptyMap();
            }
            Map map7 = MapsKt.plus((Map)map6, (Map)object4);
            object = this.options.getIdempotencyKey$stripe_release();
            if (object == null) {
                map2 = null;
            } else {
                Object object5 = object;
                bl2 = false;
                bl = false;
                it = object5;
                map4 = map7;
                boolean bl5 = false;
                map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Idempotency-Key", (Object)it));
                map7 = map4;
                map2 = map3;
            }
            object = map2;
            boolean bl6 = false;
            Object object6 = object;
            if (object == null) {
                object6 = MapsKt.emptyMap();
            }
            Map map8 = MapsKt.plus((Map)map7, (Map)object6);
            object = this.getLanguageTag();
            if (object == null) {
                map = null;
            } else {
                Object object7 = object;
                bl2 = false;
                bl = false;
                it = object7;
                map4 = map8;
                boolean bl7 = false;
                map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)it));
                map8 = map4;
                map = map3;
            }
            object = map;
            boolean bl8 = false;
            Object object8 = object;
            if (object == null) {
                object8 = MapsKt.emptyMap();
            }
            return MapsKt.plus((Map)map8, (Map)object8);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Api$Companion;", "", "()V", "DEFAULT_SYSTEM_PROPERTY_SUPPLIER", "Lkotlin/Function1;", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Fingerprint;", "Lcom/stripe/android/networking/RequestHeadersFactory;", "guid", "", "(Ljava/lang/String;)V", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "Companion", "stripe_release"})
    public static final class Fingerprint
    extends RequestHeadersFactory {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, String> extraHeaders;
        @NotNull
        private final String userAgent;
        @Deprecated
        @NotNull
        private static final String HEADER_COOKIE = "Cookie";

        public Fingerprint(@NotNull String guid) {
            Intrinsics.checkNotNullParameter((Object)guid, (String)"guid");
            super(null);
            this.extraHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)HEADER_COOKIE, (Object)Intrinsics.stringPlus((String)"m=", (Object)guid)));
            this.userAgent = Companion.getUserAgent$stripe_release("AndroidBindings/16.8.2");
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            return this.extraHeaders;
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            return this.userAgent;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Fingerprint$Companion;", "", "()V", "HEADER_COOKIE", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Analytics;", "Lcom/stripe/android/networking/RequestHeadersFactory;", "()V", "extraHeaders", "", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "stripe_release"})
    public static final class Analytics
    extends RequestHeadersFactory {
        @NotNull
        public static final Analytics INSTANCE = new Analytics();
        @NotNull
        private static final String userAgent = Companion.getUserAgent$stripe_release("AndroidBindings/16.8.2");
        @NotNull
        private static final Map<String, String> extraHeaders = MapsKt.emptyMap();

        private Analytics() {
            super(null);
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            return userAgent;
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            return extraHeaders;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Companion;", "", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "HEADER_ACCEPT_CHARSET", "HEADER_USER_AGENT", "getUserAgent", "sdkVersion", "getUserAgent$stripe_release", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUserAgent$stripe_release(@NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            return Intrinsics.stringPlus((String)"Stripe/v1 ", (Object)sdkVersion);
        }

        public static /* synthetic */ String getUserAgent$stripe_release$default(Companion companion, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = "AndroidBindings/16.8.2";
            }
            return companion.getUserAgent$stripe_release(string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

