/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.StripeError;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.networking.QueryStringFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u0006J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0002J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/networking/QueryStringFactory;", "", "()V", "create", "", "params", "", "flattenParams", "", "Lcom/stripe/android/networking/QueryStringFactory$Parameter;", "flattenParamsList", "keyPrefix", "flattenParamsMap", "flattenParamsValue", "value", "Parameter", "stripe_release"})
public final class QueryStringFactory {
    @NotNull
    public final String create(@Nullable Map<String, ?> params) {
        return CollectionsKt.joinToString$default((Iterable)this.flattenParams(params), (CharSequence)"&", null, null, (int)0, null, (Function1)create.1.INSTANCE, (int)30, null);
    }

    private final List<Parameter> flattenParams(Map<String, ?> params) throws InvalidRequestException {
        return QueryStringFactory.flattenParamsMap$default(this, params, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> flattenParamsList(List<?> params, String keyPrefix) throws InvalidRequestException {
        List list;
        if (params.isEmpty()) {
            list = CollectionsKt.listOf((Object)new Parameter(keyPrefix, ""));
        } else {
            void $this$flatMapTo$iv$iv;
            String newPrefix = Intrinsics.stringPlus((String)keyPrefix, (Object)"[]");
            Iterable $this$flatMap$iv = params;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = this.flattenParamsValue(it, newPrefix);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> flattenParamsMap(Map<String, ?> params, String keyPrefix) throws InvalidRequestException {
        List list;
        Map<String, ?> map = params;
        if (map == null) {
            list = null;
        } else {
            void $this$flatMapTo$iv$iv;
            Map<String, ?> $this$flatMap$iv = map;
            boolean $i$f$flatMap = false;
            Map<String, ?> map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var10_9 = $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var10_9.entrySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                Map.Entry element$iv$iv;
                Map.Entry $dstr$key$value = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl3 = false;
                String key = (String)entry.getKey();
                Map.Entry entry2 = $dstr$key$value;
                boolean bl4 = false;
                Object value = entry2.getValue();
                String string3 = keyPrefix;
                if (string3 == null) {
                    string2 = key;
                } else {
                    String string4 = string3;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String it = string4;
                    boolean bl7 = false;
                    String string5 = it + '[' + key + ']';
                    string2 = string5 == null ? key : string5;
                }
                String newPrefix = string2;
                Iterable list$iv$iv = this.flattenParamsValue(value, newPrefix);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    static /* synthetic */ List flattenParamsMap$default(QueryStringFactory queryStringFactory, Map map, String string2, int n, Object object) throws InvalidRequestException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return queryStringFactory.flattenParamsMap(map, string2);
    }

    private final List<Parameter> flattenParamsValue(Object value, String keyPrefix) throws InvalidRequestException {
        List list;
        Object object = value;
        if (object instanceof Map) {
            list = this.flattenParamsMap((Map)value, keyPrefix);
        } else if (object instanceof List) {
            list = this.flattenParamsList((List)value, keyPrefix);
        } else {
            if (Intrinsics.areEqual((Object)object, (Object)"")) {
                String string2 = "You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.";
                StripeError stripeError = new StripeError(null, null, null, keyPrefix, null, null, null, 119, null);
                throw new InvalidRequestException(stripeError, null, 0, string2, null, 22, null);
            }
            list = object == null ? CollectionsKt.listOf((Object)new Parameter(keyPrefix, "")) : CollectionsKt.listOf((Object)new Parameter(keyPrefix, value.toString()));
        }
        return list;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/networking/QueryStringFactory$Parameter;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "urlEncode", "str", "stripe_release"})
    private static final class Parameter {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public Parameter(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public String toString() {
            String encodedKey = this.urlEncode(this.key);
            String encodedValue = this.urlEncode(this.value);
            return encodedKey + '=' + encodedValue;
        }

        private final String urlEncode(String str) throws UnsupportedEncodingException {
            String string2 = URLEncoder.encode(str, Charsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(str, Charsets.UTF_8.name())");
            return string2;
        }

        private final String component1() {
            return this.key;
        }

        private final String component2() {
            return this.value;
        }

        @NotNull
        public final Parameter copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Parameter(key, value);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = parameter.key;
            }
            if ((n & 2) != 0) {
                string3 = parameter.value;
            }
            return parameter.copy(string2, string3);
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = result2 * 31 + this.value.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)parameter.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)parameter.value);
        }
    }
}

