/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.networking.RequestHeadersFactory;
import com.stripe.android.networking.StripeRequest;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u0000 42\u00020\u0001:\u0003456Bk\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007H\u00c6\u0003J\u000e\u0010&\u001a\u00020\tH\u00c0\u0003\u00a2\u0006\u0002\b'J\u000b\u0010(\u001a\u0004\u0018\u00010\u000bH\u00c2\u0003J\u0015\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rH\u00c2\u0003J\t\u0010*\u001a\u00020\u0005H\u00c2\u0003J\t\u0010+\u001a\u00020\u0005H\u00c2\u0003Js\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\b\u00103\u001a\u00020\u0005H\u0016R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/stripe/android/networking/ApiRequest;", "Lcom/stripe/android/networking/StripeRequest;", "method", "Lcom/stripe/android/networking/StripeRequest$Method;", "baseUrl", "", "params", "", "options", "Lcom/stripe/android/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "systemPropertySupplier", "Lkotlin/Function1;", "apiVersion", "sdkVersion", "(Lcom/stripe/android/networking/StripeRequest$Method;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/AppInfo;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "getBaseUrl", "()Ljava/lang/String;", "body", "getBody", "headersFactory", "Lcom/stripe/android/networking/RequestHeadersFactory$Api;", "getHeadersFactory", "()Lcom/stripe/android/networking/RequestHeadersFactory$Api;", "getMethod", "()Lcom/stripe/android/networking/StripeRequest$Method;", "mimeType", "Lcom/stripe/android/networking/StripeRequest$MimeType;", "getMimeType", "()Lcom/stripe/android/networking/StripeRequest$MimeType;", "getOptions$stripe_release", "()Lcom/stripe/android/networking/ApiRequest$Options;", "getParams", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component4$stripe_release", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "Factory", "Options", "stripe_release"})
public final class ApiRequest
extends StripeRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeRequest.Method method;
    @NotNull
    private final String baseUrl;
    @Nullable
    private final Map<String, ?> params;
    @NotNull
    private final Options options;
    @Nullable
    private final AppInfo appInfo;
    @NotNull
    private final Function1<String, String> systemPropertySupplier;
    @NotNull
    private final String apiVersion;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final StripeRequest.MimeType mimeType;
    @NotNull
    private final RequestHeadersFactory.Api headersFactory;
    @NotNull
    public static final String API_HOST = "https://api.stripe.com";

    public ApiRequest(@NotNull StripeRequest.Method method, @NotNull String baseUrl, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo, @NotNull Function1<? super String, String> systemPropertySupplier, @NotNull String apiVersion, @NotNull String sdkVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(systemPropertySupplier, (String)"systemPropertySupplier");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        this.method = method;
        this.baseUrl = baseUrl;
        this.params = params;
        this.options = options;
        this.appInfo = appInfo;
        this.systemPropertySupplier = systemPropertySupplier;
        this.apiVersion = apiVersion;
        this.sdkVersion = sdkVersion;
        this.mimeType = StripeRequest.MimeType.Form;
        this.headersFactory = new RequestHeadersFactory.Api(this.options, this.appInfo, null, this.systemPropertySupplier, this.apiVersion, this.sdkVersion, 4, null);
    }

    public /* synthetic */ ApiRequest(StripeRequest.Method method, String string2, Map map, Options options, AppInfo appInfo, Function1 function1, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            appInfo = null;
        }
        if ((n & 0x20) != 0) {
            function1 = StripeRequest.Companion.getDEFAULT_SYSTEM_PROPERTY_SUPPLIER$stripe_release();
        }
        if ((n & 0x40) != 0) {
            string3 = ApiVersion.Companion.get$stripe_release().getCode();
        }
        if ((n & 0x80) != 0) {
            string4 = "AndroidBindings/16.8.2";
        }
        this(method, string2, map, options, appInfo, function1, string3, string4);
    }

    @Override
    @NotNull
    public StripeRequest.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nullable
    public Map<String, ?> getParams() {
        return this.params;
    }

    @NotNull
    public final Options getOptions$stripe_release() {
        return this.options;
    }

    @Override
    @NotNull
    public StripeRequest.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    @NotNull
    public RequestHeadersFactory.Api getHeadersFactory() {
        return this.headersFactory;
    }

    @Override
    @NotNull
    protected String getBody() throws UnsupportedEncodingException, InvalidRequestException {
        return this.getQuery();
    }

    @NotNull
    public String toString() {
        return this.getMethod().getCode() + ' ' + this.getBaseUrl();
    }

    @NotNull
    public final StripeRequest.Method component1() {
        return this.getMethod();
    }

    @NotNull
    public final String component2() {
        return this.getBaseUrl();
    }

    @Nullable
    public final Map<String, ?> component3() {
        return this.getParams();
    }

    @NotNull
    public final Options component4$stripe_release() {
        return this.options;
    }

    private final AppInfo component5() {
        return this.appInfo;
    }

    private final Function1<String, String> component6() {
        return this.systemPropertySupplier;
    }

    private final String component7() {
        return this.apiVersion;
    }

    private final String component8() {
        return this.sdkVersion;
    }

    @NotNull
    public final ApiRequest copy(@NotNull StripeRequest.Method method, @NotNull String baseUrl, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo, @NotNull Function1<? super String, String> systemPropertySupplier, @NotNull String apiVersion, @NotNull String sdkVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(systemPropertySupplier, (String)"systemPropertySupplier");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        return new ApiRequest(method, baseUrl, params, options, appInfo, systemPropertySupplier, apiVersion, sdkVersion);
    }

    public static /* synthetic */ ApiRequest copy$default(ApiRequest apiRequest, StripeRequest.Method method, String string2, Map map, Options options, AppInfo appInfo, Function1 function1, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            method = apiRequest.getMethod();
        }
        if ((n & 2) != 0) {
            string2 = apiRequest.getBaseUrl();
        }
        if ((n & 4) != 0) {
            map = apiRequest.getParams();
        }
        if ((n & 8) != 0) {
            options = apiRequest.options;
        }
        if ((n & 0x10) != 0) {
            appInfo = apiRequest.appInfo;
        }
        if ((n & 0x20) != 0) {
            function1 = apiRequest.systemPropertySupplier;
        }
        if ((n & 0x40) != 0) {
            string3 = apiRequest.apiVersion;
        }
        if ((n & 0x80) != 0) {
            string4 = apiRequest.sdkVersion;
        }
        return apiRequest.copy(method, string2, map, options, appInfo, function1, string3, string4);
    }

    public int hashCode() {
        int result2 = this.getMethod().hashCode();
        result2 = result2 * 31 + this.getBaseUrl().hashCode();
        result2 = result2 * 31 + (this.getParams() == null ? 0 : ((Object)this.getParams()).hashCode());
        result2 = result2 * 31 + this.options.hashCode();
        result2 = result2 * 31 + (this.appInfo == null ? 0 : this.appInfo.hashCode());
        result2 = result2 * 31 + this.systemPropertySupplier.hashCode();
        result2 = result2 * 31 + this.apiVersion.hashCode();
        result2 = result2 * 31 + this.sdkVersion.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ApiRequest)) {
            return false;
        }
        ApiRequest apiRequest = (ApiRequest)other;
        if (this.getMethod() != apiRequest.getMethod()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBaseUrl(), (Object)apiRequest.getBaseUrl())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getParams(), apiRequest.getParams())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.options, (Object)apiRequest.options)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appInfo, (Object)apiRequest.appInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.systemPropertySupplier, apiRequest.systemPropertySupplier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiVersion, (Object)apiRequest.apiVersion)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sdkVersion, (Object)apiRequest.sdkVersion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000fJ+\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/networking/ApiRequest$Options;", "Landroid/os/Parcelable;", "apiKey", "", "stripeAccount", "idempotencyKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getIdempotencyKey$stripe_release", "getStripeAccount$stripe_release", "component1", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "stripe_release"})
    @Parcelize
    public static final class Options
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String apiKey;
        @Nullable
        private final String stripeAccount;
        @Nullable
        private final String idempotencyKey;
        @NotNull
        public static final Parcelable.Creator<Options> CREATOR;
        @NotNull
        public static final String UNDEFINED_PUBLISHABLE_KEY = "pk_undefined";

        public Options(@NotNull String apiKey, @Nullable String stripeAccount, @Nullable String idempotencyKey) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            this.apiKey = apiKey;
            this.stripeAccount = stripeAccount;
            this.idempotencyKey = idempotencyKey;
            new ApiKeyValidator().requireValid(this.apiKey);
        }

        public /* synthetic */ Options(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                string4 = null;
            }
            this(string2, string3, string4);
        }

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        @Nullable
        public final String getStripeAccount$stripe_release() {
            return this.stripeAccount;
        }

        @Nullable
        public final String getIdempotencyKey$stripe_release() {
            return this.idempotencyKey;
        }

        @NotNull
        public final String component1() {
            return this.apiKey;
        }

        @Nullable
        public final String component2$stripe_release() {
            return this.stripeAccount;
        }

        @Nullable
        public final String component3$stripe_release() {
            return this.idempotencyKey;
        }

        @NotNull
        public final Options copy(@NotNull String apiKey, @Nullable String stripeAccount, @Nullable String idempotencyKey) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            return new Options(apiKey, stripeAccount, idempotencyKey);
        }

        public static /* synthetic */ Options copy$default(Options options, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = options.apiKey;
            }
            if ((n & 2) != 0) {
                string3 = options.stripeAccount;
            }
            if ((n & 4) != 0) {
                string4 = options.idempotencyKey;
            }
            return options.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Options(apiKey=" + this.apiKey + ", stripeAccount=" + this.stripeAccount + ", idempotencyKey=" + this.idempotencyKey + ')';
        }

        public int hashCode() {
            int result2 = this.apiKey.hashCode();
            result2 = result2 * 31 + (this.stripeAccount == null ? 0 : this.stripeAccount.hashCode());
            result2 = result2 * 31 + (this.idempotencyKey == null ? 0 : this.idempotencyKey.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (!Intrinsics.areEqual((Object)this.apiKey, (Object)options.apiKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeAccount, (Object)options.stripeAccount)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idempotencyKey, (Object)options.idempotencyKey);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.apiKey);
            out.writeString(this.stripeAccount);
            out.writeString(this.idempotencyKey);
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Options> {
                @NotNull
                public final Options[] newArray(int size) {
                    return new Options[size];
                }

                @NotNull
                public final Options createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Options(parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/ApiRequest$Options$Companion;", "", "()V", "UNDEFINED_PUBLISHABLE_KEY", "", "stripe_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ,\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u000fJ,\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/networking/ApiRequest$Factory;", "", "appInfo", "Lcom/stripe/android/AppInfo;", "apiVersion", "", "sdkVersion", "(Lcom/stripe/android/AppInfo;Ljava/lang/String;Ljava/lang/String;)V", "createDelete", "Lcom/stripe/android/networking/ApiRequest;", "url", "options", "Lcom/stripe/android/networking/ApiRequest$Options;", "createGet", "params", "", "createPost", "stripe_release"})
    public static final class Factory {
        @Nullable
        private final AppInfo appInfo;
        @NotNull
        private final String apiVersion;
        @NotNull
        private final String sdkVersion;

        public Factory(@Nullable AppInfo appInfo, @NotNull String apiVersion, @NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            this.appInfo = appInfo;
            this.apiVersion = apiVersion;
            this.sdkVersion = sdkVersion;
        }

        public /* synthetic */ Factory(AppInfo appInfo, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                appInfo = null;
            }
            if ((n & 2) != 0) {
                string2 = ApiVersion.Companion.get$stripe_release().getCode();
            }
            if ((n & 4) != 0) {
                string3 = "AndroidBindings/16.8.2";
            }
            this(appInfo, string2, string3);
        }

        @NotNull
        public final ApiRequest createGet(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, params, options, this.appInfo, null, this.apiVersion, this.sdkVersion, 32, null);
        }

        public static /* synthetic */ ApiRequest createGet$default(Factory factory, String string2, Options options, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            return factory.createGet(string2, options, map);
        }

        @NotNull
        public final ApiRequest createPost(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, params, options, this.appInfo, null, this.apiVersion, this.sdkVersion, 32, null);
        }

        public static /* synthetic */ ApiRequest createPost$default(Factory factory, String string2, Options options, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            return factory.createPost(string2, options, map);
        }

        @NotNull
        public final ApiRequest createDelete(@NotNull String url, @NotNull Options options) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.DELETE, url, null, options, this.appInfo, null, this.apiVersion, this.sdkVersion, 36, null);
        }

        public Factory() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/ApiRequest$Companion;", "", "()V", "API_HOST", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

