/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepay;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.ColorInt;
import androidx.core.os.BundleKt;
import com.google.android.gms.common.api.Status;
import com.stripe.android.googlepay.StripeGooglePayActivity;
import com.stripe.android.googlepay.StripeGooglePayEnvironment;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.view.ActivityStarter;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parceler;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "GooglePayConfig", "Result", "stripe_release"})
public final class StripeGooglePayContract
extends ActivityResultContract<Args, Result> {
    @NotNull
    public Intent createIntent(@NotNull Context context, @Nullable Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent(context, StripeGooglePayActivity.class).putExtra("extra_activity_args", (Parcelable)input);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, StripeGooglePayActivity::class.java)\n            .putExtra(ActivityStarter.Args.EXTRA, input)");
        return intent;
    }

    @NotNull
    public Result parseResult(int resultCode, @Nullable Intent intent) {
        return Result.Companion.fromIntent(intent);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0001&B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J.\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0019\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "Lcom/stripe/android/view/ActivityStarter$Args;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "config", "Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "statusBarColor", "", "(Lcom/stripe/android/model/PaymentIntent;Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;Ljava/lang/Integer;)V", "getConfig", "()Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "setConfig", "(Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;)V", "getPaymentIntent", "()Lcom/stripe/android/model/PaymentIntent;", "setPaymentIntent", "(Lcom/stripe/android/model/PaymentIntent;)V", "getStatusBarColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "copy", "(Lcom/stripe/android/model/PaymentIntent;Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;Ljava/lang/Integer;)Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "describeContents", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "stripe_release"})
    @Parcelize
    public static final class Args
    implements ActivityStarter.Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private PaymentIntent paymentIntent;
        @NotNull
        private GooglePayConfig config;
        @Nullable
        private final Integer statusBarColor;
        @NotNull
        public static final Parcelable.Creator<Args> CREATOR;

        public Args(@NotNull PaymentIntent paymentIntent, @NotNull GooglePayConfig config, @ColorInt @Nullable Integer statusBarColor) {
            Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.paymentIntent = paymentIntent;
            this.config = config;
            this.statusBarColor = statusBarColor;
        }

        @NotNull
        public final PaymentIntent getPaymentIntent() {
            return this.paymentIntent;
        }

        public final void setPaymentIntent(@NotNull PaymentIntent paymentIntent) {
            Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"<set-?>");
            this.paymentIntent = paymentIntent;
        }

        @NotNull
        public final GooglePayConfig getConfig() {
            return this.config;
        }

        public final void setConfig(@NotNull GooglePayConfig googlePayConfig) {
            Intrinsics.checkNotNullParameter((Object)googlePayConfig, (String)"<set-?>");
            this.config = googlePayConfig;
        }

        @Nullable
        public final Integer getStatusBarColor() {
            return this.statusBarColor;
        }

        @NotNull
        public final PaymentIntent component1() {
            return this.paymentIntent;
        }

        @NotNull
        public final GooglePayConfig component2() {
            return this.config;
        }

        @Nullable
        public final Integer component3() {
            return this.statusBarColor;
        }

        @NotNull
        public final Args copy(@NotNull PaymentIntent paymentIntent, @NotNull GooglePayConfig config, @ColorInt @Nullable Integer statusBarColor) {
            Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new Args(paymentIntent, config, statusBarColor);
        }

        public static /* synthetic */ Args copy$default(Args args2, PaymentIntent paymentIntent, GooglePayConfig googlePayConfig, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                paymentIntent = args2.paymentIntent;
            }
            if ((n2 & 2) != 0) {
                googlePayConfig = args2.config;
            }
            if ((n2 & 4) != 0) {
                n = args2.statusBarColor;
            }
            return args2.copy(paymentIntent, googlePayConfig, n);
        }

        @NotNull
        public String toString() {
            return "Args(paymentIntent=" + this.paymentIntent + ", config=" + this.config + ", statusBarColor=" + this.statusBarColor + ')';
        }

        public int hashCode() {
            int result2 = this.paymentIntent.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            result2 = result2 * 31 + (this.statusBarColor == null ? 0 : ((Object)this.statusBarColor).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args2 = (Args)other;
            if (!Intrinsics.areEqual((Object)this.paymentIntent, (Object)args2.paymentIntent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)args2.config)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.statusBarColor, (Object)args2.statusBarColor);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.paymentIntent.writeToParcel(out, flags);
            this.config.writeToParcel(out, flags);
            Integer n = this.statusBarColor;
            if (n == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeInt(n.intValue());
            }
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Args> {
                @NotNull
                public final Args[] newArray(int size) {
                    return new Args[size];
                }

                @NotNull
                public final Args createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Args((PaymentIntent)PaymentIntent.CREATOR.createFromParcel(parcel), (GooglePayConfig)GooglePayConfig.CREATOR.createFromParcel(parcel), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()));
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Args$Companion;", "", "()V", "create", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "intent", "Landroid/content/Intent;", "create$stripe_release", "stripe_release"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ Args create$stripe_release(Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return (Args)intent.getParcelableExtra("extra_activity_args");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0019\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001eJ3\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0013\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020!H\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u0006,"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "Landroid/os/Parcelable;", "environment", "Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;", "countryCode", "", "isEmailRequired", "", "merchantName", "(Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;Ljava/lang/String;ZLjava/lang/String;)V", "getCountryCode$stripe_release", "()Ljava/lang/String;", "setCountryCode$stripe_release", "(Ljava/lang/String;)V", "getEnvironment", "()Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;", "setEnvironment", "(Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;)V", "isEmailRequired$stripe_release", "()Z", "setEmailRequired$stripe_release", "(Z)V", "getMerchantName$stripe_release", "setMerchantName$stripe_release", "component1", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "component4", "component4$stripe_release", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
    @Parcelize
    public static final class GooglePayConfig
    implements Parcelable {
        @NotNull
        private StripeGooglePayEnvironment environment;
        @NotNull
        private String countryCode;
        private boolean isEmailRequired;
        @Nullable
        private String merchantName;
        @NotNull
        public static final Parcelable.Creator<GooglePayConfig> CREATOR;

        public GooglePayConfig(@NotNull StripeGooglePayEnvironment environment, @NotNull String countryCode, boolean isEmailRequired, @Nullable String merchantName) {
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
            this.environment = environment;
            this.countryCode = countryCode;
            this.isEmailRequired = isEmailRequired;
            this.merchantName = merchantName;
        }

        public /* synthetic */ GooglePayConfig(StripeGooglePayEnvironment stripeGooglePayEnvironment, String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            this(stripeGooglePayEnvironment, string, bl, string2);
        }

        @NotNull
        public final StripeGooglePayEnvironment getEnvironment() {
            return this.environment;
        }

        public final void setEnvironment(@NotNull StripeGooglePayEnvironment stripeGooglePayEnvironment) {
            Intrinsics.checkNotNullParameter((Object)((Object)stripeGooglePayEnvironment), (String)"<set-?>");
            this.environment = stripeGooglePayEnvironment;
        }

        @NotNull
        public final String getCountryCode$stripe_release() {
            return this.countryCode;
        }

        public final void setCountryCode$stripe_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.countryCode = string;
        }

        public final boolean isEmailRequired$stripe_release() {
            return this.isEmailRequired;
        }

        public final void setEmailRequired$stripe_release(boolean bl) {
            this.isEmailRequired = bl;
        }

        @Nullable
        public final String getMerchantName$stripe_release() {
            return this.merchantName;
        }

        public final void setMerchantName$stripe_release(@Nullable String string) {
            this.merchantName = string;
        }

        @NotNull
        public final StripeGooglePayEnvironment component1() {
            return this.environment;
        }

        @NotNull
        public final String component2$stripe_release() {
            return this.countryCode;
        }

        public final boolean component3$stripe_release() {
            return this.isEmailRequired;
        }

        @Nullable
        public final String component4$stripe_release() {
            return this.merchantName;
        }

        @NotNull
        public final GooglePayConfig copy(@NotNull StripeGooglePayEnvironment environment, @NotNull String countryCode, boolean isEmailRequired, @Nullable String merchantName) {
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
            return new GooglePayConfig(environment, countryCode, isEmailRequired, merchantName);
        }

        public static /* synthetic */ GooglePayConfig copy$default(GooglePayConfig googlePayConfig, StripeGooglePayEnvironment stripeGooglePayEnvironment, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                stripeGooglePayEnvironment = googlePayConfig.environment;
            }
            if ((n & 2) != 0) {
                string = googlePayConfig.countryCode;
            }
            if ((n & 4) != 0) {
                bl = googlePayConfig.isEmailRequired;
            }
            if ((n & 8) != 0) {
                string2 = googlePayConfig.merchantName;
            }
            return googlePayConfig.copy(stripeGooglePayEnvironment, string, bl, string2);
        }

        @NotNull
        public String toString() {
            return "GooglePayConfig(environment=" + (Object)((Object)this.environment) + ", countryCode=" + this.countryCode + ", isEmailRequired=" + this.isEmailRequired + ", merchantName=" + this.merchantName + ')';
        }

        public int hashCode() {
            int result2 = this.environment.hashCode();
            result2 = result2 * 31 + this.countryCode.hashCode();
            int n = this.isEmailRequired ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.merchantName == null ? 0 : this.merchantName.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GooglePayConfig)) {
                return false;
            }
            GooglePayConfig googlePayConfig = (GooglePayConfig)other;
            if (this.environment != googlePayConfig.environment) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.countryCode, (Object)googlePayConfig.countryCode)) {
                return false;
            }
            if (this.isEmailRequired != googlePayConfig.isEmailRequired) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.merchantName, (Object)googlePayConfig.merchantName);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.environment.name());
            out.writeString(this.countryCode);
            out.writeInt(this.isEmailRequired ? 1 : 0);
            out.writeString(this.merchantName);
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<GooglePayConfig> {
                @NotNull
                public final GooglePayConfig[] newArray(int size) {
                    return new GooglePayConfig[size];
                }

                @NotNull
                public final GooglePayConfig createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new GooglePayConfig(StripeGooglePayEnvironment.valueOf(parcel.readString()), parcel.readString(), parcel.readInt() != 0, parcel.readString());
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00062\u00020\u0001:\u0005\u0005\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u0082\u0001\u0004\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "Lcom/stripe/android/view/ActivityStarter$Result;", "()V", "toBundle", "Landroid/os/Bundle;", "Canceled", "Companion", "Error", "PaymentData", "Unavailable", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$PaymentData;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Canceled;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Unavailable;", "stripe_release"})
    public static abstract class Result
    implements ActivityStarter.Result {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private Result() {
        }

        @Override
        @NotNull
        public Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"extra_activity_result", (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        @JvmStatic
        @NotNull
        public static final Result fromIntent(@Nullable Intent intent) {
            return Companion.fromIntent(intent);
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "exception", "", "googlePayStatus", "Lcom/google/android/gms/common/api/Status;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "(Ljava/lang/Throwable;Lcom/google/android/gms/common/api/Status;Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/ShippingInformation;)V", "getException", "()Ljava/lang/Throwable;", "getGooglePayStatus", "()Lcom/google/android/gms/common/api/Status;", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "stripe_release"})
        @Parcelize
        public static final class Error
        extends Result {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Throwable exception;
            @Nullable
            private final Status googlePayStatus;
            @Nullable
            private final PaymentMethod paymentMethod;
            @Nullable
            private final ShippingInformation shippingInformation;
            @NotNull
            public static final Parcelable.Creator<Error> CREATOR;

            public Error(@NotNull Throwable exception, @Nullable Status googlePayStatus, @Nullable PaymentMethod paymentMethod, @Nullable ShippingInformation shippingInformation) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
                this.googlePayStatus = googlePayStatus;
                this.paymentMethod = paymentMethod;
                this.shippingInformation = shippingInformation;
            }

            public /* synthetic */ Error(Throwable throwable, Status status, PaymentMethod paymentMethod, ShippingInformation shippingInformation, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    status = null;
                }
                if ((n & 4) != 0) {
                    paymentMethod = null;
                }
                if ((n & 8) != 0) {
                    shippingInformation = null;
                }
                this(throwable, status, paymentMethod, shippingInformation);
            }

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }

            @Nullable
            public final Status getGooglePayStatus() {
                return this.googlePayStatus;
            }

            @Nullable
            public final PaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @Nullable
            public final ShippingInformation getShippingInformation() {
                return this.shippingInformation;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Companion.write(this, out, flags);
            }

            static {
                @Metadata(mv={1, 5, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Error> {
                    @NotNull
                    public final Error[] newArray(int size) {
                        return new Error[size];
                    }

                    @NotNull
                    public final Error createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return Companion.create(parcel);
                    }
                }
                CREATOR = new Creator();
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error$Companion;", "Lkotlinx/parcelize/Parceler;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error;", "()V", "create", "parcel", "Landroid/os/Parcel;", "write", "", "flags", "", "stripe_release"})
            public static final class Companion
            implements Parceler<Error> {
                private Companion() {
                }

                @NotNull
                public Error create(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    Serializable serializable = parcel.readSerializable();
                    if (serializable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                    }
                    return new Error((Throwable)serializable, (Status)parcel.readParcelable(Status.class.getClassLoader()), null, null, 12, null);
                }

                public void write(@NotNull Error $this$write, @NotNull Parcel parcel, int flags) {
                    Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.writeSerializable((Serializable)$this$write.getException());
                    parcel.writeParcelable((Parcelable)$this$write.getGooglePayStatus(), flags);
                }

                @NotNull
                public Error[] newArray(int size) {
                    return (Error[])Parceler.DefaultImpls.newArray((Parceler)this, (int)size);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$PaymentData;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "(Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/ShippingInformation;)V", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class PaymentData
        extends Result {
            @NotNull
            private final PaymentMethod paymentMethod;
            @Nullable
            private final ShippingInformation shippingInformation;
            @NotNull
            public static final Parcelable.Creator<PaymentData> CREATOR;

            public PaymentData(@NotNull PaymentMethod paymentMethod, @Nullable ShippingInformation shippingInformation) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                super(null);
                this.paymentMethod = paymentMethod;
                this.shippingInformation = shippingInformation;
            }

            @NotNull
            public final PaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @Nullable
            public final ShippingInformation getShippingInformation() {
                return this.shippingInformation;
            }

            @NotNull
            public final PaymentMethod component1() {
                return this.paymentMethod;
            }

            @Nullable
            public final ShippingInformation component2() {
                return this.shippingInformation;
            }

            @NotNull
            public final PaymentData copy(@NotNull PaymentMethod paymentMethod, @Nullable ShippingInformation shippingInformation) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                return new PaymentData(paymentMethod, shippingInformation);
            }

            public static /* synthetic */ PaymentData copy$default(PaymentData paymentData, PaymentMethod paymentMethod, ShippingInformation shippingInformation, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentMethod = paymentData.paymentMethod;
                }
                if ((n & 2) != 0) {
                    shippingInformation = paymentData.shippingInformation;
                }
                return paymentData.copy(paymentMethod, shippingInformation);
            }

            @NotNull
            public String toString() {
                return "PaymentData(paymentMethod=" + this.paymentMethod + ", shippingInformation=" + this.shippingInformation + ')';
            }

            public int hashCode() {
                int result2 = this.paymentMethod.hashCode();
                result2 = result2 * 31 + (this.shippingInformation == null ? 0 : this.shippingInformation.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PaymentData)) {
                    return false;
                }
                PaymentData paymentData = (PaymentData)other;
                if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)paymentData.paymentMethod)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.shippingInformation, (Object)paymentData.shippingInformation);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                this.paymentMethod.writeToParcel(out, flags);
                ShippingInformation shippingInformation = this.shippingInformation;
                if (shippingInformation == null) {
                    out.writeInt(0);
                } else {
                    out.writeInt(1);
                    shippingInformation.writeToParcel(out, flags);
                }
            }

            static {
                @Metadata(mv={1, 5, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<PaymentData> {
                    @NotNull
                    public final PaymentData[] newArray(int size) {
                        return new PaymentData[size];
                    }

                    @NotNull
                    public final PaymentData createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new PaymentData((PaymentMethod)PaymentMethod.CREATOR.createFromParcel(parcel), (ShippingInformation)(parcel.readInt() == 0 ? null : ShippingInformation.CREATOR.createFromParcel(parcel)));
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Canceled;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class Canceled
        extends Result {
            @NotNull
            public static final Canceled INSTANCE = new Canceled();
            @NotNull
            public static final Parcelable.Creator<Canceled> CREATOR;

            private Canceled() {
                super(null);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeInt(1);
            }

            static {
                @Metadata(mv={1, 5, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Canceled> {
                    @NotNull
                    public final Canceled[] newArray(int size) {
                        return new Canceled[size];
                    }

                    @NotNull
                    public final Canceled createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        parcel.readInt();
                        return INSTANCE;
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Unavailable;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class Unavailable
        extends Result {
            @NotNull
            public static final Unavailable INSTANCE = new Unavailable();
            @NotNull
            public static final Parcelable.Creator<Unavailable> CREATOR;

            private Unavailable() {
                super(null);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeInt(1);
            }

            static {
                @Metadata(mv={1, 5, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Unavailable> {
                    @NotNull
                    public final Unavailable[] newArray(int size) {
                        return new Unavailable[size];
                    }

                    @NotNull
                    public final Unavailable createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        parcel.readInt();
                        return INSTANCE;
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Companion;", "", "()V", "fromIntent", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "intent", "Landroid/content/Intent;", "stripe_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Result fromIntent(@Nullable Intent intent) {
                Object object = intent;
                Result result2 = object == null ? null : (Result)object.getParcelableExtra("extra_activity_result");
                object = result2;
                return object == null ? (Result)new Error(new IllegalStateException("Error while processing result from Google Pay."), null, null, null, 14, null) : object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

