/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.parsers.BankAccountJsonParser;
import com.stripe.android.model.parsers.CardJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.SourceJsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/CustomerSourceJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/CustomerSource;", "()V", "parse", "json", "Lorg/json/JSONObject;", "stripe_release"})
public final class CustomerSourceJsonParser
implements ModelJsonParser<CustomerSource> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public CustomerSource parse(@NotNull JSONObject json) {
        StripePaymentSource stripePaymentSource;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string2 = StripeJsonUtils.optString(json, "object");
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case -896505829: {
                if (string2.equals("source")) {
                    n = 1;
                }
                break;
            }
            case 3046160: {
                if (string2.equals("card")) {
                    n = 2;
                }
                break;
            }
            case -1825227990: {
                if (string2.equals("bank_account")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                stripePaymentSource = new CardJsonParser().parse(json);
                break;
            }
            case 1: {
                stripePaymentSource = new SourceJsonParser().parse(json);
                break;
            }
            case 3: {
                stripePaymentSource = new BankAccountJsonParser().parse(json);
                break;
            }
            default: {
                return null;
            }
        }
        StripePaymentSource sourceObject = stripePaymentSource;
        string2 = sourceObject;
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        CustomerSource customerSource = new CustomerSource((StripePaymentSource)((Object)it));
        return customerSource;
    }
}

