/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AlipayAuthenticator;
import com.stripe.android.Logger;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentBrowserAuthStarter;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.StripePaymentController;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AlipayAuthResult;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.Stripe3ds2AuthParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.WeChatPayNextAction;
import com.stripe.android.networking.AlipayRepository;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.DefaultAlipayRepository;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.BrowserCapabilities;
import com.stripe.android.payments.BrowserCapabilitiesSupplier;
import com.stripe.android.payments.DefaultPaymentFlowResultProcessor;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.DefaultStripeChallengeStatusReceiver;
import com.stripe.android.payments.PaymentFlowFailureMessageFactory;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.Stripe3ds2CompletionStarter;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.Stripe3ds2ActivityStarterHost;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ChallengeProgressActivity;
import com.stripe.android.view.AuthActivityStarter;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u00b0\u00012\u00020\u0001:\u0004\u00af\u0001\u00b0\u0001B\u00b9\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019\u0012\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0019\u0012\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0019\u0012\b\b\u0002\u0010\u001f\u001a\u00020 \u0012\b\b\u0002\u0010!\u001a\u00020 \u00a2\u0006\u0002\u0010\"J)\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ1\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010@\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJc\u0010K\u001a\u00020D2\u0006\u0010L\u001a\u0002012\u0006\u0010F\u001a\u00020G2\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u00052\b\u0010P\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010R\u001a\u00020\t2\b\b\u0002\u0010S\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ+\u0010U\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010V\u001a\u00020W2\b\u0010X\u001a\u0004\u0018\u00010\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010YJ-\u0010U\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\b\u0010X\u001a\u0004\u0018\u00010\u0005H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\bZ\u0010[J)\u0010\\\u001a\u00020;2\u0006\u0010]\u001a\u00020^2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010_J!\u0010`\u001a\u00020=2\u0006\u0010a\u001a\u00020^2\u0006\u0010@\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ!\u0010c\u001a\u00020d2\u0006\u0010a\u001a\u00020e2\u0006\u0010@\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010fJ!\u0010g\u001a\u00020h2\u0006\u0010]\u001a\u00020^2\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ\u0019\u0010i\u001a\u00020W2\u0006\u0010j\u001a\u00020kH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u0019\u0010m\u001a\u00020;2\u0006\u0010j\u001a\u00020kH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u0019\u0010n\u001a\u00020o2\u0006\u0010j\u001a\u00020kH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ;\u0010p\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020A2\u0006\u0010q\u001a\u00020r2\b\u0010Q\u001a\u0004\u0018\u00010\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010sJ1\u0010t\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020A2\u0006\u0010q\u001a\u00020uH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010vJ1\u0010w\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020A2\u0006\u0010q\u001a\u00020xH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010yJ)\u0010z\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010M\u001a\u0002082\u0006\u0010{\u001a\u00020|H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010}J3\u0010~\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\b\u0010Q\u001a\u0004\u0018\u00010\u00052\u0006\u0010@\u001a\u00020AH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u007fJ4\u0010\u0080\u0001\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020A2\u0007\u0010q\u001a\u00030\u0081\u0001H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0082\u0001J4\u0010\u0083\u0001\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020A2\u0007\u0010q\u001a\u00030\u0084\u0001H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0085\u0001J\u0013\u0010\u0086\u0001\u001a\u00020D2\b\u0010Q\u001a\u0004\u0018\u00010\u0005H\u0002J,\u0010\u0087\u0001\u001a\u00020D2\u0006\u0010{\u001a\u00020|2\u0006\u0010M\u001a\u0002082\u0007\u0010\u0088\u0001\u001a\u000205H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0089\u0001J7\u0010\u008a\u0001\u001a\u00020D2\u0007\u0010\u008b\u0001\u001a\u00020\u00052\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020AH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001Je\u0010\u008e\u0001\u001a\u00020D2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u00052\u0007\u0010\u0094\u0001\u001a\u0002082\u0007\u0010\u0088\u0001\u001a\u0002052\u0006\u0010M\u001a\u0002082\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020AH\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0095\u0001\u0010\u0096\u0001J+\u0010\u0097\u0001\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010V\u001a\u00020W2\u0006\u0010@\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0098\u0001J\u001b\u0010\u0099\u0001\u001a\u00020\t2\u0006\u0010M\u001a\u0002082\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J\u001b\u0010\u009a\u0001\u001a\u00020\t2\u0006\u0010M\u001a\u0002082\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J\u001b\u0010\u009b\u0001\u001a\u00020\t2\u0006\u0010M\u001a\u0002082\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J5\u0010\u009c\u0001\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010N\u001a\u00020\u00052\u0006\u0010@\u001a\u00020A2\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u009f\u0001J+\u0010\u00a0\u0001\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0006\u0010V\u001a\u00020W2\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0098\u0001J]\u0010\u00a1\u0001\u001a\u00020D2\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u00052\u0007\u0010\u00a4\u0001\u001a\u0002082\u0007\u0010\u0088\u0001\u001a\u0002052\u0006\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010@\u001a\u00020AH\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a5\u0001\u0010\u00a6\u0001J,\u0010\u00a7\u0001\u001a\u00020D2\u0006\u0010E\u001a\u0002002\u0007\u0010a\u001a\u00030\u00a8\u00012\u0006\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a9\u0001J$\u0010\u00aa\u0001\u001a\u00020D2\u0007\u0010\u0088\u0001\u001a\u0002052\u0006\u0010F\u001a\u00020GH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ab\u0001J,\u0010\u00ac\u0001\u001a\u00020D2\u0007\u0010\u00ad\u0001\u001a\u0002012\u0006\u0010V\u001a\u00020W2\u0006\u0010@\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ae\u0001R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010'\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002050/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00106\u001a\u0014\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020907X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00b1\u0001"}, d2={"Lcom/stripe/android/StripePaymentController;", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "publishableKey", "", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "enableLogging", "", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "config", "Lcom/stripe/android/PaymentAuthConfig;", "threeDs2Service", "Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "challengeProgressActivityStarter", "Lcom/stripe/android/StripePaymentController$ChallengeProgressActivityStarter;", "alipayRepository", "Lcom/stripe/android/networking/AlipayRepository;", "paymentRelayLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "paymentBrowserAuthLauncher", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "stripe3ds2ChallengeLauncher", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "uiContext", "(Landroid/content/Context;Ljava/lang/String;Lcom/stripe/android/networking/StripeRepository;ZLcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/PaymentAuthConfig;Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lcom/stripe/android/StripePaymentController$ChallengeProgressActivityStarter;Lcom/stripe/android/networking/AlipayRepository;Landroidx/activity/result/ActivityResultLauncher;Landroidx/activity/result/ActivityResultLauncher;Landroidx/activity/result/ActivityResultLauncher;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "failureMessageFactory", "Lcom/stripe/android/payments/PaymentFlowFailureMessageFactory;", "hasCompatibleBrowser", "getHasCompatibleBrowser", "()Z", "hasCompatibleBrowser$delegate", "Lkotlin/Lazy;", "logger", "Lcom/stripe/android/Logger;", "paymentBrowserAuthStarterFactory", "Lkotlin/Function1;", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "Lcom/stripe/android/PaymentBrowserAuthStarter;", "paymentFlowResultProcessor", "Lcom/stripe/android/payments/DefaultPaymentFlowResultProcessor;", "paymentRelayStarterFactory", "Lcom/stripe/android/PaymentRelayStarter;", "stripe3ds2CompletionStarterFactory", "Lkotlin/Function2;", "", "Lcom/stripe/android/payments/Stripe3ds2CompletionStarter;", "authenticateAlipay", "Lcom/stripe/android/PaymentIntentResult;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "authenticator", "Lcom/stripe/android/AlipayAuthenticator;", "requestOptions", "Lcom/stripe/android/networking/ApiRequest$Options;", "(Lcom/stripe/android/model/PaymentIntent;Lcom/stripe/android/AlipayAuthenticator;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "begin3ds2Auth", "", "host", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "stripe3ds2Fingerprint", "Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/model/Stripe3ds2Fingerprint;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beginWebAuth", "paymentBrowserWebStarter", "requestCode", "clientSecret", "authUrl", "stripeAccount", "returnUrl", "shouldCancelSource", "shouldCancelIntentOnUserNavigation", "(Lcom/stripe/android/PaymentBrowserAuthStarter;Lcom/stripe/android/model/StripeIntent;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bypassAuth", "source", "Lcom/stripe/android/model/Source;", "stripeAccountId", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/Source;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bypassAuth$stripe_release", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmAndAuthenticateAlipay", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "(Lcom/stripe/android/model/ConfirmPaymentIntentParams;Lcom/stripe/android/AlipayAuthenticator;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmPaymentIntent", "confirmStripeIntentParams", "(Lcom/stripe/android/model/ConfirmPaymentIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmSetupIntent", "Lcom/stripe/android/model/SetupIntent;", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "(Lcom/stripe/android/model/ConfirmSetupIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmWeChatPay", "Lcom/stripe/android/model/WeChatPayNextAction;", "getAuthenticateSourceResult", "data", "Landroid/content/Intent;", "(Landroid/content/Intent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPaymentIntentResult", "getSetupIntentResult", "Lcom/stripe/android/SetupIntentResult;", "handle3ds1Auth", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS1;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS1;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handle3ds2Auth", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleAlipayAuth", "Lcom/stripe/android/model/StripeIntent$NextActionData$AlipayRedirect;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/model/StripeIntent$NextActionData$AlipayRedirect;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleError", "throwable", "", "(Lcom/stripe/android/view/AuthActivityStarter$Host;ILjava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleNextAction", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleOxxoAuth", "Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayOxxoDetails;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayOxxoDetails;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRedirectToUrlAuth", "Lcom/stripe/android/model/StripeIntent$NextActionData$RedirectToUrl;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/model/StripeIntent$NextActionData$RedirectToUrl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logReturnUrl", "on3ds2AuthFailure", "paymentRelayStarter", "(Ljava/lang/Throwable;ILcom/stripe/android/PaymentRelayStarter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "on3ds2AuthFallback", "fallbackRedirectUrl", "on3ds2AuthFallback$stripe_release", "(Ljava/lang/String;Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "on3ds2AuthSuccess", "result", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "sourceId", "timeout", "on3ds2AuthSuccess$stripe_release", "(Lcom/stripe/android/model/Stripe3ds2AuthResult;Lcom/stripe/android/stripe3ds2/transaction/Transaction;Ljava/lang/String;ILcom/stripe/android/PaymentRelayStarter;ILcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onSourceRetrieved", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/Source;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldHandlePaymentResult", "shouldHandleSetupResult", "shouldHandleSourceResult", "startAuth", "type", "Lcom/stripe/android/PaymentController$StripeIntentType;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/PaymentController$StripeIntentType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startAuthenticateSource", "startChallengeFlow", "ares", "Lcom/stripe/android/model/Stripe3ds2AuthResult$Ares;", "maxTimeout", "startChallengeFlow$stripe_release", "(Lcom/stripe/android/model/Stripe3ds2AuthResult$Ares;Lcom/stripe/android/stripe3ds2/transaction/Transaction;Ljava/lang/String;ILcom/stripe/android/PaymentRelayStarter;Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startConfirmAndAuth", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/model/ConfirmStripeIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startFrictionlessFlow", "(Lcom/stripe/android/PaymentRelayStarter;Lcom/stripe/android/model/StripeIntent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startSourceAuth", "paymentBrowserAuthStarter", "(Lcom/stripe/android/PaymentBrowserAuthStarter;Lcom/stripe/android/model/Source;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ChallengeProgressActivityStarter", "Companion", "stripe_release"})
public final class StripePaymentController
implements PaymentController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String publishableKey;
    @NotNull
    private final StripeRepository stripeRepository;
    private final boolean enableLogging;
    @NotNull
    private final MessageVersionRegistry messageVersionRegistry;
    @NotNull
    private final PaymentAuthConfig config;
    @NotNull
    private final StripeThreeDs2Service threeDs2Service;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final ChallengeProgressActivityStarter challengeProgressActivityStarter;
    @NotNull
    private final AlipayRepository alipayRepository;
    @Nullable
    private final ActivityResultLauncher<PaymentRelayStarter.Args> paymentRelayLauncher;
    @Nullable
    private final ActivityResultLauncher<PaymentBrowserAuthContract.Args> paymentBrowserAuthLauncher;
    @Nullable
    private final ActivityResultLauncher<PaymentFlowResult.Unvalidated> stripe3ds2ChallengeLauncher;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final CoroutineContext uiContext;
    @NotNull
    private final PaymentFlowFailureMessageFactory failureMessageFactory;
    @NotNull
    private final DefaultPaymentFlowResultProcessor paymentFlowResultProcessor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DefaultReturnUrl defaultReturnUrl;
    @NotNull
    private final Function1<AuthActivityStarter.Host, PaymentRelayStarter> paymentRelayStarterFactory;
    @NotNull
    private final Lazy hasCompatibleBrowser$delegate;
    @NotNull
    private final Function1<AuthActivityStarter.Host, PaymentBrowserAuthStarter> paymentBrowserAuthStarterFactory;
    @NotNull
    private final Function2<AuthActivityStarter.Host, Integer, Stripe3ds2CompletionStarter> stripe3ds2CompletionStarterFactory;
    public static final int PAYMENT_REQUEST_CODE = 50000;
    public static final int SETUP_REQUEST_CODE = 50001;
    public static final int SOURCE_REQUEST_CODE = 50002;
    @NotNull
    private static final List<String> EXPAND_PAYMENT_METHOD = CollectionsKt.listOf((Object)"payment_method");
    private static final long CHALLENGE_DELAY = TimeUnit.SECONDS.toMillis(2L);
    @NotNull
    private static final String REQUIRED_ERROR = "API request returned an invalid response.";

    public StripePaymentController(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository, boolean enableLogging, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull PaymentAuthConfig config, @NotNull StripeThreeDs2Service threeDs2Service, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull ChallengeProgressActivityStarter challengeProgressActivityStarter, @NotNull AlipayRepository alipayRepository, @Nullable ActivityResultLauncher<PaymentRelayStarter.Args> paymentRelayLauncher, @Nullable ActivityResultLauncher<PaymentBrowserAuthContract.Args> paymentBrowserAuthLauncher, @Nullable ActivityResultLauncher<PaymentFlowResult.Unvalidated> stripe3ds2ChallengeLauncher, @NotNull CoroutineContext workContext, @NotNull CoroutineContext uiContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)threeDs2Service, (String)"threeDs2Service");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)challengeProgressActivityStarter, (String)"challengeProgressActivityStarter");
        Intrinsics.checkNotNullParameter((Object)alipayRepository, (String)"alipayRepository");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        this.publishableKey = publishableKey2;
        this.stripeRepository = stripeRepository;
        this.enableLogging = enableLogging;
        this.messageVersionRegistry = messageVersionRegistry;
        this.config = config;
        this.threeDs2Service = threeDs2Service;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
        this.challengeProgressActivityStarter = challengeProgressActivityStarter;
        this.alipayRepository = alipayRepository;
        this.paymentRelayLauncher = paymentRelayLauncher;
        this.paymentBrowserAuthLauncher = paymentBrowserAuthLauncher;
        this.stripe3ds2ChallengeLauncher = stripe3ds2ChallengeLauncher;
        this.workContext = workContext;
        this.uiContext = uiContext;
        this.failureMessageFactory = new PaymentFlowFailureMessageFactory(context);
        this.paymentFlowResultProcessor = new DefaultPaymentFlowResultProcessor(context, this.publishableKey, this.stripeRepository, this.enableLogging, this.workContext);
        this.logger = Logger.Companion.getInstance$stripe_release(this.enableLogging);
        this.defaultReturnUrl = DefaultReturnUrl.Companion.create(context);
        this.paymentRelayStarterFactory = (Function1)new Function1<AuthActivityStarter.Host, PaymentRelayStarter>(this){
            final /* synthetic */ StripePaymentController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PaymentRelayStarter invoke(@NotNull AuthActivityStarter.Host host) {
                PaymentRelayStarter.Modern modern;
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ActivityResultLauncher activityResultLauncher = StripePaymentController.access$getPaymentRelayLauncher$p(this.this$0);
                if (activityResultLauncher == null) {
                    modern = null;
                } else {
                    ActivityResultLauncher activityResultLauncher2 = activityResultLauncher;
                    boolean bl = false;
                    boolean bl2 = false;
                    ActivityResultLauncher it = activityResultLauncher2;
                    boolean bl3 = false;
                    modern = new PaymentRelayStarter.Modern((ActivityResultLauncher<PaymentRelayStarter.Args>)it);
                }
                PaymentRelayStarter.Modern modern2 = modern;
                return modern2 == null ? (PaymentRelayStarter)new PaymentRelayStarter.Legacy(host) : (PaymentRelayStarter)modern2;
            }
        };
        this.hasCompatibleBrowser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            public final boolean invoke() {
                return new BrowserCapabilitiesSupplier(this.$context).get() != BrowserCapabilities.Unknown;
            }
        }));
        this.paymentBrowserAuthStarterFactory = (Function1)new Function1<AuthActivityStarter.Host, PaymentBrowserAuthStarter>(this){
            final /* synthetic */ StripePaymentController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PaymentBrowserAuthStarter invoke(@NotNull AuthActivityStarter.Host host) {
                PaymentBrowserAuthStarter.Modern modern;
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ActivityResultLauncher activityResultLauncher = StripePaymentController.access$getPaymentBrowserAuthLauncher$p(this.this$0);
                if (activityResultLauncher == null) {
                    modern = null;
                } else {
                    ActivityResultLauncher activityResultLauncher2 = activityResultLauncher;
                    boolean bl = false;
                    boolean bl2 = false;
                    ActivityResultLauncher it = activityResultLauncher2;
                    boolean bl3 = false;
                    modern = new PaymentBrowserAuthStarter.Modern((ActivityResultLauncher<PaymentBrowserAuthContract.Args>)it);
                }
                PaymentBrowserAuthStarter.Modern modern2 = modern;
                return modern2 == null ? (PaymentBrowserAuthStarter)new PaymentBrowserAuthStarter.Legacy(host, StripePaymentController.access$getHasCompatibleBrowser(this.this$0), StripePaymentController.access$getDefaultReturnUrl$p(this.this$0)) : (PaymentBrowserAuthStarter)modern2;
            }
        };
        this.stripe3ds2CompletionStarterFactory = (Function2)new Function2<AuthActivityStarter.Host, Integer, Stripe3ds2CompletionStarter>(this){
            final /* synthetic */ StripePaymentController this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Stripe3ds2CompletionStarter invoke(@NotNull AuthActivityStarter.Host host, int requestCode) {
                Stripe3ds2CompletionStarter.Modern modern;
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ActivityResultLauncher activityResultLauncher = StripePaymentController.access$getStripe3ds2ChallengeLauncher$p(this.this$0);
                if (activityResultLauncher == null) {
                    modern = null;
                } else {
                    ActivityResultLauncher activityResultLauncher2 = activityResultLauncher;
                    boolean bl = false;
                    boolean bl2 = false;
                    ActivityResultLauncher it = activityResultLauncher2;
                    boolean bl3 = false;
                    modern = new Stripe3ds2CompletionStarter.Modern((ActivityResultLauncher<PaymentFlowResult.Unvalidated>)it);
                }
                Stripe3ds2CompletionStarter.Modern modern2 = modern;
                return modern2 == null ? (Stripe3ds2CompletionStarter)new Stripe3ds2CompletionStarter.Legacy(host, requestCode) : (Stripe3ds2CompletionStarter)modern2;
            }
        };
        this.threeDs2Service.initialize((UiCustomization)this.config.getStripe3ds2Config$stripe_release().getUiCustomization$stripe_release().getUiCustomization());
    }

    public /* synthetic */ StripePaymentController(Context context, String string, StripeRepository stripeRepository, boolean bl, MessageVersionRegistry messageVersionRegistry, PaymentAuthConfig paymentAuthConfig, StripeThreeDs2Service stripeThreeDs2Service, AnalyticsRequestExecutor analyticsRequestExecutor, AnalyticsRequestFactory analyticsRequestFactory, ChallengeProgressActivityStarter challengeProgressActivityStarter, AlipayRepository alipayRepository, ActivityResultLauncher activityResultLauncher, ActivityResultLauncher activityResultLauncher2, ActivityResultLauncher activityResultLauncher3, CoroutineContext coroutineContext, CoroutineContext coroutineContext2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            messageVersionRegistry = new MessageVersionRegistry();
        }
        if ((n & 0x20) != 0) {
            paymentAuthConfig = PaymentAuthConfig.Companion.get();
        }
        if ((n & 0x40) != 0) {
            stripeThreeDs2Service = (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context, bl);
        }
        if ((n & 0x80) != 0) {
            analyticsRequestExecutor = new AnalyticsRequestExecutor.Default(Logger.Companion.getInstance$stripe_release(bl), null, 2, null);
        }
        if ((n & 0x100) != 0) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)new StringBuilder(37050).append("constructor(\n    context: Context,\n    private val publishableKey: String,\n    private val stripeRepository: StripeRepository,\n    private val enableLogging: Boolean = false,\n    private val messageVersionRegistry: MessageVersionRegistry =\n        MessageVersionRegistry(),\n    private val config: PaymentAuthConfig =\n        PaymentAuthConfig.get(),\n    private val threeDs2Service: StripeThreeDs2Service =\n        StripeThreeDs2ServiceImpl(context, enableLogging),\n    private val analyticsRequestExecutor: AnalyticsRequestExecutor =\n        AnalyticsRequestExecutor.Default(Logger.getInstance(enableLogging)),\n    private val analyticsRequestFactory: AnalyticsRequestFactory =\n        AnalyticsRequestFactory(context.applicationContext, publishableKey),\n    private val challengeProgressActivityStarter: ChallengeProgressActivityStarter =\n        ChallengeProgressActivityStarter.Default(),\n    private val alipayRepository: AlipayRepository = DefaultAlipayRepository(stripeRepository),\n    private val paymentRelayLauncher: ActivityResultLauncher<PaymentRelayStarter.Args>? = null,\n    private val paymentBrowserAuthLauncher: ActivityResultLauncher<PaymentBrowserAuthContract.Args>? = null,\n    private val stripe3ds2ChallengeLauncher: ActivityResultLauncher<PaymentFlowResult.Unvalidated>? = null,\n    private val workContext: CoroutineContext = Dispatchers.IO,\n    private val uiContext: CoroutineContext = Dispatchers.Main\n) : PaymentController {\n    private val failureMessageFactory = PaymentFlowFailureMessageFactory(context)\n    private val paymentFlowResultProcessor = DefaultPaymentFlowResultProcessor(\n        context,\n        publishableKey,\n        stripeRepository,\n        enableLogging,\n        workContext\n    )\n\n    private val logger = Logger.getInstance(enableLogging)\n    private val defaultReturnUrl = DefaultReturnUrl.create(context)\n\n    private val paymentRelayStarterFactory = { host: AuthActivityStarter.Host ->\n        paymentRelayLauncher?.let {\n            PaymentRelayStarter.Modern(it)\n        } ?: PaymentRelayStarter.Legacy(host)\n    }\n\n    private val hasCompatibleBrowser: Boolean by lazy {\n        BrowserCapabilitiesSupplier(context).get() != BrowserCapabilities.Unknown\n    }\n\n    private val paymentBrowserAuthStarterFactory = { host: AuthActivityStarter.Host ->\n        paymentBrowserAuthLauncher?.let {\n            PaymentBrowserAuthStarter.Modern(it)\n        } ?: PaymentBrowserAuthStarter.Legacy(\n            host,\n            hasCompatibleBrowser,\n            defaultReturnUrl\n        )\n    }\n\n    private val stripe3ds2CompletionStarterFactory =\n        { host: AuthActivityStarter.Host, requestCode: Int ->\n            stripe3ds2ChallengeLauncher?.let {\n                Stripe3ds2CompletionStarter.Modern(it)\n            } ?: Stripe3ds2CompletionStarter.Legacy(host, requestCode)\n        }\n\n    init {\n        threeDs2Service.initialize(\n            config.stripe3ds2Config.uiCustomization.uiCustomization\n        )\n    }\n\n    /**\n     * Confirm the Stripe Intent and resolve any next actions\n     */\n    override suspend fun startConfirmAndAuth(\n        host: AuthActivityStarter.Host,\n        confirmStripeIntentParams: ConfirmStripeIntentParams,\n        requestOptions: ApiRequest.Options\n    ) {\n        logReturnUrl(confirmStripeIntentParams.returnUrl)\n\n        val returnUrl = confirmStripeIntentParams.returnUrl.takeUnless { it.isNullOrBlank() }\n            ?: defaultReturnUrl.value\n\n        runCatching {\n            when (confirmStripeIntentParams) {\n                is ConfirmPaymentIntentParams -> {\n                    confirmPaymentIntent(\n                        confirmStripeIntentParams.also {\n                            it.returnUrl = returnUrl\n                        },\n                        requestOptions\n                    )\n                }\n                is ConfirmSetupIntentParams -> {\n                    confirmSetupIntent(\n                        confirmStripeIntentParams.also {\n                            it.returnUrl = returnUrl\n                        },\n                        requestOptions\n                    )\n                }\n                else -> error(\"Confirmation params must be ConfirmPaymentIntentParams or ConfirmSetupIntentParams\")\n            }\n        }.fold(\n            onSuccess = { intent ->\n                handleNextAction(\n                    host,\n                    intent,\n                    returnUrl,\n                    requestOptions\n                )\n            },\n            onFailure = {\n                handleError(\n                    host,\n                    getRequestCode(confirmStripeIntentParams),\n                    it\n                )\n            }\n        )\n    }\n\n    override suspend fun confirmAndAuthenticateAlipay(\n        confirmPaymentIntentParams: ConfirmPaymentIntentParams,\n        authenticator: AlipayAuthenticator,\n        requestOptions: ApiRequest.Options\n    ): PaymentIntentResult {\n        return authenticateAlipay(\n            confirmPaymentIntent(\n                confirmPaymentIntentParams,\n                requestOptions\n            ),\n            authenticator,\n            requestOptions\n        )\n    }\n\n    override suspend fun confirmWeChatPay(\n        confirmPaymentIntentParams: ConfirmPaymentIntentParams,\n        requestOptions: ApiRequest.Options\n    ): WeChatPayNextAction {\n        confirmPaymentIntent(\n            confirmPaymentIntentParams,\n            requestOptions\n        ).let { paymentIntent ->\n            require(paymentIntent.nextActionData is StripeIntent.NextActionData.WeChatPayRedirect) {\n                \"Unable to confirm Payment Intent with WeChatPay SDK\"\n            }\n            return WeChatPayNextAction(\n                paymentIntent,\n                paymentIntent.nextActionData.weChat,\n            )\n        }\n    }\n\n    private suspend fun confirmPaymentIntent(\n        confirmStripeIntentParams: ConfirmPaymentIntentParams,\n        requestOptions: ApiRequest.Options\n    ): PaymentIntent {\n        return requireNotNull(\n            stripeRepository.confirmPaymentIntent(\n                // mark this request as `use_stripe_sdk=true`\n                confirmStripeIntentParams\n                    .withShouldUseStripeSdk(shouldUseStripeSdk = true),\n                requestOptions,\n                expandFields = EXPAND_PAYMENT_METHOD\n            )\n        ) {\n            REQUIRED_ERROR\n        }\n    }\n\n    private suspend fun confirmSetupIntent(\n        confirmStripeIntentParams: ConfirmSetupIntentParams,\n        requestOptions: ApiRequest.Options\n    ): SetupIntent {\n        return requireNotNull(\n            stripeRepository.confirmSetupIntent(\n                // mark this request as `use_stripe_sdk=true`\n                confirmStripeIntentParams\n                    .withShouldUseStripeSdk(shouldUseStripeSdk = true),\n                requestOptions,\n                expandFields = EXPAND_PAYMENT_METHOD\n            )\n        ) {\n            REQUIRED_ERROR\n        }\n    }\n\n    override suspend fun startAuth(\n        host: AuthActivityStarter.Host,\n        clientSecret: String,\n        requestOptions: ApiRequest.Options,\n        type: PaymentController.StripeIntentType\n    ) {\n        runCatching {\n            val stripeIntent = when (type) {\n                PaymentController.StripeIntentType.PaymentIntent -> {\n                    stripeRepository.retrievePaymentIntent(\n                        clientSecret,\n                        requestOptions\n                    )\n                }\n                PaymentController.StripeIntentType.SetupIntent -> {\n                    stripeRepository.retrieveSetupIntent(\n                        clientSecret,\n                        requestOptions\n                    )\n                }\n            }\n            requireNotNull(stripeIntent)\n        }.fold(\n            onSuccess = { stripeIntent ->\n                handleNextAction(\n                    host = host,\n                    stripeIntent = stripeIntent,\n                    returnUrl = null,\n                    requestOptions = requestOptions\n                )\n            },\n            onFailure = {\n                handleError(\n                    host,\n                    when (type) {\n                        PaymentController.StripeIntentType.PaymentIntent -> {\n                            PAYMENT_REQUEST_CODE\n                        }\n                        PaymentController.StripeIntentType.SetupIntent -> {\n                            SETUP_REQUEST_CODE\n                        }\n                    },\n                    it\n                )\n            }\n        )\n    }\n\n    override suspend fun startAuthenticateSource(\n        host: AuthActivityStarter.Host,\n        source: Source,\n        requestOptions: ApiRequest.Options\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthSourceStart)\n        )\n\n        runCatching {\n            requireNotNull(\n                stripeRepository.retrieveSource(\n                    sourceId = source.id.orEmpty(),\n                    clientSecret = source.clientSecret.orEmpty(),\n                    options = requestOptions\n                )\n            )\n        }.fold(\n            onSuccess = { retrievedSourced ->\n                onSourceRetrieved(host, retrievedSourced, requestOptions)\n            },\n            onFailure = {\n                handleError(\n                    host,\n                    SOURCE_REQUEST_CODE,\n                    it\n                )\n            }\n        )\n    }\n\n    private suspend fun onSourceRetrieved(\n        host: AuthActivityStarter.Host,\n        source: Source,\n        requestOptions: ApiRequest.Options\n    ) {\n        if (source.flow == Source.Flow.Redirect) {\n            startSourceAuth(\n                paymentBrowserAuthStarterFactory(host),\n                source,\n                requestOptions\n            )\n        } else {\n            bypassAuth(host, source, requestOptions.stripeAccount)\n        }\n    }\n\n    private suspend fun startSourceAuth(\n        paymentBrowserAuthStarter: PaymentBrowserAuthStarter,\n        source: Source,\n        requestOptions: ApiRequest.Options\n    ) = withContext(uiContext) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthSourceRedirect)\n        )\n\n        paymentBrowserAuthStarter.start(\n            PaymentBrowserAuthContract.Args(\n                objectId = source.id.orEmpty(),\n                requestCode = SOURCE_REQUEST_CODE,\n                clientSecret = source.clientSecret.orEmpty(),\n                url = source.redirect?.url.orEmpty(),\n                returnUrl = source.redirect?.returnUrl,\n                enableLogging = enableLogging,\n                stripeAccountId = requestOptions.stripeAccount\n            )\n        )\n    }\n\n    /**\n     * Decide whether [getPaymentIntentResult] should be called.\n     */\n    override fun shouldHandlePaymentResult(requestCode: Int, data: Intent?): Boolean {\n        return requestCode == PAYMENT_REQUEST_CODE && data != null\n    }\n\n    /**\n     * Decide whether [getSetupIntentResult] should be called.\n     */\n    override fun shouldHandleSetupResult(requestCode: Int, data: Intent?): Boolean {\n        return requestCode == SETUP_REQUEST_CODE && data != null\n    }\n\n    override fun shouldHandleSourceResult(requestCode: Int, data: Intent?): Boolean {\n        return requestCode == SOURCE_REQUEST_CODE && data != null\n    }\n\n    /**\n     * Get the PaymentIntent's client_secret from {@param data} and use to retrieve\n     * the PaymentIntent object with updated status.\n     *\n     * @param data the result Intent\n     * @return the [PaymentIntentResult] object\n     *\n     * @throws AuthenticationException failure to properly authenticate yourself (check your key)\n     * @throws InvalidRequestException your request has invalid parameters\n     * @throws APIConnectionException failure to connect to Stripe's API\n     * @throws APIException any other type of problem (for instance, a temporary issue with Stripe's servers)\n     * @throws IllegalArgumentException if the response's JsonParser returns null\n     */\n    @Throws(\n        AuthenticationException::class,\n        InvalidRequestException::class,\n        APIConnectionException::class,\n        APIException::class,\n        IllegalArgumentException::class\n    )\n    override suspend fun getPaymentIntentResult(data: Intent) =\n        paymentFlowResultProcessor.processPaymentIntent(\n            PaymentFlowResult.Unvalidated.fromIntent(data)\n        )\n\n    /**\n     * Get the SetupIntent's client_secret from {@param data} and use to retrieve\n     * the PaymentIntent object with updated status.\n     *\n     * @param data the result Intent\n     * @return the [SetupIntentResult] object\n     *\n     * @throws AuthenticationException failure to properly authenticate yourself (check your key)\n     * @throws InvalidRequestException your request has invalid parameters\n     * @throws APIConnectionException failure to connect to Stripe's API\n     * @throws APIException any other type of problem (for instance, a temporary issue with Stripe's servers)\n     * @throws IllegalArgumentException if the response's JsonParser returns null\n     */\n    @Throws(\n        AuthenticationException::class,\n        InvalidRequestException::class,\n        APIConnectionException::class,\n        APIException::class,\n        IllegalArgumentException::class\n    )\n    override suspend fun getSetupIntentResult(data: Intent) =\n        paymentFlowResultProcessor.processSetupIntent(\n            PaymentFlowResult.Unvalidated.fromIntent(data)\n        )\n\n    /**\n     * Get the Source's client_secret from {@param data} and use to retrieve\n     * the Source object with updated status.\n     *\n     * @param data the result Intent\n     * @return the [Source] object\n     *\n     * @throws AuthenticationException failure to properly authenticate yourself (check your key)\n     * @throws InvalidRequestException your request has invalid parameters\n     * @throws APIConnectionException failure to connect to Stripe's API\n     * @throws APIException any other type of problem (for instance, a temporary issue with Stripe's servers)\n     * @throws IllegalArgumentException if the Source response's JsonParser returns null\n     */\n    @Throws(\n        AuthenticationException::class,\n        InvalidRequestException::class,\n        APIConnectionException::class,\n        APIException::class,\n        IllegalArgumentException::class\n    )\n    override suspend fun getAuthenticateSourceResult(data: Intent): Source {\n        val result = PaymentFlowResult.Unvalidated.fromIntent(data)\n        val sourceId = result.sourceId.orEmpty()\n        val clientSecret = result.clientSecret.orEmpty()\n\n        val requestOptions = ApiRequest.Options(\n            apiKey = publishableKey,\n            stripeAccount = result.stripeAccountId\n        )\n\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthSourceResult)\n        )\n\n        return requireNotNull(\n            stripeRepository.retrieveSource(\n                sourceId,\n                clientSecret,\n                requestOptions\n            )\n        )\n    }\n\n    private suspend fun authenticateAlipay(\n        paymentIntent: PaymentIntent,\n        authenticator: AlipayAuthenticator,\n        requestOptions: ApiRequest.Options\n    ): PaymentIntentResult {\n        val outcome =\n            alipayRepository.authenticate(paymentIntent, authenticator, requestOptions).outcome\n        val refreshedPaymentIntent = requireNotNull(\n            stripeRepository.retrievePaymentIntent(\n                paymentIntent.clientSecret.orEmpty(),\n                requestOptions,\n                expandFields = EXPAND_PAYMENT_METHOD\n            )\n        )\n\n        return PaymentIntentResult(\n            refreshedPaymentIntent,\n            outcome,\n            failureMessageFactory.create(refreshedPaymentIntent, outcome)\n        )\n    }\n\n    private suspend fun handleError(\n        host: AuthActivityStarter.Host,\n        requestCode: Int,\n        throwable: Throwable\n    ) = withContext(uiContext) {\n        paymentRelayStarterFactory(host)\n            .start(\n                PaymentRelayStarter.Args.ErrorArgs(\n                    StripeException.create(thro").append("wable),\n                    requestCode\n                )\n            )\n    }\n\n    /**\n     * Determine which authentication mechanism should be used, or bypass authentication\n     * if it is not needed.\n     *\n     * @param returnUrl in some cases, the return URL is not provided in\n     * [StripeIntent.NextActionData]. Specifically, it is not available in\n     * [StripeIntent.NextActionData.SdkData.Use3DS1]. Wire it through so that we can correctly\n     * determine how we should handle authentication.\n     */\n    @VisibleForTesting\n    override suspend fun handleNextAction(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        returnUrl: String?,\n        requestOptions: ApiRequest.Options\n    ) {\n        if (stripeIntent.requiresAction()) {\n            when (val nextActionData = stripeIntent.nextActionData) {\n                is StripeIntent.NextActionData.SdkData.Use3DS2 -> {\n                    handle3ds2Auth(\n                        host,\n                        stripeIntent,\n                        requestOptions,\n                        nextActionData\n                    )\n                }\n                is StripeIntent.NextActionData.SdkData.Use3DS1 -> {\n                    // can only triggered when `use_stripe_sdk=true`\n                    handle3ds1Auth(\n                        host,\n                        stripeIntent,\n                        requestOptions,\n                        nextActionData,\n                        returnUrl\n                    )\n                }\n                is StripeIntent.NextActionData.RedirectToUrl -> {\n                    // can only triggered when `use_stripe_sdk=false`\n                    handleRedirectToUrlAuth(\n                        host,\n                        stripeIntent,\n                        requestOptions,\n                        nextActionData\n                    )\n                }\n                is StripeIntent.NextActionData.AlipayRedirect -> {\n                    handleAlipayAuth(\n                        host,\n                        stripeIntent,\n                        requestOptions,\n                        nextActionData\n                    )\n                }\n                is StripeIntent.NextActionData.DisplayOxxoDetails -> {\n                    handleOxxoAuth(\n                        host,\n                        stripeIntent,\n                        requestOptions,\n                        nextActionData\n                    )\n                }\n                else -> bypassAuth(host, stripeIntent, requestOptions.stripeAccount)\n            }\n        } else {\n            // no action required, so bypass authentication\n            bypassAuth(host, stripeIntent, requestOptions.stripeAccount)\n        }\n    }\n\n    private suspend fun handle3ds2Auth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options,\n        nextActionData: StripeIntent.NextActionData.SdkData.Use3DS2\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.Auth3ds2Fingerprint)\n        )\n        try {\n            begin3ds2Auth(\n                host,\n                stripeIntent,\n                Stripe3ds2Fingerprint(nextActionData),\n                requestOptions\n            )\n        } catch (e: CertificateException) {\n            handleError(\n                host,\n                getRequestCode(stripeIntent),\n                e\n            )\n        }\n    }\n\n    private suspend fun handle3ds1Auth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options,\n        nextActionData: StripeIntent.NextActionData.SdkData.Use3DS1,\n        returnUrl: String?\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(\n                AnalyticsEvent.Auth3ds1Sdk\n            )\n        )\n        beginWebAuth(\n            paymentBrowserAuthStarterFactory(host),\n            stripeIntent,\n            getRequestCode(stripeIntent),\n            stripeIntent.clientSecret.orEmpty(),\n            nextActionData.url,\n            requestOptions.stripeAccount,\n            returnUrl = returnUrl,\n            // 3D-Secure requires cancelling the source when the user cancels auth (AUTHN-47)\n            shouldCancelSource = true\n        )\n    }\n\n    private suspend fun handleRedirectToUrlAuth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options,\n        nextActionData: StripeIntent.NextActionData.RedirectToUrl\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthRedirect)\n        )\n\n        beginWebAuth(\n            paymentBrowserAuthStarterFactory(host),\n            stripeIntent,\n            getRequestCode(stripeIntent),\n            stripeIntent.clientSecret.orEmpty(),\n            nextActionData.url.toString(),\n            requestOptions.stripeAccount,\n            nextActionData.returnUrl\n        )\n    }\n\n    /**\n     * If using the standard confirmation path, handle Alipay the same as\n     * a standard webview redirect.\n     * Alipay Native SDK use case is handled by [Stripe.confirmAlipayPayment]\n     * outside of the standard confirmation path.\n     */\n    private suspend fun handleAlipayAuth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options,\n        nextActionData: StripeIntent.NextActionData.AlipayRedirect\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.AuthRedirect)\n        )\n\n        beginWebAuth(\n            paymentBrowserAuthStarterFactory(host),\n            stripeIntent,\n            getRequestCode(stripeIntent),\n            stripeIntent.clientSecret.orEmpty(),\n            nextActionData.webViewUrl.toString(),\n            requestOptions.stripeAccount,\n            nextActionData.returnUrl\n        )\n    }\n\n    private suspend fun handleOxxoAuth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options,\n        nextActionData: StripeIntent.NextActionData.DisplayOxxoDetails\n    ) {\n        // TODO(smaskell): add analytics event\n        if (nextActionData.hostedVoucherUrl != null) {\n            beginWebAuth(\n                paymentBrowserAuthStarterFactory(host),\n                stripeIntent,\n                getRequestCode(stripeIntent),\n                stripeIntent.clientSecret.orEmpty(),\n                nextActionData.hostedVoucherUrl,\n                requestOptions.stripeAccount,\n                shouldCancelIntentOnUserNavigation = false\n            )\n        } else {\n            // TODO(smaskell): Determine how to handle missing URL\n            bypassAuth(host, stripeIntent, requestOptions.stripeAccount)\n        }\n    }\n\n    @JvmSynthetic\n    internal suspend fun bypassAuth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        stripeAccountId: String?\n    ) = withContext(uiContext) {\n        paymentRelayStarterFactory(host)\n            .start(\n                PaymentRelayStarter.Args.create(stripeIntent, stripeAccountId)\n            )\n    }\n\n    private suspend fun bypassAuth(\n        host: AuthActivityStarter.Host,\n        source: Source,\n        stripeAccountId: String?\n    ) = withContext(uiContext) {\n        paymentRelayStarterFactory(host)\n            .start(\n                PaymentRelayStarter.Args.SourceArgs(source, stripeAccountId)\n            )\n    }\n\n    private suspend fun begin3ds2Auth(\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        stripe3ds2Fingerprint: Stripe3ds2Fingerprint,\n        requestOptions: ApiRequest.Options\n    ) {\n        val activity = host.activity ?: return\n\n        val transaction = threeDs2Service.createTransaction(\n            stripe3ds2Fingerprint.directoryServerEncryption.directoryServerId,\n            messageVersionRegistry.current, stripeIntent.isLiveMode,\n            stripe3ds2Fingerprint.directoryServerName,\n            stripe3ds2Fingerprint.directoryServerEncryption.rootCerts,\n            stripe3ds2Fingerprint.directoryServerEncryption.directoryServerPublicKey,\n            stripe3ds2Fingerprint.directoryServerEncryption.keyId\n        )\n\n        challengeProgressActivityStarter.start(\n            activity,\n            stripe3ds2Fingerprint.directoryServerName,\n            false,\n            config.stripe3ds2Config.uiCustomization.uiCustomization,\n            transaction.sdkTransactionId\n        )\n\n        CoroutineScope(workContext).launch {\n            val areqParams = transaction.createAuthenticationRequestParameters()\n\n            val timeout = config.stripe3ds2Config.timeout\n            val authParams = Stripe3ds2AuthParams(\n                stripe3ds2Fingerprint.source,\n                areqParams.sdkAppId,\n                areqParams.sdkReferenceNumber,\n                areqParams.sdkTransactionId.value,\n                areqParams.deviceData,\n                areqParams.sdkEphemeralPublicKey,\n                areqParams.messageVersion,\n                timeout,\n                // We do not currently have a fallback url\n                // TODO(smaskell-stripe): Investigate more robust error handling\n                returnUrl = null\n            )\n\n            val start3ds2AuthResult = runCatching {\n                requireNotNull(\n                    stripeRepository.start3ds2Auth(\n                        authParams,\n                        requestOptions\n                    )\n                )\n            }\n\n            val paymentRelayStarter = paymentRelayStarterFactory(host)\n            start3ds2AuthResult.fold(\n                onSuccess = { authResult ->\n                    on3ds2AuthSuccess(\n                        authResult,\n                        transaction,\n                        stripe3ds2Fingerprint.source,\n                        timeout,\n                        paymentRelayStarter,\n                        getRequestCode(stripeIntent),\n                        host,\n                        stripeIntent,\n                        requestOptions\n                    )\n                },\n                onFailure = { throwable ->\n                    on3ds2AuthFailure(\n                        throwable,\n                        getRequestCode(stripeIntent),\n                        paymentRelayStarter\n                    )\n                }\n            )\n        }\n    }\n\n    @VisibleForTesting\n    internal suspend fun on3ds2AuthSuccess(\n        result: Stripe3ds2AuthResult,\n        transaction: Transaction,\n        sourceId: String,\n        timeout: Int,\n        paymentRelayStarter: PaymentRelayStarter,\n        requestCode: Int,\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options\n    ) {\n        val ares = result.ares\n        if (ares != null) {\n            if (ares.isChallenge) {\n                startChallengeFlow(\n                    ares,\n                    transaction,\n                    sourceId,\n                    timeout,\n                    paymentRelayStarter,\n                    host,\n                    stripeIntent,\n                    requestOptions\n                )\n            } else {\n                startFrictionlessFlow(\n                    paymentRelayStarter,\n                    stripeIntent\n                )\n            }\n        } else if (result.fallbackRedirectUrl != null) {\n            on3ds2AuthFallback(\n                result.fallbackRedirectUrl,\n                host,\n                stripeIntent,\n                requestOptions\n            )\n        } else {\n            val errorMessage = result.error?.let { error ->\n                listOf(\n                    \"Code: ${error.errorCode}\",\n                    \"Detail: ${error.errorDetail}\",\n                    \"Description: ${error.errorDescription}\",\n                    \"Component: ${error.errorComponent}\"\n                ).joinToString(separator = \", \")\n            } ?: \"Invalid 3DS2 authentication response\"\n\n            on3ds2AuthFailure(\n                RuntimeException(\n                    \"Error encountered during 3DS2 authentication request. $errorMessage\"\n                ),\n                requestCode,\n                paymentRelayStarter\n            )\n        }\n    }\n\n    /**\n     * Used when standard 3DS2 authentication mechanisms are unavailable.\n     */\n    internal suspend fun on3ds2AuthFallback(\n        fallbackRedirectUrl: String,\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options\n    ) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.Auth3ds2Fallback)\n        )\n        beginWebAuth(\n            paymentBrowserAuthStarterFactory(host),\n            stripeIntent,\n            getRequestCode(stripeIntent),\n            stripeIntent.clientSecret.orEmpty(),\n            fallbackRedirectUrl,\n            requestOptions.stripeAccount,\n            // 3D-Secure requires cancelling the source when the user cancels auth (AUTHN-47)\n            shouldCancelSource = true\n        )\n    }\n\n    private suspend fun startFrictionlessFlow(\n        paymentRelayStarter: PaymentRelayStarter,\n        stripeIntent: StripeIntent\n    ) = withContext(uiContext) {\n        analyticsRequestExecutor.executeAsync(\n            analyticsRequestFactory.createRequest(AnalyticsEvent.Auth3ds2Frictionless)\n        )\n        paymentRelayStarter.start(\n            PaymentRelayStarter.Args.create(stripeIntent)\n        )\n    }\n\n    @VisibleForTesting\n    internal suspend fun startChallengeFlow(\n        ares: Stripe3ds2AuthResult.Ares,\n        transaction: Transaction,\n        sourceId: String,\n        maxTimeout: Int,\n        paymentRelayStarter: PaymentRelayStarter,\n        host: AuthActivityStarter.Host,\n        stripeIntent: StripeIntent,\n        requestOptions: ApiRequest.Options\n    ) = withContext(workContext) {\n        runCatching {\n            requireNotNull(\n                host.fragment?.let { fragment ->\n                    Stripe3ds2ActivityStarterHost(fragment)\n                } ?: host.activity?.let { activity ->\n                    Stripe3ds2ActivityStarterHost(activity)\n                }\n            ) {\n                \"Error while attempting to start 3DS2 challenge flow.\"\n            }\n        }.fold(\n            onSuccess = { stripe3ds2Host ->\n                delay(CHALLENGE_DELAY)\n\n                transaction.doChallenge(\n                    stripe3ds2Host,\n                    ChallengeParameters(\n                        acsSignedContent = ares.acsSignedContent,\n                        threeDsServerTransactionId = ares.threeDSServerTransId,\n                        acsTransactionId = ares.acsTransId\n                    ),\n                    DefaultStripeChallengeStatusReceiver(\n                        stripe3ds2CompletionStarterFactory(host, getRequestCode(stripeIntent)),\n                        stripeRepository,\n                        stripeIntent,\n                        sourceId,\n                        requestOptions,\n                        analyticsRequestExecutor,\n                        analyticsRequestFactory,\n                        transaction,\n                        {\n                            transaction.close()\n                        },\n                        workContext = workContext\n                    ),\n                    maxTimeout\n                )\n            },\n            onFailure = {\n                on3ds2AuthFailure(\n                    it,\n                    getRequestCode(stripeIntent),\n                    paymentRelayStarter\n                )\n            }\n        )\n    }\n\n    private suspend fun on3ds2AuthFailure(\n        throwable: Throwable,\n        requestCode: Int,\n        paymentRelayStarter: PaymentRelayStarter\n    ) = withContext(uiContext) {\n        paymentRelayStarter.start(\n            PaymentRelayStarter.Args.ErrorArgs(\n                StripeException.create(throwable),\n                requestCode\n            )\n        )\n    }\n\n    /**\n     * Start in-app WebView activity.\n     */\n    private suspend fun beginWebAuth(\n        paymentBrowserWebSt").append("arter: PaymentBrowserAuthStarter,\n        stripeIntent: StripeIntent,\n        requestCode: Int,\n        clientSecret: String,\n        authUrl: String,\n        stripeAccount: String?,\n        returnUrl: String? = null,\n        shouldCancelSource: Boolean = false,\n        shouldCancelIntentOnUserNavigation: Boolean = true\n    ) = withContext(uiContext) {\n        logger.debug(\"PaymentBrowserAuthStarter#start()\")\n        paymentBrowserWebStarter.start(\n            PaymentBrowserAuthContract.Args(\n                objectId = stripeIntent.id.orEmpty(),\n                requestCode,\n                clientSecret,\n                authUrl,\n                returnUrl,\n                enableLogging,\n                stripeAccountId = stripeAccount,\n                shouldCancelSource = shouldCancelSource,\n                shouldCancelIntentOnUserNavigation = shouldCancelIntentOnUserNavigation\n            )\n        )\n    }\n\n    private fun logReturnUrl(returnUrl: String?) {\n        when (returnUrl) {\n            defaultReturnUrl.value -> {\n                AnalyticsEvent.ConfirmReturnUrlDefault\n            }\n            null -> {\n                AnalyticsEvent.ConfirmReturnUrlNull\n            }\n            else -> {\n                AnalyticsEvent.ConfirmReturnUrlCustom\n            }\n        }.let { event ->\n            analyticsRequestExecutor.executeAsync(\n                analyticsRequestFactory.createRequest(event)\n            )\n        }\n    }\n\n    internal interface ChallengeProgressActivityStarter {\n        fun start(\n            context: Context,\n            directoryServerName: String,\n            cancelable: Boolean,\n            uiCustomization: StripeUiCustomization,\n            sdkTransactionId: SdkTransactionId\n        )\n\n        class Default : ChallengeProgressActivityStarter {\n            override fun start(\n                context: Context,\n                directoryServerName: String,\n                cancelable: Boolean,\n                uiCustomization: StripeUiCustomization,\n                sdkTransactionId: SdkTransactionId\n            ) {\n                ChallengeProgressActivity.show(\n                    context,\n                    directoryServerName,\n                    cancelable,\n                    uiCustomization,\n                    sdkTransactionId\n                )\n            }\n        }\n    }\n\n    internal companion object {\n        internal const val PAYMENT_REQUEST_CODE = 50000\n        internal const val SETUP_REQUEST_CODE = 50001\n        internal const val SOURCE_REQUEST_CODE = 50002\n\n        /**\n         * Get the appropriate request code for the given stripe intent type\n         *\n         * @param intent the [StripeIntent] to get the request code for\n         * @return PAYMENT_REQUEST_CODE or SETUP_REQUEST_CODE\n         */\n        @JvmSynthetic\n        internal fun getRequestCode(intent: StripeIntent): Int {\n            return if (intent is PaymentIntent) {\n                PAYMENT_REQUEST_CODE\n            } else {\n                SETUP_REQUEST_CODE\n            }\n        }\n\n        /**\n         * Get the appropriate request code for the given stripe intent params type\n         *\n         * @param params the [ConfirmStripeIntentParams] to get the request code for\n         * @return PAYMENT_REQUEST_CODE or SETUP_REQUEST_CODE\n         */\n        @JvmSynthetic\n        internal fun getRequestCode(params: ConfirmStripeIntentParams): Int {\n            return if (params is ConfirmPaymentIntentParams) {\n                PAYMENT_REQUEST_CODE\n            } else {\n                SETUP_REQUEST_CODE\n            }\n        }\n\n        @JvmStatic\n        @JvmOverloads\n        fun create(\n            context: Context,\n            publishableKey: String,\n            stripeRepository: StripeRepository,\n            enableLogging: Boolean = false\n        ): PaymentController {\n            return StripePaymentController(\n                context.applicationContext,\n                publishableKey,\n                stripeRepository,\n                enableLogging\n            )\n        }\n\n        internal val EXPAND_PAYMENT_METHOD = listOf(\"payment_method\")\n        internal val CHALLENGE_DELAY = TimeUnit.SECONDS.toMillis(2L)\n\n        private const val REQUIRED_ERROR = \"API request returned an invalid response.\"\n    }\n}").toString());
            analyticsRequestFactory = new AnalyticsRequestFactory(context2, string);
        }
        if ((n & 0x200) != 0) {
            challengeProgressActivityStarter = new ChallengeProgressActivityStarter.Default();
        }
        if ((n & 0x400) != 0) {
            alipayRepository = new DefaultAlipayRepository(stripeRepository);
        }
        if ((n & 0x800) != 0) {
            activityResultLauncher = null;
        }
        if ((n & 0x1000) != 0) {
            activityResultLauncher2 = null;
        }
        if ((n & 0x2000) != 0) {
            activityResultLauncher3 = null;
        }
        if ((n & 0x4000) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.INSTANCE.getIO();
        }
        if ((n & 0x8000) != 0) {
            coroutineContext2 = (CoroutineContext)Dispatchers.INSTANCE.getMain();
        }
        this(context, string, stripeRepository, bl, messageVersionRegistry, paymentAuthConfig, stripeThreeDs2Service, analyticsRequestExecutor, analyticsRequestFactory, challengeProgressActivityStarter, alipayRepository, (ActivityResultLauncher<PaymentRelayStarter.Args>)activityResultLauncher, (ActivityResultLauncher<PaymentBrowserAuthContract.Args>)activityResultLauncher2, (ActivityResultLauncher<PaymentFlowResult.Unvalidated>)activityResultLauncher3, coroutineContext, coroutineContext2);
    }

    private final boolean getHasCompatibleBrowser() {
        Lazy lazy = this.hasCompatibleBrowser$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object startConfirmAndAuth(@NotNull AuthActivityStarter.Host var1_1, @NotNull ConfirmStripeIntentParams var2_2, @NotNull ApiRequest.Options var3_3, @NotNull Continuation<? super Unit> var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object confirmAndAuthenticateAlipay(@NotNull ConfirmPaymentIntentParams var1_1, @NotNull AlipayAuthenticator var2_2, @NotNull ApiRequest.Options var3_3, @NotNull Continuation<? super PaymentIntentResult> var4_4) {
        if (!(var4_4 instanceof confirmAndAuthenticateAlipay.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.confirmAndAuthenticateAlipay(null, null, null, (Continuation<? super PaymentIntentResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_8 = this;
                $continuation.L$0 = authenticator;
                $continuation.L$1 = requestOptions;
                $continuation.L$2 = var5_8;
                $continuation.label = 1;
                v0 = this.confirmPaymentIntent((ConfirmPaymentIntentParams)confirmPaymentIntentParams, requestOptions, (Continuation<? super PaymentIntent>)$continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl27
            }
            case 1: {
                var5_8 = (StripePaymentController)$continuation.L$2;
                requestOptions = (ApiRequest.Options)$continuation.L$1;
                authenticator = (AlipayAuthenticator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                var6_9 = v0;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = var5_8.authenticateAlipay((PaymentIntent)var6_9, authenticator, requestOptions, (Continuation<? super PaymentIntentResult>)$continuation);
                if (v1 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl39
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object confirmWeChatPay(@NotNull ConfirmPaymentIntentParams var1_1, @NotNull ApiRequest.Options var2_2, @NotNull Continuation<? super WeChatPayNextAction> var3_3) {
        if (!(var3_3 instanceof confirmWeChatPay.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.confirmWeChatPay(null, null, (Continuation<? super WeChatPayNextAction>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.confirmPaymentIntent((ConfirmPaymentIntentParams)confirmPaymentIntentParams, (ApiRequest.Options)requestOptions, (Continuation<? super PaymentIntent>)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                paymentIntent = (PaymentIntent)var4_7;
                $i$a$-let-StripePaymentController$confirmWeChatPay$2 = false;
                var9_12 = paymentIntent.getNextActionData() instanceof StripeIntent.NextActionData.WeChatPayRedirect;
                var10_13 = false;
                var11_14 = false;
                if (!var9_12) {
                    $i$a$-require-StripePaymentController$confirmWeChatPay$2$1 = false;
                    var11_15 = "Unable to confirm Payment Intent with WeChatPay SDK";
                    throw (Throwable)new IllegalArgumentException(var11_15.toString());
                }
                return new WeChatPayNextAction(paymentIntent, ((StripeIntent.NextActionData.WeChatPayRedirect)paymentIntent.getNextActionData()).getWeChat());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object confirmPaymentIntent(ConfirmPaymentIntentParams var1_1, ApiRequest.Options var2_2, Continuation<? super PaymentIntent> var3_3) {
        if (!(var3_3 instanceof confirmPaymentIntent.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$confirmPaymentIntent(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.stripeRepository.confirmPaymentIntent(confirmStripeIntentParams.withShouldUseStripeSdk(true), (ApiRequest.Options)requestOptions, StripePaymentController.EXPAND_PAYMENT_METHOD, (Continuation<? super PaymentIntent>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                if (var4_7 == null) {
                    $i$a$-requireNotNull-StripePaymentController$confirmPaymentIntent$2 = false;
                    var6_10 = "API request returned an invalid response.";
                    throw (Throwable)new IllegalArgumentException(var6_10.toString());
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object confirmSetupIntent(ConfirmSetupIntentParams var1_1, ApiRequest.Options var2_2, Continuation<? super SetupIntent> var3_3) {
        if (!(var3_3 instanceof confirmSetupIntent.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$confirmSetupIntent(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.stripeRepository.confirmSetupIntent(confirmStripeIntentParams.withShouldUseStripeSdk(true), (ApiRequest.Options)requestOptions, StripePaymentController.EXPAND_PAYMENT_METHOD, (Continuation<? super SetupIntent>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var4_7 = v0;
                var5_8 = false;
                var6_9 = false;
                if (var4_7 == null) {
                    $i$a$-requireNotNull-StripePaymentController$confirmSetupIntent$2 = false;
                    var6_10 = "API request returned an invalid response.";
                    throw (Throwable)new IllegalArgumentException(var6_10.toString());
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object startAuth(@NotNull AuthActivityStarter.Host var1_1, @NotNull String var2_2, @NotNull ApiRequest.Options var3_3, @NotNull PaymentController.StripeIntentType var4_4, @NotNull Continuation<? super Unit> var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object startAuthenticateSource(@NotNull AuthActivityStarter.Host var1_1, @NotNull Source var2_2, @NotNull ApiRequest.Options var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof startAuthenticateSource.1)) ** GOTO lbl-1000
        var16_5 = var4_4;
        if ((var16_5.label & -2147483648) != 0) {
            var16_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startAuthenticateSource(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthSourceStart, null, null, null, null, 30, null));
                var5_8 = this;
                var6_9 = false;
                var7_10 /* !! */  = Result.Companion;
                $this$startAuthenticateSource_u24lambda_u2d13 = var5_8;
                $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = false;
                v0 = $this$startAuthenticateSource_u24lambda_u2d13.stripeRepository;
                var10_21 = source.getId();
                var11_23 = false;
                v1 = var10_21;
                if (v1 == null) {
                    v1 = "";
                }
                var10_21 = source.getClientSecret();
                var11_23 = false;
                v2 = var10_21;
                if (v2 == null) {
                    v2 = "";
                }
                $continuation.L$0 = this;
                $continuation.L$1 = host;
                $continuation.L$2 = requestOptions;
                $continuation.label = 1;
                v3 = v0.retrieveSource((String)v1, (String)v2, requestOptions, (Continuation<? super Source>)$continuation);
                ** if (v3 != var17_7) goto lbl38
lbl37:
                // 1 sources

                return var17_7;
lbl38:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = false;
                requestOptions = (ApiRequest.Options)$continuation.L$2;
                host = (AuthActivityStarter.Host)$continuation.L$1;
                this = (StripePaymentController)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl48:
                    // 2 sources

                    var10_21 = v3;
                    var11_23 = false;
                    var12_24 = false;
                    var12_24 = false;
                    var13_25 = false;
                    if (var10_21 == null) {
                        var14_27 = false;
                        var13_26 = "Required value was null.";
                        throw (Throwable)new IllegalArgumentException(var13_26.toString());
                    }
                    $this$startAuthenticateSource_u24lambda_u2d13 = (Source)var10_21;
                    $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = false;
                    var7_10 /* !! */  = Result.constructor-impl((Object)$this$startAuthenticateSource_u24lambda_u2d13);
                }
                catch (Throwable $this$startAuthenticateSource_u24lambda_u2d13) {
                    $i$a$-runCatching-StripePaymentController$startAuthenticateSource$2 = Result.Companion;
                    var10_22 = false;
                    var7_10 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$startAuthenticateSource_u24lambda_u2d13));
                }
                var5_8 = var7_10 /* !! */ ;
                var6_9 = false;
                var7_11 = false;
                var7_12 = Result.exceptionOrNull-impl((Object)var5_8);
                if (var7_12 != null) break;
                retrievedSourced = (Source)var5_8;
                $i$a$-fold-StripePaymentController$startAuthenticateSource$3 = false;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v4 = this.onSourceRetrieved(host, retrievedSourced, requestOptions, (Continuation<? super Unit>)$continuation);
                if (v4 == var17_7) {
                    return var17_7;
                }
                ** GOTO lbl100
            }
            case 2: {
                $i$a$-fold-StripePaymentController$startAuthenticateSource$3 = false;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                ** GOTO lbl100
            }
        }
        it = var7_12;
        $i$a$-fold-StripePaymentController$startAuthenticateSource$4 = false;
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 3;
        v5 = this.handleError(var1_1, 50002, it, (Continuation<? super Unit>)$continuation);
        if (v5 == var17_7) {
            return var17_7;
        }
        ** GOTO lbl100
        {
            case 3: {
                $i$a$-fold-StripePaymentController$startAuthenticateSource$4 = false;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl100:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object onSourceRetrieved(AuthActivityStarter.Host host, Source source, ApiRequest.Options requestOptions, Continuation<? super Unit> $completion) {
        if (source.getFlow() == Source.Flow.Redirect) {
            Object object = this.startSourceAuth((PaymentBrowserAuthStarter)this.paymentBrowserAuthStarterFactory.invoke((Object)host), source, requestOptions, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.bypassAuth(host, source, requestOptions.getStripeAccount$stripe_release(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object startSourceAuth(PaymentBrowserAuthStarter paymentBrowserAuthStarter, Source source, ApiRequest.Options requestOptions, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentBrowserAuthStarter, source, requestOptions, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ PaymentBrowserAuthStarter $paymentBrowserAuthStarter;
            final /* synthetic */ Source $source;
            final /* synthetic */ ApiRequest.Options $requestOptions;
            {
                this.this$0 = $receiver;
                this.$paymentBrowserAuthStarter = $paymentBrowserAuthStarter;
                this.$source = $source;
                this.$requestOptions = $requestOptions;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StripePaymentController.access$getAnalyticsRequestExecutor$p(this.this$0).executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(StripePaymentController.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.AuthSourceRedirect, null, null, null, null, 30, null));
                        Object object3 = this.$source.getId();
                        boolean bl = false;
                        Object object4 = object3;
                        if (object4 == null) {
                            object4 = "";
                        }
                        object3 = this.$source.getClientSecret();
                        bl = false;
                        Object object5 = object3;
                        if (object5 == null) {
                            object5 = "";
                        }
                        object3 = this.$source.getRedirect();
                        object3 = object3 == null ? null : ((Source.Redirect)object3).getUrl();
                        bl = false;
                        Object object6 = object3;
                        if (object6 == null) {
                            object6 = "";
                        }
                        object3 = this.$source.getRedirect();
                        this.$paymentBrowserAuthStarter.start(new PaymentBrowserAuthContract.Args((String)object4, 50002, (String)object5, (String)object6, object3 == null ? null : ((Source.Redirect)object3).getReturnUrl(), StripePaymentController.access$getEnableLogging$p(this.this$0), null, this.$requestOptions.getStripeAccount$stripe_release(), false, false, null, 1856, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean shouldHandlePaymentResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50000 && data != null;
    }

    @Override
    public boolean shouldHandleSetupResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50001 && data != null;
    }

    @Override
    public boolean shouldHandleSourceResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50002 && data != null;
    }

    @Override
    @Nullable
    public Object getPaymentIntentResult(@NotNull Intent data, @NotNull Continuation<? super PaymentIntentResult> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, IllegalArgumentException {
        return this.paymentFlowResultProcessor.processPaymentIntent(PaymentFlowResult.Unvalidated.Companion.fromIntent$stripe_release(data), $completion);
    }

    @Override
    @Nullable
    public Object getSetupIntentResult(@NotNull Intent data, @NotNull Continuation<? super SetupIntentResult> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, IllegalArgumentException {
        return this.paymentFlowResultProcessor.processSetupIntent(PaymentFlowResult.Unvalidated.Companion.fromIntent$stripe_release(data), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getAuthenticateSourceResult(@NotNull Intent var1_1, @NotNull Continuation<? super Source> var2_2) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, IllegalArgumentException {
        if (!(var2_2 instanceof getAuthenticateSourceResult.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAuthenticateSourceResult(null, (Continuation<? super Source>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = PaymentFlowResult.Unvalidated.Companion.fromIntent$stripe_release((Intent)data);
                var5_7 = result.getSourceId$stripe_release();
                var6_8 = false;
                v0 = var5_7;
                if (v0 == null) {
                    v0 = "";
                }
                sourceId = v0;
                var6_9 = result.getClientSecret$stripe_release();
                var7_11 = false;
                v1 = var6_9;
                if (v1 == null) {
                    v1 = "";
                }
                clientSecret = v1;
                requestOptions = new ApiRequest.Options(this.publishableKey, result.getStripeAccountId$stripe_release(), null, 4, null);
                this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthSourceResult, null, null, null, null, 30, null));
                $continuation.label = 1;
                v2 = this.stripeRepository.retrieveSource(sourceId, clientSecret, requestOptions, (Continuation<? super Source>)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                var7_12 = v2;
                var8_13 = false;
                var9_14 = false;
                var9_14 = false;
                var10_15 = false;
                if (var7_12 == null) {
                    var11_17 = false;
                    var10_16 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(var10_16.toString());
                }
                return var7_12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object authenticateAlipay(PaymentIntent var1_1, AlipayAuthenticator var2_2, ApiRequest.Options var3_3, Continuation<? super PaymentIntentResult> var4_4) {
        if (!(var4_4 instanceof authenticateAlipay.1)) ** GOTO lbl-1000
        var13_5 = var4_4;
        if ((var13_5.label & -2147483648) != 0) {
            var13_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$authenticateAlipay(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = paymentIntent;
                $continuation.L$2 = requestOptions;
                $continuation.label = 1;
                v0 = this.alipayRepository.authenticate(paymentIntent, (AlipayAuthenticator)authenticator, requestOptions, (Continuation<? super AlipayAuthResult>)$continuation);
                if (v0 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                requestOptions = (ApiRequest.Options)$continuation.L$2;
                paymentIntent = (PaymentIntent)$continuation.L$1;
                this = (StripePaymentController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                outcome = ((AlipayAuthResult)v0).getOutcome();
                var7_9 = paymentIntent.getClientSecret();
                var8_10 = false;
                v1 = var7_9;
                if (v1 == null) {
                    v1 = "";
                }
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.I$0 = outcome;
                $continuation.label = 2;
                v2 = this.stripeRepository.retrievePaymentIntent((String)v1, requestOptions, StripePaymentController.EXPAND_PAYMENT_METHOD, (Continuation<? super PaymentIntent>)$continuation);
                if (v2 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl46
            }
            case 2: {
                var5_8 = $continuation.I$0;
                this = (StripePaymentController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                var7_9 = v2;
                var8_10 = false;
                var9_11 = false;
                var9_11 = false;
                var10_12 = false;
                if (var7_9 == null) {
                    var11_14 = false;
                    var10_13 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(var10_13.toString());
                }
                refreshedPaymentIntent = (PaymentIntent)var7_9;
                return new PaymentIntentResult(refreshedPaymentIntent, var5_8, this.failureMessageFactory.create(refreshedPaymentIntent, var5_8));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handleError(AuthActivityStarter.Host host, int requestCode, Throwable throwable, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, host, throwable, requestCode, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ int $requestCode;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$throwable = $throwable;
                this.$requestCode = $requestCode;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ((PaymentRelayStarter)StripePaymentController.access$getPaymentRelayStarterFactory$p(this.this$0).invoke((Object)this.$host)).start(new PaymentRelayStarter.Args.ErrorArgs(StripeException.Companion.create(this.$throwable), this.$requestCode));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @VisibleForTesting
    @Nullable
    public Object handleNextAction(@NotNull AuthActivityStarter.Host host, @NotNull StripeIntent stripeIntent, @Nullable String returnUrl, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        if (stripeIntent.requiresAction()) {
            StripeIntent.NextActionData nextActionData = stripeIntent.getNextActionData();
            if (nextActionData instanceof StripeIntent.NextActionData.SdkData.Use3DS2) {
                Object object = this.handle3ds2Auth(host, stripeIntent, requestOptions, (StripeIntent.NextActionData.SdkData.Use3DS2)nextActionData, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (nextActionData instanceof StripeIntent.NextActionData.SdkData.Use3DS1) {
                Object object = this.handle3ds1Auth(host, stripeIntent, requestOptions, (StripeIntent.NextActionData.SdkData.Use3DS1)nextActionData, returnUrl, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (nextActionData instanceof StripeIntent.NextActionData.RedirectToUrl) {
                Object object = this.handleRedirectToUrlAuth(host, stripeIntent, requestOptions, (StripeIntent.NextActionData.RedirectToUrl)nextActionData, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (nextActionData instanceof StripeIntent.NextActionData.AlipayRedirect) {
                Object object = this.handleAlipayAuth(host, stripeIntent, requestOptions, (StripeIntent.NextActionData.AlipayRedirect)nextActionData, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (nextActionData instanceof StripeIntent.NextActionData.DisplayOxxoDetails) {
                Object object = this.handleOxxoAuth(host, stripeIntent, requestOptions, (StripeIntent.NextActionData.DisplayOxxoDetails)nextActionData, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            Object object = this.bypassAuth$stripe_release(host, stripeIntent, requestOptions.getStripeAccount$stripe_release(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.bypassAuth$stripe_release(host, stripeIntent, requestOptions.getStripeAccount$stripe_release(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handle3ds2Auth(AuthActivityStarter.Host var1_1, StripeIntent var2_2, ApiRequest.Options var3_3, StripeIntent.NextActionData.SdkData.Use3DS2 var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof handle3ds2Auth.1)) ** GOTO lbl-1000
        var8_6 = var5_5;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ StripePaymentController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripePaymentController.access$handle3ds2Auth(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.Auth3ds2Fingerprint, null, null, null, null, 30, null));
                $continuation.L$0 = this;
                $continuation.L$1 = host;
                $continuation.L$2 = stripeIntent;
                $continuation.label = 1;
                v0 = this.begin3ds2Auth(host, stripeIntent, new Stripe3ds2Fingerprint((StripeIntent.NextActionData.SdkData.Use3DS2)nextActionData), (ApiRequest.Options)requestOptions, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var9_8) goto lbl22
lbl21:
                // 1 sources

                return var9_8;
lbl22:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                stripeIntent = (StripeIntent)$continuation.L$2;
                host = (AuthActivityStarter.Host)$continuation.L$1;
                this = (StripePaymentController)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl44
                }
                catch (CertificateException e) {
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v1 = this.handleError(host, StripePaymentController.Companion.getRequestCode$stripe_release(stripeIntent), e, (Continuation<? super Unit>)$continuation);
                    if (v1 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl44
                }
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handle3ds1Auth(AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.SdkData.Use3DS1 nextActionData, String returnUrl, Continuation<? super Unit> $completion) {
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.Auth3ds1Sdk, null, null, null, null, 30, null));
        PaymentBrowserAuthStarter paymentBrowserAuthStarter = (PaymentBrowserAuthStarter)this.paymentBrowserAuthStarterFactory.invoke((Object)host);
        int n = Companion.getRequestCode$stripe_release(stripeIntent);
        String string = stripeIntent.getClientSecret();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        Object object = StripePaymentController.beginWebAuth$default(this, paymentBrowserAuthStarter, stripeIntent, n, string2, nextActionData.getUrl(), requestOptions.getStripeAccount$stripe_release(), returnUrl, true, false, $completion, 256, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object handleRedirectToUrlAuth(AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.RedirectToUrl nextActionData, Continuation<? super Unit> $completion) {
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthRedirect, null, null, null, null, 30, null));
        PaymentBrowserAuthStarter paymentBrowserAuthStarter = (PaymentBrowserAuthStarter)this.paymentBrowserAuthStarterFactory.invoke((Object)host);
        int n = Companion.getRequestCode$stripe_release(stripeIntent);
        String string = stripeIntent.getClientSecret();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string = nextActionData.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextActionData.url.toString()");
        Object object = StripePaymentController.beginWebAuth$default(this, paymentBrowserAuthStarter, stripeIntent, n, string2, string, requestOptions.getStripeAccount$stripe_release(), nextActionData.getReturnUrl(), false, false, $completion, 384, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object handleAlipayAuth(AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.AlipayRedirect nextActionData, Continuation<? super Unit> $completion) {
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.AuthRedirect, null, null, null, null, 30, null));
        PaymentBrowserAuthStarter paymentBrowserAuthStarter = (PaymentBrowserAuthStarter)this.paymentBrowserAuthStarterFactory.invoke((Object)host);
        int n = Companion.getRequestCode$stripe_release(stripeIntent);
        String string = stripeIntent.getClientSecret();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string = nextActionData.getWebViewUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextActionData.webViewUrl.toString()");
        Object object = StripePaymentController.beginWebAuth$default(this, paymentBrowserAuthStarter, stripeIntent, n, string2, string, requestOptions.getStripeAccount$stripe_release(), nextActionData.getReturnUrl(), false, false, $completion, 384, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object handleOxxoAuth(AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.DisplayOxxoDetails nextActionData, Continuation<? super Unit> $completion) {
        if (nextActionData.getHostedVoucherUrl() != null) {
            PaymentBrowserAuthStarter paymentBrowserAuthStarter = (PaymentBrowserAuthStarter)this.paymentBrowserAuthStarterFactory.invoke((Object)host);
            int n = Companion.getRequestCode$stripe_release(stripeIntent);
            String string = stripeIntent.getClientSecret();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            Object object = StripePaymentController.beginWebAuth$default(this, paymentBrowserAuthStarter, stripeIntent, n, string2, nextActionData.getHostedVoucherUrl(), requestOptions.getStripeAccount$stripe_release(), null, false, false, $completion, 192, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.bypassAuth$stripe_release(host, stripeIntent, requestOptions.getStripeAccount$stripe_release(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final /* synthetic */ Object bypassAuth$stripe_release(AuthActivityStarter.Host host, StripeIntent stripeIntent, String stripeAccountId, Continuation $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, host, stripeIntent, stripeAccountId, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ StripeIntent $stripeIntent;
            final /* synthetic */ String $stripeAccountId;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$stripeIntent = $stripeIntent;
                this.$stripeAccountId = $stripeAccountId;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ((PaymentRelayStarter)StripePaymentController.access$getPaymentRelayStarterFactory$p(this.this$0).invoke((Object)this.$host)).start(PaymentRelayStarter.Args.Companion.create(this.$stripeIntent, this.$stripeAccountId));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object bypassAuth(AuthActivityStarter.Host host, Source source, String stripeAccountId, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, host, source, stripeAccountId, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ Source $source;
            final /* synthetic */ String $stripeAccountId;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$source = $source;
                this.$stripeAccountId = $stripeAccountId;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ((PaymentRelayStarter)StripePaymentController.access$getPaymentRelayStarterFactory$p(this.this$0).invoke((Object)this.$host)).start(new PaymentRelayStarter.Args.SourceArgs(this.$source, this.$stripeAccountId));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object begin3ds2Auth(AuthActivityStarter.Host host, StripeIntent stripeIntent, Stripe3ds2Fingerprint stripe3ds2Fingerprint, ApiRequest.Options requestOptions, Continuation<? super Unit> $completion) {
        Activity activity = host.getActivity$stripe_release();
        if (activity == null) {
            return Unit.INSTANCE;
        }
        Activity activity2 = activity;
        Transaction transaction = this.threeDs2Service.createTransaction(stripe3ds2Fingerprint.getDirectoryServerEncryption().getDirectoryServerId(), this.messageVersionRegistry.getCurrent(), stripeIntent.isLiveMode(), stripe3ds2Fingerprint.getDirectoryServerName(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getRootCerts(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getDirectoryServerPublicKey(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getKeyId());
        this.challengeProgressActivityStarter.start((Context)activity2, stripe3ds2Fingerprint.getDirectoryServerName(), false, this.config.getStripe3ds2Config$stripe_release().getUiCustomization$stripe_release().getUiCustomization(), transaction.getSdkTransactionId());
        Job job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(transaction, this, stripe3ds2Fingerprint, host, requestOptions, stripeIntent, null){
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Transaction $transaction;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ Stripe3ds2Fingerprint $stripe3ds2Fingerprint;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ ApiRequest.Options $requestOptions;
            final /* synthetic */ StripeIntent $stripeIntent;
            {
                this.$transaction = $transaction;
                this.this$0 = $receiver;
                this.$stripe3ds2Fingerprint = $stripe3ds2Fingerprint;
                this.$host = $host;
                this.$requestOptions = $requestOptions;
                this.$stripeIntent = $stripeIntent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var21_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = this.$transaction.createAuthenticationRequestParameters((Continuation)this);
                        if (v0 == var21_2) {
                            return var21_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        areqParams = (AuthenticationRequestParameters)v0;
                        timeout = StripePaymentController.access$getConfig$p(this.this$0).getStripe3ds2Config$stripe_release().getTimeout$stripe_release();
                        authParams = new Stripe3ds2AuthParams(this.$stripe3ds2Fingerprint.getSource(), areqParams.getSdkAppId(), areqParams.getSdkReferenceNumber(), areqParams.getSdkTransactionId().getValue(), areqParams.getDeviceData(), areqParams.getSdkEphemeralPublicKey(), areqParams.getMessageVersion(), timeout, null);
                        var7_7 = $this$launch;
                        var8_8 = this.this$0;
                        var9_9 = this.$requestOptions;
                        var10_10 = false;
                        var11_12 = Result.Companion;
                        var12_13 /* !! */  = var7_7;
                        $i$a$-runCatching-StripePaymentController$begin3ds2Auth$2$start3ds2AuthResult$1 = false;
                        this.L$0 = null;
                        this.I$0 = timeout;
                        this.label = 2;
                        v1 = StripePaymentController.access$getStripeRepository$p((StripePaymentController)var8_8).start3ds2Auth(authParams, (ApiRequest.Options)var9_9, (Continuation<? super Stripe3ds2AuthResult>)this);
                        ** if (v1 != var21_2) goto lbl34
lbl33:
                        // 1 sources

                        return var21_2;
lbl34:
                        // 1 sources

                        ** GOTO lbl42
                    }
                    case 2: {
                        $i$a$-runCatching-StripePaymentController$begin3ds2Auth$2$start3ds2AuthResult$1 = false;
                        timeout = this.I$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl42:
                            // 2 sources

                            var14_18 = v1;
                            var15_20 = false;
                            var16_22 = false;
                            var16_22 = false;
                            var17_24 = false;
                            if (var14_18 == null) {
                                var18_26 = false;
                                var17_25 = "Required value was null.";
                                throw (Throwable)new IllegalArgumentException(var17_25.toString());
                            }
                            var12_13 /* !! */  = (Stripe3ds2AuthResult)var14_18;
                            var13_15 = false;
                            var11_12 = Result.constructor-impl((Object)var12_13 /* !! */ );
                        }
                        catch (Throwable var12_14) {
                            var13_16 = Result.Companion;
                            var14_19 = false;
                            var11_12 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var12_14));
                        }
                        start3ds2AuthResult = var11_12;
                        paymentRelayStarter = (PaymentRelayStarter)StripePaymentController.access$getPaymentRelayStarterFactory$p(this.this$0).invoke((Object)this.$host);
                        var8_8 = start3ds2AuthResult;
                        var9_9 = this.this$0;
                        var10_11 = this.$transaction;
                        var11_12 = this.$stripe3ds2Fingerprint;
                        var12_13 /* !! */  = this.$stripeIntent;
                        var13_17 = this.$host;
                        var14_18 = this.$requestOptions;
                        var15_21 = this.this$0;
                        var16_23 = this.$stripeIntent;
                        var17_24 = false;
                        var18_27 = false;
                        var18_28 = Result.exceptionOrNull-impl((Object)var8_8);
                        if (var18_28 != null) break;
                        authResult = (Stripe3ds2AuthResult)var8_8;
                        $i$a$-fold-StripePaymentController$begin3ds2Auth$2$1 = false;
                        this.L$0 = null;
                        this.label = 3;
                        v2 = var9_9.on3ds2AuthSuccess$stripe_release(authResult, var10_11, var11_12.getSource(), timeout, paymentRelayStarter, StripePaymentController.Companion.getRequestCode$stripe_release((StripeIntent)var12_13 /* !! */ ), var13_17, (StripeIntent)var12_13 /* !! */ , var14_18, (Continuation<? super Unit>)this);
                        if (v2 == var21_2) {
                            return var21_2;
                        }
                        ** GOTO lbl100
                    }
                    case 3: {
                        $i$a$-fold-StripePaymentController$begin3ds2Auth$2$1 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl100
                    }
                }
                throwable = var18_28;
                $i$a$-fold-StripePaymentController$begin3ds2Auth$2$2 = false;
                this.L$0 = null;
                this.label = 4;
                v3 = StripePaymentController.access$on3ds2AuthFailure(var15_21, throwable, StripePaymentController.Companion.getRequestCode$stripe_release(var16_23), paymentRelayStarter, (Continuation)this);
                if (v3 == var21_2) {
                    return var21_2;
                }
                ** GOTO lbl100
                {
                    case 4: {
                        $i$a$-fold-StripePaymentController$begin3ds2Auth$2$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl100:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (job == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return job;
        }
        return Unit.INSTANCE;
    }

    @VisibleForTesting
    @Nullable
    public final Object on3ds2AuthSuccess$stripe_release(@NotNull Stripe3ds2AuthResult result2, @NotNull Transaction transaction, @NotNull String sourceId, int timeout, @NotNull PaymentRelayStarter paymentRelayStarter, int requestCode, @NotNull AuthActivityStarter.Host host, @NotNull StripeIntent stripeIntent, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        String string;
        Stripe3ds2AuthResult.Ares ares = result2.getAres();
        if (ares != null) {
            if (ares.isChallenge()) {
                Object object = this.startChallengeFlow$stripe_release(ares, transaction, sourceId, timeout, paymentRelayStarter, host, stripeIntent, requestOptions, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            Object object = this.startFrictionlessFlow(paymentRelayStarter, stripeIntent, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (result2.getFallbackRedirectUrl() != null) {
            Object object = this.on3ds2AuthFallback$stripe_release(result2.getFallbackRedirectUrl(), host, stripeIntent, requestOptions, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Stripe3ds2AuthResult.ThreeDS2Error threeDS2Error = result2.getError();
        if (threeDS2Error == null) {
            string = "Invalid 3DS2 authentication response";
        } else {
            Stripe3ds2AuthResult.ThreeDS2Error threeDS2Error2 = threeDS2Error;
            boolean bl = false;
            boolean bl2 = false;
            Stripe3ds2AuthResult.ThreeDS2Error error = threeDS2Error2;
            boolean bl3 = false;
            Object[] objectArray = new String[]{Intrinsics.stringPlus((String)"Code: ", (Object)error.getErrorCode()), Intrinsics.stringPlus((String)"Detail: ", (Object)error.getErrorDetail()), Intrinsics.stringPlus((String)"Description: ", (Object)error.getErrorDescription()), Intrinsics.stringPlus((String)"Component: ", (Object)error.getErrorComponent())};
            String string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            string = string2 == null ? "Invalid 3DS2 authentication response" : string2;
        }
        String errorMessage = string;
        Object object = this.on3ds2AuthFailure(new RuntimeException(Intrinsics.stringPlus((String)"Error encountered during 3DS2 authentication request. ", (Object)errorMessage)), requestCode, paymentRelayStarter, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object on3ds2AuthFallback$stripe_release(@NotNull String fallbackRedirectUrl, @NotNull AuthActivityStarter.Host host, @NotNull StripeIntent stripeIntent, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, AnalyticsEvent.Auth3ds2Fallback, null, null, null, null, 30, null));
        PaymentBrowserAuthStarter paymentBrowserAuthStarter = (PaymentBrowserAuthStarter)this.paymentBrowserAuthStarterFactory.invoke((Object)host);
        int n = Companion.getRequestCode$stripe_release(stripeIntent);
        String string = stripeIntent.getClientSecret();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        Object object = StripePaymentController.beginWebAuth$default(this, paymentBrowserAuthStarter, stripeIntent, n, string2, fallbackRedirectUrl, requestOptions.getStripeAccount$stripe_release(), null, true, false, $completion, 320, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object startFrictionlessFlow(PaymentRelayStarter paymentRelayStarter, StripeIntent stripeIntent, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentRelayStarter, stripeIntent, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ PaymentRelayStarter $paymentRelayStarter;
            final /* synthetic */ StripeIntent $stripeIntent;
            {
                this.this$0 = $receiver;
                this.$paymentRelayStarter = $paymentRelayStarter;
                this.$stripeIntent = $stripeIntent;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StripePaymentController.access$getAnalyticsRequestExecutor$p(this.this$0).executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(StripePaymentController.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.Auth3ds2Frictionless, null, null, null, null, 30, null));
                        this.$paymentRelayStarter.start(PaymentRelayStarter.Args.Companion.create$default(PaymentRelayStarter.Args.Companion, this.$stripeIntent, null, 2, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @VisibleForTesting
    @Nullable
    public final Object startChallengeFlow$stripe_release(@NotNull Stripe3ds2AuthResult.Ares ares, @NotNull Transaction transaction, @NotNull String sourceId, int maxTimeout, @NotNull PaymentRelayStarter paymentRelayStarter, @NotNull AuthActivityStarter.Host host, @NotNull StripeIntent stripeIntent, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.workContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(host, transaction, ares, this, stripeIntent, sourceId, requestOptions, maxTimeout, paymentRelayStarter, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ Transaction $transaction;
            final /* synthetic */ Stripe3ds2AuthResult.Ares $ares;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ StripeIntent $stripeIntent;
            final /* synthetic */ String $sourceId;
            final /* synthetic */ ApiRequest.Options $requestOptions;
            final /* synthetic */ int $maxTimeout;
            final /* synthetic */ PaymentRelayStarter $paymentRelayStarter;
            {
                this.$host = $host;
                this.$transaction = $transaction;
                this.$ares = $ares;
                this.this$0 = $receiver;
                this.$stripeIntent = $stripeIntent;
                this.$sourceId = $sourceId;
                this.$requestOptions = $requestOptions;
                this.$maxTimeout = $maxTimeout;
                this.$paymentRelayStarter = $paymentRelayStarter;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 = $this$withContext = (CoroutineScope)this.L$0;
                        var4_5 = this.$host;
                        var5_6 = false;
                        try {
                            var6_8 /* !! */  = Result.Companion;
                            var7_9 /* !! */  = var3_4;
                            $i$a$-runCatching-StripePaymentController$startChallengeFlow$2$1 = false;
                            var9_14 = var4_5.getFragment$stripe_release();
                            if (var9_14 == null) {
                                v0 = null;
                            } else {
                                var10_17 = var9_14;
                                var11_21 = 0;
                                var12_22 = false;
                                fragment = var10_17;
                                $i$a$-let-StripePaymentController$startChallengeFlow$2$1$1 = false;
                                v0 = new Stripe3ds2ActivityStarterHost(fragment);
                            }
                            var15_27 = v0;
                            if (var15_27 == null) {
                                var9_14 = var4_5.getActivity$stripe_release();
                                if (var9_14 == null) {
                                    v1 = null;
                                } else {
                                    var10_17 = var9_14;
                                    var11_21 = 0;
                                    var12_22 = false;
                                    activity = var10_17;
                                    $i$a$-let-StripePaymentController$startChallengeFlow$2$1$2 = false;
                                    v1 = new Stripe3ds2ActivityStarterHost((Activity)activity);
                                }
                            } else {
                                v1 = var15_27;
                            }
                            var15_27 = v1;
                            var9_15 = false;
                            var10_18 = false;
                            if (var15_27 == null) {
                                $i$a$-requireNotNull-StripePaymentController$startChallengeFlow$2$1$3 = false;
                                var10_19 = "Error while attempting to start 3DS2 challenge flow.";
                                throw (Throwable)new IllegalArgumentException(var10_19.toString());
                            }
                            var7_9 /* !! */  = var15_27;
                            var8_11 = false;
                            var6_8 /* !! */  = Result.constructor-impl((Object)var7_9 /* !! */ );
                        }
                        catch (Throwable var7_10) {
                            var8_12 = Result.Companion;
                            var9_15 = false;
                            var6_8 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var7_10));
                        }
                        var3_4 = var6_8 /* !! */ ;
                        var4_5 = this.$transaction;
                        var5_7 = this.$ares;
                        var6_8 /* !! */  = this.this$0;
                        var7_9 /* !! */  = this.$host;
                        var8_13 = this.$stripeIntent;
                        var9_16 = this.$sourceId;
                        var10_20 = this.$requestOptions;
                        var11_21 = this.$maxTimeout;
                        var12_23 = this.this$0;
                        var13_24 = this.$stripeIntent;
                        var14_26 = this.$paymentRelayStarter;
                        var15_28 = false;
                        var16_29 = false;
                        var16_30 = Result.exceptionOrNull-impl((Object)var3_4);
                        if (var16_30 != null) break;
                        stripe3ds2Host = (Stripe3ds2ActivityStarterHost)var3_4;
                        $i$a$-fold-StripePaymentController$startChallengeFlow$2$2 = false;
                        this.L$0 = var4_5;
                        this.L$1 = var5_7;
                        this.L$2 = var6_8 /* !! */ ;
                        this.L$3 = var7_9 /* !! */ ;
                        this.L$4 = var8_13;
                        this.L$5 = var9_16;
                        this.L$6 = var10_20;
                        this.L$7 = stripe3ds2Host;
                        this.I$0 = var11_21;
                        this.label = 1;
                        v2 = DelayKt.delay((long)StripePaymentController.Companion.getCHALLENGE_DELAY$stripe_release(), (Continuation)this);
                        if (v2 == var22_2) {
                            return var22_2;
                        }
                        ** GOTO lbl98
                    }
                    case 1: {
                        $i$a$-fold-StripePaymentController$startChallengeFlow$2$2 = false;
                        var11_21 = this.I$0;
                        stripe3ds2Host = (Stripe3ds2ActivityStarterHost)this.L$7;
                        var10_20 = (ApiRequest.Options)this.L$6;
                        var9_16 = (String)this.L$5;
                        var8_13 = (StripeIntent)this.L$4;
                        var7_9 /* !! */  = (AuthActivityStarter.Host)this.L$3;
                        var6_8 /* !! */  = (StripePaymentController)this.L$2;
                        var5_7 = (Stripe3ds2AuthResult.Ares)this.L$1;
                        var4_5 = (Transaction)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl98:
                        // 2 sources

                        var19_38 = var5_7.getAcsSignedContent$stripe_release();
                        var20_39 = var5_7.getThreeDSServerTransId$stripe_release();
                        var21_40 = var5_7.getAcsTransId$stripe_release();
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.L$5 = null;
                        this.L$6 = null;
                        this.L$7 = null;
                        this.label = 2;
                        v3 = var4_5.doChallenge(stripe3ds2Host, new ChallengeParameters(var20_39, var21_40, null, var19_38, 4, null), (ChallengeStatusReceiver)new DefaultStripeChallengeStatusReceiver((Stripe3ds2CompletionStarter)StripePaymentController.access$getStripe3ds2CompletionStarterFactory$p((StripePaymentController)var6_8 /* !! */ ).invoke((Object)var7_9 /* !! */ , (Object)Boxing.boxInt((int)StripePaymentController.Companion.getRequestCode$stripe_release(var8_13))), StripePaymentController.access$getStripeRepository$p((StripePaymentController)var6_8 /* !! */ ), var8_13, var9_16, var10_20, StripePaymentController.access$getAnalyticsRequestExecutor$p((StripePaymentController)var6_8 /* !! */ ), StripePaymentController.access$getAnalyticsRequestFactory$p((StripePaymentController)var6_8 /* !! */ ), (Transaction)var4_5, (Function0)new Function0<Unit>((Transaction)var4_5){
                            final /* synthetic */ Transaction $transaction;
                            {
                                this.$transaction = $transaction;
                                super(0);
                            }

                            public final void invoke() {
                                this.$transaction.close();
                            }
                        }, null, false, StripePaymentController.access$getWorkContext$p((StripePaymentController)var6_8 /* !! */ ), 1536, null), var11_21, (Continuation)this);
                        if (v3 == var22_2) {
                            return var22_2;
                        }
                        ** GOTO lbl131
                    }
                    case 2: {
                        $i$a$-fold-StripePaymentController$startChallengeFlow$2$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl131
                    }
                }
                it = var16_30;
                $i$a$-fold-StripePaymentController$startChallengeFlow$2$3 = false;
                this.label = 3;
                v4 = StripePaymentController.access$on3ds2AuthFailure(var12_23, it, StripePaymentController.Companion.getRequestCode$stripe_release(var13_24), var14_26, (Continuation)this);
                if (v4 == var22_2) {
                    return var22_2;
                }
                ** GOTO lbl131
                {
                    case 3: {
                        $i$a$-fold-StripePaymentController$startChallengeFlow$2$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl131:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object on3ds2AuthFailure(Throwable throwable, int requestCode, PaymentRelayStarter paymentRelayStarter, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(paymentRelayStarter, throwable, requestCode, null){
            int label;
            final /* synthetic */ PaymentRelayStarter $paymentRelayStarter;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ int $requestCode;
            {
                this.$paymentRelayStarter = $paymentRelayStarter;
                this.$throwable = $throwable;
                this.$requestCode = $requestCode;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$paymentRelayStarter.start(new PaymentRelayStarter.Args.ErrorArgs(StripeException.Companion.create(this.$throwable), this.$requestCode));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object beginWebAuth(PaymentBrowserAuthStarter paymentBrowserWebStarter, StripeIntent stripeIntent, int requestCode, String clientSecret, String authUrl, String stripeAccount, String returnUrl, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.uiContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentBrowserWebStarter, stripeIntent, requestCode, clientSecret, authUrl, returnUrl, stripeAccount, shouldCancelSource, shouldCancelIntentOnUserNavigation, null){
            int label;
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ PaymentBrowserAuthStarter $paymentBrowserWebStarter;
            final /* synthetic */ StripeIntent $stripeIntent;
            final /* synthetic */ int $requestCode;
            final /* synthetic */ String $clientSecret;
            final /* synthetic */ String $authUrl;
            final /* synthetic */ String $returnUrl;
            final /* synthetic */ String $stripeAccount;
            final /* synthetic */ boolean $shouldCancelSource;
            final /* synthetic */ boolean $shouldCancelIntentOnUserNavigation;
            {
                this.this$0 = $receiver;
                this.$paymentBrowserWebStarter = $paymentBrowserWebStarter;
                this.$stripeIntent = $stripeIntent;
                this.$requestCode = $requestCode;
                this.$clientSecret = $clientSecret;
                this.$authUrl = $authUrl;
                this.$returnUrl = $returnUrl;
                this.$stripeAccount = $stripeAccount;
                this.$shouldCancelSource = $shouldCancelSource;
                this.$shouldCancelIntentOnUserNavigation = $shouldCancelIntentOnUserNavigation;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StripePaymentController.access$getLogger$p(this.this$0).debug("PaymentBrowserAuthStarter#start()");
                        String string = this.$stripeIntent.getId();
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            string2 = "";
                        }
                        this.$paymentBrowserWebStarter.start(new PaymentBrowserAuthContract.Args(string2, this.$requestCode, this.$clientSecret, this.$authUrl, this.$returnUrl, StripePaymentController.access$getEnableLogging$p(this.this$0), null, this.$stripeAccount, this.$shouldCancelSource, this.$shouldCancelIntentOnUserNavigation, null, 1088, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static /* synthetic */ Object beginWebAuth$default(StripePaymentController stripePaymentController, PaymentBrowserAuthStarter paymentBrowserAuthStarter, StripeIntent stripeIntent, int n, String string, String string2, String string3, String string4, boolean bl, boolean bl2, Continuation continuation, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            string4 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = true;
        }
        return stripePaymentController.beginWebAuth(paymentBrowserAuthStarter, stripeIntent, n, string, string2, string3, string4, bl, bl2, (Continuation<? super Unit>)continuation);
    }

    private final void logReturnUrl(String returnUrl) {
        Object object = returnUrl;
        object = Intrinsics.areEqual((Object)object, (Object)this.defaultReturnUrl.getValue()) ? AnalyticsEvent.ConfirmReturnUrlDefault : (object == null ? AnalyticsEvent.ConfirmReturnUrlNull : AnalyticsEvent.ConfirmReturnUrlCustom);
        boolean bl = false;
        boolean bl2 = false;
        Object event = object;
        boolean bl3 = false;
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, (AnalyticsEvent)((Object)event), null, null, null, null, 30, null));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository, boolean enableLogging) {
        return Companion.create(context, publishableKey2, stripeRepository, enableLogging);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository) {
        return Companion.create(context, publishableKey2, stripeRepository);
    }

    public static final /* synthetic */ Object access$confirmPaymentIntent(StripePaymentController $this, ConfirmPaymentIntentParams confirmStripeIntentParams, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.confirmPaymentIntent(confirmStripeIntentParams, requestOptions, (Continuation<? super PaymentIntent>)$completion);
    }

    public static final /* synthetic */ Object access$confirmSetupIntent(StripePaymentController $this, ConfirmSetupIntentParams confirmStripeIntentParams, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.confirmSetupIntent(confirmStripeIntentParams, requestOptions, (Continuation<? super SetupIntent>)$completion);
    }

    public static final /* synthetic */ Object access$onSourceRetrieved(StripePaymentController $this, AuthActivityStarter.Host host, Source source, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.onSourceRetrieved(host, source, requestOptions, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$startSourceAuth(StripePaymentController $this, PaymentBrowserAuthStarter paymentBrowserAuthStarter, Source source, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.startSourceAuth(paymentBrowserAuthStarter, source, requestOptions, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ AnalyticsRequestExecutor access$getAnalyticsRequestExecutor$p(StripePaymentController $this) {
        return $this.analyticsRequestExecutor;
    }

    public static final /* synthetic */ AnalyticsRequestFactory access$getAnalyticsRequestFactory$p(StripePaymentController $this) {
        return $this.analyticsRequestFactory;
    }

    public static final /* synthetic */ boolean access$getEnableLogging$p(StripePaymentController $this) {
        return $this.enableLogging;
    }

    public static final /* synthetic */ Object access$authenticateAlipay(StripePaymentController $this, PaymentIntent paymentIntent, AlipayAuthenticator authenticator, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.authenticateAlipay(paymentIntent, authenticator, requestOptions, (Continuation<? super PaymentIntentResult>)$completion);
    }

    public static final /* synthetic */ Object access$handleError(StripePaymentController $this, AuthActivityStarter.Host host, int requestCode, Throwable throwable, Continuation $completion) {
        return $this.handleError(host, requestCode, throwable, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Function1 access$getPaymentRelayStarterFactory$p(StripePaymentController $this) {
        return $this.paymentRelayStarterFactory;
    }

    public static final /* synthetic */ Object access$handle3ds2Auth(StripePaymentController $this, AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData, Continuation $completion) {
        return $this.handle3ds2Auth(host, stripeIntent, requestOptions, nextActionData, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handle3ds1Auth(StripePaymentController $this, AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.SdkData.Use3DS1 nextActionData, String returnUrl, Continuation $completion) {
        return $this.handle3ds1Auth(host, stripeIntent, requestOptions, nextActionData, returnUrl, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleRedirectToUrlAuth(StripePaymentController $this, AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.RedirectToUrl nextActionData, Continuation $completion) {
        return $this.handleRedirectToUrlAuth(host, stripeIntent, requestOptions, nextActionData, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleAlipayAuth(StripePaymentController $this, AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.AlipayRedirect nextActionData, Continuation $completion) {
        return $this.handleAlipayAuth(host, stripeIntent, requestOptions, nextActionData, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleOxxoAuth(StripePaymentController $this, AuthActivityStarter.Host host, StripeIntent stripeIntent, ApiRequest.Options requestOptions, StripeIntent.NextActionData.DisplayOxxoDetails nextActionData, Continuation $completion) {
        return $this.handleOxxoAuth(host, stripeIntent, requestOptions, nextActionData, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$bypassAuth(StripePaymentController $this, AuthActivityStarter.Host host, Source source, String stripeAccountId, Continuation $completion) {
        return $this.bypassAuth(host, source, stripeAccountId, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$begin3ds2Auth(StripePaymentController $this, AuthActivityStarter.Host host, StripeIntent stripeIntent, Stripe3ds2Fingerprint stripe3ds2Fingerprint, ApiRequest.Options requestOptions, Continuation $completion) {
        return $this.begin3ds2Auth(host, stripeIntent, stripe3ds2Fingerprint, requestOptions, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ PaymentAuthConfig access$getConfig$p(StripePaymentController $this) {
        return $this.config;
    }

    public static final /* synthetic */ StripeRepository access$getStripeRepository$p(StripePaymentController $this) {
        return $this.stripeRepository;
    }

    public static final /* synthetic */ Object access$on3ds2AuthFailure(StripePaymentController $this, Throwable throwable, int requestCode, PaymentRelayStarter paymentRelayStarter, Continuation $completion) {
        return $this.on3ds2AuthFailure(throwable, requestCode, paymentRelayStarter, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$startFrictionlessFlow(StripePaymentController $this, PaymentRelayStarter paymentRelayStarter, StripeIntent stripeIntent, Continuation $completion) {
        return $this.startFrictionlessFlow(paymentRelayStarter, stripeIntent, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Function2 access$getStripe3ds2CompletionStarterFactory$p(StripePaymentController $this) {
        return $this.stripe3ds2CompletionStarterFactory;
    }

    public static final /* synthetic */ CoroutineContext access$getWorkContext$p(StripePaymentController $this) {
        return $this.workContext;
    }

    public static final /* synthetic */ Object access$beginWebAuth(StripePaymentController $this, PaymentBrowserAuthStarter paymentBrowserWebStarter, StripeIntent stripeIntent, int requestCode, String clientSecret, String authUrl, String stripeAccount, String returnUrl, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, Continuation $completion) {
        return $this.beginWebAuth(paymentBrowserWebStarter, stripeIntent, requestCode, clientSecret, authUrl, stripeAccount, returnUrl, shouldCancelSource, shouldCancelIntentOnUserNavigation, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(StripePaymentController $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ActivityResultLauncher access$getPaymentRelayLauncher$p(StripePaymentController $this) {
        return $this.paymentRelayLauncher;
    }

    public static final /* synthetic */ ActivityResultLauncher access$getPaymentBrowserAuthLauncher$p(StripePaymentController $this) {
        return $this.paymentBrowserAuthLauncher;
    }

    public static final /* synthetic */ boolean access$getHasCompatibleBrowser(StripePaymentController $this) {
        return $this.getHasCompatibleBrowser();
    }

    public static final /* synthetic */ DefaultReturnUrl access$getDefaultReturnUrl$p(StripePaymentController $this) {
        return $this.defaultReturnUrl;
    }

    public static final /* synthetic */ ActivityResultLauncher access$getStripe3ds2ChallengeLauncher$p(StripePaymentController $this) {
        return $this.stripe3ds2ChallengeLauncher;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u000eJ0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeProgressActivityStarter;", "", "start", "", "context", "Landroid/content/Context;", "directoryServerName", "", "cancelable", "", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "Default", "stripe_release"})
    public static interface ChallengeProgressActivityStarter {
        public void start(@NotNull Context var1, @NotNull String var2, boolean var3, @NotNull StripeUiCustomization var4, @NotNull SdkTransactionId var5);

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeProgressActivityStarter$Default;", "Lcom/stripe/android/StripePaymentController$ChallengeProgressActivityStarter;", "()V", "start", "", "context", "Landroid/content/Context;", "directoryServerName", "", "cancelable", "", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "stripe_release"})
        public static final class Default
        implements ChallengeProgressActivityStarter {
            @Override
            public void start(@NotNull Context context, @NotNull String directoryServerName, boolean cancelable, @NotNull StripeUiCustomization uiCustomization, @NotNull SdkTransactionId sdkTransactionId) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
                Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
                Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
                ChallengeProgressActivity.Companion.show(context, directoryServerName, cancelable, uiCustomization, sdkTransactionId);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/StripePaymentController$Companion;", "", "()V", "CHALLENGE_DELAY", "", "getCHALLENGE_DELAY$stripe_release", "()J", "EXPAND_PAYMENT_METHOD", "", "", "getEXPAND_PAYMENT_METHOD$stripe_release", "()Ljava/util/List;", "PAYMENT_REQUEST_CODE", "", "REQUIRED_ERROR", "SETUP_REQUEST_CODE", "SOURCE_REQUEST_CODE", "create", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "publishableKey", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "enableLogging", "", "getRequestCode", "params", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "getRequestCode$stripe_release", "intent", "Lcom/stripe/android/model/StripeIntent;", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ int getRequestCode$stripe_release(StripeIntent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            return intent instanceof PaymentIntent ? 50000 : 50001;
        }

        public final /* synthetic */ int getRequestCode$stripe_release(ConfirmStripeIntentParams params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return params instanceof ConfirmPaymentIntentParams ? 50000 : 50001;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository, boolean enableLogging) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            return new StripePaymentController(context2, publishableKey2, stripeRepository, enableLogging, null, null, null, null, null, null, null, null, null, null, null, null, 65520, null);
        }

        public static /* synthetic */ PaymentController create$default(Companion companion, Context context, String string, StripeRepository stripeRepository, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.create(context, string, stripeRepository, bl);
        }

        @NotNull
        public final List<String> getEXPAND_PAYMENT_METHOD$stripe_release() {
            return EXPAND_PAYMENT_METHOD;
        }

        public final long getCHALLENGE_DELAY$stripe_release() {
            return CHALLENGE_DELAY;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull String publishableKey2, @NotNull StripeRepository stripeRepository) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
            return com.stripe.android.StripePaymentController$Companion.create$default(this, context, publishableKey2, stripeRepository, false, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentController.StripeIntentType.values().length];
            nArray[PaymentController.StripeIntentType.PaymentIntent.ordinal()] = 1;
            nArray[PaymentController.StripeIntentType.SetupIntent.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

