/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Application;
import android.content.Context;
import androidx.annotation.IntegerRes;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import com.google.android.gms.common.api.Status;
import com.stripe.android.Logger;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.R;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.googlepay.StripeGooglePayContract;
import com.stripe.android.googlepay.StripeGooglePayContractKt;
import com.stripe.android.googlepay.StripeGooglePayEnvironment;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.payments.DefaultPaymentFlowResultProcessor;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.PaymentFlowResultProcessor;
import com.stripe.android.paymentsheet.DefaultGooglePayRepository;
import com.stripe.android.paymentsheet.DefaultPrefsRepository;
import com.stripe.android.paymentsheet.GooglePayRepository;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PaymentSheetContract;
import com.stripe.android.paymentsheet.PaymentSheetResult;
import com.stripe.android.paymentsheet.PrefsRepository;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.model.ConfirmParamsFactory;
import com.stripe.android.paymentsheet.model.FragmentConfig;
import com.stripe.android.paymentsheet.model.PaymentIntentValidator;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.model.PaymentSheetViewState;
import com.stripe.android.paymentsheet.repositories.PaymentMethodsApiRepository;
import com.stripe.android.paymentsheet.repositories.PaymentMethodsRepository;
import com.stripe.android.paymentsheet.repositories.StripeIntentRepository;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004nopqBa\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020KH\u0002J\u000e\u0010L\u001a\u00020M2\u0006\u00102\u001a\u000203J\u0012\u0010N\u001a\u00020M2\b\u0010O\u001a\u0004\u0018\u00010PH\u0002J\u0006\u0010Q\u001a\u00020MJ\u0006\u0010R\u001a\u00020MJ\u001d\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0T2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bUJ\u0010\u0010V\u001a\u00020M2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020M2\u0006\u0010J\u001a\u00020KH\u0016J\u0015\u0010Z\u001a\u00020M2\u0006\u0010[\u001a\u00020\\H\u0000\u00a2\u0006\u0002\b]J\u000e\u0010^\u001a\u00020M2\u0006\u0010_\u001a\u00020`J\u0010\u0010a\u001a\u00020M2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010b\u001a\u00020M2\u0006\u0010c\u001a\u00020dH\u0002J\b\u0010e\u001a\u00020MH\u0016J\u0010\u0010f\u001a\u00020M2\u0006\u0010g\u001a\u00020dH\u0002J!\u0010h\u001a\u00020M2\u0006\u0010W\u001a\u00020X2\n\b\u0001\u0010i\u001a\u0004\u0018\u00010jH\u0002\u00a2\u0006\u0002\u0010kJ\u001a\u0010h\u001a\u00020M2\u0006\u0010W\u001a\u00020X2\b\u0010l\u001a\u0004\u0018\u00010IH\u0002J\u0006\u0010m\u001a\u00020MR\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010 R\u001a\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u001e\u001a\u0004\b+\u0010 R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\"0-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010/R \u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020)0-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010/\u00a8\u0006r"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel;", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget;", "stripeIntentRepository", "Lcom/stripe/android/paymentsheet/repositories/StripeIntentRepository;", "paymentMethodsRepository", "Lcom/stripe/android/paymentsheet/repositories/PaymentMethodsRepository;", "paymentFlowResultProcessor", "Lcom/stripe/android/payments/PaymentFlowResultProcessor;", "googlePayRepository", "Lcom/stripe/android/paymentsheet/GooglePayRepository;", "prefsRepository", "Lcom/stripe/android/paymentsheet/PrefsRepository;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "args", "Lcom/stripe/android/paymentsheet/PaymentSheetContract$Args;", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "logger", "Lcom/stripe/android/Logger;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "application", "Landroid/app/Application;", "(Lcom/stripe/android/paymentsheet/repositories/StripeIntentRepository;Lcom/stripe/android/paymentsheet/repositories/PaymentMethodsRepository;Lcom/stripe/android/payments/PaymentFlowResultProcessor;Lcom/stripe/android/paymentsheet/GooglePayRepository;Lcom/stripe/android/paymentsheet/PrefsRepository;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lcom/stripe/android/paymentsheet/PaymentSheetContract$Args;Lcom/stripe/android/payments/DefaultReturnUrl;Lcom/stripe/android/Logger;Lkotlin/coroutines/CoroutineContext;Landroid/app/Application;)V", "_amount", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$Amount;", "get_amount$stripe_release$annotations", "()V", "get_amount$stripe_release", "()Landroidx/lifecycle/MutableLiveData;", "_paymentSheetResult", "Lcom/stripe/android/paymentsheet/PaymentSheetResult;", "get_paymentSheetResult$stripe_release$annotations", "get_paymentSheetResult$stripe_release", "_startConfirm", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel$Event;", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "_viewState", "Lcom/stripe/android/paymentsheet/model/PaymentSheetViewState;", "get_viewState$stripe_release$annotations", "get_viewState$stripe_release", "amount", "Landroidx/lifecycle/LiveData;", "getAmount$stripe_release", "()Landroidx/lifecycle/LiveData;", "getArgs$stripe_release", "()Lcom/stripe/android/paymentsheet/PaymentSheetContract$Args;", "checkoutIdentifier", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$CheckoutIdentifier;", "getCheckoutIdentifier$stripe_release", "()Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$CheckoutIdentifier;", "setCheckoutIdentifier$stripe_release", "(Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$CheckoutIdentifier;)V", "confirmParamsFactory", "Lcom/stripe/android/paymentsheet/model/ConfirmParamsFactory;", "newCard", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$Card;", "getNewCard", "()Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$Card;", "setNewCard", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$Card;)V", "paymentIntentValidator", "Lcom/stripe/android/paymentsheet/model/PaymentIntentValidator;", "paymentSheetResult", "getPaymentSheetResult$stripe_release", "startConfirm", "getStartConfirm$stripe_release", "viewState", "getViewState$stripe_release", "apiThrowableToString", "", "throwable", "", "checkout", "", "confirmPaymentSelection", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "fetchIsGooglePayReady", "fetchStripeIntent", "getButtonStateObservable", "Landroidx/lifecycle/MediatorLiveData;", "getButtonStateObservable$stripe_release", "onConfirmedPaymentIntent", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "onFatal", "onGooglePayResult", "googlePayResult", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "onGooglePayResult$stripe_release", "onPaymentFlowResult", "paymentFlowResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "onPaymentIntentResponse", "onPaymentIntentResult", "paymentIntentResult", "Lcom/stripe/android/PaymentIntentResult;", "onUserCancel", "processResult", "stripeIntentResult", "resetViewState", "stringResId", "", "(Lcom/stripe/android/model/PaymentIntent;Ljava/lang/Integer;)V", "userErrorMessage", "updatePaymentMethods", "Amount", "CheckoutIdentifier", "Factory", "TransitionTarget", "stripe_release"})
public final class PaymentSheetViewModel
extends BaseSheetViewModel<TransitionTarget> {
    @NotNull
    private final StripeIntentRepository stripeIntentRepository;
    @NotNull
    private final PaymentMethodsRepository paymentMethodsRepository;
    @NotNull
    private final PaymentFlowResultProcessor paymentFlowResultProcessor;
    @NotNull
    private final GooglePayRepository googlePayRepository;
    @NotNull
    private final EventReporter eventReporter;
    @NotNull
    private final PaymentSheetContract.Args args;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfirmParamsFactory confirmParamsFactory;
    @NotNull
    private final MutableLiveData<PaymentSheetResult> _paymentSheetResult;
    @NotNull
    private final LiveData<PaymentSheetResult> paymentSheetResult;
    @NotNull
    private final MutableLiveData<BaseSheetViewModel.Event<ConfirmPaymentIntentParams>> _startConfirm;
    @NotNull
    private final LiveData<BaseSheetViewModel.Event<ConfirmPaymentIntentParams>> startConfirm;
    @NotNull
    private final MutableLiveData<Amount> _amount;
    @NotNull
    private final LiveData<Amount> amount;
    @NotNull
    private final MutableLiveData<PaymentSheetViewState> _viewState;
    @NotNull
    private final LiveData<PaymentSheetViewState> viewState;
    @NotNull
    private CheckoutIdentifier checkoutIdentifier;
    @Nullable
    private PaymentSelection.New.Card newCard;
    @NotNull
    private final PaymentIntentValidator paymentIntentValidator;

    public PaymentSheetViewModel(@NotNull StripeIntentRepository stripeIntentRepository, @NotNull PaymentMethodsRepository paymentMethodsRepository, @NotNull PaymentFlowResultProcessor paymentFlowResultProcessor, @NotNull GooglePayRepository googlePayRepository, @NotNull PrefsRepository prefsRepository2, @NotNull EventReporter eventReporter2, @NotNull PaymentSheetContract.Args args2, @NotNull DefaultReturnUrl defaultReturnUrl, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)stripeIntentRepository, (String)"stripeIntentRepository");
        Intrinsics.checkNotNullParameter((Object)paymentMethodsRepository, (String)"paymentMethodsRepository");
        Intrinsics.checkNotNullParameter((Object)paymentFlowResultProcessor, (String)"paymentFlowResultProcessor");
        Intrinsics.checkNotNullParameter((Object)googlePayRepository, (String)"googlePayRepository");
        Intrinsics.checkNotNullParameter((Object)prefsRepository2, (String)"prefsRepository");
        Intrinsics.checkNotNullParameter((Object)eventReporter2, (String)"eventReporter");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application, args2.getConfig(), prefsRepository2, workContext);
        this.stripeIntentRepository = stripeIntentRepository;
        this.paymentMethodsRepository = paymentMethodsRepository;
        this.paymentFlowResultProcessor = paymentFlowResultProcessor;
        this.googlePayRepository = googlePayRepository;
        this.eventReporter = eventReporter2;
        this.args = args2;
        this.logger = logger2;
        this.confirmParamsFactory = new ConfirmParamsFactory(defaultReturnUrl, this.args.getClientSecret());
        this._paymentSheetResult = new MutableLiveData();
        this.paymentSheetResult = (LiveData)this._paymentSheetResult;
        this._startConfirm = new MutableLiveData();
        this.startConfirm = (LiveData)this._startConfirm;
        this._amount = new MutableLiveData();
        this.amount = (LiveData)this._amount;
        this._viewState = new MutableLiveData(null);
        LiveData $this$distinctUntilChanged$iv = (LiveData)this._viewState;
        boolean $i$f$distinctUntilChanged = false;
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)$this$distinctUntilChanged$iv);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        this.viewState = liveData;
        this.checkoutIdentifier = CheckoutIdentifier.SheetBottomBuy;
        this.paymentIntentValidator = new PaymentIntentValidator();
        this.fetchIsGooglePayReady();
        this.eventReporter.onInit(this.getConfig$stripe_release());
    }

    public /* synthetic */ PaymentSheetViewModel(StripeIntentRepository stripeIntentRepository, PaymentMethodsRepository paymentMethodsRepository, PaymentFlowResultProcessor paymentFlowResultProcessor, GooglePayRepository googlePayRepository, PrefsRepository prefsRepository2, EventReporter eventReporter2, PaymentSheetContract.Args args2, DefaultReturnUrl defaultReturnUrl, Logger logger2, CoroutineContext coroutineContext, Application application, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            logger2 = Logger.Companion.noop$stripe_release();
        }
        this(stripeIntentRepository, paymentMethodsRepository, paymentFlowResultProcessor, googlePayRepository, prefsRepository2, eventReporter2, args2, defaultReturnUrl, logger2, coroutineContext, application);
    }

    @NotNull
    public final PaymentSheetContract.Args getArgs$stripe_release() {
        return this.args;
    }

    @NotNull
    public final MutableLiveData<PaymentSheetResult> get_paymentSheetResult$stripe_release() {
        return this._paymentSheetResult;
    }

    @VisibleForTesting
    public static /* synthetic */ void get_paymentSheetResult$stripe_release$annotations() {
    }

    @NotNull
    public final LiveData<PaymentSheetResult> getPaymentSheetResult$stripe_release() {
        return this.paymentSheetResult;
    }

    @NotNull
    public final LiveData<BaseSheetViewModel.Event<ConfirmPaymentIntentParams>> getStartConfirm$stripe_release() {
        return this.startConfirm;
    }

    @NotNull
    public final MutableLiveData<Amount> get_amount$stripe_release() {
        return this._amount;
    }

    @VisibleForTesting
    public static /* synthetic */ void get_amount$stripe_release$annotations() {
    }

    @NotNull
    public final LiveData<Amount> getAmount$stripe_release() {
        return this.amount;
    }

    @NotNull
    public final MutableLiveData<PaymentSheetViewState> get_viewState$stripe_release() {
        return this._viewState;
    }

    @VisibleForTesting
    public static /* synthetic */ void get_viewState$stripe_release$annotations() {
    }

    @NotNull
    public final LiveData<PaymentSheetViewState> getViewState$stripe_release() {
        return this.viewState;
    }

    @NotNull
    public final CheckoutIdentifier getCheckoutIdentifier$stripe_release() {
        return this.checkoutIdentifier;
    }

    public final void setCheckoutIdentifier$stripe_release(@NotNull CheckoutIdentifier checkoutIdentifier) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkoutIdentifier), (String)"<set-?>");
        this.checkoutIdentifier = checkoutIdentifier;
    }

    @NotNull
    public final MediatorLiveData<PaymentSheetViewState> getButtonStateObservable$stripe_release(@NotNull CheckoutIdentifier checkoutIdentifier) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkoutIdentifier), (String)"checkoutIdentifier");
        MediatorLiveData outputLiveData = new MediatorLiveData();
        outputLiveData.addSource((LiveData)this._viewState, arg_0 -> PaymentSheetViewModel.getButtonStateObservable$lambda-0(this, checkoutIdentifier, outputLiveData, arg_0));
        return outputLiveData;
    }

    @Override
    @Nullable
    public PaymentSelection.New.Card getNewCard() {
        return this.newCard;
    }

    @Override
    public void setNewCard(@Nullable PaymentSelection.New.Card card) {
        this.newCard = card;
    }

    private final String apiThrowableToString(Throwable throwable) {
        Throwable throwable2 = throwable;
        return throwable2 instanceof APIConnectionException ? this.getApplication().getResources().getString(R.string.stripe_failure_connection_error) : throwable.getLocalizedMessage();
    }

    public final void fetchIsGooglePayReady() {
        if (this.isGooglePayReady$stripe_release().getValue() == null) {
            if (this.args.isGooglePayEnabled()) {
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ PaymentSheetViewModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = BuildersKt.withContext((CoroutineContext)PaymentSheetViewModel.access$getWorkContext(this.this$0), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ PaymentSheetViewModel this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = FlowKt.first(PaymentSheetViewModel.access$getGooglePayRepository$p(this.this$0).isReady(), (Continuation)((Continuation)this));
                                                if (object3 != object2) return object3;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                isGooglePayReady = (Boolean)v0;
                                PaymentSheetViewModel.access$get_isGooglePayReady(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)(isGooglePayReady != false)));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else {
                this.get_isGooglePayReady().setValue((Object)false);
            }
        }
    }

    public final void updatePaymentMethods() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ PaymentSheetViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = PaymentSheetViewModel.access$get_paymentMethods(this.this$0);
                        var2_3 = this.this$0.getCustomerConfig$stripe_release();
                        if (var2_3 != null) ** GOTO lbl10
                        v1 = null;
                        ** GOTO lbl31
lbl10:
                        // 1 sources

                        var3_4 = var2_3;
                        var4_6 = this.this$0;
                        var5_7 = false;
                        var6_8 = false;
                        var7_9 = var3_4;
                        var9_10 = v0;
                        $i$a$-let-PaymentSheetViewModel$updatePaymentMethods$1$1 = false;
                        this.L$0 = var9_10;
                        this.label = 1;
                        v2 = PaymentSheetViewModel.access$getPaymentMethodsRepository$p(var4_6).get((PaymentSheet.CustomerConfiguration)it, PaymentMethod.Type.Card, (Continuation<? super List<PaymentMethod>>)this);
                        if (v2 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        $i$a$-let-PaymentSheetViewModel$updatePaymentMethods$1$1 = false;
                        var9_10 = (MutableLiveData)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl28:
                        // 2 sources

                        var10_13 = (List)v2;
                        v0 = var9_10;
                        v1 = var10_13;
lbl31:
                        // 2 sources

                        var2_3 = v1;
                        var3_5 = false;
                        v3 = var2_3;
                        if (v3 == null) {
                            v3 = CollectionsKt.emptyList();
                        }
                        v0.setValue(v3);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void fetchStripeIntent() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentSheetViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var4_5 = this.this$0;
                        var5_6 = false;
                        var6_8 = Result.Companion;
                        var7_10 = var3_4 /* !! */ ;
                        $i$a$-runCatching-PaymentSheetViewModel$fetchStripeIntent$1$1 = false;
                        this.label = 1;
                        v0 = PaymentSheetViewModel.access$getStripeIntentRepository$p(var4_5).get(var4_5.getArgs$stripe_release().getClientSecret(), (Continuation<? super PaymentIntent>)this);
                        ** if (v0 != var10_2) goto lbl17
lbl16:
                        // 1 sources

                        return var10_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl24
                    }
                    case 1: {
                        $i$a$-runCatching-PaymentSheetViewModel$fetchStripeIntent$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            var7_10 = (PaymentIntent)v0;
                            $i$a$-runCatching-PaymentSheetViewModel$fetchStripeIntent$1$1 = false;
                            var6_8 = Result.constructor-impl((Object)var7_10);
                        }
                        catch (Throwable var7_11) {
                            $i$a$-runCatching-PaymentSheetViewModel$fetchStripeIntent$1$1 = Result.Companion;
                            var9_18 = false;
                            var6_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var7_11));
                        }
                        var3_4 /* !! */  = var6_8;
                        var4_5 = this.this$0;
                        var5_7 = this.this$0;
                        var6_9 = false;
                        var7_12 = false;
                        var7_13 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (var7_13 == null) {
                            p0 = (PaymentIntent)var3_4 /* !! */ ;
                            $i$a$-fold-PaymentSheetViewModel$fetchStripeIntent$1$2 = false;
                            PaymentSheetViewModel.access$onPaymentIntentResponse(var4_5, p0);
                        } else {
                            it = var7_13;
                            $i$a$-fold-PaymentSheetViewModel$fetchStripeIntent$1$3 = false;
                            PaymentSheetViewModel.access$get_paymentIntent(var5_7).setValue(null);
                            var5_7.onFatal(it);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onPaymentIntentResponse(PaymentIntent paymentIntent) {
        if (paymentIntent.isConfirmed()) {
            this.onConfirmedPaymentIntent(paymentIntent);
        } else {
            Object object;
            PaymentSheetViewModel paymentSheetViewModel = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                Object $this$onPaymentIntentResponse_u24lambda_u2d1 = paymentSheetViewModel;
                boolean bl2 = false;
                $this$onPaymentIntentResponse_u24lambda_u2d1 = $this$onPaymentIntentResponse_u24lambda_u2d1.paymentIntentValidator.requireValid(paymentIntent);
                bl2 = false;
                object = Result.constructor-impl((Object)$this$onPaymentIntentResponse_u24lambda_u2d1);
            }
            catch (Throwable $this$onPaymentIntentResponse_u24lambda_u2d1) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$onPaymentIntentResponse_u24lambda_u2d1));
            }
            paymentSheetViewModel = object;
            bl = false;
            boolean bl4 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)paymentSheetViewModel));
            if (throwable == null) {
                PaymentIntent it = (PaymentIntent)((Object)paymentSheetViewModel);
                boolean bl5 = false;
                this.get_paymentIntent().setValue((Object)paymentIntent);
                this.resetViewState(paymentIntent, (String)null);
            } else {
                Throwable p0 = throwable;
                boolean bl6 = false;
                this.onFatal(p0);
            }
        }
    }

    private final void onConfirmedPaymentIntent(PaymentIntent paymentIntent) {
        this.logger.info(StringsKt.trimIndent((String)("\n            PaymentIntent with id=" + paymentIntent.getId() + "\" has already been confirmed.\n            ")));
        this._viewState.setValue((Object)new PaymentSheetViewState.FinishProcessing((Function0<Unit>)((Function0)new Function0<Unit>(this, paymentIntent){
            final /* synthetic */ PaymentSheetViewModel this$0;
            final /* synthetic */ PaymentIntent $paymentIntent;
            {
                this.this$0 = $receiver;
                this.$paymentIntent = $paymentIntent;
                super(0);
            }

            public final void invoke() {
                PaymentSheetViewModel.access$processResult(this.this$0, new PaymentIntentResult(this.$paymentIntent, 1, null, 4, null));
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final void resetViewState(PaymentIntent paymentIntent, @IntegerRes Integer stringResId) {
        String string2;
        PaymentSheetViewModel paymentSheetViewModel = this;
        PaymentIntent paymentIntent2 = paymentIntent;
        Integer n = stringResId;
        if (n == null) {
            string2 = null;
        } else {
            void it;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = ((Number)n2).intValue();
            PaymentIntent paymentIntent3 = paymentIntent2;
            PaymentSheetViewModel paymentSheetViewModel2 = paymentSheetViewModel;
            boolean bl3 = false;
            String string3 = this.getApplication().getResources().getString((int)it);
            paymentSheetViewModel = paymentSheetViewModel2;
            paymentIntent2 = paymentIntent3;
            string2 = string3;
        }
        paymentSheetViewModel.resetViewState(paymentIntent2, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final void resetViewState(PaymentIntent paymentIntent, String userErrorMessage) {
        Long amount = paymentIntent.getAmount();
        String currencyCode = paymentIntent.getCurrency();
        this.get_processing$stripe_release().setValue((Object)false);
        if (amount != null && currencyCode != null) {
            BaseSheetViewModel.UserErrorMessage userErrorMessage2;
            this._amount.setValue((Object)new Amount(amount, currencyCode));
            MutableLiveData<PaymentSheetViewState> mutableLiveData = this._viewState;
            String string2 = userErrorMessage;
            if (string2 == null) {
                userErrorMessage2 = null;
            } else {
                void it;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3;
                MutableLiveData<PaymentSheetViewState> mutableLiveData2 = mutableLiveData;
                boolean bl3 = false;
                BaseSheetViewModel.UserErrorMessage userErrorMessage3 = new BaseSheetViewModel.UserErrorMessage((String)it);
                mutableLiveData = mutableLiveData2;
                userErrorMessage2 = userErrorMessage3;
            }
            BaseSheetViewModel.UserErrorMessage userErrorMessage4 = userErrorMessage2;
            mutableLiveData.setValue((Object)new PaymentSheetViewState.Reset(userErrorMessage4));
        } else {
            this.onFatal(new IllegalStateException("PaymentIntent could not be parsed correctly."));
        }
    }

    public final void checkout(@NotNull CheckoutIdentifier checkoutIdentifier) {
        Intrinsics.checkNotNullParameter((Object)((Object)checkoutIdentifier), (String)"checkoutIdentifier");
        this._viewState.setValue((Object)new PaymentSheetViewState.Reset(null));
        this.checkoutIdentifier = checkoutIdentifier;
        this.get_processing$stripe_release().setValue((Object)true);
        this._viewState.setValue((Object)PaymentSheetViewState.StartProcessing.INSTANCE);
        PaymentSelection paymentSelection = (PaymentSelection)this.getSelection$stripe_release().getValue();
        if (paymentSelection instanceof PaymentSelection.GooglePay) {
            PaymentIntent paymentIntent = (PaymentIntent)this.getPaymentIntent$stripe_release().getValue();
            if (paymentIntent != null) {
                PaymentSheet.GooglePayConfiguration googlePayConfiguration;
                PaymentIntent paymentIntent2 = paymentIntent;
                boolean bl = false;
                boolean bl2 = false;
                PaymentIntent paymentIntent3 = paymentIntent2;
                boolean bl3 = false;
                MutableLiveData<BaseSheetViewModel.Event<StripeGooglePayContract.Args>> mutableLiveData = this.get_launchGooglePay();
                PaymentSheet.Configuration configuration = this.getArgs$stripe_release().getConfig();
                Object object = configuration == null ? null : ((googlePayConfiguration = configuration.getGooglePay()) == null ? null : googlePayConfiguration.getEnvironment());
                int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
                StripeGooglePayEnvironment stripeGooglePayEnvironment = n == 1 ? StripeGooglePayEnvironment.Production : StripeGooglePayEnvironment.Test;
                object = this.getArgs$stripe_release().getGooglePayConfig();
                object = object == null ? null : ((PaymentSheet.GooglePayConfiguration)object).getCountryCode();
                n = 0;
                Object object2 = object;
                if (object2 == null) {
                    object2 = "";
                }
                object = this.getArgs$stripe_release().getConfig();
                mutableLiveData.setValue(new BaseSheetViewModel.Event<StripeGooglePayContract.Args>(new StripeGooglePayContract.Args(paymentIntent3, new StripeGooglePayContract.GooglePayConfig(stripeGooglePayEnvironment, (String)object2, false, object == null ? null : ((PaymentSheet.Configuration)object).getMerchantDisplayName(), 4, null), this.getArgs$stripe_release().getStatusBarColor())));
            }
        } else {
            this.confirmPaymentSelection(paymentSelection);
        }
    }

    private final void confirmPaymentSelection(PaymentSelection paymentSelection) {
        ConfirmPaymentIntentParams confirmPaymentIntentParams;
        Object object = paymentSelection;
        ConfirmPaymentIntentParams confirmPaymentIntentParams2 = object instanceof PaymentSelection.Saved ? this.confirmParamsFactory.create$stripe_release((PaymentSelection.Saved)paymentSelection) : (confirmPaymentIntentParams = object instanceof PaymentSelection.New.Card ? this.confirmParamsFactory.create$stripe_release((PaymentSelection.New)paymentSelection) : null);
        if (confirmPaymentIntentParams != null) {
            object = confirmPaymentIntentParams;
            boolean bl = false;
            boolean bl2 = false;
            Object confirmParams = object;
            boolean bl3 = false;
            this._startConfirm.setValue(new BaseSheetViewModel.Event<Object>(confirmParams));
        }
    }

    private final void onPaymentIntentResult(PaymentIntentResult paymentIntentResult) {
        int n = paymentIntentResult.getOutcome();
        if (n == 1) {
            PaymentSelection paymentSelection;
            this.eventReporter.onPaymentSuccess((PaymentSelection)this.getSelection$stripe_release().getValue());
            PaymentSelection paymentSelection2 = (PaymentSelection)this.getSelection$stripe_release().getValue();
            if (paymentSelection2 instanceof PaymentSelection.New.Card) {
                PaymentSelection.Saved saved;
                PaymentMethod paymentMethod = paymentIntentResult.getIntent().getPaymentMethod();
                if (paymentMethod == null) {
                    saved = null;
                } else {
                    PaymentMethod paymentMethod2 = paymentMethod;
                    boolean bl = false;
                    boolean bl2 = false;
                    PaymentMethod it = paymentMethod2;
                    boolean bl3 = false;
                    saved = new PaymentSelection.Saved(it);
                }
                paymentSelection = saved;
            } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
                paymentSelection = (PaymentSelection)this.getSelection$stripe_release().getValue();
            } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
                paymentSelection = (PaymentSelection)this.getSelection$stripe_release().getValue();
            } else if (paymentSelection2 == null) {
                paymentSelection = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            PaymentSelection paymentSelection3 = paymentSelection;
            if (paymentSelection3 != null) {
                paymentSelection2 = paymentSelection3;
                boolean bl = false;
                boolean bl4 = false;
                PaymentSelection it = paymentSelection2;
                boolean bl5 = false;
                this.getPrefsRepository().savePaymentSelection(it);
            }
            this._viewState.setValue((Object)new PaymentSheetViewState.FinishProcessing((Function0<Unit>)((Function0)new Function0<Unit>(this, paymentIntentResult){
                final /* synthetic */ PaymentSheetViewModel this$0;
                final /* synthetic */ PaymentIntentResult $paymentIntentResult;
                {
                    this.this$0 = $receiver;
                    this.$paymentIntentResult = $paymentIntentResult;
                    super(0);
                }

                public final void invoke() {
                    PaymentSheetViewModel.access$processResult(this.this$0, this.$paymentIntentResult);
                }
            })));
        } else {
            Object object;
            this.eventReporter.onPaymentFailure((PaymentSelection)this.getSelection$stripe_release().getValue());
            PaymentSheetViewModel paymentSheetViewModel = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                Object $this$onPaymentIntentResult_u24lambda_u2d9 = paymentSheetViewModel;
                boolean bl6 = false;
                $this$onPaymentIntentResult_u24lambda_u2d9 = $this$onPaymentIntentResult_u24lambda_u2d9.paymentIntentValidator.requireValid(paymentIntentResult.getIntent());
                bl6 = false;
                object = Result.constructor-impl((Object)$this$onPaymentIntentResult_u24lambda_u2d9);
            }
            catch (Throwable $this$onPaymentIntentResult_u24lambda_u2d9) {
                Result.Companion bl6 = Result.Companion;
                boolean bl7 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$onPaymentIntentResult_u24lambda_u2d9));
            }
            paymentSheetViewModel = object;
            bl = false;
            boolean bl8 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)paymentSheetViewModel));
            if (throwable == null) {
                PaymentIntent it = (PaymentIntent)((Object)paymentSheetViewModel);
                boolean bl9 = false;
                this.resetViewState(it, paymentIntentResult.getFailureMessage());
            } else {
                Throwable p0 = throwable;
                boolean bl10 = false;
                this.onFatal(p0);
            }
        }
    }

    private final void processResult(PaymentIntentResult stripeIntentResult) {
        int n = stripeIntentResult.getOutcome();
        if (n == 1) {
            this._paymentSheetResult.setValue((Object)PaymentSheetResult.Completed.INSTANCE);
        }
    }

    public final void onGooglePayResult$stripe_release(@NotNull StripeGooglePayContract.Result googlePayResult) {
        Intrinsics.checkNotNullParameter((Object)googlePayResult, (String)"googlePayResult");
        StripeGooglePayContract.Result result2 = googlePayResult;
        if (result2 instanceof StripeGooglePayContract.Result.PaymentData) {
            PaymentSelection.Saved paymentSelection = new PaymentSelection.Saved(((StripeGooglePayContract.Result.PaymentData)googlePayResult).getPaymentMethod());
            this.confirmPaymentSelection(paymentSelection);
        } else if (result2 instanceof StripeGooglePayContract.Result.Error) {
            this.eventReporter.onPaymentFailure(PaymentSelection.GooglePay.INSTANCE);
            PaymentIntent paymentIntent = (PaymentIntent)this.getPaymentIntent$stripe_release().getValue();
            if (paymentIntent != null) {
                PaymentIntent paymentIntent2 = paymentIntent;
                boolean bl = false;
                boolean bl2 = false;
                PaymentIntent it = paymentIntent2;
                boolean bl3 = false;
                Status status = ((StripeGooglePayContract.Result.Error)googlePayResult).getGooglePayStatus();
                this.resetViewState(it, status == null ? null : StripeGooglePayContractKt.getErrorResourceID(status));
            }
        } else {
            PaymentIntent paymentIntent = (PaymentIntent)this.getPaymentIntent$stripe_release().getValue();
            if (paymentIntent != null) {
                PaymentIntent paymentIntent3 = paymentIntent;
                boolean bl = false;
                boolean bl4 = false;
                PaymentIntent it = paymentIntent3;
                boolean bl5 = false;
                this.resetViewState(it, (String)null);
            }
        }
    }

    public final void onPaymentFlowResult(@NotNull PaymentFlowResult.Unvalidated paymentFlowResult) {
        Intrinsics.checkNotNullParameter((Object)paymentFlowResult, (String)"paymentFlowResult");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentFlowResult, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentSheetViewModel this$0;
            final /* synthetic */ PaymentFlowResult.Unvalidated $paymentFlowResult;
            {
                this.this$0 = $receiver;
                this.$paymentFlowResult = $paymentFlowResult;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var4_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var5_5 = this.this$0;
                        var6_6 = this.$paymentFlowResult;
                        var7_7 = false;
                        var8_8 = Result.Companion;
                        var9_11 = var4_4 /* !! */ ;
                        $i$a$-runCatching-PaymentSheetViewModel$onPaymentFlowResult$1$result$1 = false;
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)PaymentSheetViewModel.access$getWorkContext(var5_5), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PaymentIntentResult>, Object>(var5_5, (PaymentFlowResult.Unvalidated)var6_6, null){
                            int label;
                            final /* synthetic */ PaymentSheetViewModel this$0;
                            final /* synthetic */ PaymentFlowResult.Unvalidated $paymentFlowResult;
                            {
                                this.this$0 = $receiver;
                                this.$paymentFlowResult = $paymentFlowResult;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = PaymentSheetViewModel.access$getPaymentFlowResultProcessor$p(this.this$0).processPaymentIntent(this.$paymentFlowResult, (Continuation<? super PaymentIntentResult>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super PaymentIntentResult> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        ** if (v0 != var17_2) goto lbl18
lbl17:
                        // 1 sources

                        return var17_2;
lbl18:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$a$-runCatching-PaymentSheetViewModel$onPaymentFlowResult$1$result$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var9_11 = (PaymentIntentResult)v0;
                            $i$a$-runCatching-PaymentSheetViewModel$onPaymentFlowResult$1$result$1 = false;
                            var8_8 = Result.constructor-impl((Object)var9_11);
                        }
                        catch (Throwable var9_12) {
                            $i$a$-runCatching-PaymentSheetViewModel$onPaymentFlowResult$1$result$1 = Result.Companion;
                            var11_17 = false;
                            var8_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_12));
                        }
                        result = var8_8;
                        var4_4 /* !! */  = result;
                        var5_5 = this.this$0;
                        var6_6 = this.this$0;
                        var7_7 = false;
                        var8_9 = false;
                        var8_10 = Result.exceptionOrNull-impl((Object)var4_4 /* !! */ );
                        if (var8_10 == null) {
                            it = (PaymentIntentResult)var4_4 /* !! */ ;
                            $i$a$-fold-PaymentSheetViewModel$onPaymentFlowResult$1$1 = false;
                            PaymentSheetViewModel.access$onPaymentIntentResult(var5_5, it);
                        } else {
                            error = var8_10;
                            $i$a$-fold-PaymentSheetViewModel$onPaymentFlowResult$1$2 = false;
                            var11_18 /* !! */  = (PaymentSelection)var6_6.getSelection$stripe_release().getValue();
                            if (var11_18 /* !! */  != null) {
                                var12_20 = var11_18 /* !! */ ;
                                var13_21 = false;
                                var14_22 = false;
                                it = var12_20;
                                $i$a$-let-PaymentSheetViewModel$onPaymentFlowResult$1$2$1 = false;
                                PaymentSheetViewModel.access$getEventReporter$p((PaymentSheetViewModel)var6_6).onPaymentFailure(it);
                            }
                            var11_18 /* !! */  = (PaymentIntent)var6_6.getPaymentIntent$stripe_release().getValue();
                            if (var11_18 /* !! */  != null) {
                                var12_20 = var11_18 /* !! */ ;
                                var13_21 = false;
                                var14_22 = false;
                                it = var12_20;
                                $i$a$-let-PaymentSheetViewModel$onPaymentFlowResult$1$2$2 = false;
                                PaymentSheetViewModel.access$resetViewState((PaymentSheetViewModel)var6_6, (PaymentIntent)it, PaymentSheetViewModel.access$apiThrowableToString((PaymentSheetViewModel)var6_6, error));
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onFatal(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.get_fatal().setValue((Object)throwable);
        this._paymentSheetResult.setValue((Object)new PaymentSheetResult.Failed(throwable));
    }

    @Override
    public void onUserCancel() {
        this._paymentSheetResult.setValue((Object)PaymentSheetResult.Canceled.INSTANCE);
    }

    private static final void getButtonStateObservable$lambda-0(PaymentSheetViewModel this$0, CheckoutIdentifier $checkoutIdentifier, MediatorLiveData $outputLiveData, PaymentSheetViewState currentValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$checkoutIdentifier), (String)"$checkoutIdentifier");
        Intrinsics.checkNotNullParameter((Object)$outputLiveData, (String)"$outputLiveData");
        if (this$0.getCheckoutIdentifier$stripe_release() == $checkoutIdentifier) {
            $outputLiveData.setValue((Object)currentValue);
        }
    }

    public static final /* synthetic */ CoroutineContext access$getWorkContext(PaymentSheetViewModel $this) {
        return $this.getWorkContext();
    }

    public static final /* synthetic */ GooglePayRepository access$getGooglePayRepository$p(PaymentSheetViewModel $this) {
        return $this.googlePayRepository;
    }

    public static final /* synthetic */ MutableLiveData access$get_isGooglePayReady(PaymentSheetViewModel $this) {
        return $this.get_isGooglePayReady();
    }

    public static final /* synthetic */ MutableLiveData access$get_paymentMethods(PaymentSheetViewModel $this) {
        return $this.get_paymentMethods();
    }

    public static final /* synthetic */ PaymentMethodsRepository access$getPaymentMethodsRepository$p(PaymentSheetViewModel $this) {
        return $this.paymentMethodsRepository;
    }

    public static final /* synthetic */ StripeIntentRepository access$getStripeIntentRepository$p(PaymentSheetViewModel $this) {
        return $this.stripeIntentRepository;
    }

    public static final /* synthetic */ void access$onPaymentIntentResponse(PaymentSheetViewModel $this, PaymentIntent paymentIntent) {
        $this.onPaymentIntentResponse(paymentIntent);
    }

    public static final /* synthetic */ MutableLiveData access$get_paymentIntent(PaymentSheetViewModel $this) {
        return $this.get_paymentIntent();
    }

    public static final /* synthetic */ void access$processResult(PaymentSheetViewModel $this, PaymentIntentResult stripeIntentResult) {
        $this.processResult(stripeIntentResult);
    }

    public static final /* synthetic */ PaymentFlowResultProcessor access$getPaymentFlowResultProcessor$p(PaymentSheetViewModel $this) {
        return $this.paymentFlowResultProcessor;
    }

    public static final /* synthetic */ void access$onPaymentIntentResult(PaymentSheetViewModel $this, PaymentIntentResult paymentIntentResult) {
        $this.onPaymentIntentResult(paymentIntentResult);
    }

    public static final /* synthetic */ EventReporter access$getEventReporter$p(PaymentSheetViewModel $this) {
        return $this.eventReporter;
    }

    public static final /* synthetic */ void access$resetViewState(PaymentSheetViewModel $this, PaymentIntent paymentIntent, String userErrorMessage) {
        $this.resetViewState(paymentIntent, userErrorMessage);
    }

    public static final /* synthetic */ String access$apiThrowableToString(PaymentSheetViewModel $this, Throwable throwable) {
        return $this.apiThrowableToString(throwable);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget;", "", "()V", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "AddPaymentMethodFull", "AddPaymentMethodSheet", "SelectSavedPaymentMethod", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget$SelectSavedPaymentMethod;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget$AddPaymentMethodFull;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget$AddPaymentMethodSheet;", "stripe_release"})
    public static abstract class TransitionTarget {
        private TransitionTarget() {
        }

        @NotNull
        public abstract FragmentConfig getFragmentConfig();

        public /* synthetic */ TransitionTarget(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget$SelectSavedPaymentMethod;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class SelectSavedPaymentMethod
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;

            public SelectSavedPaymentMethod(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final SelectSavedPaymentMethod copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new SelectSavedPaymentMethod(fragmentConfig);
            }

            public static /* synthetic */ SelectSavedPaymentMethod copy$default(SelectSavedPaymentMethod selectSavedPaymentMethod, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = selectSavedPaymentMethod.getFragmentConfig();
                }
                return selectSavedPaymentMethod.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "SelectSavedPaymentMethod(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SelectSavedPaymentMethod)) {
                    return false;
                }
                SelectSavedPaymentMethod selectSavedPaymentMethod = (SelectSavedPaymentMethod)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)selectSavedPaymentMethod.getFragmentConfig());
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget$AddPaymentMethodFull;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class AddPaymentMethodFull
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;

            public AddPaymentMethodFull(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final AddPaymentMethodFull copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new AddPaymentMethodFull(fragmentConfig);
            }

            public static /* synthetic */ AddPaymentMethodFull copy$default(AddPaymentMethodFull addPaymentMethodFull, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = addPaymentMethodFull.getFragmentConfig();
                }
                return addPaymentMethodFull.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "AddPaymentMethodFull(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddPaymentMethodFull)) {
                    return false;
                }
                AddPaymentMethodFull addPaymentMethodFull = (AddPaymentMethodFull)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)addPaymentMethodFull.getFragmentConfig());
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget$AddPaymentMethodSheet;", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class AddPaymentMethodSheet
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;

            public AddPaymentMethodSheet(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final AddPaymentMethodSheet copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new AddPaymentMethodSheet(fragmentConfig);
            }

            public static /* synthetic */ AddPaymentMethodSheet copy$default(AddPaymentMethodSheet addPaymentMethodSheet, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = addPaymentMethodSheet.getFragmentConfig();
                }
                return addPaymentMethodSheet.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "AddPaymentMethodSheet(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddPaymentMethodSheet)) {
                    return false;
                }
                AddPaymentMethodSheet addPaymentMethodSheet = (AddPaymentMethodSheet)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)addPaymentMethodSheet.getFragmentConfig());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J'\u0010\b\u001a\u0002H\t\"\n\b\u0000\u0010\t*\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "applicationSupplier", "Lkotlin/Function0;", "Landroid/app/Application;", "starterArgsSupplier", "Lcom/stripe/android/paymentsheet/PaymentSheetContract$Args;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Function0<Application> applicationSupplier;
        @NotNull
        private final Function0<PaymentSheetContract.Args> starterArgsSupplier;

        public Factory(@NotNull Function0<? extends Application> applicationSupplier, @NotNull Function0<PaymentSheetContract.Args> starterArgsSupplier) {
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter(starterArgsSupplier, (String)"starterArgsSupplier");
            this.applicationSupplier = applicationSupplier;
            this.starterArgsSupplier = starterArgsSupplier;
        }

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            DefaultPrefsRepository defaultPrefsRepository;
            boolean bl;
            Object object;
            DefaultGooglePayRepository defaultGooglePayRepository;
            PaymentSheet.GooglePayConfiguration googlePayConfiguration;
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Application application = (Application)this.applicationSupplier.invoke();
            PaymentConfiguration config = PaymentConfiguration.Companion.getInstance((Context)application);
            String publishableKey2 = config.getPublishableKey();
            String stripeAccountId = config.getStripeAccountId();
            StripeApiRepository stripeRepository = new StripeApiRepository((Context)application, publishableKey2, null, null, null, null, null, null, null, null, null, null, null, 8188, null);
            PaymentSheetContract.Args starterArgs2 = (PaymentSheetContract.Args)this.starterArgsSupplier.invoke();
            Object object2 = starterArgs2.getConfig();
            PaymentSheet.GooglePayConfiguration googlePayConfiguration2 = googlePayConfiguration = object2 == null ? null : object2.getGooglePay();
            if (googlePayConfiguration == null) {
                defaultGooglePayRepository = null;
            } else {
                object2 = googlePayConfiguration.getEnvironment();
                if (object2 == null) {
                    defaultGooglePayRepository = null;
                } else {
                    object = object2;
                    boolean bl2 = false;
                    bl = false;
                    Object environment = object;
                    boolean bl3 = false;
                    defaultGooglePayRepository = new DefaultGooglePayRepository((Context)application, (PaymentSheet.GooglePayConfiguration.Environment)((Object)environment), null, 4, null);
                }
            }
            DefaultGooglePayRepository defaultGooglePayRepository2 = defaultGooglePayRepository;
            GooglePayRepository googlePayRepository = defaultGooglePayRepository2 == null ? (GooglePayRepository)GooglePayRepository.Disabled.INSTANCE : (GooglePayRepository)defaultGooglePayRepository2;
            object2 = starterArgs2.getConfig();
            if (object2 == null) {
                defaultPrefsRepository = null;
            } else {
                object = object2.getCustomer();
                if (object == null) {
                    defaultPrefsRepository = null;
                } else {
                    Object object3 = object;
                    bl = false;
                    boolean bl4 = false;
                    Object $dstr$id = object3;
                    boolean bl5 = false;
                    String id2 = ((PaymentSheet.CustomerConfiguration)$dstr$id).component1();
                    defaultPrefsRepository = new DefaultPrefsRepository((Context)application, id2, (Function1<? super Continuation<? super Boolean>, ? extends Object>)((Function1)new Function1<Continuation<? super Boolean>, Object>(googlePayRepository, null){
                        int label;
                        final /* synthetic */ GooglePayRepository $googlePayRepository;
                        {
                            this.$googlePayRepository = $googlePayRepository;
                            super(1, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = FlowKt.first(this.$googlePayRepository.isReady(), (Continuation)((Continuation)this));
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@Nullable Continuation<? super Boolean> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (CoroutineContext)Dispatchers.INSTANCE.getIO());
                }
            }
            googlePayConfiguration = defaultPrefsRepository;
            PrefsRepository prefsRepository2 = googlePayConfiguration == null ? (PrefsRepository)new PrefsRepository.Noop() : (PrefsRepository)((Object)googlePayConfiguration);
            StripeIntentRepository.Api stripeIntentRepository = new StripeIntentRepository.Api(stripeRepository, new ApiRequest.Options(publishableKey2, stripeAccountId, null, 4, null), (CoroutineContext)Dispatchers.INSTANCE.getIO());
            PaymentMethodsApiRepository paymentMethodsRepository = new PaymentMethodsApiRepository(stripeRepository, publishableKey2, stripeAccountId, false, (CoroutineContext)Dispatchers.INSTANCE.getIO(), 8, null);
            return (T)((ViewModel)new PaymentSheetViewModel(stripeIntentRepository, paymentMethodsRepository, new DefaultPaymentFlowResultProcessor((Context)application, publishableKey2, stripeRepository, true, (CoroutineContext)Dispatchers.INSTANCE.getIO()), googlePayRepository, prefsRepository2, new DefaultEventReporter(EventReporter.Mode.Complete, starterArgs2.getSessionId(), (Context)application, null, 8, null), starterArgs2, DefaultReturnUrl.Companion.create((Context)application), Logger.Companion.noop$stripe_release(), (CoroutineContext)Dispatchers.INSTANCE.getIO(), application));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$Amount;", "", "value", "", "currencyCode", "", "(JLjava/lang/String;)V", "getCurrencyCode", "()Ljava/lang/String;", "getValue", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "stripe_release"})
    public static final class Amount {
        private final long value;
        @NotNull
        private final String currencyCode;

        public Amount(long value, @NotNull String currencyCode) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            this.value = value;
            this.currencyCode = currencyCode;
        }

        public final long getValue() {
            return this.value;
        }

        @NotNull
        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final long component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.currencyCode;
        }

        @NotNull
        public final Amount copy(long value, @NotNull String currencyCode) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            return new Amount(value, currencyCode);
        }

        public static /* synthetic */ Amount copy$default(Amount amount, long l, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                l = amount.value;
            }
            if ((n & 2) != 0) {
                string2 = amount.currencyCode;
            }
            return amount.copy(l, string2);
        }

        @NotNull
        public String toString() {
            return "Amount(value=" + this.value + ", currencyCode=" + this.currencyCode + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.value);
            result2 = result2 * 31 + this.currencyCode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Amount)) {
                return false;
            }
            Amount amount = (Amount)other;
            if (this.value != amount.value) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currencyCode, (Object)amount.currencyCode);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$CheckoutIdentifier;", "", "(Ljava/lang/String;I)V", "AddFragmentTopGooglePay", "SheetBottomGooglePay", "SheetBottomBuy", "None", "stripe_release"})
    public static final class CheckoutIdentifier
    extends Enum<CheckoutIdentifier> {
        public static final /* enum */ CheckoutIdentifier AddFragmentTopGooglePay = new CheckoutIdentifier();
        public static final /* enum */ CheckoutIdentifier SheetBottomGooglePay = new CheckoutIdentifier();
        public static final /* enum */ CheckoutIdentifier SheetBottomBuy = new CheckoutIdentifier();
        public static final /* enum */ CheckoutIdentifier None = new CheckoutIdentifier();
        private static final /* synthetic */ CheckoutIdentifier[] $VALUES;

        public static CheckoutIdentifier[] values() {
            CheckoutIdentifier[] checkoutIdentifierArray = $VALUES;
            return Arrays.copyOf(checkoutIdentifierArray, checkoutIdentifierArray.length);
        }

        public static CheckoutIdentifier valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(CheckoutIdentifier.class, value);
        }

        static {
            $VALUES = checkoutIdentifierArray = new CheckoutIdentifier[]{CheckoutIdentifier.AddFragmentTopGooglePay, CheckoutIdentifier.SheetBottomGooglePay, CheckoutIdentifier.SheetBottomBuy, CheckoutIdentifier.None};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentSheet.GooglePayConfiguration.Environment.values().length];
            nArray[PaymentSheet.GooglePayConfiguration.Environment.Production.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

