/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.Logger;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.networking.AnalyticsRequest;
import com.stripe.android.networking.ConnectionFactory;
import com.stripe.android.networking.StripeConnection;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "", "executeAsync", "", "request", "Lcom/stripe/android/networking/AnalyticsRequest;", "Default", "stripe_release"})
public interface AnalyticsRequestExecutor {
    public void executeAsync(@NotNull AnalyticsRequest var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/networking/AnalyticsRequestExecutor$Default;", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "logger", "Lcom/stripe/android/Logger;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/stripe/android/Logger;Lkotlin/coroutines/CoroutineContext;)V", "connectionFactory", "Lcom/stripe/android/networking/ConnectionFactory$Default;", "execute", "", "request", "Lcom/stripe/android/networking/AnalyticsRequest;", "execute$stripe_release", "executeAsync", "", "stripe_release"})
    public static final class Default
    implements AnalyticsRequestExecutor {
        @NotNull
        private final Logger logger;
        @NotNull
        private final CoroutineContext workContext;
        @NotNull
        private final ConnectionFactory.Default connectionFactory;

        public Default(@NotNull Logger logger2, @NotNull CoroutineContext workContext) {
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
            this.logger = logger2;
            this.workContext = workContext;
            this.connectionFactory = new ConnectionFactory.Default();
        }

        public /* synthetic */ Default(Logger logger2, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                logger2 = Logger.Companion.noop$stripe_release();
            }
            if ((n & 2) != 0) {
                coroutineContext = (CoroutineContext)Dispatchers.INSTANCE.getIO();
            }
            this(logger2, coroutineContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public final int execute$stripe_release(@NotNull AnalyticsRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Closeable closeable = this.connectionFactory.create(request);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                StripeConnection it = (StripeConnection)closeable;
                boolean bl3 = false;
                try {
                    int n = it.getResponseCode();
                    return n;
                }
                catch (IOException e) {
                    try {
                        throw APIConnectionException.Companion.create$stripe_release(e, request.getBaseUrl());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Override
        public void executeAsync(@NotNull AnalyticsRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.logger.info(Intrinsics.stringPlus((String)"Event: ", request.getParams().get("event")));
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Default this$0;
                final /* synthetic */ AnalyticsRequest $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            boolean bl;
                            Object object3;
                            CoroutineScope $this$launch;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = $this$launch = (CoroutineScope)this.L$0;
                            Default default_ = this.this$0;
                            AnalyticsRequest analyticsRequest = this.$request;
                            boolean bl2 = false;
                            try {
                                object3 = Result.Companion;
                                Object object4 = coroutineScope;
                                boolean bl3 = false;
                                object4 = Boxing.boxInt((int)default_.execute$stripe_release(analyticsRequest));
                                boolean bl4 = false;
                                object3 = Result.constructor-impl((Object)object4);
                            }
                            catch (Throwable throwable) {
                                Result.Companion companion = Result.Companion;
                                bl = false;
                                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            coroutineScope = object3;
                            default_ = this.this$0;
                            boolean bl5 = false;
                            bl2 = false;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)coroutineScope);
                            if (throwable != null) {
                                Throwable throwable2 = throwable;
                                boolean bl6 = false;
                                boolean bl7 = false;
                                Throwable throwable3 = throwable2;
                                bl = false;
                                Throwable it = throwable3;
                                boolean bl8 = false;
                                Default.access$getLogger$p(default_).error("Exception while making analytics request", it);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public Default() {
            this(null, null, 3, null);
        }

        public static final /* synthetic */ Logger access$getLogger$p(Default $this) {
            return $this.logger;
        }
    }
}

