/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.widget.ImageViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.databinding.BankItemBinding;
import com.stripe.android.model.BankStatuses;
import com.stripe.android.view.Bank;
import com.stripe.android.view.ThemeConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0016J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\nJ\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\nH\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\nH\u0016J\u0015\u0010*\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b+R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/stripe/android/view/AddPaymentMethodListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "items", "", "Lcom/stripe/android/view/Bank;", "itemSelectedCallback", "Lkotlin/Function1;", "", "", "(Lcom/stripe/android/view/ThemeConfig;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "bankStatuses", "Lcom/stripe/android/model/BankStatuses;", "getBankStatuses$stripe_release", "()Lcom/stripe/android/model/BankStatuses;", "setBankStatuses$stripe_release", "(Lcom/stripe/android/model/BankStatuses;)V", "getItemSelectedCallback", "()Lkotlin/jvm/functions/Function1;", "getItems", "()Ljava/util/List;", "value", "selectedPosition", "getSelectedPosition", "()I", "setSelectedPosition", "(I)V", "getThemeConfig", "()Lcom/stripe/android/view/ThemeConfig;", "getItemCount", "getItemId", "", "position", "notifyAdapterItemChanged", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateSelected", "updateSelected$stripe_release", "BankViewHolder", "stripe_release"})
public final class AddPaymentMethodListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @Nullable
    private BankStatuses bankStatuses;
    private int selectedPosition;
    @NotNull
    private final ThemeConfig themeConfig;
    @NotNull
    private final List<Bank> items;
    @NotNull
    private final Function1<Integer, Unit> itemSelectedCallback;

    @Nullable
    public final BankStatuses getBankStatuses$stripe_release() {
        return this.bankStatuses;
    }

    public final void setBankStatuses$stripe_release(@Nullable BankStatuses bankStatuses) {
        this.bankStatuses = bankStatuses;
    }

    public final int getSelectedPosition() {
        return this.selectedPosition;
    }

    public final void setSelectedPosition(int value) {
        if (value != this.selectedPosition) {
            if (this.selectedPosition != -1) {
                this.notifyItemChanged(this.selectedPosition);
            }
            this.notifyItemChanged(value);
            this.itemSelectedCallback.invoke((Object)value);
        }
        this.selectedPosition = value;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BankItemBinding bankItemBinding = BankItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)bankItemBinding, (String)"BankItemBinding.inflate(\u2026      false\n            )");
        return new BankViewHolder(bankItemBinding, this.themeConfig);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Bank item = this.items.get(position);
        holder.itemView.setOnClickListener(new View.OnClickListener(this, holder){
            final /* synthetic */ AddPaymentMethodListAdapter this$0;
            final /* synthetic */ RecyclerView.ViewHolder $holder;

            public final void onClick(View it) {
                this.this$0.setSelectedPosition(this.$holder.getBindingAdapterPosition());
            }
            {
                this.this$0 = addPaymentMethodListAdapter;
                this.$holder = viewHolder;
            }
        });
        BankViewHolder bankViewHolder = (BankViewHolder)holder;
        bankViewHolder.setSelected$stripe_release(position == this.selectedPosition);
        BankStatuses bankStatuses = this.bankStatuses;
        bankViewHolder.update(item, bankStatuses != null ? bankStatuses.isOnline$stripe_release(item) : true);
    }

    public final void updateSelected$stripe_release(int position) {
        this.setSelectedPosition(position);
        this.notifyItemChanged(position);
    }

    public final void notifyAdapterItemChanged(int position) {
        this.notifyItemChanged(position);
    }

    @NotNull
    public final ThemeConfig getThemeConfig() {
        return this.themeConfig;
    }

    @NotNull
    public final List<Bank> getItems() {
        return this.items;
    }

    @NotNull
    public final Function1<Integer, Unit> getItemSelectedCallback() {
        return this.itemSelectedCallback;
    }

    public AddPaymentMethodListAdapter(@NotNull ThemeConfig themeConfig, @NotNull List<? extends Bank> items, @NotNull Function1<? super Integer, Unit> itemSelectedCallback) {
        Intrinsics.checkNotNullParameter((Object)themeConfig, (String)"themeConfig");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(itemSelectedCallback, (String)"itemSelectedCallback");
        this.themeConfig = themeConfig;
        this.items = items;
        this.itemSelectedCallback = itemSelectedCallback;
        this.selectedPosition = -1;
        this.setHasStableIds(true);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/view/AddPaymentMethodListAdapter$BankViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "viewBinding", "Lcom/stripe/android/databinding/BankItemBinding;", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "(Lcom/stripe/android/databinding/BankItemBinding;Lcom/stripe/android/view/ThemeConfig;)V", "resources", "Landroid/content/res/Resources;", "setSelected", "", "isSelected", "", "setSelected$stripe_release", "update", "bank", "Lcom/stripe/android/view/Bank;", "isOnline", "stripe_release"})
    public static final class BankViewHolder
    extends RecyclerView.ViewHolder {
        private final Resources resources;
        private final BankItemBinding viewBinding;
        private final ThemeConfig themeConfig;

        public final void update(@NotNull Bank bank, boolean isOnline) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)bank, (String)"bank");
                AppCompatTextView appCompatTextView = this.viewBinding.name;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"viewBinding.name");
                appCompatTextView.setText(isOnline ? (CharSequence)bank.getDisplayName() : (CharSequence)this.resources.getString(R.string.fpx_bank_offline, new Object[]{bank.getDisplayName()}));
                Integer n = bank.getBrandIconResId();
                if (n == null) break block0;
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                this.viewBinding.icon.setImageResource(it);
            }
        }

        public final void setSelected$stripe_release(boolean isSelected) {
            this.viewBinding.name.setTextColor(this.themeConfig.getTextColor$stripe_release(isSelected));
            ImageViewCompat.setImageTintList((ImageView)((ImageView)this.viewBinding.checkIcon), (ColorStateList)ColorStateList.valueOf((int)this.themeConfig.getTintColor$stripe_release(isSelected)));
            AppCompatImageView appCompatImageView = this.viewBinding.checkIcon;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"viewBinding.checkIcon");
            View $this$isVisible$iv = (View)appCompatImageView;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(isSelected ? 0 : 8);
        }

        public BankViewHolder(@NotNull BankItemBinding viewBinding2, @NotNull ThemeConfig themeConfig) {
            Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
            Intrinsics.checkNotNullParameter((Object)themeConfig, (String)"themeConfig");
            super((View)viewBinding2.getRoot());
            this.viewBinding = viewBinding2;
            this.themeConfig = themeConfig;
            View view = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            Resources resources = view.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"itemView.resources");
            this.resources = resources;
        }
    }
}

