/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0004H\u0007J\u001a\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/DateUtils;", "", "()V", "MAX_VALID_YEAR", "", "convertTwoDigitYearToFour", "inputYear", "calendar", "Ljava/util/Calendar;", "isExpiryDataValid", "", "expiryMonth", "expiryYear", "stripe_release"})
public final class DateUtils {
    private static final int MAX_VALID_YEAR = 9980;
    @NotNull
    public static final DateUtils INSTANCE;

    @JvmStatic
    public static final boolean isExpiryDataValid(int expiryMonth, int expiryYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        return DateUtils.isExpiryDataValid(expiryMonth, expiryYear, calendar);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean isExpiryDataValid(int expiryMonth, int expiryYear, @NotNull Calendar calendar) {
        int readableMonth;
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        int n = expiryMonth;
        if (1 > n || 12 < n) {
            return false;
        }
        n = expiryYear;
        if (0 > n || 9980 < n) {
            return false;
        }
        int currentYear = calendar.get(1);
        return expiryYear < currentYear ? false : (expiryYear > currentYear ? true : expiryMonth >= (readableMonth = calendar.get(2) + 1));
    }

    @IntRange(from=1000L, to=9999L)
    public final int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        return this.convertTwoDigitYearToFour(inputYear, calendar);
    }

    @VisibleForTesting
    @IntRange(from=1000L, to=9999L)
    public final int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear, @NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        int year = calendar.get(1);
        int centuryBase = year / 100;
        if (year % 100 > 80 && inputYear < 20) {
            ++centuryBase;
        } else if (year % 100 < 20 && inputYear > 80) {
            --centuryBase;
        }
        return centuryBase * 100 + inputYear;
    }

    private DateUtils() {
    }

    static {
        DateUtils dateUtils;
        INSTANCE = dateUtils = new DateUtils();
    }
}

