/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import com.stripe.android.model.CountryCode;
import com.stripe.android.model.CountryCodeKt;
import com.stripe.android.view.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\fJ!\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/CountryUtils;", "", "()V", "NO_POSTAL_CODE_COUNTRIES", "", "", "getNO_POSTAL_CODE_COUNTRIES$stripe_release", "()Ljava/util/Set;", "doesCountryUsePostalCode", "", "countryCode", "Lcom/stripe/android/model/CountryCode;", "doesCountryUsePostalCode$stripe_release", "getCountryByCode", "Lcom/stripe/android/view/Country;", "currentLocale", "Ljava/util/Locale;", "getCountryByCode$stripe_release", "getCountryCodeByName", "countryName", "getCountryCodeByName$stripe_release", "getDisplayCountry", "getOrderedCountries", "", "getOrderedCountries$stripe_release", "localizedCountries", "stripe_release"})
public final class CountryUtils {
    @NotNull
    private static final Set<String> NO_POSTAL_CODE_COUNTRIES;
    @NotNull
    public static final CountryUtils INSTANCE;

    @NotNull
    public final Set<String> getNO_POSTAL_CODE_COUNTRIES$stripe_release() {
        return NO_POSTAL_CODE_COUNTRIES;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> localizedCountries(Locale currentLocale) {
        void $this$mapTo$iv$iv;
        String[] stringArray = Locale.getISOCountries();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"Locale.getISOCountries()");
        String[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        String[] stringArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void code;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = code;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"code");
            CountryCode countryCode = CountryCode.Companion.create((String)v1);
            String string2 = new Locale("", (String)code).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale(\"\", code).getDisplayCountry(currentLocale)");
            Country country = new Country(countryCode, string2);
            collection.add(country);
        }
        return (List)destination$iv$iv;
    }

    public final /* synthetic */ String getDisplayCountry(CountryCode countryCode, Locale currentLocale) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Object object = this.getCountryByCode$stripe_release(countryCode, currentLocale);
        if (object == null || (object = ((Country)object).getName()) == null) {
            String string2 = new Locale("", countryCode.getValue()).getDisplayCountry(currentLocale);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale(\"\", countryCode.v\u2026layCountry(currentLocale)");
        }
        return object;
    }

    public final /* synthetic */ CountryCode getCountryCodeByName$stripe_release(String countryName, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)countryName, (String)"countryName");
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.localizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)countryName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Country country = v0;
        return country != null ? country.getCode() : null;
    }

    public final /* synthetic */ Country getCountryByCode$stripe_release(CountryCode countryCode, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.localizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCode(), (Object)countryCode)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ List<Country> getOrderedCountries$stripe_release(Locale currentLocale) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Iterable $this$sortedBy$iv = this.localizedCountries(currentLocale);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Country it = (Country)a;
                boolean bl2 = false;
                String string2 = it.getName();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                boolean bl3 = false;
                String string3 = string2;
                boolean bl4 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                it = (Country)b;
                Comparable comparable = (Comparable)((Object)string5);
                bl2 = false;
                string2 = it.getName();
                Locale locale3 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.ROOT");
                locale2 = locale3;
                bl3 = false;
                string3 = string2;
                bl4 = false;
                String string6 = string3;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
                String string8 = string7;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string8)));
            }
        });
        Collection collection = CollectionsKt.listOfNotNull((Object)this.getCountryByCode$stripe_release(CountryCodeKt.getCountryCode(currentLocale), currentLocale));
        boolean $i$f$filterNot = false;
        void var4_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Country it = (Country)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @Deprecated(message="Use with parameter CountryCode", replaceWith=@ReplaceWith(imports={"com.stripe.android.model.CountryCode"}, expression="CountryUtils.doesCountryUsePostalCode(CountryCode.create(countryCode))"))
    public final /* synthetic */ boolean doesCountryUsePostalCode$stripe_release(String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        String string2 = countryCode;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        return !NO_POSTAL_CODE_COUNTRIES.contains(string4);
    }

    public final /* synthetic */ boolean doesCountryUsePostalCode$stripe_release(CountryCode countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        return !NO_POSTAL_CODE_COUNTRIES.contains(countryCode.getValue());
    }

    private CountryUtils() {
    }

    static {
        CountryUtils countryUtils;
        INSTANCE = countryUtils = new CountryUtils();
        NO_POSTAL_CODE_COUNTRIES = SetsKt.setOf((Object[])new String[]{"AE", "AG", "AN", "AO", "AW", "BF", "BI", "BJ", "BO", "BS", "BW", "BZ", "CD", "CF", "CG", "CI", "CK", "CM", "DJ", "DM", "ER", "FJ", "GD", "GH", "GM", "GN", "GQ", "GY", "HK", "IE", "JM", "KE", "KI", "KM", "KN", "KP", "LC", "ML", "MO", "MR", "MS", "MU", "MW", "NR", "NU", "PA", "QA", "RW", "SB", "SC", "SL", "SO", "SR", "ST", "SY", "TF", "TK", "TL", "TO", "TT", "TV", "TZ", "UG", "VU", "YE", "ZA", "ZW"});
    }
}

