/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.content.Context;
import com.stripe.android.R;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/payments/PaymentFlowFailureMessageFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "create", "", "intent", "Lcom/stripe/android/model/StripeIntent;", "outcome", "", "createForPaymentIntent", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "createForSetupIntent", "setupIntent", "Lcom/stripe/android/model/SetupIntent;", "stripe_release"})
public final class PaymentFlowFailureMessageFactory {
    private final Context context;

    @Nullable
    public final String create(@NotNull StripeIntent intent, int outcome) {
        StripeIntent stripeIntent;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.getStatus() == StripeIntent.Status.RequiresPaymentMethod ? ((stripeIntent = intent) instanceof PaymentIntent ? this.createForPaymentIntent((PaymentIntent)intent) : (stripeIntent instanceof SetupIntent ? this.createForSetupIntent((SetupIntent)intent) : null)) : (outcome == 4 ? this.context.getResources().getString(R.string.stripe_failure_reason_timed_out) : null);
    }

    private final String createForPaymentIntent(PaymentIntent paymentIntent) {
        String string2;
        PaymentIntent.Error error = paymentIntent.getLastPaymentError();
        if (Intrinsics.areEqual((Object)(error != null ? error.getCode() : null), (Object)"payment_intent_authentication_failure")) {
            string2 = this.context.getResources().getString(R.string.stripe_failure_reason_authentication);
        } else {
            PaymentIntent.Error error2 = paymentIntent.getLastPaymentError();
            string2 = (error2 != null ? error2.getType() : null) == PaymentIntent.Error.Type.CardError ? paymentIntent.getLastPaymentError().getMessage() : null;
        }
        return string2;
    }

    private final String createForSetupIntent(SetupIntent setupIntent) {
        String string2;
        SetupIntent.Error error = setupIntent.getLastSetupError();
        if (Intrinsics.areEqual((Object)(error != null ? error.getCode() : null), (Object)"payment_intent_authentication_failure")) {
            string2 = this.context.getResources().getString(R.string.stripe_failure_reason_authentication);
        } else {
            SetupIntent.Error error2 = setupIntent.getLastSetupError();
            string2 = (error2 != null ? error2.getType() : null) == SetupIntent.Error.Type.CardError ? setupIntent.getLastSetupError().getMessage() : null;
        }
        return string2;
    }

    public PaymentFlowFailureMessageFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

