/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import com.stripe.android.R;
import com.stripe.android.model.ExpirationDate;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 92\u00020\u0001:\u00019B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0002J\b\u0010,\u001a\u00020\u000fH\u0002J#\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010/\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0004\b0\u00101J-\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b7J\u0012\u00108\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010!8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006:"}, d2={"Lcom/stripe/android/view/ExpiryDateEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "accessibilityText", "", "getAccessibilityText", "()Ljava/lang/String;", "completionCallback", "Lkotlin/Function0;", "", "getCompletionCallback$stripe_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$stripe_release", "(Lkotlin/jvm/functions/Function0;)V", "dateDigitsLength", "<set-?>", "", "includeSeparatorGaps", "getIncludeSeparatorGaps$stripe_release", "()Z", "setIncludeSeparatorGaps$stripe_release", "(Z)V", "includeSeparatorGaps$delegate", "Lkotlin/properties/ReadWriteProperty;", "isDateValid", "separator", "validDateFields", "Lkotlin/Pair;", "getValidDateFields$annotations", "()V", "getValidDateFields", "()Lkotlin/Pair;", "validatedDate", "Lcom/stripe/android/model/ExpirationDate$Validated;", "getValidatedDate", "()Lcom/stripe/android/model/ExpirationDate$Validated;", "month", "year", "listenForTextChanges", "setText", "expiryMonth", "expiryYear", "setText$stripe_release", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "updateSelectionIndex", "newLength", "editActionStart", "editActionAddition", "maxInputLength", "updateSelectionIndex$stripe_release", "updateSeparatorUi", "Companion", "stripe_release"})
public final class ExpiryDateEditText
extends StripeEditText {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean isDateValid;
    @NotNull
    private final ReadWriteProperty includeSeparatorGaps$delegate;
    private final int dateDigitsLength;
    private String separator;
    @java.lang.Deprecated
    private static final int INVALID_INPUT = -1;
    @java.lang.Deprecated
    private static final String SEPARATOR_WITHOUT_GAPS = "/";
    @java.lang.Deprecated
    private static final String SEPARATOR_WITH_GAPS = " / ";
    @java.lang.Deprecated
    private static final boolean INCLUDE_SEPARATOR_GAPS_DEFAULT = false;
    @NotNull
    private static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ExpiryDateEditText.class, "includeSeparatorGaps", "getIncludeSeparatorGaps$stripe_release()Z", 0))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$stripe_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$stripe_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final boolean isDateValid() {
        return this.isDateValid;
    }

    @Deprecated(message="Use validatedDate")
    public static /* synthetic */ void getValidDateFields$annotations() {
    }

    @Nullable
    public final Pair<Integer, Integer> getValidDateFields() {
        Pair pair;
        ExpirationDate.Validated validated = this.getValidatedDate();
        if (validated != null) {
            ExpirationDate.Validated validated2 = validated;
            boolean bl = false;
            boolean bl2 = false;
            ExpirationDate.Validated it = validated2;
            boolean bl3 = false;
            pair = new Pair((Object)it.getMonth(), (Object)it.getYear());
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public final ExpirationDate.Validated getValidatedDate() {
        ExpirationDate.Validated validated;
        boolean bl = this.isDateValid;
        if (bl) {
            validated = ExpirationDate.Unvalidated.Companion.create(this.getFieldText$stripe_release()).validate();
        } else if (!bl) {
            validated = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return validated;
    }

    @Override
    @NotNull
    protected String getAccessibilityText() {
        String string2 = this.getResources().getString(R.string.acc_label_expiry_date_node, new Object[]{this.getText()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026l_expiry_date_node, text)");
        return string2;
    }

    public final boolean getIncludeSeparatorGaps$stripe_release() {
        return (Boolean)this.includeSeparatorGaps$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setIncludeSeparatorGaps$stripe_release(boolean bl) {
        this.includeSeparatorGaps$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public final void setText$stripe_release(@Nullable Integer expiryMonth, @Nullable Integer expiryYear) {
        if (expiryMonth != null && expiryYear != null) {
            this.setText(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{StringsKt.padStart((String)String.valueOf(expiryMonth), (int)2, (char)'0'), StringsKt.padStart((String)StringsKt.takeLast((String)String.valueOf(expiryYear), (int)2), (int)2, (char)'0')}), (CharSequence)this.separator, null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final void updateSeparatorUi(boolean includeSeparatorGaps) {
        this.separator = includeSeparatorGaps ? SEPARATOR_WITH_GAPS : SEPARATOR_WITHOUT_GAPS;
        Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object)new InputFilter.LengthFilter(this.dateDigitsLength + this.separator.length()));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        InputFilter.LengthFilter[] lengthFilterArray = thisCollection$iv.toArray(new InputFilter.LengthFilter[0]);
        if (lengthFilterArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.setFilters((InputFilter[])lengthFilterArray);
    }

    static /* synthetic */ void updateSeparatorUi$default(ExpiryDateEditText expiryDateEditText, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        expiryDateEditText.updateSeparatorUi(bl);
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new StripeTextWatcher(this){
            private boolean ignoreChanges;
            private int latestChangeStart;
            private int latestInsertionSize;
            private ExpirationDate.Unvalidated expirationDate;
            private Integer newCursorPosition;
            private String formattedDate;
            final /* synthetic */ ExpiryDateEditText this$0;

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                if (this.ignoreChanges) {
                    return;
                }
                this.latestChangeStart = start;
                this.latestInsertionSize = after;
            }

            /*
             * WARNING - void declaration
             */
            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                void $this$filterTo$iv$iv2;
                String inputText;
                if (this.ignoreChanges) {
                    return;
                }
                boolean inErrorState = false;
                CharSequence charSequence = s;
                String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                String $this$filter$iv = inputText = string3;
                int $i$f$filter22 = 0;
                CharSequence charSequence2 = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = 0;
                int n2 = $this$filterTo$iv$iv2.length();
                while (n < n2) {
                    void index$iv$iv;
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterTo$iv$iv2.charAt((int)index$iv$iv);
                    boolean bl2 = false;
                    char c = it;
                    boolean bl3 = false;
                    if (Character.isDigit(c)) {
                        destination$iv$iv.append(element$iv$iv);
                    }
                    ++index$iv$iv;
                }
                String string4 = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"filterTo(StringBuilder(), predicate).toString()");
                String rawNumericInput = string4;
                if (rawNumericInput.length() == 1 && this.latestChangeStart == 0 && this.latestInsertionSize == 1) {
                    char first = rawNumericInput.charAt(0);
                    if (first != '0' && first != '1') {
                        rawNumericInput = '0' + rawNumericInput;
                        $i$f$filter22 = this.latestInsertionSize;
                        this.latestInsertionSize = $i$f$filter22 + 1;
                    }
                } else if (rawNumericInput.length() == 2 && this.latestChangeStart == 2 && this.latestInsertionSize == 0) {
                    String first = rawNumericInput;
                    $i$f$filter22 = 0;
                    int $this$filterTo$iv$iv2 = 1;
                    boolean bl4 = false;
                    String string5 = first;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring($i$f$filter22, $this$filterTo$iv$iv2);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    rawNumericInput = string6;
                }
                ExpirationDate.Unvalidated $i$f$filter22 = ExpirationDate.Unvalidated.Companion.create(rawNumericInput);
                boolean $this$filterTo$iv$iv2 = false;
                boolean bl5 = false;
                ExpirationDate.Unvalidated it = $i$f$filter22;
                boolean bl6 = false;
                this.expirationDate = it;
                ExpirationDate.Unvalidated expirationDate = $i$f$filter22;
                if (!expirationDate.isMonthValid()) {
                    inErrorState = true;
                }
                StringBuilder formattedDateBuilder = new StringBuilder().append(expirationDate.getMonth());
                if (expirationDate.getMonth().length() == 2 && this.latestInsertionSize > 0 && !inErrorState || rawNumericInput.length() > 2) {
                    formattedDateBuilder.append(ExpiryDateEditText.access$getSeparator$p(this.this$0));
                }
                formattedDateBuilder.append(expirationDate.getYear());
                String string7 = formattedDateBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"formattedDateBuilder.toString()");
                String formattedDate = string7;
                this.newCursorPosition = this.this$0.updateSelectionIndex$stripe_release(formattedDate.length(), this.latestChangeStart, this.latestInsertionSize, ExpiryDateEditText.access$getDateDigitsLength$p(this.this$0) + ExpiryDateEditText.access$getSeparator$p(this.this$0).length());
                this.formattedDate = formattedDate;
            }

            public void afterTextChanged(@Nullable Editable s) {
                boolean shouldShowError;
                if (this.ignoreChanges) {
                    return;
                }
                this.ignoreChanges = true;
                if (!this.this$0.isLastKeyDelete() && this.formattedDate != null) {
                    this.this$0.setText(this.formattedDate);
                    Integer n = this.newCursorPosition;
                    if (n != null) {
                        Integer n2 = n;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = ((Number)n2).intValue();
                        boolean bl3 = false;
                        this.this$0.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)this.this$0.getFieldText$stripe_release().length()));
                    }
                }
                this.ignoreChanges = false;
                String month = this.expirationDate.getMonth();
                String year = this.expirationDate.getYear();
                boolean bl = shouldShowError = month.length() == 2 && !this.expirationDate.isMonthValid();
                if (month.length() == 2 && year.length() == 2) {
                    boolean wasComplete = this.this$0.isDateValid();
                    ExpiryDateEditText.access$setDateValid$p(this.this$0, ExpiryDateEditText.access$isDateValid(this.this$0, month, year));
                    boolean bl4 = shouldShowError = !this.this$0.isDateValid();
                    if (!wasComplete && this.this$0.isDateValid()) {
                        this.this$0.getCompletionCallback$stripe_release().invoke();
                    }
                } else {
                    ExpiryDateEditText.access$setDateValid$p(this.this$0, false);
                }
                this.this$0.setErrorMessage(this.this$0.getResources().getString(this.expirationDate.isPartialEntry$stripe_release() ? R.string.incomplete_expiry_date : (!this.expirationDate.isMonthValid() ? R.string.invalid_expiry_month : R.string.invalid_expiry_year)));
                this.this$0.setShouldShowError(shouldShowError && (this.expirationDate.isPartialEntry$stripe_release() || this.expirationDate.isComplete$stripe_release()));
                this.formattedDate = null;
                this.newCursorPosition = null;
            }
            {
                this.this$0 = this$0;
                this.expirationDate = ExpirationDate.Unvalidated.Companion.getEMPTY();
            }
        });
    }

    @VisibleForTesting
    public final int updateSelectionIndex$stripe_release(int newLength, int editActionStart, int editActionAddition, int maxInputLength) {
        int gapsJumped = editActionStart <= 2 && editActionStart + editActionAddition >= 2 ? this.separator.length() : 0;
        boolean isDelete = editActionAddition == 0;
        boolean shouldRemoveSeparator = isDelete && editActionStart == 2 + this.separator.length();
        int n = editActionStart + editActionAddition + gapsJumped;
        boolean bl = false;
        boolean bl2 = false;
        int newPosition = n;
        boolean bl3 = false;
        int newPosition2 = newPosition - (shouldRemoveSeparator && newPosition > 0 ? this.separator.length() : 0);
        bl = false;
        int untruncatedPosition = Math.min(newPosition2, newLength);
        bl = false;
        return Math.min(maxInputLength, untruncatedPosition);
    }

    private final boolean isDateValid(String month, String year) {
        int n;
        int inputMonth;
        boolean bl;
        Object object;
        Object object2;
        boolean bl2;
        String string2;
        int n2;
        if (month.length() != 2) {
            n2 = -1;
        } else {
            Object object3;
            ExpiryDateEditText expiryDateEditText = this;
            boolean bl3 = false;
            try {
                object3 = Result.Companion;
                ExpiryDateEditText $this$runCatching = expiryDateEditText;
                boolean bl4 = false;
                string2 = month;
                bl2 = false;
                object2 = Integer.parseInt(string2);
                bl4 = false;
                object3 = Result.constructor-impl((Object)object2);
            }
            catch (Throwable throwable) {
                Result.Companion bl4 = Result.Companion;
                boolean bl5 = false;
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            expiryDateEditText = object3;
            object = -1;
            bl = false;
            n2 = inputMonth = ((Number)(Result.isFailure-impl((Object)((Object)expiryDateEditText)) ? object : expiryDateEditText)).intValue();
        }
        if (year.length() != 2) {
            n = -1;
        } else {
            object = this;
            bl = false;
            try {
                object2 = Result.Companion;
                ExpiryDateEditText $this$runCatching = object;
                boolean bl6 = false;
                String string3 = year;
                boolean bl7 = false;
                Integer n3 = DateUtils.INSTANCE.convertTwoDigitYearToFour(Integer.parseInt(string3));
                boolean bl8 = false;
                object2 = Result.constructor-impl((Object)n3);
            }
            catch (Throwable throwable) {
                string2 = Result.Companion;
                bl2 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            Integer n4 = -1;
            boolean bl9 = false;
            n = ((Number)(Result.isFailure-impl((Object)object) ? n4 : object)).intValue();
        }
        int inputYear = n;
        return DateUtils.isExpiryDataValid(inputMonth, inputYear);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.completionCallback = completionCallback.1.INSTANCE;
        Delegates delegates = Delegates.INSTANCE;
        Boolean bl = false;
        boolean $i$f$observable = false;
        this.includeSeparatorGaps$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ExpiryDateEditText this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = expiryDateEditText;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                ExpiryDateEditText.access$updateSeparatorUi(this.this$0, (boolean)newValue2);
            }
        };
        this.dateDigitsLength = context.getResources().getInteger(R.integer.stripe_date_digits_length);
        this.separator = SEPARATOR_WITHOUT_GAPS;
        this.setInputType(2);
        ExpiryDateEditText.updateSeparatorUi$default(this, false, 1, null);
        this.listenForTextChanges();
        if (Build.VERSION.SDK_INT >= 26) {
            this.setAutofillHints(new String[]{"creditCardExpirationDate"});
        }
        this.getInternalFocusChangeListeners$stripe_release().add(new View.OnFocusChangeListener(){

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (!hasFocus && !this.isDateValid()) {
                    this.setShouldShowError(true);
                }
            }
        });
        this.setLayoutDirection(0);
    }

    public /* synthetic */ ExpiryDateEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ String access$getSeparator$p(ExpiryDateEditText $this) {
        return $this.separator;
    }

    public static final /* synthetic */ void access$setSeparator$p(ExpiryDateEditText $this, String string2) {
        $this.separator = string2;
    }

    public static final /* synthetic */ int access$getDateDigitsLength$p(ExpiryDateEditText $this) {
        return $this.dateDigitsLength;
    }

    public static final /* synthetic */ boolean access$isDateValid$p(ExpiryDateEditText $this) {
        return $this.isDateValid;
    }

    public static final /* synthetic */ void access$setDateValid$p(ExpiryDateEditText $this, boolean bl) {
        $this.isDateValid = bl;
    }

    public static final /* synthetic */ boolean access$isDateValid(ExpiryDateEditText $this, String month, String year) {
        return $this.isDateValid(month, year);
    }

    public static final /* synthetic */ void access$updateSeparatorUi(ExpiryDateEditText $this, boolean includeSeparatorGaps) {
        $this.updateSeparatorUi(includeSeparatorGaps);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/ExpiryDateEditText$Companion;", "", "()V", "INCLUDE_SEPARATOR_GAPS_DEFAULT", "", "INVALID_INPUT", "", "SEPARATOR_WITHOUT_GAPS", "", "SEPARATOR_WITH_GAPS", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

