/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import com.google.android.material.checkbox.MaterialCheckBox;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.databinding.FragmentPaymentsheetAddCardBinding;
import com.stripe.android.databinding.StripeHorizontalDividerBinding;
import com.stripe.android.databinding.StripeVerticalDividerBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.paymentsheet.BaseAddCardFragment;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.model.FragmentConfig;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.ui.BillingAddressView;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.CardValidCallback;
import com.stripe.android.view.Country;
import com.stripe.android.view.StripeEditText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J&\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\u001eH\u0002J\u001a\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020\u001eH\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u001eH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lcom/stripe/android/paymentsheet/BaseAddCardFragment;", "Landroidx/fragment/app/Fragment;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter;)V", "addCardHeader", "Landroid/widget/TextView;", "addCardViewModel", "Lcom/stripe/android/paymentsheet/BaseAddCardFragment$AddCardViewModel;", "getAddCardViewModel", "()Lcom/stripe/android/paymentsheet/BaseAddCardFragment$AddCardViewModel;", "addCardViewModel$delegate", "Lkotlin/Lazy;", "billingAddressView", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView;", "billingErrors", "cardErrors", "cardMultilineWidget", "Lcom/stripe/android/view/CardMultilineWidget;", "paymentMethodParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "saveCardCheckbox", "Landroid/widget/CheckBox;", "sheetViewModel", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "getSheetViewModel", "()Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "onCardError", "", "field", "Lcom/stripe/android/paymentsheet/BaseAddCardFragment$AddCardViewModel$Field;", "errorMessage", "", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onSaveCardCheckboxChanged", "onViewCreated", "view", "populateFieldsFromNewCard", "setupCardWidget", "setupSaveCardCheckbox", "shouldSaveCard", "", "updateSelection", "AddCardViewModel", "stripe_release"})
public abstract class BaseAddCardFragment
extends Fragment {
    private CardMultilineWidget cardMultilineWidget;
    private BillingAddressView billingAddressView;
    private TextView cardErrors;
    private TextView billingErrors;
    private CheckBox saveCardCheckbox;
    private TextView addCardHeader;
    private final Lazy addCardViewModel$delegate;
    private final EventReporter eventReporter;

    @NotNull
    public abstract BaseSheetViewModel<?> getSheetViewModel();

    private final PaymentMethodCreateParams getPaymentMethodParams() {
        PaymentMethodCreateParams paymentMethodCreateParams;
        CardParams cardParams;
        CardParams cardParams2;
        boolean bl;
        boolean bl2;
        Address address;
        BillingAddressView billingAddressView = this.billingAddressView;
        if (billingAddressView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingAddressView");
        }
        Address address2 = (Address)billingAddressView.getAddress$stripe_release().getValue();
        if (address2 != null) {
            address = address2;
            bl2 = false;
            bl = false;
            Address billingAddress = address;
            boolean bl3 = false;
            CardMultilineWidget cardMultilineWidget = this.cardMultilineWidget;
            if (cardMultilineWidget == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
            }
            CardParams cardParams3 = cardMultilineWidget.getCardParams();
            if (cardParams3 != null) {
                CardParams cardParams4 = cardParams3;
                boolean bl4 = false;
                boolean bl5 = false;
                CardParams cardParams5 = cardParams4;
                boolean bl6 = false;
                cardParams5.setAddress(billingAddress);
                cardParams2 = cardParams4;
            } else {
                cardParams2 = null;
            }
        } else {
            cardParams2 = null;
        }
        CardParams cardParams6 = cardParams = cardParams2;
        if (cardParams6 != null) {
            address = cardParams6;
            bl2 = false;
            bl = false;
            Address it = address;
            boolean bl7 = false;
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.createCard((CardParams)((Object)it));
        } else {
            paymentMethodCreateParams = null;
        }
        return paymentMethodCreateParams;
    }

    private final AddCardViewModel getAddCardViewModel() {
        Lazy lazy = this.addCardViewModel$delegate;
        BaseAddCardFragment baseAddCardFragment = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AddCardViewModel)((Object)lazy.getValue());
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        LayoutInflater themedInflater = inflater.cloneInContext((Context)new ContextThemeWrapper((Context)this.requireActivity(), R.style.StripePaymentSheetAddCardTheme));
        return themedInflater.inflate(R.layout.fragment_paymentsheet_add_card, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Object object;
        FragmentConfig config;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Bundle bundle = this.getArguments();
        FragmentConfig fragmentConfig = config = bundle != null ? (FragmentConfig)bundle.getParcelable("com.stripe.android.paymentsheet.extra_fragment_config") : null;
        if (this.getActivity() == null || config == null) {
            this.getSheetViewModel().onFatal(new IllegalArgumentException("Failed to start add payment option fragment."));
            return;
        }
        FragmentPaymentsheetAddCardBinding fragmentPaymentsheetAddCardBinding = FragmentPaymentsheetAddCardBinding.bind(view);
        Intrinsics.checkNotNullExpressionValue((Object)fragmentPaymentsheetAddCardBinding, (String)"FragmentPaymentsheetAddCardBinding.bind(view)");
        FragmentPaymentsheetAddCardBinding viewBinding2 = fragmentPaymentsheetAddCardBinding;
        CardMultilineWidget cardMultilineWidget = viewBinding2.cardMultilineWidget;
        Intrinsics.checkNotNullExpressionValue((Object)cardMultilineWidget, (String)"viewBinding.cardMultilineWidget");
        this.cardMultilineWidget = cardMultilineWidget;
        BillingAddressView billingAddressView = viewBinding2.billingAddress;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)billingAddressView), (String)"viewBinding.billingAddress");
        this.billingAddressView = billingAddressView;
        TextView textView = viewBinding2.cardErrors;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.cardErrors");
        this.cardErrors = textView;
        TextView textView2 = viewBinding2.billingErrors;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"viewBinding.billingErrors");
        this.billingErrors = textView2;
        MaterialCheckBox materialCheckBox = viewBinding2.saveCardCheckbox;
        Intrinsics.checkNotNullExpressionValue((Object)materialCheckBox, (String)"viewBinding.saveCardCheckbox");
        this.saveCardCheckbox = (CheckBox)materialCheckBox;
        TextView textView3 = viewBinding2.addCardHeader;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"viewBinding.addCardHeader");
        this.addCardHeader = textView3;
        BillingAddressView billingAddressView2 = this.billingAddressView;
        if (billingAddressView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingAddressView");
        }
        if ((object = this.getSheetViewModel().getConfig$stripe_release()) == null || (object = object.getBillingAddressCollection()) == null) {
            object = PaymentSheet.BillingAddressCollectionLevel.Automatic;
        }
        billingAddressView2.setLevel$stripe_release((PaymentSheet.BillingAddressCollectionLevel)((Object)object));
        this.populateFieldsFromNewCard();
        this.setupCardWidget();
        BillingAddressView billingAddressView3 = this.billingAddressView;
        if (billingAddressView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingAddressView");
        }
        billingAddressView3.getAddress$stripe_release().observe(this.getViewLifecycleOwner(), (Observer)new Observer<Address>(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void onChanged(@Nullable Address it) {
                this.this$0.updateSelection();
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
        CardMultilineWidget cardMultilineWidget2 = this.cardMultilineWidget;
        if (cardMultilineWidget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget2.setCardValidCallback(new CardValidCallback(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void onInputChanged(boolean isValid, @NotNull Set<? extends CardValidCallback.Fields> $noName_1) {
                Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                BaseAddCardFragment.access$getAddCardViewModel$p(this.this$0).setCardValid(isValid);
                this.this$0.updateSelection();
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
        CardMultilineWidget cardMultilineWidget3 = this.cardMultilineWidget;
        if (cardMultilineWidget3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget3.setCardInputListener(new CardInputListener(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public void onFocusChange(@NotNull CardInputListener.FocusField focusField) {
                Intrinsics.checkNotNullParameter((Object)((Object)focusField), (String)"focusField");
            }

            public void onCardComplete() {
            }

            public void onExpirationComplete() {
            }

            public void onCvcComplete() {
                BaseAddCardFragment.access$getBillingAddressView$p(this.this$0).focusFirstField();
            }
            {
                this.this$0 = this$0;
            }
        });
        this.getSheetViewModel().getProcessing().observe(this.getViewLifecycleOwner(), (Observer)new Observer<Boolean>(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void onChanged(Boolean isProcessing) {
                BaseAddCardFragment.access$getSaveCardCheckbox$p(this.this$0).setEnabled(isProcessing == false);
                BaseAddCardFragment.access$getCardMultilineWidget$p(this.this$0).setEnabled(isProcessing == false);
                BaseAddCardFragment.access$getBillingAddressView$p(this.this$0).setEnabled(isProcessing == false);
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
        CheckBox checkBox = this.saveCardCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveCardCheckbox");
        }
        this.setupSaveCardCheckbox(checkBox);
        this.eventReporter.onShowNewPaymentOptionForm();
    }

    protected final void updateSelection() {
        PaymentSelection.New.Card validCard;
        PaymentSelection.New.Card card;
        boolean bl;
        boolean bl2;
        PaymentMethodCreateParams paymentMethodCreateParams;
        if (this.getAddCardViewModel().isCardValid()) {
            PaymentMethodCreateParams paymentMethodCreateParams2 = this.getPaymentMethodParams();
            if (paymentMethodCreateParams2 != null) {
                paymentMethodCreateParams = paymentMethodCreateParams2;
                bl2 = false;
                bl = false;
                PaymentMethodCreateParams params = paymentMethodCreateParams;
                boolean bl3 = false;
                CardMultilineWidget cardMultilineWidget = this.cardMultilineWidget;
                if (cardMultilineWidget == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
                }
                card = new PaymentSelection.New.Card(params, cardMultilineWidget.getBrand$stripe_release(), this.shouldSaveCard());
            } else {
                card = null;
            }
        } else {
            card = null;
        }
        PaymentSelection.New.Card card2 = validCard = card;
        if (card2 != null) {
            paymentMethodCreateParams = card2;
            bl2 = false;
            bl = false;
            PaymentMethodCreateParams it = paymentMethodCreateParams;
            boolean bl4 = false;
            this.getSheetViewModel().setNewCard(validCard);
        }
        this.getSheetViewModel().updateSelection(validCard);
    }

    private final void setupCardWidget() {
        StripeEditText[] stripeEditTextArray = new StripeEditText[3];
        CardMultilineWidget cardMultilineWidget = this.cardMultilineWidget;
        if (cardMultilineWidget == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        stripeEditTextArray[0] = cardMultilineWidget.getCardNumberEditText$stripe_release();
        CardMultilineWidget cardMultilineWidget2 = this.cardMultilineWidget;
        if (cardMultilineWidget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        stripeEditTextArray[1] = cardMultilineWidget2.getExpiryDateEditText$stripe_release();
        CardMultilineWidget cardMultilineWidget3 = this.cardMultilineWidget;
        if (cardMultilineWidget3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        stripeEditTextArray[2] = cardMultilineWidget3.getCvcEditText$stripe_release();
        Iterable $this$forEach$iv = SetsKt.setOf((Object[])stripeEditTextArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StripeEditText editText = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            editText.setTextSize(0, this.getResources().getDimension(R.dimen.stripe_paymentsheet_form_textsize));
            editText.setTextColor(ContextCompat.getColor((Context)((Context)this.requireActivity()), (int)R.color.stripe_paymentsheet_textinput_color));
            editText.setBackgroundResource(17170445);
            editText.setErrorColor(ContextCompat.getColor((Context)((Context)this.requireActivity()), (int)R.color.stripe_paymentsheet_form_error));
        }
        CardMultilineWidget cardMultilineWidget4 = this.cardMultilineWidget;
        if (cardMultilineWidget4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget4.getExpiryDateEditText$stripe_release().setIncludeSeparatorGaps$stripe_release(true);
        CardMultilineWidget cardMultilineWidget5 = this.cardMultilineWidget;
        if (cardMultilineWidget5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget5.setExpirationDatePlaceholderRes$stripe_release(null);
        CardMultilineWidget cardMultilineWidget6 = this.cardMultilineWidget;
        if (cardMultilineWidget6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget6.getExpiryTextInputLayout$stripe_release().setHint((CharSequence)this.getString(R.string.stripe_paymentsheet_expiration_date_hint));
        CardMultilineWidget cardMultilineWidget7 = this.cardMultilineWidget;
        if (cardMultilineWidget7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget7.getCardNumberTextInputLayout$stripe_release().setPlaceholderText(null);
        CardMultilineWidget cardMultilineWidget8 = this.cardMultilineWidget;
        if (cardMultilineWidget8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget8.setCvcPlaceholderText$stripe_release("");
        CardMultilineWidget cardMultilineWidget9 = this.cardMultilineWidget;
        if (cardMultilineWidget9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget9.getCvcEditText$stripe_release().setImeOptions(5);
        CardMultilineWidget cardMultilineWidget10 = this.cardMultilineWidget;
        if (cardMultilineWidget10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget10.setBackgroundResource(R.drawable.stripe_paymentsheet_form_states);
        CardMultilineWidget cardMultilineWidget11 = this.cardMultilineWidget;
        if (cardMultilineWidget11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        LinearLayout linearLayout = cardMultilineWidget11.getSecondRowLayout$stripe_release();
        LayoutInflater layoutInflater = this.getLayoutInflater();
        CardMultilineWidget cardMultilineWidget12 = this.cardMultilineWidget;
        if (cardMultilineWidget12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        StripeVerticalDividerBinding stripeVerticalDividerBinding = StripeVerticalDividerBinding.inflate(layoutInflater, (ViewGroup)cardMultilineWidget12.getSecondRowLayout$stripe_release(), false);
        Intrinsics.checkNotNullExpressionValue((Object)stripeVerticalDividerBinding, (String)"StripeVerticalDividerBin\u2026      false\n            )");
        linearLayout.addView(stripeVerticalDividerBinding.getRoot(), 1);
        CardMultilineWidget cardMultilineWidget13 = this.cardMultilineWidget;
        if (cardMultilineWidget13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        LayoutInflater layoutInflater2 = this.getLayoutInflater();
        CardMultilineWidget cardMultilineWidget14 = this.cardMultilineWidget;
        if (cardMultilineWidget14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        StripeHorizontalDividerBinding stripeHorizontalDividerBinding = StripeHorizontalDividerBinding.inflate(layoutInflater2, (ViewGroup)cardMultilineWidget14, false);
        Intrinsics.checkNotNullExpressionValue((Object)stripeHorizontalDividerBinding, (String)"StripeHorizontalDividerB\u2026      false\n            )");
        cardMultilineWidget13.addView(stripeHorizontalDividerBinding.getRoot(), 1);
        int layoutMarginHorizontal = this.getResources().getDimensionPixelSize(R.dimen.stripe_paymentsheet_cardwidget_margin_horizontal);
        int layoutMarginVertical = this.getResources().getDimensionPixelSize(R.dimen.stripe_paymentsheet_cardwidget_margin_vertical);
        Object[] objectArray = new TextInputLayout[3];
        CardMultilineWidget cardMultilineWidget15 = this.cardMultilineWidget;
        if (cardMultilineWidget15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        objectArray[0] = cardMultilineWidget15.getCardNumberTextInputLayout$stripe_release();
        CardMultilineWidget cardMultilineWidget16 = this.cardMultilineWidget;
        if (cardMultilineWidget16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        objectArray[1] = cardMultilineWidget16.getExpiryTextInputLayout$stripe_release();
        CardMultilineWidget cardMultilineWidget17 = this.cardMultilineWidget;
        if (cardMultilineWidget17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        objectArray[2] = cardMultilineWidget17.getCvcInputLayout$stripe_release();
        Iterable $this$forEach$iv2 = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            TextInputLayout layout2 = (TextInputLayout)element$iv;
            boolean bl = false;
            View $this$updateLayoutParams$iv = (View)layout2;
            boolean $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            }
            ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((LinearLayout.LayoutParams)layoutParams);
            LinearLayout.LayoutParams $this$updateLayoutParams = (LinearLayout.LayoutParams)params$iv;
            boolean bl2 = false;
            $this$updateLayoutParams.setMarginStart(layoutMarginHorizontal);
            $this$updateLayoutParams.setMarginEnd(layoutMarginHorizontal);
            $this$updateLayoutParams.topMargin = layoutMarginVertical;
            $this$updateLayoutParams.bottomMargin = layoutMarginVertical;
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
            layout2.setErrorEnabled(false);
            layout2.setError((CharSequence)null);
        }
        CardMultilineWidget cardMultilineWidget18 = this.cardMultilineWidget;
        if (cardMultilineWidget18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget18.setCvcIcon$stripe_release(R.drawable.stripe_ic_paymentsheet_cvc);
        CardMultilineWidget cardMultilineWidget19 = this.cardMultilineWidget;
        if (cardMultilineWidget19 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget19.setCardBrandIconSupplier$stripe_release(setupCardWidget.3.INSTANCE);
        CardMultilineWidget cardMultilineWidget20 = this.cardMultilineWidget;
        if (cardMultilineWidget20 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget20.setCardNumberErrorListener$stripe_release(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void displayErrorMessage(@Nullable String errorMessage) {
                BaseAddCardFragment.access$onCardError(this.this$0, AddCardViewModel.Field.Number, errorMessage);
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
        CardMultilineWidget cardMultilineWidget21 = this.cardMultilineWidget;
        if (cardMultilineWidget21 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget21.setExpirationDateErrorListener$stripe_release(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void displayErrorMessage(@Nullable String errorMessage) {
                BaseAddCardFragment.access$onCardError(this.this$0, AddCardViewModel.Field.Date, errorMessage);
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
        CardMultilineWidget cardMultilineWidget22 = this.cardMultilineWidget;
        if (cardMultilineWidget22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget22.setCvcErrorListener$stripe_release(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void displayErrorMessage(@Nullable String errorMessage) {
                BaseAddCardFragment.access$onCardError(this.this$0, AddCardViewModel.Field.Cvc, errorMessage);
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
        CardMultilineWidget cardMultilineWidget23 = this.cardMultilineWidget;
        if (cardMultilineWidget23 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        cardMultilineWidget23.setPostalCodeErrorListener$stripe_release(null);
        BillingAddressView billingAddressView = this.billingAddressView;
        if (billingAddressView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingAddressView");
        }
        billingAddressView.setPostalCodeViewListener$stripe_release(new BillingAddressView.PostalCodeViewListener(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            /*
             * Unable to fully structure code
             */
            public void onLosingFocus(@Nullable Country country, boolean isPostalValid) {
                if (isPostalValid) ** GOTO lbl-1000
                var4_3 = (CharSequence)BaseAddCardFragment.access$getBillingAddressView$p(this.this$0).getPostalCodeView$stripe_release().getText();
                var5_4 = false;
                var6_7 = false;
                if (!(var4_3 == null || var4_3.length() == 0)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                shouldToggleBillingError = v0;
                BaseAddCardFragment.access$getBillingErrors$p(this.this$0).setText(shouldToggleBillingError != false ? (CharSequence)(country == null || Intrinsics.areEqual((Object)country.getCode(), (Object)"US") != false ? this.this$0.getString(R.string.address_zip_invalid) : this.this$0.getString(R.string.address_postal_code_invalid)) : null);
                var5_5 = BaseAddCardFragment.access$getBillingErrors$p(this.this$0).getText();
                var6_7 = false;
                var7_9 = false;
                var5_6 = (var5_5 == null || var5_5.length() == 0) == false;
                var4_3 = (View)BaseAddCardFragment.access$getBillingErrors$p(this.this$0);
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
            }

            public void onGainingFocus(@Nullable Country country, boolean isPostalValid) {
                boolean bl = false;
                View $this$isVisible$iv = (View)BaseAddCardFragment.access$getBillingErrors$p(this.this$0);
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }

            public void onCountryChanged(@Nullable Country country, boolean isPostalValid) {
                BaseAddCardFragment.access$getBillingErrors$p(this.this$0).setText((CharSequence)null);
                boolean bl = false;
                View $this$isVisible$iv = (View)BaseAddCardFragment.access$getBillingErrors$p(this.this$0);
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void populateFieldsFromNewCard() {
        Parcelable parcelable;
        PaymentSelection.New.Card card = this.getSheetViewModel().getNewCard();
        PaymentMethodCreateParams paymentMethodCreateParams = card != null ? card.getPaymentMethodCreateParams() : null;
        CheckBox checkBox = this.saveCardCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveCardCheckbox");
        }
        PaymentSelection.New.Card card2 = this.getSheetViewModel().getNewCard();
        checkBox.setChecked(card2 != null ? card2.getShouldSavePaymentMethod() : true);
        CardMultilineWidget cardMultilineWidget = this.cardMultilineWidget;
        if (cardMultilineWidget == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        PaymentMethodCreateParams paymentMethodCreateParams2 = paymentMethodCreateParams;
        cardMultilineWidget.populate$stripe_release(paymentMethodCreateParams2 != null ? paymentMethodCreateParams2.getCard$stripe_release() : null);
        BillingAddressView billingAddressView = this.billingAddressView;
        if (billingAddressView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingAddressView");
        }
        billingAddressView.populate$stripe_release((parcelable = paymentMethodCreateParams) != null && (parcelable = parcelable.getBillingDetails$stripe_release()) != null ? ((PaymentMethod.BillingDetails)parcelable).address : null);
    }

    /*
     * WARNING - void declaration
     */
    private final void onCardError(AddCardViewModel.Field field, String errorMessage) {
        void value$iv;
        Object v0;
        boolean $i$f$firstOrNull;
        block4: {
            void $this$firstOrNull$iv;
            int n;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            this.getAddCardViewModel().getCardErrors().put(field, errorMessage);
            AddCardViewModel.Field[] fieldArray = AddCardViewModel.Field.values();
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var9_10 = $this$mapTo$iv$iv;
            int n2 = ((void)var9_10).length;
            for (n = 0; n < n2; ++n) {
                void it;
                void item$iv$iv;
                void var13_17 = item$iv$iv = var9_10[n];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = this.getAddCardViewModel().getCardErrors().get(it);
                collection.add(string2);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                n = 0;
                boolean bl2 = false;
                if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        String error = v0;
        TextView textView = this.cardErrors;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardErrors");
        }
        textView.setText((CharSequence)error);
        TextView textView2 = this.cardErrors;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardErrors");
        }
        $i$f$firstOrNull = error != null;
        View $this$isVisible$iv = (View)textView2;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
    }

    /*
     * Unable to fully structure code
     */
    private final void setupSaveCardCheckbox(CheckBox saveCardCheckbox) {
        v0 = this.getSheetViewModel().getConfig$stripe_release();
        var3_2 = v0 != null ? v0.getMerchantDisplayName() : null;
        var4_3 = false;
        var5_4 = false;
        it = var3_2;
        $i$a$-takeUnless-BaseAddCardFragment$setupSaveCardCheckbox$merchantDisplayName$1 = false;
        var8_7 = it;
        var9_8 = false;
        var10_9 = false;
        merchantDisplayName = (var8_7 == null || StringsKt.isBlank((CharSequence)var8_7) != false) == false ? var3_2 : null;
        v1 = saveCardCheckbox;
        v2 = merchantDisplayName;
        if (v2 == null) ** GOTO lbl-1000
        var3_2 = v2;
        var4_3 = false;
        var5_4 = false;
        it = var3_2;
        var11_11 = v1;
        $i$a$-let-BaseAddCardFragment$setupSaveCardCheckbox$1 = false;
        var12_12 = this.getString(R.string.stripe_paymentsheet_save_this_card_with_merchant_name, new Object[]{it});
        v1 = var11_11;
        v2 = var12_12;
        if (v2 != null) {
            v3 = v2;
        } else lbl-1000:
        // 2 sources

        {
            v3 = this.getString(R.string.stripe_paymentsheet_save_this_card);
        }
        v1.setText(v3);
        var4_3 = this.getSheetViewModel().getCustomerConfig$stripe_release() != null;
        $this$isVisible$iv = (View)saveCardCheckbox;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
        saveCardCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(this){
            final /* synthetic */ BaseAddCardFragment this$0;

            public final void onCheckedChanged(CompoundButton $noName_0, boolean $noName_1) {
                BaseAddCardFragment.access$onSaveCardCheckboxChanged(this.this$0);
            }
            {
                this.this$0 = baseAddCardFragment;
            }
        });
    }

    private final void onSaveCardCheckboxChanged() {
        PaymentSelection selection = (PaymentSelection)this.getSheetViewModel().getSelection$stripe_release().getValue();
        if (selection instanceof PaymentSelection.New.Card) {
            PaymentSelection.New.Card newCardSelection = PaymentSelection.New.Card.copy$default((PaymentSelection.New.Card)selection, null, null, this.shouldSaveCard(), 3, null);
            this.getSheetViewModel().updateSelection(newCardSelection);
            this.getSheetViewModel().setNewCard(newCardSelection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSaveCard() {
        CheckBox checkBox = this.saveCardCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveCardCheckbox");
        }
        if (!checkBox.isShown()) return false;
        CheckBox checkBox2 = this.saveCardCheckbox;
        if (checkBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveCardCheckbox");
        }
        if (!checkBox2.isChecked()) return false;
        return true;
    }

    public BaseAddCardFragment(@NotNull EventReporter eventReporter2) {
        Intrinsics.checkNotNullParameter((Object)eventReporter2, (String)"eventReporter");
        this.eventReporter = eventReporter2;
        BaseAddCardFragment $this$viewModels$iv = this;
        Function0 ownerProducer$iv = (Function0)new Function0<Fragment>((Fragment)$this$viewModels$iv){
            final /* synthetic */ Fragment $this_viewModels;
            {
                this.$this_viewModels = fragment;
                super(0);
            }

            @NotNull
            public final Fragment invoke() {
                return this.$this_viewModels;
            }
        };
        Function0 factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        this.addCardViewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$viewModels$iv, (KClass)Reflection.getOrCreateKotlinClass(AddCardViewModel.class), (Function0)((Function0)new Function0<ViewModelStore>(ownerProducer$iv){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }), (Function0)factoryProducer$iv);
    }

    public static final /* synthetic */ AddCardViewModel access$getAddCardViewModel$p(BaseAddCardFragment $this) {
        return $this.getAddCardViewModel();
    }

    public static final /* synthetic */ BillingAddressView access$getBillingAddressView$p(BaseAddCardFragment $this) {
        BillingAddressView billingAddressView = $this.billingAddressView;
        if (billingAddressView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingAddressView");
        }
        return billingAddressView;
    }

    public static final /* synthetic */ void access$setBillingAddressView$p(BaseAddCardFragment $this, BillingAddressView billingAddressView) {
        $this.billingAddressView = billingAddressView;
    }

    public static final /* synthetic */ CheckBox access$getSaveCardCheckbox$p(BaseAddCardFragment $this) {
        CheckBox checkBox = $this.saveCardCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveCardCheckbox");
        }
        return checkBox;
    }

    public static final /* synthetic */ void access$setSaveCardCheckbox$p(BaseAddCardFragment $this, CheckBox checkBox) {
        $this.saveCardCheckbox = checkBox;
    }

    public static final /* synthetic */ CardMultilineWidget access$getCardMultilineWidget$p(BaseAddCardFragment $this) {
        CardMultilineWidget cardMultilineWidget = $this.cardMultilineWidget;
        if (cardMultilineWidget == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardMultilineWidget");
        }
        return cardMultilineWidget;
    }

    public static final /* synthetic */ void access$setCardMultilineWidget$p(BaseAddCardFragment $this, CardMultilineWidget cardMultilineWidget) {
        $this.cardMultilineWidget = cardMultilineWidget;
    }

    public static final /* synthetic */ void access$onCardError(BaseAddCardFragment $this, AddCardViewModel.Field field, String errorMessage) {
        $this.onCardError(field, errorMessage);
    }

    public static final /* synthetic */ TextView access$getBillingErrors$p(BaseAddCardFragment $this) {
        TextView textView = $this.billingErrors;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"billingErrors");
        }
        return textView;
    }

    public static final /* synthetic */ void access$setBillingErrors$p(BaseAddCardFragment $this, TextView textView) {
        $this.billingErrors = textView;
    }

    public static final /* synthetic */ void access$onSaveCardCheckboxChanged(BaseAddCardFragment $this) {
        $this.onSaveCardCheckboxChanged();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/paymentsheet/BaseAddCardFragment$AddCardViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "cardErrors", "", "Lcom/stripe/android/paymentsheet/BaseAddCardFragment$AddCardViewModel$Field;", "", "getCardErrors", "()Ljava/util/Map;", "isCardValid", "", "()Z", "setCardValid", "(Z)V", "Field", "stripe_release"})
    public static final class AddCardViewModel
    extends ViewModel {
        private boolean isCardValid;
        @NotNull
        private final Map<Field, String> cardErrors;

        public final boolean isCardValid() {
            return this.isCardValid;
        }

        public final void setCardValid(boolean bl) {
            this.isCardValid = bl;
        }

        @NotNull
        public final Map<Field, String> getCardErrors() {
            return this.cardErrors;
        }

        public AddCardViewModel() {
            boolean bl = false;
            this.cardErrors = new LinkedHashMap();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/BaseAddCardFragment$AddCardViewModel$Field;", "", "(Ljava/lang/String;I)V", "Number", "Date", "Cvc", "stripe_release"})
        public static final class Field
        extends Enum<Field> {
            public static final /* enum */ Field Number;
            public static final /* enum */ Field Date;
            public static final /* enum */ Field Cvc;
            private static final /* synthetic */ Field[] $VALUES;

            static {
                Field[] fieldArray = new Field[3];
                Field[] fieldArray2 = fieldArray;
                fieldArray[0] = Number = new Field();
                fieldArray[1] = Date = new Field();
                fieldArray[2] = Cvc = new Field();
                $VALUES = fieldArray;
            }

            public static Field[] values() {
                return (Field[])$VALUES.clone();
            }

            public static Field valueOf(String string2) {
                return Enum.valueOf(Field.class, string2);
            }
        }
    }
}

