/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.Logger;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.ApiRequestExecutor;
import com.stripe.android.networking.ConnectionFactory;
import com.stripe.android.networking.FileUploadRequest;
import com.stripe.android.networking.RetryDelaySupplier;
import com.stripe.android.networking.StripeConnection;
import com.stripe.android.networking.StripeRequest;
import com.stripe.android.networking.StripeResponse;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001:\u0001\tJ\u0019\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/stripe/android/networking/ApiRequestExecutor;", "", "execute", "Lcom/stripe/android/networking/StripeResponse;", "request", "Lcom/stripe/android/networking/ApiRequest;", "(Lcom/stripe/android/networking/ApiRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/stripe/android/networking/FileUploadRequest;", "(Lcom/stripe/android/networking/FileUploadRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Default", "stripe_release"})
public interface ApiRequestExecutor {
    @Nullable
    public Object execute(@NotNull ApiRequest var1, @NotNull Continuation<? super StripeResponse> var2);

    @Nullable
    public Object execute(@NotNull FileUploadRequest var1, @NotNull Continuation<? super StripeResponse> var2);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ#\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/networking/ApiRequestExecutor$Default;", "Lcom/stripe/android/networking/ApiRequestExecutor;", "connectionFactory", "Lcom/stripe/android/networking/ConnectionFactory;", "retryDelaySupplier", "Lcom/stripe/android/networking/RetryDelaySupplier;", "logger", "Lcom/stripe/android/Logger;", "(Lcom/stripe/android/networking/ConnectionFactory;Lcom/stripe/android/networking/RetryDelaySupplier;Lcom/stripe/android/Logger;)V", "execute", "Lcom/stripe/android/networking/StripeResponse;", "request", "Lcom/stripe/android/networking/ApiRequest;", "(Lcom/stripe/android/networking/ApiRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/stripe/android/networking/FileUploadRequest;", "(Lcom/stripe/android/networking/FileUploadRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeInternal", "Lcom/stripe/android/networking/StripeRequest;", "remainingRetries", "", "executeInternal$stripe_release", "(Lcom/stripe/android/networking/StripeRequest;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeRequest", "Companion", "stripe_release"})
    public static final class Default
    implements ApiRequestExecutor {
        private final ConnectionFactory connectionFactory;
        private final RetryDelaySupplier retryDelaySupplier;
        private final Logger logger;
        @Deprecated
        private static final int MAX_RETRIES = 3;
        @NotNull
        private static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public Object execute(@NotNull ApiRequest request, @NotNull Continuation<? super StripeResponse> $completion) {
            return this.executeInternal$stripe_release(request, 3, $completion);
        }

        @Override
        @Nullable
        public Object execute(@NotNull FileUploadRequest request, @NotNull Continuation<? super StripeResponse> $completion) {
            return this.executeInternal$stripe_release(request, 3, $completion);
        }

        /*
         * Unable to fully structure code
         */
        @VisibleForTesting
        @Nullable
        public final Object executeInternal$stripe_release(@NotNull StripeRequest var1_1, int var2_2, @NotNull Continuation<? super StripeResponse> var3_3) {
            block9: {
                if (!(var3_3 instanceof executeInternal.1)) ** GOTO lbl-1000
                var6_4 = var3_3;
                if ((var6_4.label & -2147483648) != 0) {
                    var6_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var3_3){
                        /* synthetic */ Object result;
                        int label;
                        final /* synthetic */ Default this$0;
                        Object L$0;
                        Object L$1;
                        int I$0;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.executeInternal$stripe_release(null, 0, (Continuation<? super StripeResponse>)this);
                        }
                        {
                            this.this$0 = default_;
                            super(continuation);
                        }
                    };
                }
                $result = $continuation.result;
                var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.logger.info("Firing request: " + request);
                        stripeResponse = this.makeRequest(request);
                        if (!stripeResponse.isRateLimited$stripe_release() || remainingRetries <= 0) break;
                        this.logger.info("Request was rate-limited with " + remainingRetries + " remaining retries.");
                        $continuation.L$0 = this;
                        $continuation.L$1 = request;
                        $continuation.I$0 = remainingRetries;
                        $continuation.label = 1;
                        v0 = DelayKt.delay((long)this.retryDelaySupplier.getDelayMillis(3, remainingRetries), (Continuation)$continuation);
                        if (v0 == var7_6) {
                            return var7_6;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        remainingRetries = $continuation.I$0;
                        request = (StripeRequest)$continuation.L$1;
                        this = (Default)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.label = 2;
                        v1 = this.executeInternal$stripe_release(request, remainingRetries - 1, (Continuation<? super StripeResponse>)$continuation);
                        if (v1 == var7_6) {
                            return var7_6;
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl40:
                        // 2 sources

                        v2 = (StripeResponse)v1;
                        break block9;
                    }
                }
                v2 = stripeResponse;
            }
            return v2;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final StripeResponse makeRequest(StripeRequest request) {
            StripeResponse stripeResponse;
            Closeable closeable = this.connectionFactory.create(request);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object object;
                StripeConnection it = (StripeConnection)closeable;
                boolean bl3 = false;
                Default default_ = this;
                boolean bl4 = false;
                try {
                    object = Result.Companion;
                    Object $this$runCatching = default_;
                    boolean bl5 = false;
                    StripeResponse stripeResponse2 = it.getResponse();
                    ((Default)$this$runCatching).logger.info(stripeResponse2.toString());
                    $this$runCatching = stripeResponse2;
                    bl5 = false;
                    object = Result.constructor-impl((Object)$this$runCatching);
                }
                catch (Throwable $this$runCatching) {
                    Result.Companion bl5 = Result.Companion;
                    boolean bl6 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                }
                default_ = object;
                bl4 = false;
                boolean bl7 = false;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)default_);
                if (throwable2 != null) {
                    Throwable error = throwable2;
                    boolean bl8 = false;
                    this.logger.error("Exception while making Stripe API request", error);
                    Throwable throwable3 = error;
                    throw throwable3 instanceof IOException ? (Throwable)APIConnectionException.Companion.create$stripe_release((IOException)error, request.getBaseUrl()) : error;
                }
                stripeResponse = (StripeResponse)((Object)default_);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return stripeResponse;
        }

        public Default(@NotNull ConnectionFactory connectionFactory, @NotNull RetryDelaySupplier retryDelaySupplier, @NotNull Logger logger2) {
            Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
            Intrinsics.checkNotNullParameter((Object)retryDelaySupplier, (String)"retryDelaySupplier");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            this.connectionFactory = connectionFactory;
            this.retryDelaySupplier = retryDelaySupplier;
            this.logger = logger2;
        }

        public /* synthetic */ Default(ConnectionFactory connectionFactory, RetryDelaySupplier retryDelaySupplier, Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                connectionFactory = new ConnectionFactory.Default();
            }
            if ((n & 2) != 0) {
                retryDelaySupplier = new RetryDelaySupplier(0L, 1, null);
            }
            if ((n & 4) != 0) {
                logger2 = Logger.Companion.noop$stripe_release();
            }
            this(connectionFactory, retryDelaySupplier, logger2);
        }

        public Default() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/ApiRequestExecutor$Default$Companion;", "", "()V", "MAX_RETRIES", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

