/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import com.stripe.android.AnalyticsEvent;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.cards.DefaultStaticCardAccountRanges;
import com.stripe.android.cards.StaticCardAccountRanges;
import com.stripe.android.model.AccountRange;
import com.stripe.android.model.BinRange;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.StripeModel;
import com.stripe.android.networking.AnalyticsDataFactory;
import com.stripe.android.networking.AnalyticsRequest;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardNumberEditText$CardNumberTextWatcher$WhenMappings;
import com.stripe.android.view.CardNumberEditText$onAttachedToWindow$1$invokeSuspend$;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u00002\u00020\u0001:\u0001qB%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB7\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eBW\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J/\u0010^\u001a\u00020\u00072\u0006\u0010_\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u00072\u0006\u0010a\u001a\u00020\u00072\b\b\u0002\u0010P\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bbJ\b\u0010c\u001a\u00020-H\u0002J\u0017\u0010d\u001a\u00020-2\b\u0010e\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\bfJ\b\u0010g\u001a\u00020-H\u0014J\r\u0010h\u001a\u00020-H\u0000\u00a2\u0006\u0002\biJ\b\u0010j\u001a\u00020-H\u0014J\u0015\u0010k\u001a\u00020-2\u0006\u00109\u001a\u00020SH\u0000\u00a2\u0006\u0002\blJ\u0010\u0010m\u001a\u00020E2\u0006\u00109\u001a\u00020SH\u0002J\u0017\u0010n\u001a\u00020-2\b\b\u0002\u0010o\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bpR\u0016\u0010\u001a\u001a\u0004\u0018\u00010\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b \u0010!R&\u0010\"\u001a\u0004\u0018\u00010#8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010.\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u00103\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020,8\u0006@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b4\u0010%\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u00010\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010%\u001a\u0004\b;\u0010\u001cR \u0010<\u001a\b\u0012\u0004\u0012\u00020-0\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u001e\u0010F\u001a\u00020E2\u0006\u0010D\u001a\u00020E@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR&\u0010H\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020-0+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u00100\"\u0004\bJ\u00102R\u0014\u0010K\u001a\u00020E8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010GR\u001a\u0010L\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bM\u0010%\u001a\u0004\bN\u0010CR\u0010\u0010O\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010P\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010CR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\u00020S8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u0016\u0010V\u001a\u0004\u0018\u00010W8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]\u00a8\u0006r"}, d2={"Lcom/stripe/android/view/CardNumberEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "workContext", "Lkotlin/coroutines/CoroutineContext;", "publishableKeySupplier", "Lkotlin/Function0;", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)V", "cardAccountRangeRepository", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "staticCardAccountRanges", "Lcom/stripe/android/cards/StaticCardAccountRanges;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequest$Factory;", "analyticsDataFactory", "Lcom/stripe/android/networking/AnalyticsDataFactory;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lcom/stripe/android/cards/CardAccountRangeRepository;Lcom/stripe/android/cards/StaticCardAccountRanges;Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequest$Factory;Lcom/stripe/android/networking/AnalyticsDataFactory;)V", "accessibilityText", "getAccessibilityText", "()Ljava/lang/String;", "value", "Lcom/stripe/android/model/AccountRange;", "accountRange", "setAccountRange", "(Lcom/stripe/android/model/AccountRange;)V", "accountRangeRepositoryJob", "Lkotlinx/coroutines/Job;", "getAccountRangeRepositoryJob$stripe_release$annotations", "()V", "getAccountRangeRepositoryJob$stripe_release", "()Lkotlinx/coroutines/Job;", "setAccountRangeRepositoryJob$stripe_release", "(Lkotlinx/coroutines/Job;)V", "callback", "Lkotlin/Function1;", "Lcom/stripe/android/model/CardBrand;", "", "brandChangeCallback", "getBrandChangeCallback$stripe_release", "()Lkotlin/jvm/functions/Function1;", "setBrandChangeCallback$stripe_release", "(Lkotlin/jvm/functions/Function1;)V", "cardBrand", "getCardBrand$annotations", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "setCardBrand$stripe_release", "(Lcom/stripe/android/model/CardBrand;)V", "cardNumber", "getCardNumber$annotations", "getCardNumber", "completionCallback", "getCompletionCallback$stripe_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$stripe_release", "(Lkotlin/jvm/functions/Function0;)V", "formattedPanLength", "getFormattedPanLength", "()I", "<set-?>", "", "isCardNumberValid", "()Z", "isLoadingCallback", "isLoadingCallback$stripe_release", "setLoadingCallback$stripe_release", "isValid", "lengthMax", "getLengthMax$annotations", "getLengthMax", "loadingJob", "panLength", "getPanLength$stripe_release", "unvalidatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "getUnvalidatedCardNumber", "()Lcom/stripe/android/cards/CardNumber$Unvalidated;", "validatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Validated;", "getValidatedCardNumber$stripe_release", "()Lcom/stripe/android/cards/CardNumber$Validated;", "getWorkContext$stripe_release", "()Lkotlin/coroutines/CoroutineContext;", "setWorkContext$stripe_release", "(Lkotlin/coroutines/CoroutineContext;)V", "calculateCursorPosition", "newFormattedLength", "start", "addedDigits", "calculateCursorPosition$stripe_release", "cancelAccountRangeRepositoryJob", "onAccountRangeResult", "newAccountRange", "onAccountRangeResult$stripe_release", "onAttachedToWindow", "onCardMetadataLoadedTooSlow", "onCardMetadataLoadedTooSlow$stripe_release", "onDetachedFromWindow", "queryAccountRangeRepository", "queryAccountRangeRepository$stripe_release", "shouldQueryAccountRange", "updateLengthFilter", "maxLength", "updateLengthFilter$stripe_release", "CardNumberTextWatcher", "stripe_release"})
public final class CardNumberEditText
extends StripeEditText {
    @NotNull
    private CardBrand cardBrand;
    private /* synthetic */ Function1<? super CardBrand, Unit> brandChangeCallback;
    private /* synthetic */ Function0<Unit> completionCallback;
    private AccountRange accountRange;
    private boolean isCardNumberValid;
    @Nullable
    private Job accountRangeRepositoryJob;
    private /* synthetic */ Function1<? super Boolean, Unit> isLoadingCallback;
    private Job loadingJob;
    @NotNull
    private CoroutineContext workContext;
    private final CardAccountRangeRepository cardAccountRangeRepository;
    private final StaticCardAccountRanges staticCardAccountRanges;
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final AnalyticsRequest.Factory analyticsRequestFactory;
    private final AnalyticsDataFactory analyticsDataFactory;

    @VisibleForTesting
    public static /* synthetic */ void getCardBrand$annotations() {
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public final void setCardBrand$stripe_release(@NotNull CardBrand value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        CardBrand prevBrand = this.cardBrand;
        this.cardBrand = value;
        if (value != prevBrand) {
            this.brandChangeCallback.invoke((Object)this.cardBrand);
            CardNumberEditText.updateLengthFilter$stripe_release$default(this, 0, 1, null);
        }
    }

    @NotNull
    public final Function1<CardBrand, Unit> getBrandChangeCallback$stripe_release() {
        return this.brandChangeCallback;
    }

    public final void setBrandChangeCallback$stripe_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.brandChangeCallback = callback;
        callback.invoke((Object)this.cardBrand);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$stripe_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$stripe_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    @Deprecated(message="Will be removed in upcoming major release.")
    public static /* synthetic */ void getLengthMax$annotations() {
    }

    public final int getLengthMax() {
        return this.cardBrand.getMaxLengthWithSpacesForCardNumber(this.getFieldText$stripe_release());
    }

    private final void setAccountRange(AccountRange value) {
        this.accountRange = value;
        CardNumberEditText.updateLengthFilter$stripe_release$default(this, 0, 1, null);
    }

    public final int getPanLength$stripe_release() {
        Integer n;
        AccountRange accountRange = this.accountRange;
        if (accountRange != null) {
            n = accountRange.getPanLength();
        } else {
            AccountRange accountRange2 = this.staticCardAccountRanges.first(this.getUnvalidatedCardNumber());
            n = accountRange2 != null ? Integer.valueOf(accountRange2.getPanLength()) : null;
        }
        return n != null ? n : 16;
    }

    private final int getFormattedPanLength() {
        return this.getPanLength$stripe_release() + CardNumber.Companion.getSpacePositions$stripe_release(this.getPanLength$stripe_release()).size();
    }

    public final boolean isCardNumberValid() {
        return this.isCardNumberValid;
    }

    @Deprecated(message="Will be removed in next major release.")
    public static /* synthetic */ void getCardNumber$annotations() {
    }

    @Nullable
    public final String getCardNumber() {
        return this.isCardNumberValid ? this.getUnvalidatedCardNumber().getNormalized() : null;
    }

    @Nullable
    public final CardNumber.Validated getValidatedCardNumber$stripe_release() {
        return this.getUnvalidatedCardNumber().validate(this.getPanLength$stripe_release());
    }

    private final CardNumber.Unvalidated getUnvalidatedCardNumber() {
        return new CardNumber.Unvalidated(this.getFieldText$stripe_release());
    }

    private final boolean isValid() {
        return this.getValidatedCardNumber$stripe_release() != null;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAccountRangeRepositoryJob$stripe_release$annotations() {
    }

    @Nullable
    public final Job getAccountRangeRepositoryJob$stripe_release() {
        return this.accountRangeRepositoryJob;
    }

    public final void setAccountRangeRepositoryJob$stripe_release(@Nullable Job job) {
        this.accountRangeRepositoryJob = job;
    }

    @NotNull
    public final Function1<Boolean, Unit> isLoadingCallback$stripe_release() {
        return this.isLoadingCallback;
    }

    public final void setLoadingCallback$stripe_release(@NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.isLoadingCallback = function1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.loadingJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CardNumberEditText this$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Flow<Boolean> flow = CardNumberEditText.access$getCardAccountRangeRepository$p(this.this$0).getLoading();
                        onAttachedToWindow.1 var3_4 = this;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<Boolean>(this){
                            final /* synthetic */ onAttachedToWindow.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                boolean it = (Boolean)value;
                                boolean bl = false;
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this){
                                    int label;
                                    final /* synthetic */ boolean $it;
                                    final /* synthetic */ onAttachedToWindow$1$invokeSuspend$$inlined$collect$1 this$0;
                                    {
                                        this.$it = bl;
                                        this.this$0 = var3_3;
                                        super(2, continuation);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.this$0.this$0.this$0.isLoadingCallback$stripe_release().invoke((Object)Boxing.boxBoolean((boolean)this.$it));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)var3_4);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = cardNumberEditText;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    protected String getAccessibilityText() {
        return this.getResources().getString(R.string.acc_label_card_number_node, new Object[]{this.getText()});
    }

    protected void onDetachedFromWindow() {
        Job job = this.loadingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.loadingJob = null;
        this.cancelAccountRangeRepositoryJob();
        super.onDetachedFromWindow();
    }

    public final /* synthetic */ void updateLengthFilter$stripe_release(int maxLength) {
        this.setFilters(new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(maxLength)});
    }

    public static /* synthetic */ void updateLengthFilter$stripe_release$default(CardNumberEditText cardNumberEditText, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = cardNumberEditText.getFormattedPanLength();
        }
        cardNumberEditText.updateLengthFilter$stripe_release(n);
    }

    public final /* synthetic */ int calculateCursorPosition$stripe_release(int newFormattedLength, int start, int addedDigits, int panLength) {
        boolean bl;
        int gapsJumped;
        block7: {
            int gap;
            int n;
            Set<Integer> gapSet = CardNumber.Companion.getSpacePositions$stripe_release(panLength);
            Iterable $this$count$iv = gapSet;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!(start <= gap && start + addedDigits >= gap)) continue;
                    gap = ++count$iv;
                    bl2 = false;
                    if (gap >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            gapsJumped = n;
            Iterable $this$any$iv = gapSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (!(addedDigits == 0 && start == gap + 1)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean skipBack = bl;
        int newPosition = start + addedDigits + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newFormattedLength ? newPosition : newFormattedLength;
    }

    public static /* synthetic */ int calculateCursorPosition$stripe_release$default(CardNumberEditText cardNumberEditText, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = cardNumberEditText.getPanLength$stripe_release();
        }
        return cardNumberEditText.calculateCursorPosition$stripe_release(n, n2, n3, n4);
    }

    public final /* synthetic */ void queryAccountRangeRepository$stripe_release(CardNumber.Unvalidated cardNumber) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        if (this.shouldQueryAccountRange(cardNumber)) {
            this.cancelAccountRangeRepositoryJob();
            this.setAccountRange(null);
            this.accountRangeRepositoryJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cardNumber, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CardNumberEditText this$0;
                final /* synthetic */ CardNumber.Unvalidated $cardNumber;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block7: {
                        var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                bin = this.$cardNumber.getBin();
                                v0 = var3_4 = new Ref.ObjectRef();
                                if (bin == null) break;
                                var4_5 = v0;
                                this.L$0 = accountRange;
                                this.L$1 = var4_5;
                                this.label = 1;
                                v1 = CardNumberEditText.access$getCardAccountRangeRepository$p(this.this$0).getAccountRange(this.$cardNumber, (Continuation<? super AccountRange>)this);
                                if (v1 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl21
                            }
                            case 1: {
                                var4_5 = (Ref.ObjectRef)this.L$1;
                                accountRange = (Ref.ObjectRef)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                var5_6 = v1;
                                v0 = var4_5;
                                v2 = (AccountRange)var5_6;
                                break block7;
                            }
                        }
                        v2 = null;
                    }
                    v0.element = v2;
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accountRange, null){
                        int label;
                        final /* synthetic */ queryAccountRangeRepository.1 this$0;
                        final /* synthetic */ Ref.ObjectRef $accountRange;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.this$0.this$0.onAccountRangeResult$stripe_release((AccountRange)this.$accountRange.element);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.this$0 = var1_1;
                            this.$accountRange = objectRef;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)this);
                    if (v3 == var6_2) {
                        return var6_2;
                    }
                    ** GOTO lbl38
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl38:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = cardNumberEditText;
                    this.$cardNumber = unvalidated;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void cancelAccountRangeRepositoryJob() {
        Job job = this.accountRangeRepositoryJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.accountRangeRepositoryJob = null;
    }

    public final /* synthetic */ void onAccountRangeResult$stripe_release(AccountRange newAccountRange) {
        this.setAccountRange(newAccountRange);
        Object object = newAccountRange;
        if (object == null || (object = object.getBrand()) == null) {
            object = CardBrand.Unknown;
        }
        this.setCardBrand$stripe_release((CardBrand)((Object)object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldQueryAccountRange(CardNumber.Unvalidated cardNumber) {
        if (this.accountRange == null) return true;
        if (cardNumber.getBin() == null) return true;
        AccountRange accountRange = this.accountRange;
        StripeModel stripeModel = accountRange;
        if (accountRange == null) return false;
        BinRange binRange = ((AccountRange)stripeModel).getBinRange();
        stripeModel = binRange;
        if (binRange == null) return false;
        if (((BinRange)stripeModel).matches$stripe_release(cardNumber)) return false;
        return true;
    }

    public final /* synthetic */ void onCardMetadataLoadedTooSlow$stripe_release() {
        this.analyticsRequestExecutor.executeAsync(this.analyticsRequestFactory.create$stripe_release(this.analyticsDataFactory.createParams$stripe_release(AnalyticsEvent.CardMetadataLoadedTooSlow)));
    }

    @NotNull
    public final CoroutineContext getWorkContext$stripe_release() {
        return this.workContext;
    }

    public final void setWorkContext$stripe_release(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"<set-?>");
        this.workContext = coroutineContext;
    }

    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull CoroutineContext workContext, @NotNull CardAccountRangeRepository cardAccountRangeRepository2, @NotNull StaticCardAccountRanges staticCardAccountRanges, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequest.Factory analyticsRequestFactory, @NotNull AnalyticsDataFactory analyticsDataFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)cardAccountRangeRepository2, (String)"cardAccountRangeRepository");
        Intrinsics.checkNotNullParameter((Object)staticCardAccountRanges, (String)"staticCardAccountRanges");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)analyticsDataFactory, (String)"analyticsDataFactory");
        super(context, attrs, defStyleAttr);
        this.workContext = workContext;
        this.cardAccountRangeRepository = cardAccountRangeRepository2;
        this.staticCardAccountRanges = staticCardAccountRanges;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
        this.analyticsDataFactory = analyticsDataFactory;
        this.cardBrand = CardBrand.Unknown;
        this.brandChangeCallback = brandChangeCallback.1.INSTANCE;
        this.completionCallback = completionCallback.1.INSTANCE;
        this.isLoadingCallback = isLoadingCallback.1.INSTANCE;
        this.setInputType(2);
        this.setErrorMessage(this.getResources().getString(R.string.invalid_card_number));
        this.addTextChangedListener(new CardNumberTextWatcher());
        if (Build.VERSION.SDK_INT >= 26) {
            this.setAutofillHints(new String[]{"creditCardNumber"});
        }
        CardNumberEditText.updateLengthFilter$stripe_release$default(this, 0, 1, null);
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, CoroutineContext coroutineContext, CardAccountRangeRepository cardAccountRangeRepository2, StaticCardAccountRanges staticCardAccountRanges, AnalyticsRequestExecutor analyticsRequestExecutor, AnalyticsRequest.Factory factory, AnalyticsDataFactory analyticsDataFactory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        if ((n2 & 0x20) != 0) {
            staticCardAccountRanges = new DefaultStaticCardAccountRanges();
        }
        this(context, attributeSet, n, coroutineContext, cardAccountRangeRepository2, staticCardAccountRanges, analyticsRequestExecutor, factory, analyticsDataFactory);
    }

    @JvmOverloads
    public CardNumberEditText(final @NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, (CoroutineContext)Dispatchers.getIO(), (Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return PaymentConfiguration.Companion.getInstance(context).getPublishableKey();
            }
        }));
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    private CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr, CoroutineContext workContext, Function0<String> publishableKeySupplier) {
        this(context, attrs, defStyleAttr, workContext, new DefaultCardAccountRangeRepositoryFactory(context).create(), new DefaultStaticCardAccountRanges(), new AnalyticsRequestExecutor.Default(null, null, 3, null), new AnalyticsRequest.Factory(null, 1, null), new AnalyticsDataFactory(context, publishableKeySupplier));
    }

    public static final /* synthetic */ boolean access$isCardNumberValid$p(CardNumberEditText $this) {
        return $this.isCardNumberValid;
    }

    public static final /* synthetic */ void access$setAccountRange$p(CardNumberEditText $this, AccountRange accountRange) {
        $this.setAccountRange(accountRange);
    }

    public static final /* synthetic */ CardAccountRangeRepository access$getCardAccountRangeRepository$p(CardNumberEditText $this) {
        return $this.cardAccountRangeRepository;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J*\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0004H\u0002J*\u0010#\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006("}, d2={"Lcom/stripe/android/view/CardNumberEditText$CardNumberTextWatcher;", "Lcom/stripe/android/view/StripeTextWatcher;", "(Lcom/stripe/android/view/CardNumberEditText;)V", "beforeCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "digitsAdded", "", "getDigitsAdded", "()Z", "formattedNumber", "", "ignoreChanges", "isPastedPan", "latestChangeStart", "", "latestInsertionSize", "newCursorPosition", "Ljava/lang/Integer;", "shouldUpdateAfterChange", "getShouldUpdateAfterChange", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "isComplete", "wasCardNumberValid", "startPosition", "previousCount", "currentCount", "cardNumber", "onTextChanged", "before", "shouldQueryRepository", "accountRange", "Lcom/stripe/android/model/AccountRange;", "stripe_release"})
    private final class CardNumberTextWatcher
    extends StripeTextWatcher {
        private boolean ignoreChanges;
        private int latestChangeStart;
        private int latestInsertionSize;
        private Integer newCursorPosition;
        private String formattedNumber;
        private CardNumber.Unvalidated beforeCardNumber;
        private boolean isPastedPan;

        @Override
        public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            if (!this.ignoreChanges) {
                this.isPastedPan = false;
                this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
                this.latestChangeStart = start;
                this.latestInsertionSize = after;
            }
        }

        @Override
        public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
            if (this.ignoreChanges) {
                return;
            }
            CharSequence charSequence = s;
            String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            CardNumber.Unvalidated cardNumber = new CardNumber.Unvalidated(string3);
            List<AccountRange> list = CardNumberEditText.this.staticCardAccountRanges.filter(cardNumber);
            boolean bl2 = false;
            boolean bl3 = false;
            List<AccountRange> accountRanges = list;
            boolean bl4 = false;
            AccountRange staticAccountRange = accountRanges.size() == 1 ? (AccountRange)CollectionsKt.first(accountRanges) : null;
            if (staticAccountRange == null || this.shouldQueryRepository(staticAccountRange)) {
                CardNumberEditText.this.queryAccountRangeRepository$stripe_release(cardNumber);
            } else {
                CardNumberEditText.this.onAccountRangeResult$stripe_release(staticAccountRange);
            }
            this.isPastedPan = this.isPastedPan(start, before, count, cardNumber);
            if (this.isPastedPan) {
                CardNumberEditText.this.updateLengthFilter$stripe_release(cardNumber.getFormatted(cardNumber.getLength()).length());
            }
            int n = this.isPastedPan ? cardNumber.getLength() : CardNumberEditText.this.getPanLength$stripe_release();
            bl2 = false;
            bl3 = false;
            int maxPanLength = n;
            boolean bl5 = false;
            String formattedNumber = cardNumber.getFormatted(maxPanLength);
            this.newCursorPosition = CardNumberEditText.this.calculateCursorPosition$stripe_release(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize, maxPanLength);
            this.formattedNumber = formattedNumber;
        }

        @Override
        public void afterTextChanged(@Nullable Editable s) {
            if (this.ignoreChanges) {
                return;
            }
            this.ignoreChanges = true;
            if (this.getShouldUpdateAfterChange()) {
                CardNumberEditText.this.setText(this.formattedNumber);
                Integer n = this.newCursorPosition;
                if (n != null) {
                    Integer n2 = n;
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)n2).intValue();
                    boolean bl3 = false;
                    CardNumberEditText.this.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)CardNumberEditText.this.getFieldText$stripe_release().length()));
                }
            }
            this.formattedNumber = null;
            this.newCursorPosition = null;
            this.ignoreChanges = false;
            if (CardNumberEditText.this.getUnvalidatedCardNumber().getLength() == CardNumberEditText.this.getPanLength$stripe_release()) {
                boolean wasCardNumberValid = CardNumberEditText.this.isCardNumberValid();
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(!CardNumberEditText.this.isValid());
                if (CardNumberEditText.this.accountRange == null && CardNumberEditText.this.getUnvalidatedCardNumber().isValidLuhn()) {
                    CardNumberEditText.this.onCardMetadataLoadedTooSlow$stripe_release();
                }
                if (this.isComplete(wasCardNumberValid)) {
                    CardNumberEditText.this.getCompletionCallback$stripe_release().invoke();
                }
            } else {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(false);
            }
        }

        private final boolean getShouldUpdateAfterChange() {
            return (this.getDigitsAdded() || !CardNumberEditText.this.isLastKeyDelete()) && this.formattedNumber != null;
        }

        private final boolean getDigitsAdded() {
            return CardNumberEditText.this.getUnvalidatedCardNumber().getLength() > this.beforeCardNumber.getLength();
        }

        private final boolean isComplete(boolean wasCardNumberValid) {
            return !wasCardNumberValid && (CardNumberEditText.this.getUnvalidatedCardNumber().isMaxLength() || CardNumberEditText.this.isValid() && CardNumberEditText.this.accountRange != null);
        }

        private final boolean isPastedPan(int startPosition, int previousCount, int currentCount, CardNumber.Unvalidated cardNumber) {
            return currentCount > previousCount && startPosition == 0 && cardNumber.getNormalized().length() >= 14;
        }

        private final boolean shouldQueryRepository(AccountRange accountRange) {
            boolean bl;
            switch (CardNumberEditText$CardNumberTextWatcher$WhenMappings.$EnumSwitchMapping$0[accountRange.getBrand().ordinal()]) {
                case 1: 
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public CardNumberTextWatcher() {
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
        }
    }
}

