/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepay;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.core.os.BundleKt;
import com.google.android.gms.common.api.Status;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.googlepay.StripeGooglePayActivity;
import com.stripe.android.googlepay.StripeGooglePayEnvironment;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.view.ActivityStarter;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parceler;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "GooglePayConfig", "Result", "stripe_release"})
public final class StripeGooglePayContract
extends ActivityResultContract<Args, Result> {
    @NotNull
    public Intent createIntent(@NotNull Context context, @Nullable Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent(context, StripeGooglePayActivity.class).putExtra("extra_activity_args", (Parcelable)input);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, StripeGo\u2026tarter.Args.EXTRA, input)");
        return intent;
    }

    @NotNull
    public Result parseResult(int resultCode, @Nullable Intent intent) {
        return Result.Companion.fromIntent(intent);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "Lcom/stripe/android/view/ActivityStarter$Args;", "()V", "config", "Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "getConfig", "()Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "setConfig", "(Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;)V", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "getPaymentIntent", "()Lcom/stripe/android/model/PaymentIntent;", "setPaymentIntent", "(Lcom/stripe/android/model/PaymentIntent;)V", "Companion", "ConfirmPaymentIntent", "PaymentData", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args$PaymentData;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args$ConfirmPaymentIntent;", "stripe_release"})
    public static abstract class Args
    implements ActivityStarter.Args {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public abstract PaymentIntent getPaymentIntent();

        public abstract void setPaymentIntent(@NotNull PaymentIntent var1);

        @NotNull
        public abstract GooglePayConfig getConfig();

        public abstract void setConfig(@NotNull GooglePayConfig var1);

        private Args() {
        }

        public /* synthetic */ Args(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Args$PaymentData;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "config", "Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "(Lcom/stripe/android/model/PaymentIntent;Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;)V", "getConfig", "()Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "setConfig", "(Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;)V", "getPaymentIntent", "()Lcom/stripe/android/model/PaymentIntent;", "setPaymentIntent", "(Lcom/stripe/android/model/PaymentIntent;)V", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class PaymentData
        extends Args {
            @NotNull
            private PaymentIntent paymentIntent;
            @NotNull
            private GooglePayConfig config;
            public static final Parcelable.Creator<PaymentData> CREATOR = new Creator();

            @Override
            @NotNull
            public PaymentIntent getPaymentIntent() {
                return this.paymentIntent;
            }

            @Override
            public void setPaymentIntent(@NotNull PaymentIntent paymentIntent) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"<set-?>");
                this.paymentIntent = paymentIntent;
            }

            @Override
            @NotNull
            public GooglePayConfig getConfig() {
                return this.config;
            }

            @Override
            public void setConfig(@NotNull GooglePayConfig googlePayConfig) {
                Intrinsics.checkNotNullParameter((Object)googlePayConfig, (String)"<set-?>");
                this.config = googlePayConfig;
            }

            public PaymentData(@NotNull PaymentIntent paymentIntent, @NotNull GooglePayConfig config) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                super(null);
                this.paymentIntent = paymentIntent;
                this.config = config;
            }

            @NotNull
            public final PaymentIntent component1() {
                return this.getPaymentIntent();
            }

            @NotNull
            public final GooglePayConfig component2() {
                return this.getConfig();
            }

            @NotNull
            public final PaymentData copy(@NotNull PaymentIntent paymentIntent, @NotNull GooglePayConfig config) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                return new PaymentData(paymentIntent, config);
            }

            public static /* synthetic */ PaymentData copy$default(PaymentData paymentData, PaymentIntent paymentIntent, GooglePayConfig googlePayConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentIntent = paymentData.getPaymentIntent();
                }
                if ((n & 2) != 0) {
                    googlePayConfig = paymentData.getConfig();
                }
                return paymentData.copy(paymentIntent, googlePayConfig);
            }

            @NotNull
            public String toString() {
                return "PaymentData(paymentIntent=" + this.getPaymentIntent() + ", config=" + this.getConfig() + ")";
            }

            public int hashCode() {
                PaymentIntent paymentIntent = this.getPaymentIntent();
                GooglePayConfig googlePayConfig = this.getConfig();
                return (paymentIntent != null ? ((Object)paymentIntent).hashCode() : 0) * 31 + (googlePayConfig != null ? ((Object)googlePayConfig).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof PaymentData)) break block3;
                        PaymentData paymentData = (PaymentData)object;
                        if (!Intrinsics.areEqual((Object)this.getPaymentIntent(), (Object)paymentData.getPaymentIntent()) || !Intrinsics.areEqual((Object)this.getConfig(), (Object)paymentData.getConfig())) break block3;
                    }
                    return true;
                }
                return false;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                this.paymentIntent.writeToParcel(parcel, 0);
                this.config.writeToParcel(parcel, 0);
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<PaymentData> {
                @NotNull
                public final PaymentData[] newArray(int size) {
                    return new PaymentData[size];
                }

                @NotNull
                public final PaymentData createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    return new PaymentData((PaymentIntent)PaymentIntent.CREATOR.createFromParcel(in), (GooglePayConfig)GooglePayConfig.CREATOR.createFromParcel(in));
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Args$ConfirmPaymentIntent;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "config", "Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "(Lcom/stripe/android/model/PaymentIntent;Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;)V", "getConfig", "()Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "setConfig", "(Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;)V", "getPaymentIntent", "()Lcom/stripe/android/model/PaymentIntent;", "setPaymentIntent", "(Lcom/stripe/android/model/PaymentIntent;)V", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class ConfirmPaymentIntent
        extends Args {
            @NotNull
            private PaymentIntent paymentIntent;
            @NotNull
            private GooglePayConfig config;
            public static final Parcelable.Creator<ConfirmPaymentIntent> CREATOR = new Creator();

            @Override
            @NotNull
            public PaymentIntent getPaymentIntent() {
                return this.paymentIntent;
            }

            @Override
            public void setPaymentIntent(@NotNull PaymentIntent paymentIntent) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"<set-?>");
                this.paymentIntent = paymentIntent;
            }

            @Override
            @NotNull
            public GooglePayConfig getConfig() {
                return this.config;
            }

            @Override
            public void setConfig(@NotNull GooglePayConfig googlePayConfig) {
                Intrinsics.checkNotNullParameter((Object)googlePayConfig, (String)"<set-?>");
                this.config = googlePayConfig;
            }

            public ConfirmPaymentIntent(@NotNull PaymentIntent paymentIntent, @NotNull GooglePayConfig config) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                super(null);
                this.paymentIntent = paymentIntent;
                this.config = config;
            }

            @NotNull
            public final PaymentIntent component1() {
                return this.getPaymentIntent();
            }

            @NotNull
            public final GooglePayConfig component2() {
                return this.getConfig();
            }

            @NotNull
            public final ConfirmPaymentIntent copy(@NotNull PaymentIntent paymentIntent, @NotNull GooglePayConfig config) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                return new ConfirmPaymentIntent(paymentIntent, config);
            }

            public static /* synthetic */ ConfirmPaymentIntent copy$default(ConfirmPaymentIntent confirmPaymentIntent2, PaymentIntent paymentIntent, GooglePayConfig googlePayConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentIntent = confirmPaymentIntent2.getPaymentIntent();
                }
                if ((n & 2) != 0) {
                    googlePayConfig = confirmPaymentIntent2.getConfig();
                }
                return confirmPaymentIntent2.copy(paymentIntent, googlePayConfig);
            }

            @NotNull
            public String toString() {
                return "ConfirmPaymentIntent(paymentIntent=" + this.getPaymentIntent() + ", config=" + this.getConfig() + ")";
            }

            public int hashCode() {
                PaymentIntent paymentIntent = this.getPaymentIntent();
                GooglePayConfig googlePayConfig = this.getConfig();
                return (paymentIntent != null ? ((Object)paymentIntent).hashCode() : 0) * 31 + (googlePayConfig != null ? ((Object)googlePayConfig).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ConfirmPaymentIntent)) break block3;
                        ConfirmPaymentIntent confirmPaymentIntent2 = (ConfirmPaymentIntent)object;
                        if (!Intrinsics.areEqual((Object)this.getPaymentIntent(), (Object)confirmPaymentIntent2.getPaymentIntent()) || !Intrinsics.areEqual((Object)this.getConfig(), (Object)confirmPaymentIntent2.getConfig())) break block3;
                    }
                    return true;
                }
                return false;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                this.paymentIntent.writeToParcel(parcel, 0);
                this.config.writeToParcel(parcel, 0);
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<ConfirmPaymentIntent> {
                @NotNull
                public final ConfirmPaymentIntent[] newArray(int size) {
                    return new ConfirmPaymentIntent[size];
                }

                @NotNull
                public final ConfirmPaymentIntent createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    return new ConfirmPaymentIntent((PaymentIntent)PaymentIntent.CREATOR.createFromParcel(in), (GooglePayConfig)GooglePayConfig.CREATOR.createFromParcel(in));
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Args$Companion;", "", "()V", "create", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "intent", "Landroid/content/Intent;", "create$stripe_release", "stripe_release"})
        public static final class Companion {
            public final /* synthetic */ Args create$stripe_release(Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return (Args)intent.getParcelableExtra("extra_activity_args");
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0019\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001eJ3\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0013\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020!H\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u0006,"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$GooglePayConfig;", "Landroid/os/Parcelable;", "environment", "Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;", "countryCode", "", "isEmailRequired", "", "merchantName", "(Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;Ljava/lang/String;ZLjava/lang/String;)V", "getCountryCode$stripe_release", "()Ljava/lang/String;", "setCountryCode$stripe_release", "(Ljava/lang/String;)V", "getEnvironment", "()Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;", "setEnvironment", "(Lcom/stripe/android/googlepay/StripeGooglePayEnvironment;)V", "isEmailRequired$stripe_release", "()Z", "setEmailRequired$stripe_release", "(Z)V", "getMerchantName$stripe_release", "setMerchantName$stripe_release", "component1", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "component4", "component4$stripe_release", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
    @Parcelize
    public static final class GooglePayConfig
    implements Parcelable {
        @NotNull
        private StripeGooglePayEnvironment environment;
        @NotNull
        private String countryCode;
        private boolean isEmailRequired;
        @Nullable
        private String merchantName;
        public static final Parcelable.Creator<GooglePayConfig> CREATOR = new Creator();

        @NotNull
        public final StripeGooglePayEnvironment getEnvironment() {
            return this.environment;
        }

        public final void setEnvironment(@NotNull StripeGooglePayEnvironment stripeGooglePayEnvironment) {
            Intrinsics.checkNotNullParameter((Object)((Object)stripeGooglePayEnvironment), (String)"<set-?>");
            this.environment = stripeGooglePayEnvironment;
        }

        @NotNull
        public final String getCountryCode$stripe_release() {
            return this.countryCode;
        }

        public final void setCountryCode$stripe_release(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.countryCode = string2;
        }

        public final boolean isEmailRequired$stripe_release() {
            return this.isEmailRequired;
        }

        public final void setEmailRequired$stripe_release(boolean bl) {
            this.isEmailRequired = bl;
        }

        @Nullable
        public final String getMerchantName$stripe_release() {
            return this.merchantName;
        }

        public final void setMerchantName$stripe_release(@Nullable String string2) {
            this.merchantName = string2;
        }

        public GooglePayConfig(@NotNull StripeGooglePayEnvironment environment, @NotNull String countryCode, boolean isEmailRequired, @Nullable String merchantName) {
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
            this.environment = environment;
            this.countryCode = countryCode;
            this.isEmailRequired = isEmailRequired;
            this.merchantName = merchantName;
        }

        public /* synthetic */ GooglePayConfig(StripeGooglePayEnvironment stripeGooglePayEnvironment, String string2, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(stripeGooglePayEnvironment, string2, bl, string3);
        }

        @NotNull
        public final StripeGooglePayEnvironment component1() {
            return this.environment;
        }

        @NotNull
        public final String component2$stripe_release() {
            return this.countryCode;
        }

        public final boolean component3$stripe_release() {
            return this.isEmailRequired;
        }

        @Nullable
        public final String component4$stripe_release() {
            return this.merchantName;
        }

        @NotNull
        public final GooglePayConfig copy(@NotNull StripeGooglePayEnvironment environment, @NotNull String countryCode, boolean isEmailRequired, @Nullable String merchantName) {
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
            return new GooglePayConfig(environment, countryCode, isEmailRequired, merchantName);
        }

        public static /* synthetic */ GooglePayConfig copy$default(GooglePayConfig googlePayConfig, StripeGooglePayEnvironment stripeGooglePayEnvironment, String string2, boolean bl, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                stripeGooglePayEnvironment = googlePayConfig.environment;
            }
            if ((n & 2) != 0) {
                string2 = googlePayConfig.countryCode;
            }
            if ((n & 4) != 0) {
                bl = googlePayConfig.isEmailRequired;
            }
            if ((n & 8) != 0) {
                string3 = googlePayConfig.merchantName;
            }
            return googlePayConfig.copy(stripeGooglePayEnvironment, string2, bl, string3);
        }

        @NotNull
        public String toString() {
            return "GooglePayConfig(environment=" + (Object)((Object)this.environment) + ", countryCode=" + this.countryCode + ", isEmailRequired=" + this.isEmailRequired + ", merchantName=" + this.merchantName + ")";
        }

        public int hashCode() {
            StripeGooglePayEnvironment stripeGooglePayEnvironment = this.environment;
            String string2 = this.countryCode;
            int n = ((stripeGooglePayEnvironment != null ? ((Object)((Object)stripeGooglePayEnvironment)).hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.isEmailRequired ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string3 = this.merchantName;
            return (n + n2) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GooglePayConfig)) break block3;
                    GooglePayConfig googlePayConfig = (GooglePayConfig)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.environment), (Object)((Object)googlePayConfig.environment)) || !Intrinsics.areEqual((Object)this.countryCode, (Object)googlePayConfig.countryCode) || this.isEmailRequired != googlePayConfig.isEmailRequired || !Intrinsics.areEqual((Object)this.merchantName, (Object)googlePayConfig.merchantName)) break block3;
                }
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeString(this.environment.name());
            parcel.writeString(this.countryCode);
            parcel.writeInt(this.isEmailRequired ? 1 : 0);
            parcel.writeString(this.merchantName);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator<GooglePayConfig> {
            @NotNull
            public final GooglePayConfig[] newArray(int size) {
                return new GooglePayConfig[size];
            }

            @NotNull
            public final GooglePayConfig createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new GooglePayConfig(Enum.valueOf(StripeGooglePayEnvironment.class, in.readString()), in.readString(), in.readInt() != 0, in.readString());
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00062\u00020\u0001:\u0006\u0005\u0006\u0007\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u0082\u0001\u0005\u000b\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "Lcom/stripe/android/view/ActivityStarter$Result;", "()V", "toBundle", "Landroid/os/Bundle;", "Canceled", "Companion", "Error", "PaymentData", "PaymentIntent", "Unavailable", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$PaymentIntent;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$PaymentData;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Canceled;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Unavailable;", "stripe_release"})
    public static abstract class Result
    implements ActivityStarter.Result {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Bundle toBundle() {
            return BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)"extra_activity_result", (Object)this)});
        }

        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        @NotNull
        public static final Result fromIntent(@Nullable Intent intent) {
            return Companion.fromIntent(intent);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "exception", "", "googlePayStatus", "Lcom/google/android/gms/common/api/Status;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "(Ljava/lang/Throwable;Lcom/google/android/gms/common/api/Status;Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/ShippingInformation;)V", "getException", "()Ljava/lang/Throwable;", "getGooglePayStatus", "()Lcom/google/android/gms/common/api/Status;", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "stripe_release"})
        @Parcelize
        public static final class Error
        extends Result {
            @NotNull
            private final Throwable exception;
            @Nullable
            private final Status googlePayStatus;
            @Nullable
            private final PaymentMethod paymentMethod;
            @Nullable
            private final ShippingInformation shippingInformation;
            @NotNull
            public static final Companion Companion = new Companion(null);
            public static final Parcelable.Creator<Error> CREATOR = new Creator();

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }

            @Nullable
            public final Status getGooglePayStatus() {
                return this.googlePayStatus;
            }

            @Nullable
            public final PaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @Nullable
            public final ShippingInformation getShippingInformation() {
                return this.shippingInformation;
            }

            public Error(@NotNull Throwable exception, @Nullable Status googlePayStatus, @Nullable PaymentMethod paymentMethod, @Nullable ShippingInformation shippingInformation) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
                this.googlePayStatus = googlePayStatus;
                this.paymentMethod = paymentMethod;
                this.shippingInformation = shippingInformation;
            }

            public /* synthetic */ Error(Throwable throwable, Status status, PaymentMethod paymentMethod, ShippingInformation shippingInformation, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    status = null;
                }
                if ((n & 4) != 0) {
                    paymentMethod = null;
                }
                if ((n & 8) != 0) {
                    shippingInformation = null;
                }
                this(throwable, status, paymentMethod, shippingInformation);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                Companion.write(this, parcel, flags);
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<Error> {
                @NotNull
                public final Error[] newArray(int size) {
                    return new Error[size];
                }

                @NotNull
                public final Error createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    return Companion.create(in);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error$Companion;", "Lkotlinx/parcelize/Parceler;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Error;", "()V", "create", "parcel", "Landroid/os/Parcel;", "write", "", "flags", "", "stripe_release"})
            public static final class Companion
            implements Parceler<Error> {
                @NotNull
                public Error create(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    Serializable serializable = parcel.readSerializable();
                    if (serializable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                    }
                    return new Error((Throwable)serializable, (Status)parcel.readParcelable(Status.class.getClassLoader()), null, null, 12, null);
                }

                public void write(@NotNull Error $this$write, @NotNull Parcel parcel, int flags) {
                    Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.writeSerializable((Serializable)$this$write.getException());
                    parcel.writeParcelable((Parcelable)$this$write.getGooglePayStatus(), flags);
                }

                private Companion() {
                }

                @NotNull
                public Error[] newArray(int size) {
                    return (Error[])Parceler.DefaultImpls.newArray((Parceler)this, (int)size);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$PaymentIntent;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "paymentIntentResult", "Lcom/stripe/android/PaymentIntentResult;", "(Lcom/stripe/android/PaymentIntentResult;)V", "getPaymentIntentResult", "()Lcom/stripe/android/PaymentIntentResult;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class PaymentIntent
        extends Result {
            @NotNull
            private final PaymentIntentResult paymentIntentResult;
            public static final Parcelable.Creator<PaymentIntent> CREATOR = new Creator();

            @NotNull
            public final PaymentIntentResult getPaymentIntentResult() {
                return this.paymentIntentResult;
            }

            public PaymentIntent(@NotNull PaymentIntentResult paymentIntentResult) {
                Intrinsics.checkNotNullParameter((Object)paymentIntentResult, (String)"paymentIntentResult");
                super(null);
                this.paymentIntentResult = paymentIntentResult;
            }

            @NotNull
            public final PaymentIntentResult component1() {
                return this.paymentIntentResult;
            }

            @NotNull
            public final PaymentIntent copy(@NotNull PaymentIntentResult paymentIntentResult) {
                Intrinsics.checkNotNullParameter((Object)paymentIntentResult, (String)"paymentIntentResult");
                return new PaymentIntent(paymentIntentResult);
            }

            public static /* synthetic */ PaymentIntent copy$default(PaymentIntent paymentIntent, PaymentIntentResult paymentIntentResult, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentIntentResult = paymentIntent.paymentIntentResult;
                }
                return paymentIntent.copy(paymentIntentResult);
            }

            @NotNull
            public String toString() {
                return "PaymentIntent(paymentIntentResult=" + this.paymentIntentResult + ")";
            }

            public int hashCode() {
                PaymentIntentResult paymentIntentResult = this.paymentIntentResult;
                return paymentIntentResult != null ? ((Object)paymentIntentResult).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof PaymentIntent)) break block3;
                        PaymentIntent paymentIntent = (PaymentIntent)object;
                        if (!Intrinsics.areEqual((Object)this.paymentIntentResult, (Object)paymentIntent.paymentIntentResult)) break block3;
                    }
                    return true;
                }
                return false;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                this.paymentIntentResult.writeToParcel(parcel, 0);
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<PaymentIntent> {
                @NotNull
                public final PaymentIntent[] newArray(int size) {
                    return new PaymentIntent[size];
                }

                @NotNull
                public final PaymentIntent createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    return new PaymentIntent((PaymentIntentResult)PaymentIntentResult.CREATOR.createFromParcel(in));
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$PaymentData;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "(Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/ShippingInformation;)V", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class PaymentData
        extends Result {
            @NotNull
            private final PaymentMethod paymentMethod;
            @Nullable
            private final ShippingInformation shippingInformation;
            public static final Parcelable.Creator<PaymentData> CREATOR = new Creator();

            @NotNull
            public final PaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @Nullable
            public final ShippingInformation getShippingInformation() {
                return this.shippingInformation;
            }

            public PaymentData(@NotNull PaymentMethod paymentMethod, @Nullable ShippingInformation shippingInformation) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                super(null);
                this.paymentMethod = paymentMethod;
                this.shippingInformation = shippingInformation;
            }

            @NotNull
            public final PaymentMethod component1() {
                return this.paymentMethod;
            }

            @Nullable
            public final ShippingInformation component2() {
                return this.shippingInformation;
            }

            @NotNull
            public final PaymentData copy(@NotNull PaymentMethod paymentMethod, @Nullable ShippingInformation shippingInformation) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                return new PaymentData(paymentMethod, shippingInformation);
            }

            public static /* synthetic */ PaymentData copy$default(PaymentData paymentData, PaymentMethod paymentMethod, ShippingInformation shippingInformation, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentMethod = paymentData.paymentMethod;
                }
                if ((n & 2) != 0) {
                    shippingInformation = paymentData.shippingInformation;
                }
                return paymentData.copy(paymentMethod, shippingInformation);
            }

            @NotNull
            public String toString() {
                return "PaymentData(paymentMethod=" + this.paymentMethod + ", shippingInformation=" + this.shippingInformation + ")";
            }

            public int hashCode() {
                PaymentMethod paymentMethod = this.paymentMethod;
                ShippingInformation shippingInformation = this.shippingInformation;
                return (paymentMethod != null ? ((Object)paymentMethod).hashCode() : 0) * 31 + (shippingInformation != null ? ((Object)shippingInformation).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof PaymentData)) break block3;
                        PaymentData paymentData = (PaymentData)object;
                        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)paymentData.paymentMethod) || !Intrinsics.areEqual((Object)this.shippingInformation, (Object)paymentData.shippingInformation)) break block3;
                    }
                    return true;
                }
                return false;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                this.paymentMethod.writeToParcel(parcel, 0);
                Parcel parcel2 = parcel;
                ShippingInformation shippingInformation = this.shippingInformation;
                if (shippingInformation != null) {
                    parcel.writeInt(1);
                    shippingInformation.writeToParcel(parcel2, 0);
                } else {
                    parcel2.writeInt(0);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<PaymentData> {
                @NotNull
                public final PaymentData[] newArray(int size) {
                    return new PaymentData[size];
                }

                @NotNull
                public final PaymentData createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    return new PaymentData((PaymentMethod)PaymentMethod.CREATOR.createFromParcel(in), in.readInt() != 0 ? (ShippingInformation)ShippingInformation.CREATOR.createFromParcel(in) : null);
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Canceled;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class Canceled
        extends Result {
            @NotNull
            public static final Canceled INSTANCE;
            public static final Parcelable.Creator<Canceled> CREATOR;

            private Canceled() {
                super(null);
            }

            static {
                Canceled canceled;
                INSTANCE = canceled = new Canceled();
                CREATOR = new Creator();
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                if (this != null) {
                    parcel.writeInt(1);
                } else {
                    parcel.writeInt(0);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<Canceled> {
                @NotNull
                public final Canceled[] newArray(int size) {
                    return new Canceled[size];
                }

                @NotNull
                public final Canceled createFromParcel(@NotNull Parcel in) {
                    Canceled canceled;
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    Canceled canceled2 = canceled;
                    Canceled canceled3 = canceled;
                    return in.readInt() != 0 ? INSTANCE : null;
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Unavailable;", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
        @Parcelize
        public static final class Unavailable
        extends Result {
            @NotNull
            public static final Unavailable INSTANCE;
            public static final Parcelable.Creator<Unavailable> CREATOR;

            private Unavailable() {
                super(null);
            }

            static {
                Unavailable unavailable;
                INSTANCE = unavailable = new Unavailable();
                CREATOR = new Creator();
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                if (this != null) {
                    parcel.writeInt(1);
                } else {
                    parcel.writeInt(0);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
            public static final class Creator
            implements Parcelable.Creator<Unavailable> {
                @NotNull
                public final Unavailable[] newArray(int size) {
                    return new Unavailable[size];
                }

                @NotNull
                public final Unavailable createFromParcel(@NotNull Parcel in) {
                    Unavailable unavailable;
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    Unavailable unavailable2 = unavailable;
                    Unavailable unavailable3 = unavailable;
                    return in.readInt() != 0 ? INSTANCE : null;
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayContract$Result$Companion;", "", "()V", "fromIntent", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "intent", "Landroid/content/Intent;", "stripe_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Result fromIntent(@Nullable Intent intent) {
                Intent intent2 = intent;
                Result result2 = intent2 != null ? (Result)intent2.getParcelableExtra("extra_activity_result") : null;
                Result result3 = result2;
                if (result3 == null) {
                    result3 = new Error(new IllegalStateException("Error while processing result from Google Pay."), null, null, null, 14, null);
                }
                return result3;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

