/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.networking.StripeResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001:\u0001\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/networking/StripeConnection;", "Ljava/io/Closeable;", "response", "Lcom/stripe/android/networking/StripeResponse;", "getResponse", "()Lcom/stripe/android/networking/StripeResponse;", "responseCode", "", "getResponseCode", "()I", "Default", "stripe_release"})
public interface StripeConnection
extends Closeable {
    public int getResponseCode();

    @NotNull
    public StripeResponse getResponse();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/networking/StripeConnection$Default;", "Lcom/stripe/android/networking/StripeConnection;", "conn", "Ljavax/net/ssl/HttpsURLConnection;", "(Ljavax/net/ssl/HttpsURLConnection;)V", "response", "Lcom/stripe/android/networking/StripeResponse;", "getResponse", "()Lcom/stripe/android/networking/StripeResponse;", "responseBody", "", "getResponseBody", "()Ljava/lang/String;", "responseCode", "", "getResponseCode", "()I", "responseStream", "Ljava/io/InputStream;", "getResponseStream", "()Ljava/io/InputStream;", "close", "", "Companion", "stripe_release"})
    public static final class Default
    implements StripeConnection {
        private final HttpsURLConnection conn;
        private static final String CHARSET;
        @NotNull
        private static final Companion Companion;

        @Override
        public /* synthetic */ int getResponseCode() {
            return this.conn.getResponseCode();
        }

        @Override
        public /* synthetic */ StripeResponse getResponse() throws IOException {
            int responseCode = this.getResponseCode();
            String string2 = this.getResponseBody();
            Map<String, List<String>> map = this.conn.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map, (String)"conn.headerFields");
            return new StripeResponse(responseCode, string2, map);
        }

        private final String getResponseBody() throws IOException {
            return this.getResponseBody(this.getResponseStream());
        }

        private final InputStream getResponseStream() throws IOException {
            int n = this.getResponseCode();
            return 200 <= n && 299 >= n ? this.conn.getInputStream() : this.conn.getErrorStream();
        }

        private final String getResponseBody(InputStream responseStream) throws IOException {
            if (responseStream == null) {
                return null;
            }
            Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
            String responseBody = scanner.hasNext() ? scanner.next() : null;
            responseStream.close();
            return responseBody;
        }

        @Override
        public void close() {
            InputStream inputStream = this.getResponseStream();
            if (inputStream != null) {
                inputStream.close();
            }
            this.conn.disconnect();
        }

        public Default(@NotNull HttpsURLConnection conn) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            this.conn = conn;
        }

        static {
            Companion = new Companion(null);
            CHARSET = StandardCharsets.UTF_8.name();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/networking/StripeConnection$Default$Companion;", "", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

