/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.WalletJsonParser$WhenMappings;
import com.stripe.android.model.wallets.Wallet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/parsers/WalletJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/wallets/Wallet;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseMasterpassWallet", "Lcom/stripe/android/model/wallets/Wallet$MasterpassWallet;", "parseVisaCheckoutWallet", "Lcom/stripe/android/model/wallets/Wallet$VisaCheckoutWallet;", "dynamicLast4", "", "Companion", "stripe_release"})
public final class WalletJsonParser
implements ModelJsonParser<Wallet> {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DYNAMIC_LAST4 = "dynamic_last4";
    private static final String FIELD_BILLING_ADDRESS = "billing_address";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SHIPPING_ADDRESS = "shipping_address";
    @NotNull
    private static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Wallet parse(@NotNull JSONObject json) {
        Wallet wallet;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Wallet.Type type = Wallet.Type.Companion.fromCode$stripe_release(StripeJsonUtils.optString(json, FIELD_TYPE));
        if (type == null) {
            return null;
        }
        Wallet.Type walletType = type;
        JSONObject jSONObject = json.optJSONObject(walletType.getCode());
        if (jSONObject == null) {
            return null;
        }
        JSONObject walletTypeJson = jSONObject;
        String dynamicLast4 = StripeJsonUtils.optString(json, FIELD_DYNAMIC_LAST4);
        switch (WalletJsonParser$WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
            case 1: {
                wallet = new Wallet.AmexExpressCheckoutWallet(dynamicLast4);
                break;
            }
            case 2: {
                wallet = new Wallet.ApplePayWallet(dynamicLast4);
                break;
            }
            case 3: {
                wallet = new Wallet.SamsungPayWallet(dynamicLast4);
                break;
            }
            case 4: {
                wallet = new Wallet.GooglePayWallet(dynamicLast4);
                break;
            }
            case 5: {
                wallet = this.parseMasterpassWallet(walletTypeJson);
                break;
            }
            case 6: {
                wallet = this.parseVisaCheckoutWallet(walletTypeJson, dynamicLast4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return wallet;
    }

    private final Wallet.MasterpassWallet parseMasterpassWallet(JSONObject json) {
        Address address;
        Address address2;
        Address address3;
        JSONObject it;
        boolean bl;
        boolean bl2;
        JSONObject jSONObject;
        JSONObject jSONObject2 = json.optJSONObject(FIELD_BILLING_ADDRESS);
        if (jSONObject2 != null) {
            jSONObject = jSONObject2;
            bl2 = false;
            bl = false;
            it = jSONObject;
            boolean bl3 = false;
            address2 = address3 = new AddressJsonParser().parse(it);
        } else {
            address2 = null;
        }
        String string2 = StripeJsonUtils.optString(json, FIELD_EMAIL);
        String string3 = StripeJsonUtils.optString(json, FIELD_NAME);
        JSONObject jSONObject3 = json.optJSONObject(FIELD_SHIPPING_ADDRESS);
        if (jSONObject3 != null) {
            jSONObject = jSONObject3;
            bl2 = false;
            bl = false;
            it = jSONObject;
            String string4 = string3;
            String string5 = string2;
            address3 = address2;
            boolean bl4 = false;
            Address address4 = new AddressJsonParser().parse(it);
            address2 = address3;
            string2 = string5;
            string3 = string4;
            address = address4;
        } else {
            address = null;
        }
        Address address5 = address;
        String string6 = string3;
        String string7 = string2;
        Address address6 = address2;
        return new Wallet.MasterpassWallet(address6, string7, string6, address5);
    }

    private final Wallet.VisaCheckoutWallet parseVisaCheckoutWallet(JSONObject json, String dynamicLast4) {
        Address address;
        Address address2;
        Address address3;
        JSONObject it;
        boolean bl;
        boolean bl2;
        JSONObject jSONObject;
        JSONObject jSONObject2 = json.optJSONObject(FIELD_BILLING_ADDRESS);
        if (jSONObject2 != null) {
            jSONObject = jSONObject2;
            bl2 = false;
            bl = false;
            it = jSONObject;
            boolean bl3 = false;
            address2 = address3 = new AddressJsonParser().parse(it);
        } else {
            address2 = null;
        }
        String string2 = StripeJsonUtils.optString(json, FIELD_EMAIL);
        String string3 = StripeJsonUtils.optString(json, FIELD_NAME);
        JSONObject jSONObject3 = json.optJSONObject(FIELD_SHIPPING_ADDRESS);
        if (jSONObject3 != null) {
            jSONObject = jSONObject3;
            bl2 = false;
            bl = false;
            it = jSONObject;
            String string4 = string3;
            String string5 = string2;
            address3 = address2;
            boolean bl4 = false;
            Address address4 = new AddressJsonParser().parse(it);
            address2 = address3;
            string2 = string5;
            string3 = string4;
            address = address4;
        } else {
            address = null;
        }
        String string6 = dynamicLast4;
        Address address5 = address;
        String string7 = string3;
        String string8 = string2;
        Address address6 = address2;
        return new Wallet.VisaCheckoutWallet(address6, string8, string7, address5, string6);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/WalletJsonParser$Companion;", "", "()V", "FIELD_BILLING_ADDRESS", "", "FIELD_DYNAMIC_LAST4", "FIELD_EMAIL", "FIELD_NAME", "FIELD_SHIPPING_ADDRESS", "FIELD_TYPE", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

