/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00062\b\b\u0001\u0010\u0015\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/StripeColorUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "colorAccent", "", "getColorAccent", "()I", "colorControlNormal", "getColorControlNormal", "textColorPrimary", "getTextColorPrimary", "textColorSecondary", "getTextColorSecondary", "getTintedIconWithAttribute", "Landroid/graphics/drawable/Drawable;", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "attributeResource", "iconResourceId", "getTypedValue", "Landroid/util/TypedValue;", "idRes", "Companion", "stripe_release"})
public final class StripeColorUtils {
    private final int colorAccent;
    private final int colorControlNormal;
    private final int textColorPrimary;
    private final int textColorSecondary;
    private final Context context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getColorAccent() {
        return this.colorAccent;
    }

    public final int getColorControlNormal() {
        return this.colorControlNormal;
    }

    public final int getTextColorPrimary() {
        return this.textColorPrimary;
    }

    public final int getTextColorSecondary() {
        return this.textColorSecondary;
    }

    private final TypedValue getTypedValue(@AttrRes int idRes) {
        TypedValue typedValue = new TypedValue();
        boolean bl = false;
        boolean bl2 = false;
        TypedValue it = typedValue;
        boolean bl3 = false;
        this.context.getTheme().resolveAttribute(idRes, it, true);
        return typedValue;
    }

    @NotNull
    public final Drawable getTintedIconWithAttribute(@NotNull Resources.Theme theme, @AttrRes int attributeResource, @DrawableRes int iconResourceId) {
        Drawable icon;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        TypedValue typedValue = new TypedValue();
        theme.resolveAttribute(attributeResource, typedValue, true);
        int color2 = typedValue.data;
        Drawable drawable2 = icon = ContextCompat.getDrawable((Context)this.context, (int)iconResourceId);
        Intrinsics.checkNotNull((Object)drawable2);
        Drawable compatIcon = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)color2);
        Drawable drawable3 = compatIcon;
        Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"compatIcon");
        return drawable3;
    }

    public StripeColorUtils(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.colorAccent = this.getTypedValue((int)16843829).data;
        this.colorControlNormal = this.getTypedValue((int)16843817).data;
        this.textColorPrimary = this.getTypedValue((int)16842806).data;
        this.textColorSecondary = this.getTypedValue((int)16842808).data;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/StripeColorUtils$Companion;", "", "()V", "isColorDark", "", "color", "", "isColorTransparent", "stripe_release"})
    public static final class Companion {
        public final boolean isColorTransparent(@ColorInt int color2) {
            return Color.alpha((int)color2) < 16;
        }

        public final boolean isColorDark(@ColorInt int color2) {
            double luminescence = 0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2);
            double luminescencePercentage = luminescence / (double)255;
            return luminescencePercentage <= 0.5;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

