/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.os.ConfigurationCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.textfield.TextInputEditText;
import com.stripe.android.R;
import com.stripe.android.databinding.StripeBillingAddressLayoutBinding;
import com.stripe.android.databinding.StripeCountryDropdownItemBinding;
import com.stripe.android.view.Country;
import com.stripe.android.view.CountryAdapter;
import com.stripe.android.view.CountryAutoCompleteTextViewValidator;
import com.stripe.android.view.CountryUtils;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0015\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\r\u0010\u001e\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "countryAdapter", "Lcom/stripe/android/view/CountryAdapter;", "countryView", "Landroid/widget/AutoCompleteTextView;", "getCountryView$stripe_release", "()Landroid/widget/AutoCompleteTextView;", "postalCodeView", "Lcom/google/android/material/textfield/TextInputEditText;", "selectedCountry", "Lcom/stripe/android/view/Country;", "viewBinding", "Lcom/stripe/android/databinding/StripeBillingAddressLayoutBinding;", "configureCountryAutoComplete", "", "updateInitialCountry", "updateUiForCountryEntered", "displayCountryEntered", "", "updateUiForCountryEntered$stripe_release", "updatedSelectedCountryCode", "country", "validateCountry", "validateCountry$stripe_release", "stripe_release"})
public final class BillingAddressView
extends LinearLayout {
    private final StripeBillingAddressLayoutBinding viewBinding;
    private final CountryAdapter countryAdapter;
    @NotNull
    private final AutoCompleteTextView countryView;
    private final TextInputEditText postalCodeView;
    private Country selectedCountry;

    @NotNull
    public final AutoCompleteTextView getCountryView$stripe_release() {
        return this.countryView;
    }

    private final void configureCountryAutoComplete() {
        this.countryView.setThreshold(0);
        this.countryView.setAdapter((ListAdapter)this.countryAdapter);
        this.countryView.setOnItemClickListener(new AdapterView.OnItemClickListener(this){
            final /* synthetic */ BillingAddressView this$0;

            public final void onItemClick(AdapterView<?> $noName_0, View $noName_1, int position, long $noName_3) {
                BillingAddressView.access$updatedSelectedCountryCode(this.this$0, BillingAddressView.access$getCountryAdapter$p(this.this$0).getItem(position));
            }
            {
                this.this$0 = billingAddressView;
            }
        });
        this.countryView.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ BillingAddressView this$0;

            public final void onFocusChange(View $noName_0, boolean focused) {
                if (focused) {
                    this.this$0.getCountryView$stripe_release().showDropDown();
                } else {
                    String countryEntered = this.this$0.getCountryView$stripe_release().getText().toString();
                    this.this$0.updateUiForCountryEntered$stripe_release(countryEntered);
                }
            }
            {
                this.this$0 = billingAddressView;
            }
        });
        this.selectedCountry = this.countryAdapter.getFirstItem$stripe_release();
        this.updateInitialCountry();
        this.countryView.setValidator((AutoCompleteTextView.Validator)new CountryAutoCompleteTextViewValidator(this.countryAdapter, (Function1<? super Country, Unit>)((Function1)new Function1<Country, Unit>(this){
            final /* synthetic */ BillingAddressView this$0;

            public final void invoke(@Nullable Country country) {
                BillingAddressView.access$setSelectedCountry$p(this.this$0, country);
            }
            {
                this.this$0 = billingAddressView;
                super(1);
            }
        })));
    }

    private final void updateInitialCountry() {
        Country initialCountry = this.countryAdapter.getFirstItem$stripe_release();
        this.countryView.setText((CharSequence)initialCountry.getName());
        this.selectedCountry = initialCountry;
    }

    @VisibleForTesting
    public final void updateUiForCountryEntered$stripe_release(@NotNull String displayCountryEntered) {
        String string2;
        Country country;
        Intrinsics.checkNotNullParameter((Object)displayCountryEntered, (String)"displayCountryEntered");
        Country country2 = country = CountryUtils.INSTANCE.getCountryByName$stripe_release(displayCountryEntered);
        if (country2 != null) {
            Country country3 = country2;
            boolean bl = false;
            boolean bl2 = false;
            Country it = country3;
            boolean bl3 = false;
            this.updatedSelectedCountryCode(it);
            string2 = displayCountryEntered;
        } else {
            Country country4 = this.selectedCountry;
            string2 = country4 != null ? country4.getName() : null;
        }
        String displayCountry = string2;
        this.countryView.setText((CharSequence)displayCountry);
    }

    private final void updatedSelectedCountryCode(Country country) {
        if (Intrinsics.areEqual((Object)this.selectedCountry, (Object)country) ^ true) {
            this.selectedCountry = country;
        }
    }

    public final void validateCountry$stripe_release() {
        this.countryView.performValidation();
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BillingAddressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void it;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        StripeBillingAddressLayoutBinding stripeBillingAddressLayoutBinding = StripeBillingAddressLayoutBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeBillingAddressLayoutBinding, (String)"StripeBillingAddressLayo\u2026text),\n        this\n    )");
        this.viewBinding = stripeBillingAddressLayoutBinding;
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        Locale locale = ConfigurationCompat.getLocales((Configuration)resources.getConfiguration()).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ConfigurationCompat.getL\u2026sources.configuration)[0]");
        this.countryAdapter = new CountryAdapter(context, CountryUtils.INSTANCE.getOrderedCountries$stripe_release(locale), R.layout.stripe_country_dropdown_item, (Function1<? super ViewGroup, ? extends TextView>)((Function1)new Function1<ViewGroup, TextView>(context){
            final /* synthetic */ Context $context;

            @NotNull
            public final TextView invoke(@NotNull ViewGroup it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                StripeCountryDropdownItemBinding stripeCountryDropdownItemBinding = StripeCountryDropdownItemBinding.inflate(LayoutInflater.from((Context)this.$context), it, false);
                Intrinsics.checkNotNullExpressionValue((Object)stripeCountryDropdownItemBinding, (String)"StripeCountryDropdownIte\u2026          false\n        )");
                TextView textView = stripeCountryDropdownItemBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"StripeCountryDropdownIte\u2026     false\n        ).root");
                return textView;
            }
            {
                this.$context = context;
                super(1);
            }
        }));
        AutoCompleteTextView autoCompleteTextView = this.viewBinding.country;
        Intrinsics.checkNotNullExpressionValue((Object)autoCompleteTextView, (String)"viewBinding.country");
        this.countryView = autoCompleteTextView;
        TextInputEditText textInputEditText = this.viewBinding.postalCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputEditText, (String)"viewBinding.postalCode");
        this.postalCodeView = textInputEditText;
        this.setOrientation(1);
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(new ShapeAppearanceModel().toBuilder().setAllCorners(0, this.getResources().getDimension(R.dimen.stripe_paymentsheet_form_corner_radius)).build());
        boolean bl = false;
        boolean bl2 = false;
        MaterialShapeDrawable materialShapeDrawable2 = materialShapeDrawable;
        View view = (View)this;
        boolean bl3 = false;
        it.setStroke(this.getResources().getDimension(R.dimen.stripe_paymentsheet_form_border_width), ContextCompat.getColor((Context)context, (int)R.color.stripe_paymentsheet_form_border));
        it.setFillColor(ContextCompat.getColorStateList((Context)context, (int)17170445));
        Unit unit = Unit.INSTANCE;
        ViewCompat.setBackground((View)view, (Drawable)((Drawable)materialShapeDrawable));
        this.configureCountryAutoComplete();
    }

    public /* synthetic */ BillingAddressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BillingAddressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BillingAddressView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updatedSelectedCountryCode(BillingAddressView $this, Country country) {
        $this.updatedSelectedCountryCode(country);
    }

    public static final /* synthetic */ CountryAdapter access$getCountryAdapter$p(BillingAddressView $this) {
        return $this.countryAdapter;
    }

    public static final /* synthetic */ Country access$getSelectedCountry$p(BillingAddressView $this) {
        return $this.selectedCountry;
    }

    public static final /* synthetic */ void access$setSelectedCountry$p(BillingAddressView $this, Country country) {
        $this.selectedCountry = country;
    }
}

