/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.stripe.android.R;
import com.stripe.android.databinding.PaymentSheetBuyButtonBinding;
import com.stripe.android.paymentsheet.model.PaymentOptionViewState;
import com.stripe.android.paymentsheet.ui.PrimaryButtonAnimator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020#R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/stripe/android/paymentsheet/AddButton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animator", "Lcom/stripe/android/paymentsheet/ui/PrimaryButtonAnimator;", "completedAnimation", "Landroidx/lifecycle/LiveData;", "Lcom/stripe/android/paymentsheet/model/PaymentOptionViewState$Completed;", "kotlin.jvm.PlatformType", "getCompletedAnimation$stripe_release", "()Landroidx/lifecycle/LiveData;", "confirmedIcon", "Landroid/widget/ImageView;", "mutableCompletedAnimation", "Landroidx/lifecycle/MutableLiveData;", "viewBinding", "Lcom/stripe/android/databinding/PaymentSheetBuyButtonBinding;", "getViewBinding$stripe_release", "()Lcom/stripe/android/databinding/PaymentSheetBuyButtonBinding;", "animateConfirmedIcon", "", "state", "onCompletedState", "onProcessingState", "onReadyState", "setEnabled", "enabled", "", "updateState", "Lcom/stripe/android/paymentsheet/model/PaymentOptionViewState;", "Companion", "stripe_release"})
public final class AddButton
extends FrameLayout {
    private final PrimaryButtonAnimator animator;
    @NotNull
    private final PaymentSheetBuyButtonBinding viewBinding;
    private final ImageView confirmedIcon;
    private final MutableLiveData<PaymentOptionViewState.Completed> mutableCompletedAnimation;
    @NotNull
    private final LiveData<PaymentOptionViewState.Completed> completedAnimation;
    private static final float ALPHA_ENABLED = 1.0f;
    private static final float ALPHA_DISABLED = 0.5f;
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final PaymentSheetBuyButtonBinding getViewBinding$stripe_release() {
        return this.viewBinding;
    }

    @NotNull
    public final LiveData<PaymentOptionViewState.Completed> getCompletedAnimation$stripe_release() {
        return this.completedAnimation;
    }

    public final void onReadyState() {
        ProgressBar progressBar2 = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.confirmingIcon");
        progressBar2.setVisibility(8);
    }

    public final void onProcessingState() {
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.lockIcon");
        imageView.setVisibility(8);
        ProgressBar progressBar2 = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.confirmingIcon");
        progressBar2.setVisibility(0);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        textView.setText((CharSequence)this.getResources().getString(R.string.stripe_paymentsheet_pay_button_processing));
    }

    public final void onCompletedState(@NotNull PaymentOptionViewState.Completed state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.setBackgroundResource(R.drawable.stripe_paymentsheet_buy_button_confirmed_background);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        this.animator.fadeOut$stripe_release((View)textView);
        ProgressBar progressBar2 = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.confirmingIcon");
        this.animator.fadeOut$stripe_release((View)progressBar2);
        this.animateConfirmedIcon(state);
    }

    private final void animateConfirmedIcon(PaymentOptionViewState.Completed state) {
        this.animator.fadeIn$stripe_release((View)this.confirmedIcon, this.getWidth(), (Function0<Unit>)((Function0)new Function0<Unit>(this, state){
            final /* synthetic */ AddButton this$0;
            final /* synthetic */ PaymentOptionViewState.Completed $state;

            public final void invoke() {
                AddButton.access$getMutableCompletedAnimation$p(this.this$0).setValue((Object)this.$state);
            }
            {
                this.this$0 = addButton;
                this.$state = completed;
                super(0);
            }
        }));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        textView.setAlpha(enabled ? 1.0f : 0.5f);
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.lockIcon");
        imageView.setVisibility(enabled ? 0 : 8);
    }

    public final void updateState(@NotNull PaymentOptionViewState state) {
        block1: {
            PaymentOptionViewState paymentOptionViewState;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    paymentOptionViewState = state;
                    if (!Intrinsics.areEqual((Object)paymentOptionViewState, (Object)PaymentOptionViewState.Ready.INSTANCE)) break block0;
                    this.onReadyState();
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)paymentOptionViewState, (Object)PaymentOptionViewState.Processing.INSTANCE)) break block2;
                this.onProcessingState();
                break block1;
            }
            if (!(paymentOptionViewState instanceof PaymentOptionViewState.Completed)) break block1;
            this.onCompletedState((PaymentOptionViewState.Completed)state);
        }
    }

    @JvmOverloads
    public AddButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.animator = new PrimaryButtonAnimator(context);
        PaymentSheetBuyButtonBinding paymentSheetBuyButtonBinding = PaymentSheetBuyButtonBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)paymentSheetBuyButtonBinding, (String)"PaymentSheetBuyButtonBin\u2026text),\n        this\n    )");
        this.viewBinding = paymentSheetBuyButtonBinding;
        ImageView imageView = this.viewBinding.confirmedIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.confirmedIcon");
        this.confirmedIcon = imageView;
        this.mutableCompletedAnimation = new MutableLiveData();
        LiveData $this$distinctUntilChanged$iv = (LiveData)this.mutableCompletedAnimation;
        boolean $i$f$distinctUntilChanged = false;
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)$this$distinctUntilChanged$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        this.completedAnimation = liveData;
        this.setBackgroundResource(R.drawable.stripe_paymentsheet_buy_button_default_background);
        this.setClickable(true);
        this.setEnabled(false);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        textView.setText((CharSequence)this.getResources().getString(R.string.stripe_paymentsheet_add_button_label));
    }

    public /* synthetic */ AddButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public AddButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AddButton(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ MutableLiveData access$getMutableCompletedAnimation$p(AddButton $this) {
        return $this.mutableCompletedAnimation;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/AddButton$Companion;", "", "()V", "ALPHA_DISABLED", "", "ALPHA_ENABLED", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

