/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.Token;
import com.stripe.android.model.parsers.BankAccountJsonParser;
import com.stripe.android.model.parsers.CardJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.TokenJsonParser$WhenMappings;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/TokenJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Token;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
public final class TokenJsonParser
implements ModelJsonParser<Token> {
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_ID = "id";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USED = "used";
    @NotNull
    private static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Token parse(@NotNull JSONObject json) {
        Token token;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String tokenId = StripeJsonUtils.optString(json, FIELD_ID);
        Long createdTimeStamp = StripeJsonUtils.INSTANCE.optLong$stripe_release(json, FIELD_CREATED);
        Token.Type tokenType = Token.Type.Companion.fromCode(StripeJsonUtils.optString(json, FIELD_TYPE));
        if (tokenType == null || tokenId == null || createdTimeStamp == null) {
            return null;
        }
        boolean used = StripeJsonUtils.INSTANCE.optBoolean$stripe_release(json, FIELD_USED);
        boolean liveMode = StripeJsonUtils.INSTANCE.optBoolean$stripe_release(json, FIELD_LIVEMODE);
        Date date = new Date(TimeUnit.SECONDS.toMillis(createdTimeStamp));
        switch (TokenJsonParser$WhenMappings.$EnumSwitchMapping$0[tokenType.ordinal()]) {
            case 1: {
                JSONObject jSONObject = json.optJSONObject(Token.Type.Card.getCode$stripe_release());
                if (jSONObject != null) {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject it = jSONObject2;
                    boolean bl3 = false;
                    Card card = new CardJsonParser().parse(it);
                    BankAccount bankAccount = null;
                    Token.Type type = Token.Type.Card;
                    boolean bl4 = used;
                    Date date2 = date;
                    boolean bl5 = liveMode;
                    Token token2 = new Token(tokenId, type, date2, bl5, bl4, bankAccount, card, 32, null);
                    token = token2;
                    break;
                }
                token = null;
                break;
            }
            case 2: {
                JSONObject jSONObject = json.optJSONObject(Token.Type.BankAccount.getCode$stripe_release());
                if (jSONObject != null) {
                    JSONObject jSONObject3 = jSONObject;
                    boolean bl = false;
                    boolean bl6 = false;
                    JSONObject it = jSONObject3;
                    boolean bl7 = false;
                    Card card = null;
                    BankAccount bankAccount = new BankAccountJsonParser().parse(it);
                    Token.Type type = Token.Type.BankAccount;
                    boolean bl8 = used;
                    Date date3 = date;
                    boolean bl9 = liveMode;
                    Token token3 = new Token(tokenId, type, date3, bl9, bl8, bankAccount, card, 64, null);
                    token = token3;
                    break;
                }
                token = null;
                break;
            }
            default: {
                Card card = null;
                BankAccount bankAccount = null;
                boolean bl = used;
                Date date4 = date;
                boolean bl10 = liveMode;
                Token token4 = new Token(tokenId, tokenType, date4, bl10, bl, bankAccount, card, 96, null);
                token = token4;
            }
        }
        return token;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/TokenJsonParser$Companion;", "", "()V", "FIELD_CREATED", "", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_TYPE", "FIELD_USED", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

