/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.model.StripeModel;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\rH\u00d6\u0001J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/model/BinRange;", "Lcom/stripe/android/model/StripeModel;", "low", "", "high", "(Ljava/lang/String;Ljava/lang/String;)V", "getHigh", "()Ljava/lang/String;", "getLow", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "matches", "cardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "matches$stripe_release", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
@Parcelize
public final class BinRange
implements StripeModel {
    @NotNull
    private final String low;
    @NotNull
    private final String high;
    public static final Parcelable.Creator<BinRange> CREATOR = new Creator();

    public final boolean matches$stripe_release(@NotNull CardNumber.Unvalidated cardNumber) {
        boolean bl;
        boolean bl2;
        String string2;
        boolean withinLowRange;
        boolean bl3;
        boolean bl4;
        String string3;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        String number = cardNumber.getNormalized();
        BigDecimal bigDecimal = StringsKt.toBigDecimalOrNull((String)number);
        if (bigDecimal == null) {
            return false;
        }
        BigDecimal numberBigDecimal = bigDecimal;
        if (number.length() < this.low.length()) {
            string3 = StringsKt.take((String)this.low, (int)number.length());
            bl4 = false;
            bl3 = numberBigDecimal.compareTo(new BigDecimal(string3)) >= 0;
        } else {
            string3 = StringsKt.take((String)number, (int)this.low.length());
            bl4 = false;
            BigDecimal bigDecimal2 = new BigDecimal(string3);
            string3 = this.low;
            bl4 = false;
            bl3 = withinLowRange = bigDecimal2.compareTo(new BigDecimal(string3)) >= 0;
        }
        if (number.length() < this.high.length()) {
            string2 = StringsKt.take((String)this.high, (int)number.length());
            bl2 = false;
            bl = numberBigDecimal.compareTo(new BigDecimal(string2)) <= 0;
        } else {
            string2 = StringsKt.take((String)number, (int)this.high.length());
            bl2 = false;
            BigDecimal bigDecimal3 = new BigDecimal(string2);
            string2 = this.high;
            bl2 = false;
            bl = bigDecimal3.compareTo(new BigDecimal(string2)) <= 0;
        }
        boolean withinHighRange = bl;
        return withinLowRange && withinHighRange;
    }

    @NotNull
    public final String getLow() {
        return this.low;
    }

    @NotNull
    public final String getHigh() {
        return this.high;
    }

    public BinRange(@NotNull String low, @NotNull String high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        this.low = low;
        this.high = high;
    }

    @NotNull
    public final String component1() {
        return this.low;
    }

    @NotNull
    public final String component2() {
        return this.high;
    }

    @NotNull
    public final BinRange copy(@NotNull String low, @NotNull String high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        return new BinRange(low, high);
    }

    public static /* synthetic */ BinRange copy$default(BinRange binRange, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = binRange.low;
        }
        if ((n & 2) != 0) {
            string3 = binRange.high;
        }
        return binRange.copy(string2, string3);
    }

    @NotNull
    public String toString() {
        return "BinRange(low=" + this.low + ", high=" + this.high + ")";
    }

    @Override
    public int hashCode() {
        String string2 = this.low;
        String string3 = this.high;
        return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BinRange)) break block3;
                BinRange binRange = (BinRange)object;
                if (!Intrinsics.areEqual((Object)this.low, (Object)binRange.low) || !Intrinsics.areEqual((Object)this.high, (Object)binRange.high)) break block3;
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeString(this.low);
        parcel.writeString(this.high);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator<BinRange> {
        @NotNull
        public final BinRange[] newArray(int size) {
            return new BinRange[size];
        }

        @NotNull
        public final BinRange createFromParcel(@NotNull Parcel in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            return new BinRange(in.readString(), in.readString());
        }
    }
}

