/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.Customer;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.TokenizationMethod;
import com.stripe.android.model.parsers.CustomerSourceJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.ShippingInformationJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/CustomerJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Customer;", "()V", "customerSourceJsonParser", "Lcom/stripe/android/model/parsers/CustomerSourceJsonParser;", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
public final class CustomerJsonParser
implements ModelJsonParser<Customer> {
    private final CustomerSourceJsonParser customerSourceJsonParser = new CustomerSourceJsonParser();
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_DEFAULT_SOURCE = "default_source";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_SHIPPING = "shipping";
    private static final String FIELD_SOURCES = "sources";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_HAS_MORE = "has_more";
    private static final String FIELD_TOTAL_COUNT = "total_count";
    private static final String FIELD_URL = "url";
    private static final String VALUE_LIST = "list";
    private static final String VALUE_CUSTOMER = "customer";
    private static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Customer parse(@NotNull JSONObject json) {
        ShippingInformation shippingInformation;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String objectType = StripeJsonUtils.optString(json, FIELD_OBJECT);
        if (Intrinsics.areEqual((Object)VALUE_CUSTOMER, (Object)objectType) ^ true) {
            return null;
        }
        String id2 = StripeJsonUtils.optString(json, FIELD_ID);
        String defaultSource = StripeJsonUtils.optString(json, FIELD_DEFAULT_SOURCE);
        JSONObject jSONObject = json.optJSONObject(FIELD_SHIPPING);
        if (jSONObject != null) {
            JSONObject jSONObject2 = jSONObject;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject it = jSONObject2;
            boolean bl3 = false;
            shippingInformation = new ShippingInformationJsonParser().parse(it);
        } else {
            shippingInformation = null;
        }
        ShippingInformation shippingInformation2 = shippingInformation;
        JSONObject sourcesJson = json.optJSONObject(FIELD_SOURCES);
        boolean hasMore = false;
        Integer totalCount = null;
        String url = null;
        List sources = null;
        if (sourcesJson != null && Intrinsics.areEqual((Object)VALUE_LIST, (Object)StripeJsonUtils.optString(sourcesJson, FIELD_OBJECT))) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            hasMore = StripeJsonUtils.INSTANCE.optBoolean$stripe_release(sourcesJson, FIELD_HAS_MORE);
            totalCount = StripeJsonUtils.INSTANCE.optInteger$stripe_release(sourcesJson, FIELD_TOTAL_COUNT);
            url = StripeJsonUtils.optString(sourcesJson, FIELD_URL);
            JSONArray jSONArray = sourcesJson.optJSONArray(FIELD_DATA);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            JSONArray dataArray = jSONArray;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)dataArray.length());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void idx;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JSONObject jSONObject3 = dataArray.getJSONObject((int)idx);
                collection.add(jSONObject3);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator idx = $this$forEach$iv$iv$iv.iterator();
            while (idx.hasNext()) {
                CustomerSource customerSource;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = idx.next();
                boolean bl = false;
                JSONObject it = (JSONObject)element$iv$iv;
                boolean bl4 = false;
                JSONObject jSONObject4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject4, (String)"it");
                if (this.customerSourceJsonParser.parse(jSONObject4) == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                CustomerSource it$iv$iv = customerSource;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                CustomerSource it = (CustomerSource)element$iv$iv;
                boolean bl = false;
                if (it.getTokenizationMethod() == TokenizationMethod.ApplePay) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            sources = (List)destination$iv$iv;
        } else {
            hasMore = false;
            totalCount = null;
            url = null;
            sources = CollectionsKt.emptyList();
        }
        return new Customer(id2, defaultSource, shippingInformation2, sources, hasMore, totalCount, url, StripeJsonUtils.optString(json, FIELD_DESCRIPTION), StripeJsonUtils.optString(json, FIELD_EMAIL), json.optBoolean(FIELD_LIVEMODE, false));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/model/parsers/CustomerJsonParser$Companion;", "", "()V", "FIELD_DATA", "", "FIELD_DEFAULT_SOURCE", "FIELD_DESCRIPTION", "FIELD_EMAIL", "FIELD_HAS_MORE", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_OBJECT", "FIELD_SHIPPING", "FIELD_SOURCES", "FIELD_TOTAL_COUNT", "FIELD_URL", "VALUE_CUSTOMER", "VALUE_LIST", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

