/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.cards;

import com.stripe.android.CardUtils;
import com.stripe.android.cards.Bin;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/cards/CardNumber;", "", "()V", "Companion", "Unvalidated", "Validated", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "Lcom/stripe/android/cards/CardNumber$Validated;", "stripe_release"})
public abstract class CardNumber {
    public static final int MIN_PAN_LENGTH = 14;
    public static final int MAX_PAN_LENGTH = 19;
    public static final int DEFAULT_PAN_LENGTH = 16;
    private static final Set<Integer> DEFAULT_SPACE_POSITIONS;
    private static final Map<Integer, Set<Integer>> SPACE_POSITIONS;
    public static final Companion Companion;

    private CardNumber() {
    }

    static {
        Companion = new Companion(null);
        DEFAULT_SPACE_POSITIONS = SetsKt.setOf((Object[])new Integer[]{4, 9, 14});
        SPACE_POSITIONS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)14, (Object)SetsKt.setOf((Object[])new Integer[]{4, 11})), TuplesKt.to((Object)15, (Object)SetsKt.setOf((Object[])new Integer[]{4, 11})), TuplesKt.to((Object)16, (Object)SetsKt.setOf((Object[])new Integer[]{4, 9, 14})), TuplesKt.to((Object)19, (Object)SetsKt.setOf((Object[])new Integer[]{4, 9, 14, 19}))});
    }

    public /* synthetic */ CardNumber(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u000eJ\t\u0010\u001c\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/stripe/android/cards/CardNumber$Unvalidated;", "Lcom/stripe/android/cards/CardNumber;", "denormalized", "", "(Ljava/lang/String;)V", "bin", "Lcom/stripe/android/cards/Bin;", "getBin", "()Lcom/stripe/android/cards/Bin;", "isMaxLength", "", "()Z", "isValidLuhn", "length", "", "getLength", "()I", "normalized", "getNormalized", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "formatNumber", "panLength", "getFormatted", "hashCode", "toString", "validate", "Lcom/stripe/android/cards/CardNumber$Validated;", "Companion", "stripe_release"})
    public static final class Unvalidated
    extends CardNumber {
        @NotNull
        private final String normalized;
        private final int length;
        private final boolean isMaxLength;
        @Nullable
        private final Bin bin;
        private final boolean isValidLuhn;
        private final String denormalized;
        private static final Set<Character> REJECT_CHARS;
        private static final Companion Companion;

        @NotNull
        public final String getNormalized() {
            return this.normalized;
        }

        public final int getLength() {
            return this.length;
        }

        public final boolean isMaxLength() {
            return this.isMaxLength;
        }

        @Nullable
        public final Bin getBin() {
            return this.bin;
        }

        public final boolean isValidLuhn() {
            return this.isValidLuhn;
        }

        @Nullable
        public final Validated validate(int panLength) {
            return panLength >= 14 && this.normalized.length() == panLength && this.isValidLuhn ? new Validated(this.normalized) : null;
        }

        @NotNull
        public final String getFormatted(int panLength) {
            return this.formatNumber(panLength);
        }

        public static /* synthetic */ String getFormatted$default(Unvalidated unvalidated, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            return unvalidated.getFormatted(n);
        }

        private final String formatNumber(int panLength) {
            int n;
            boolean $i$f$indexOfFirst;
            Object $this$indexOfFirst$iv;
            boolean spacePosition;
            int n2;
            int index$iv;
            int lastUsedIndex;
            String[] groups;
            String spacelessCardNumber;
            block7: {
                Set<Integer> spacePositions = Companion.getSpacePositions$stripe_release(panLength);
                spacelessCardNumber = StringsKt.take((String)this.normalized, (int)panLength);
                groups = new String[spacePositions.size() + 1];
                int length = spacelessCardNumber.length();
                lastUsedIndex = 0;
                Iterable $this$forEachIndexed$iv = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)spacePositions));
                boolean $i$f$forEachIndexed = false;
                index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n3 = index$iv++;
                    n2 = 0;
                    if (n3 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n4 = ((Number)item$iv).intValue();
                    int idx = n3;
                    boolean bl = false;
                    void adjustedSpacePosition = spacePosition - idx;
                    if (length <= adjustedSpacePosition) continue;
                    String string2 = spacelessCardNumber;
                    int n5 = lastUsedIndex;
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n5, (int)adjustedSpacePosition), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    lastUsedIndex = adjustedSpacePosition;
                }
                $this$indexOfFirst$iv = groups;
                $i$f$indexOfFirst = false;
                int n6 = ((String[])$this$indexOfFirst$iv).length;
                for (index$iv = 0; index$iv < n6; ++index$iv) {
                    String it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == null)) continue;
                    n = index$iv;
                    break block7;
                }
                n = -1;
            }
            $this$indexOfFirst$iv = n;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            int it = ((Number)$this$indexOfFirst$iv).intValue();
            boolean bl = false;
            Object object = it != -1 ? $this$indexOfFirst$iv : null;
            if (object != null) {
                $this$indexOfFirst$iv = object;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                it = ((Number)$this$indexOfFirst$iv).intValue();
                boolean bl3 = false;
                String string4 = spacelessCardNumber;
                n2 = lastUsedIndex;
                spacePosition = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
            }
            String[] $this$takeWhile$iv = groups;
            boolean $i$f$takeWhile = false;
            ArrayList<String> list$iv = new ArrayList<String>();
            String[] stringArray = $this$takeWhile$iv;
            int n7 = stringArray.length;
            for (int i = 0; i < n7; ++i) {
                String item$iv;
                String it2 = item$iv = stringArray[i];
                boolean bl4 = false;
                if (!(it2 != null)) break;
                list$iv.add(item$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        public Unvalidated(@NotNull String denormalized) {
            String string2;
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Intrinsics.checkNotNullParameter((Object)denormalized, (String)"denormalized");
            super(null);
            String string3 = this.denormalized = denormalized;
            Unvalidated unvalidated = this;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            void var7_8 = $this$filterNotTo$iv$iv;
            for (int i = 0; i < var7_8.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = var7_8.charAt(i);
                boolean bl = false;
                if (REJECT_CHARS.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string4 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"filterNotTo(StringBuilder(), predicate).toString()");
            unvalidated.normalized = string2 = string4;
            this.length = this.normalized.length();
            this.isMaxLength = this.length == 19;
            this.bin = Bin.Companion.create(this.normalized);
            this.isValidLuhn = CardUtils.INSTANCE.isValidLuhnNumber$stripe_release(this.normalized);
        }

        static {
            Companion = new Companion(null);
            REJECT_CHARS = SetsKt.setOf((Object[])new Character[]{Character.valueOf('-'), Character.valueOf(' ')});
        }

        private final String component1() {
            return this.denormalized;
        }

        @NotNull
        public final Unvalidated copy(@NotNull String denormalized) {
            Intrinsics.checkNotNullParameter((Object)denormalized, (String)"denormalized");
            return new Unvalidated(denormalized);
        }

        public static /* synthetic */ Unvalidated copy$default(Unvalidated unvalidated, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = unvalidated.denormalized;
            }
            return unvalidated.copy(string2);
        }

        @NotNull
        public String toString() {
            return "Unvalidated(denormalized=" + this.denormalized + ")";
        }

        public int hashCode() {
            String string2 = this.denormalized;
            return string2 != null ? string2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Unvalidated)) break block3;
                    Unvalidated unvalidated = (Unvalidated)object;
                    if (!Intrinsics.areEqual((Object)this.denormalized, (Object)unvalidated.denormalized)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/cards/CardNumber$Unvalidated$Companion;", "", "()V", "REJECT_CHARS", "", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\bJ\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/cards/CardNumber$Validated;", "Lcom/stripe/android/cards/CardNumber;", "value", "", "(Ljava/lang/String;)V", "getValue$stripe_release", "()Ljava/lang/String;", "component1", "component1$stripe_release", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stripe_release"})
    public static final class Validated
    extends CardNumber {
        @NotNull
        private final String value;

        @NotNull
        public final String getValue$stripe_release() {
            return this.value;
        }

        public Validated(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String component1$stripe_release() {
            return this.value;
        }

        @NotNull
        public final Validated copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Validated(value);
        }

        public static /* synthetic */ Validated copy$default(Validated validated, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = validated.value;
            }
            return validated.copy(string2);
        }

        @NotNull
        public String toString() {
            return "Validated(value=" + this.value + ")";
        }

        public int hashCode() {
            String string2 = this.value;
            return string2 != null ? string2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Validated)) break block3;
                    Validated validated = (Validated)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)validated.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/cards/CardNumber$Companion;", "", "()V", "DEFAULT_PAN_LENGTH", "", "DEFAULT_SPACE_POSITIONS", "", "MAX_PAN_LENGTH", "MIN_PAN_LENGTH", "SPACE_POSITIONS", "", "getSpacePositions", "panLength", "getSpacePositions$stripe_release", "stripe_release"})
    public static final class Companion {
        @NotNull
        public final Set<Integer> getSpacePositions$stripe_release(int panLength) {
            Set set = (Set)SPACE_POSITIONS.get(panLength);
            if (set == null) {
                set = DEFAULT_SPACE_POSITIONS;
            }
            return set;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

